<?php

/**
 * This is the model class for table "{{mas_company}}".
 *
 * The followings are the available columns in table '{{mas_company}}':
 * @property string $id
 * @property integer $crm_user_id
 * @property string $company_name
 * @property string $company_logo
 * @property string $company_address
 * @property string $company_city
 * @property string $company_state
 * @property string $company_country
 * @property string $company_pin_zip
 * @property string $company_postal_code
 * @property string $company_phone_no
 * @property string $company_email_id
 * @property string $company_location
 * @property string $company_fax
 * @property string $company_web
 * @property string $company_industry
 * @property string $company_latitude
 * @property string $company_longitude
 * @property integer $currency_id
 * @property string $isActive
 */
class MasCompany extends CActiveRecord
{

    /**
     * @return string the associated database table name
     */
    //const DB_ARK ='diatech_erp_main';
    //const DB_ACE ='diatech_erp_main';
    const MainDB = 'blskysoftware_erp_coral_main';
    const CODE = "CORAL";

    public function tableName()
    {
        return 'blskysoftware_erp_coral_main.{{mas_company}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    /* public function rules()
      {
      // NOTE: you should only define rules for those attributes that
      // will receive user inputs.
      return array(
      array('crm_user_id, company_name,company_state, company_country', 'required'),
      array('crm_user_id, currency_id', 'numerical', 'integerOnly'=>true),
      array('company_name, company_logo,  company_state, company_country, company_postal_code, company_phone_no, company_email_id, company_location, company_fax, company_web, company_industry', 'length', 'max'=>255),
      array('isActive', 'length', 'max'=>1),
      array('footer_line_one,footer_line_two,footer_autogenerated', 'length', 'max' => 500),
      // The following rule is used by search().
      // @todo Please remove those attributes that should not be searched.
      array('id, crm_user_id, company_name, company_logo,  company_state, company_country, company_pin_zip, company_postal_code, company_phone_no, company_email_id, company_location, company_fax, company_web, company_industry, currency_id, isActive,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on'=>'search'),
      );
      } */

    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('company_name, billing_address,billing_country,
                            shipping_address,   shipping_country,

                               currency_id',
                'required'
            ),
            array('crm_user_id, currency_id, fin_year', 'numerical', 'integerOnly' => true),
            array('company_logo, company_name, billing_city, billing_postalcode, billing_state, billing_country, billing_pinzip,
                            shipping_address, shipping_city, shipping_state, shipping_country, shipping_postalcode, shipping_pinzip, facebook,
                            skype, twitter, linkedin, instagram, myspace, youtube, googleplus,  , genral_phno, genral_email, genral_location,
                            genral_fax, genral_web, genral_industry, genral_latitude, genral_longitude,trn_no,excise_no',
                'length',
                'max' => 255
            ),
            array('footer_line_one,footer_line_two,footer_autogenerated', 'length', 'max' => 500),
            array('shipping_address_same_as_billing, isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('company_logo, crm_user_id, company_name, billing_address, billing_city, billing_postalcode, billing_state,
                            billing_country, billing_pinzip, shipping_address_same_as_billing, shipping_address, shipping_city, shipping_state,
                            shipping_country, shipping_postalcode, shipping_pinzip, facebook, skype, twitter, linkedin, instagram, myspace,
                            youtube, googleplus,    genral_phno, genral_email, genral_location, genral_fax, genral_web, genral_industry,
                            genral_latitude, genral_longitude, currency_id, isActive,no_of_decimals,sales_and_service,contract,erp_setting',
                'safe',
                'on' => 'search'
            ),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'companycurrency' => array(self::BELONGS_TO, 'MasCurrency', 'currency_id'),
            'country' => array(self::BELONGS_TO, 'MasCountry', 'company_country'),
            'currencydetails' => array(self::BELONGS_TO, 'MasCurrency', 'currency_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    /* public function attributeLabels()
      {
      return array(
      'id' => 'ID',
      'crm_user_id' => 'Crm User',
      'company_name' => 'Company Name',
      'company_logo' => 'Company Logo',
      //'company_address' => 'Company Address',
      //'company_city' => 'Company City',
      'company_state' => 'Company State',
      'company_country' => 'Company Country',
      'company_pin_zip' => 'Company Pin Zip',
      'company_postal_code' => 'Company Postal Code',
      'company_phone_no' => 'Company Phone No',
      'company_email_id' => 'Company Email',
      'company_location' => 'Company Location',
      'company_fax' => 'Company Fax',
      'company_web' => 'Company Web',
      'company_industry' => 'Company Industry',
      'currency_id' => 'Currency',
      'isActive' => 'Is Active',
      );
      } */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'company_logo' => 'Company Logo',
            'crm_user_id' => 'Crm User',
            'company_name' => 'Company Name',
            'erp_setting' => 'ERP Settings',
            'billing_address' => 'Billing Address',
            'billing_city' => 'Billing City',
            'billing_postalcode' => 'Billing Postalcode',
            'billing_state' => 'Billing State',
            'billing_country' => 'Billing Country',
            'billing_pinzip' => 'Billing Pinzip',
            'shipping_address_same_as_billing' => 'Shipping Address Same As Billing',
            'shipping_address' => 'Shipping Address',
            'shipping_city' => 'Shipping City',
            'shipping_state' => 'Shipping State',
            'shipping_country' => 'Shipping Country',
            'shipping_postalcode' => 'Shipping Postalcode',
            'shipping_pinzip' => 'Shipping Pinzip',
            'facebook' => 'Facebook',
            'skype' => 'Skype',
            'twitter' => 'Twitter',
            'linkedin' => 'Linkedin',
            'instagram' => 'Instagram',
            'myspace' => 'Myspace',
            'youtube' => 'Youtube',
            'googleplus' => 'Googleplus',
            'genral_phno' => 'Genral Phno',
            'genral_email' => 'Genral Email',
            'genral_location' => 'Genral Location',
            'genral_fax' => 'Genral Fax',
            'genral_web' => 'Genral Web',
            'genral_industry' => 'Genral Industry',
            'genral_latitude' => 'Genral Latitude',
            'genral_longitude' => 'Genral Longitude',
            'currency_id' => 'Currency',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    /* public function search()
      {
      // @todo Please modify the following code to remove attributes that should not be searched.

      $criteria=new CDbCriteria;

      $criteria->compare('id',$this->id,true);
      $criteria->compare('crm_user_id',$this->crm_user_id);
      $criteria->compare('company_name',$this->company_name,true);
      $criteria->compare('company_logo',$this->company_logo,true);
      //$criteria->compare('company_address',$this->company_address,true);
      //$criteria->compare('company_city',$this->company_city,true);
      $criteria->compare('company_state',$this->company_state,true);
      $criteria->compare('company_country',$this->company_country,true);
      $criteria->compare('company_pin_zip',$this->company_pin_zip,true);
      $criteria->compare('company_postal_code',$this->company_postal_code,true);
      $criteria->compare('company_phone_no',$this->company_phone_no,true);
      $criteria->compare('company_email_id',$this->company_email_id,true);
      $criteria->compare('company_location',$this->company_location,true);
      $criteria->compare('company_fax',$this->company_fax,true);
      $criteria->compare('company_web',$this->company_web,true);
      $criteria->compare('company_industry',$this->company_industry,true);
      $criteria->compare('currency_id',$this->currency_id);
      $criteria->compare('isActive',$this->isActive,true);

      return new CActiveDataProvider($this, array(
      'criteria'=>$criteria,
      ));
      } */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id, true);
        $criteria->compare('company_logo', $this->company_logo, true);
        $criteria->compare('crm_user_id', $this->crm_user_id);
        $criteria->compare('company_name', $this->company_name, true);
        $criteria->compare('billing_address', $this->billing_address, true);
        $criteria->compare('billing_city', $this->billing_city, true);
        $criteria->compare('billing_postalcode', $this->billing_postalcode, true);
        $criteria->compare('billing_state', $this->billing_state, true);
        $criteria->compare('billing_country', $this->billing_country, true);
        $criteria->compare('billing_pinzip', $this->billing_pinzip, true);
        $criteria->compare('shipping_address_same_as_billing', $this->shipping_address_same_as_billing, true);
        $criteria->compare('shipping_address', $this->shipping_address, true);
        $criteria->compare('shipping_city', $this->shipping_city, true);
        $criteria->compare('shipping_state', $this->shipping_state, true);
        $criteria->compare('shipping_country', $this->shipping_country, true);
        $criteria->compare('shipping_postalcode', $this->shipping_postalcode, true);
        $criteria->compare('shipping_pinzip', $this->shipping_pinzip, true);
        $criteria->compare('facebook', $this->facebook, true);
        $criteria->compare('skype', $this->skype, true);
        $criteria->compare('twitter', $this->twitter, true);
        $criteria->compare('linkedin', $this->linkedin, true);
        $criteria->compare('instagram', $this->instagram, true);
        $criteria->compare('myspace', $this->myspace, true);
        $criteria->compare('youtube', $this->youtube, true);
        $criteria->compare('googleplus', $this->googleplus, true);

        $criteria->compare('genral_phno', $this->genral_phno, true);
        $criteria->compare('genral_email', $this->genral_email, true);
        $criteria->compare('genral_location', $this->genral_location, true);
        $criteria->compare('genral_fax', $this->genral_fax, true);
        $criteria->compare('genral_web', $this->genral_web, true);
        $criteria->compare('genral_industry', $this->genral_industry, true);
        $criteria->compare('genral_latitude', $this->genral_latitude, true);
        $criteria->compare('genral_longitude', $this->genral_longitude, true);
        $criteria->compare('currency_id', $this->currency_id);
        $criteria->compare('isActive', $this->isActive, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasCompany the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }

    public function getAddress()
    {
        $address = array();
        $mas_company = MasCompany::model()->findByPK(Yii::app()->user->master_user_company_id);
        $address[] = $mas_company->company_address;
        $address[] = $mas_company->company_city;
        return (implode(', ', array_filter($address)));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasCompany the static model class
     */
    public static function getCompanyName()
    {

        $condition = 'isActive =  "Y"';

        $model = self::model()->findAll(array('condition' => $condition));

        return CHtml::listData($model, 'id', 'company_name');
    }

    public static function getMasCompanyDetails($master_user_company_id = 0)
    {
        if ($master_user_company_id > 0) {
            $arr_mas_company = MasCompany::model()->findByPK($master_user_company_id);
        } else {
            $arr_mas_company = MasCompany::model()->find();
        }
        return $arr_mas_company;
    }

    public static function getCompanyId($company_code)
    {
        if ($company_code != '')
            return self::model()->find(array('condition' => 'company_code = "' . $company_code . '"'))->id;
        else
            return 0;
    }

    public static function getCurrentUserERPSetting()
    {
        $userId = Yii::app()->user->id;
        $companyId = Yii::app()->user->master_user_company_id;
        
        $company = self::model()->findByPk($companyId);
        // var_dump( $companyId->erp_setting);
        return $company ? $company->erp_setting : 'E';
    }
    public static function getCurrentUserERPSettingApp($companyId)
    {
        // $companyId = Yii::app()->user->master_user_company_id;
        
        $company = self::model()->findByPk($companyId);
        // var_dump( $companyId->erp_setting);
        return $company ? $company->erp_setting : 'E';
    }

}
