<?php
class MasCategorySecondLevel extends CActiveRecord {



    /**

     * @return string the associated database table name

     */

    public function tableName() {

        return '{{inventory_level2_category}}';

    }



    /**

     * @return array validation rules for model attributes.

     */

    public function rules() {

        // NOTE: you should only define rules for those attributes that

        // will receive user inputs.

        return array(

            array('generic_name_id', 'required'),
            array('id, generic_name_id,category_description,category_name,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on' => 'search'),

        );

    }



    /**

     * @return array relational rules.

     */

    public function relations() {

        // NOTE: you may need to adjust the relation name and the related

        // class name for the relations automatically generated below.

        return array(

            'generic' => array(self::BELONGS_TO, 'MasGeneric', 'generic_name_id'),

        );

    }



    /**

     * @return array customized attribute labels (name=>label)

     */

    public function attributeLabels() {

        return array(

            'id' => 'ID',
            'generic_name_id' => 'Generic Name ID',
            'category_name' => 'Category Name',
            'category_description' => 'Category Description',
            'created_by' => 'created_by',
            'created_date_time' => 'created_date_time',
            'updated_by' => 'updated_by',
            'updated_date_time' => 'updated_date_time',

        );

    }



    public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('generic_name_id',$this->generic_name_id);
                $criteria->compare('category_name',$this->category_name);
                $criteria->compare('category_description',$this->category_description);
                                            
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
    /**

     * Returns the static model of the specified AR class.

     * Please note that you should have this exact method in all your CActiveRecord descendants!

     * @param string $className active record class name.

     * @return Store the static model class

     */

    public static function model($className = __CLASS__) {

        return parent::model($className);

    }

    public function getCategoryL2() {

        $model = self::model()->findAll(array('select' => array('id', 'category_name'), 'order' => 'category_name'));

        return CHtml::listData($model, 'id', 'category_name');

    }
      public static function getCategoryL2Details($id){		
        if($id > 0){
    		$model = self::model()->findAll(array('condition'=>'generic_name_id='.$id));
    		return CHtml::listData($model, 'id', 'category_name');
        }
        else
        {
            return "";
        }
    }

}


