<?php

/**
 * This is the model class for table "{{machine_service_detail}}".
 *
 * The followings are the available columns in table '{{machine_service_detail}}':
 * @property integer $id
 * @property integer $product_id
 * @property integer $pdt_location_id
 * @property string $date_service
 * @property string $job_card_no
 * @property string $service_time
 * @property string $next_service_date
 * @property string $serviced_by
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class MachineServiceDetail extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{machine_service_detail}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_id, serial_no', 'required'),
			array('product_id, pdt_location_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('job_card_no, serviced_by', 'length', 'max'=>500),
			array('service_time', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, product_id, pdt_location_id, date_service, job_card_no, service_time, next_service_date, serviced_by, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_id' => 'Product',
			'pdt_location_id' => 'Pdt Location',
			'date_service' => 'Date Service',
			'job_card_no' => 'Job Card No',
			'service_time' => 'Service Time',
			'next_service_date' => 'Next Service Date',
			'serviced_by' => 'Serviced By',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('pdt_location_id',$this->pdt_location_id);
		$criteria->compare('date_service',$this->date_service,true);
		$criteria->compare('job_card_no',$this->job_card_no,true);
		$criteria->compare('service_time',$this->service_time,true);
		$criteria->compare('next_service_date',$this->next_service_date,true);
		$criteria->compare('serviced_by',$this->serviced_by,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MachineServiceDetail the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
