<?php

/**
 * This is the model class for table "{{machine_profile}}".
 *
 * The followings are the available columns in table '{{machine_profile}}':
 * @property integer $id
 * @property integer $product_id
 * @property integer $pdt_location_id
 * @property integer $year_manufacture
 * @property string $serial_no
 * @property integer $application
 * @property string $max_pressure
 * @property string $max_output_hr
 * @property string $weight
 * @property string $dimensions
 * @property string $dimensions_dismantle
 * @property string $fuel_tank_capacity
 * @property string $fuel_consumption_hr
 * @property string $powered_by
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class MachineProfile extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{machine_profile}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_id,serial_no', 'required'),
			array('product_id, pdt_location_id, year_manufacture, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('serial_no,application, max_pressure, max_output_hr, weight, dimensions, dimensions_dismantle, fuel_tank_capacity, fuel_consumption_hr', 'length', 'max'=>255),
			array('powered_by', 'length', 'max'=>500),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, product_id, pdt_location_id, year_manufacture, serial_no, application, max_pressure, max_output_hr, weight, dimensions, dimensions_dismantle, fuel_tank_capacity, fuel_consumption_hr, powered_by, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_id' => 'Product',
			'pdt_location_id' => 'Pdt Location',
			'year_manufacture' => 'Year Manufacture',
			'serial_no' => 'Serial No',
			'application' => 'Application',
			'max_pressure' => 'Max Pressure',
			'max_output_hr' => 'Max Output Hr',
			'weight' => 'Weight',
			'dimensions' => 'Dimensions',
			'dimensions_dismantle' => 'Dimensions Dismantle',
			'fuel_tank_capacity' => 'Fuel Tank Capacity',
			'fuel_consumption_hr' => 'Fuel Consumption Hr',
			'powered_by' => 'Powered By',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('pdt_location_id',$this->pdt_location_id);
		$criteria->compare('year_manufacture',$this->year_manufacture);
		$criteria->compare('serial_no',$this->serial_no,true);
		$criteria->compare('application',$this->application,true);
		$criteria->compare('max_pressure',$this->max_pressure,true);
		$criteria->compare('max_output_hr',$this->max_output_hr,true);
		$criteria->compare('weight',$this->weight,true);
		$criteria->compare('dimensions',$this->dimensions,true);
		$criteria->compare('dimensions_dismantle',$this->dimensions_dismantle,true);
		$criteria->compare('fuel_tank_capacity',$this->fuel_tank_capacity,true);
		$criteria->compare('fuel_consumption_hr',$this->fuel_consumption_hr,true);
		$criteria->compare('powered_by',$this->powered_by,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MachineProfile the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
