<?php

/**
 * This is the model class for table "{{machine_document_detail}}".
 *
 * The followings are the available columns in table '{{machine_document_detail}}':
 * @property integer $id
 * @property integer $product_id
 * @property integer $pdt_location_id
 * @property integer $document_id
 * @property string $document_no
 * @property string $date_valid
 * @property string $date_reminder
 * @property string $document_upload
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class MachineDocumentDetail extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{machine_document_detail}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_id, serial_no,document_id', 'required'),
			array('product_id, pdt_location_id, document_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('document_no, document_upload', 'length', 'max'=>500),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, product_id, pdt_location_id, document_id, document_no, date_valid, date_reminder, document_upload, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'document' => array(self::BELONGS_TO, 'MachineDocument', 'document_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_id' => 'Product',
			'pdt_location_id' => 'Pdt Location',
			'document_id' => 'Document',
			'document_no' => 'Document No',
			'date_valid' => 'Date Valid',
			'date_reminder' => 'Date Reminder',
			'document_upload' => 'Document Upload',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('pdt_location_id',$this->pdt_location_id);
		$criteria->compare('document_id',$this->document_id);
		$criteria->compare('document_no',$this->document_no,true);
		$criteria->compare('date_valid',$this->date_valid,true);
		$criteria->compare('date_reminder',$this->date_reminder,true);
		$criteria->compare('document_upload',$this->document_upload,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MachineDocumentDetail the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
