<?php

/**
 * This is the model class for table "{{machine_document}}".
 *
 * The followings are the available columns in table '{{machine_document}}':
 * @property integer $id
 * @property string $document_name
 * @property integer $document_type
 * @property string $isActive
 */
class MachineDocument extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{machine_document}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('document_name, document_type', 'required'),
                        array('document_name', 'unique'),
			array('document_type', 'numerical', 'integerOnly'=>true),
			array('document_name', 'length', 'max'=>255),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, document_name, document_type, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'document_name' => 'Document Name',
			'document_type' => 'Type',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('document_name',$this->document_name,true);
		$criteria->compare('document_type',$this->document_type);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MachineDocument the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getDocuments() {
            $condition = 'isActive =  "Y"';
            $model = self::model()->findAll(array('condition' => $condition,'order'=>'document_name asc'));
            return CHtml::listData($model, 'id', 'document_name');
        }
//        public static function getMachineDocument($product_id=0,$serial_no=0,$document_id=0) {
//            $condition = 'isActive="Y"';
//            $machine_document=array();
//            $model_machine_documents = MachineDocumentDetail::model()->findAll(array('select'=>'document_id','condition' => 'serial_no="'.$serial_no.'" and document_id!="'.$document_id.'" and product_id="'.$product_id.'"'));
//            foreach ($model_machine_documents as $key_1 => $value_1) {
//                $machine_document[$key_1]=$value_1->document_id;
//            }
//            $model = self::model()->findAll(array('condition' => $condition,'order'=>'document_name asc'));
//            $document=array();
//            foreach ($model as $key => $value) {
//                if (!in_array($value->id,$machine_document)) {
//                    $document[$key]['id']=$value->id;
//                    $document[$key]['document_name']=$value->document_name;
//                }
//            }
//            return CHtml::listData($document, 'id', 'document_name');
//        }
        public static function getMachineDocument() {
            $condition = 'isActive="Y"';
            $model = self::model()->findAll(array('condition' => $condition,'order'=>'document_name asc'));
            $document=array();
            foreach ($model as $key => $value) {
                $document[$key]['id']=$value->id;
                $document[$key]['document_name']=$value->document_name;
            }
            return CHtml::listData($document, 'id', 'document_name');
        }
}
