<?php

/**
 * This is the model class for table "{{mas_designation}}".
 *
 * The followings are the available columns in table '{{mas_designation}}':
 * @property integer $id
 * @property string $designation_name
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property MasCompany[] $masCompanies
 */
class Loan extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{hr_employee_loan}}';
    }

    /**
     * @return array validation rules for model attributes.
	 id	employee_id	loan_id	loan_amount
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('employee_id,loan_id,loan_amount', 'required'),           
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, employee_id,loan_id,loan_amount,isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'employee_id' => 'Employee Id',
            'loan_id' => 'Loan Id',
            'loan_amount' => 'Loan Amount',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        $criteria = new CDbCriteria;
        $searchterm = trim(Yii::app()->request->getParam('employee_id'));
        $sterm = trim(Yii::app()->request->getParam('search'));
     
        if($sterm)
        {
      $criteria->addCondition('employee_id like "%' . $sterm . '%"', 'AND');
        }
        if (!empty($searchterm)){
            $criteria->addCondition('employee_id like "%' . $searchterm . '%"', 'AND');
        }
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 12,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.employee_id ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasBank the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    //function Written by Dikson

    public static function getDesignation() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'designation_name');
    }
    public static function getDesignationName() {
        $condition = 'isActive =  "Y" ';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'designation_name');
    }

	

	
	
    public static function getFiiledDesignationName($id) {
        $model = self::model()->findByPk($id);
        return $model->designation_name;
    }
}
