<?php
class LandingCost extends CActiveRecord {
    public function tableName() {
        return '{{landing_cost}}';
    }
    public function rules() {
        return array(
            array('parent_invoice_id,parent_invoice_item_id,product_id,service_invoice_id,quantity,rate,amount,currency,exchange_rate,service_amount_percentage,service_invoice_value,created_by,created_date_time', 'required'),
            array('parent_invoice_id,parent_invoice_item_id,product_id,service_invoice_id,currency,created_by','numerical','integerOnly' => true),
            array('quantity,rate,amount,exchange_rate,service_amount_percentage,service_invoice_value','numerical'),
            array('id,parent_invoice_id,parent_invoice_item_id,product_id,service_invoice_id,quantity,rate,amount,currency,exchange_rate,service_amount_percentage,service_invoice_value', 'safe', 'on' => 'search'),
        );
    }
    public function relations() {
        return array(
            'purchase_invoice' => array(self::BELONGS_TO, 'PurchasingInvoice', 'parent_invoice_id'),
            'service_invoice' => array(self::BELONGS_TO, 'PurchasingInvoice', 'service_invoice_id'),
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'currencyname' => array(self::BELONGS_TO, 'MasCurrency', 'currency'),
        );
    }

    public function attributeLabels() {

        return array(
            'id' => 'ID',
        );
    }
    public function search() {
        $criteria = new CDbCriteria;
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(),
        ));
    }
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
}

