<?php

/**
 * This is the model class for table "{{invoice_item}}".
 *
 * The followings are the available columns in table '{{invoice_item}}':
 * @property string $id
 * @property integer $invoice_id
 * @property integer $order_item_id
 * @property integer $product_id
 * @property string $description
 * @property string $product_generic_name
 * @property integer $brand_class_id
 * @property string $quantity
 * @property string $picked_qty
 * @property integer $unit_id
 * @property string $rate
 * @property string $amount
 * @property string $addition_percentage
 * @property string $addition_amount
 * @property string $deduction_percentage
 * @property string $deduction_amount
 * @property string $tax_vat_percentage
 * @property string $tax_vat_amount
 * @property string $net_amount
 * @property string $cost_rate
 * @property integer $fin_account_id
 * @property string $unit_factor
 * @property string $unit_cost_rate
 * @property string $base_cost_rate
 * @property string $cost_updated
 * @property integer $created_by
 * @property string $updated_cost_rate
 * @property integer $updated_by
 * @property string $created_datetime
 * @property string $updated_datetime
 */
class InvoiceItem extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */

	public $product_name;
	public $unit;
	public $actual_tax_percentage;
	public $actual_tax_amount;
	public $actual_rate;

	public function tableName()
	{
		return '{{invoice_item}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.


		return array(
			array('product_id, description, quantity, rate, amount, net_amount', 'required'),
			array('id, product_id, invoice_id', 'numerical', 'integerOnly' => true),
			array('quantity, rate, amount, addition_amount, deduction_amount, net_amount,cost_rate,tax_vat_percentage,tax_vat_amount', 'numerical'),
			array('addition_percentage, deduction_percentage', 'length', 'max' => 50),
			array('description,description_2', 'length', 'max' => 10000),
			array(
				'rate',
				'compare',
				'compareValue' => 0,
				'operator' => '>=',
				'allowEmpty' => false,
				'message' => '{attribute} must be greater than "{compareValue}".'
			),
			array('net_amount', 'validatenetamount'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, product_id, invoice_id, description, quantity, unit, rate, amount, addition_percentage, addition_amount, deduction_percentage, deduction_amount, net_amount', 'safe', 'on' => 'search'),
		);


	}

	// public function validatenetamount($attribute) {
	//     if ($this->net_amount<0  && $this->invoice_item_nature!='H') {
	//         $this->addError($attribute, 'Net Amount must be greater than or equal to 0');
	//         return false;
	//     } else {
	//         return true;
	//     }
	// }
	public function validatenetamount($attribute)
	{
		if ($this->net_amount < 0) {
			$this->addError($attribute, 'Net Amount must be greater than or equal to 0');
			return false;
		} else {
			return true;
		}
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'invoice' => array(self::BELONGS_TO, 'Invoice', 'invoice_id'),
			'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
			'unit' => array(self::BELONGS_TO, 'Unit', 'unit_id'),
			//'invoiceunit' => array(self::BELONGS_TO, 'Unit', 'unit_id'),
			'invoiceunit' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'invoice_id' => 'Invoice',
			'order_item_id' => 'Order Item',
			'product_id' => 'Product',
			'description' => 'Description',
			'product_generic_name' => 'Product Generic Name',
			'brand_class_id' => 'Brand Class',
			'quantity' => 'Quantity',
			'picked_qty' => 'Picked Qty',
			'unit_id' => 'Unit',
			'rate' => 'Rate',
			'amount' => 'Amount',
			'addition_percentage' => 'Addition Percentage',
			'addition_amount' => 'Addition Amount',
			'deduction_percentage' => 'Deduction Percentage',
			'deduction_amount' => 'Deduction Amount',
			'tax_vat_percentage' => 'Tax Vat Percentage',
			'tax_vat_amount' => 'Tax Vat Amount',
			'net_amount' => 'Net Amount',
			'cost_rate' => 'Cost Rate',
			'fin_account_id' => 'Fin Account',
			'unit_factor' => 'Unit Factor',
			'unit_cost_rate' => 'Unit Cost Rate',
			'base_cost_rate' => 'Base Cost Rate',
			'cost_updated' => 'Cost Updated',
			'created_by' => 'Created By',
			'updated_cost_rate' => 'Updated Cost Rate',
			'updated_by' => 'Updated By',
			'created_datetime' => 'Created Datetime',
			'updated_datetime' => 'Updated Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */



	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	/* public function search() {
		 // @todo Please modify the following code to remove attributes that should not be searched.

		 $criteria = new CDbCriteria;
		 if (isset($_GET['invoice_id']))// if isadmin
			 $criteria->condition = "quantity>0 AND invoice_id=" . (int) $_GET['invoice_id'][0];
		 // if (isset($_POST['product_id']))// if isadmin
		 //     $criteria->condition = "product_id=" . (int) $_POST['product_id'];

		 return new CActiveDataProvider($this, array(
			 'criteria' => $criteria,
		 ));
	 }*/

	public function generatesaleshistory()
	{
		$criteria = new CDbCriteria;
		if (isset($_POST['product_id']))// if isadmin
			$criteria->condition = "product_id=" . (int) $_POST['product_id'];
		$criteria->with = array('invoice');
		if (isset($_POST['sales_hist_start_date']) && isset($_POST['sales_hist_end_date']) && isset($_POST['sales_history_product_id']))
			$criteria->condition .= 'product_id   = "' . $_POST['sales_history_product_id'] . '" AND invoice.invoice_date BETWEEN "' . $_POST['sales_hist_start_date'] . '" AND "' . $_POST['sales_hist_end_date'] . '"';
		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
			'sort' => array(
				'defaultOrder' => 'invoice.invoice_date DESC',
			),
			'pagination' => array('pageSize' => 10)
		));
	}

	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id, true);
		$criteria->compare('invoice_id', $this->invoice_id);
		$criteria->compare('order_item_id', $this->order_item_id);
		$criteria->compare('product_id', $this->product_id);
		$criteria->compare('description', $this->description, true);
		$criteria->compare('product_generic_name', $this->product_generic_name, true);
		$criteria->compare('brand_class_id', $this->brand_class_id);
		$criteria->compare('quantity', $this->quantity, true);
		$criteria->compare('picked_qty', $this->picked_qty, true);
		$criteria->compare('unit_id', $this->unit_id);
		$criteria->compare('rate', $this->rate, true);
		$criteria->compare('amount', $this->amount, true);
		$criteria->compare('addition_percentage', $this->addition_percentage, true);
		$criteria->compare('addition_amount', $this->addition_amount, true);
		$criteria->compare('deduction_percentage', $this->deduction_percentage, true);
		$criteria->compare('deduction_amount', $this->deduction_amount, true);
		$criteria->compare('tax_vat_percentage', $this->tax_vat_percentage, true);
		$criteria->compare('tax_vat_amount', $this->tax_vat_amount, true);
		$criteria->compare('net_amount', $this->net_amount, true);
		$criteria->compare('cost_rate', $this->cost_rate, true);
		$criteria->compare('fin_account_id', $this->fin_account_id);
		$criteria->compare('unit_factor', $this->unit_factor, true);
		$criteria->compare('unit_cost_rate', $this->unit_cost_rate, true);
		$criteria->compare('base_cost_rate', $this->base_cost_rate, true);
		$criteria->compare('cost_updated', $this->cost_updated, true);
		$criteria->compare('created_by', $this->created_by);
		$criteria->compare('updated_cost_rate', $this->updated_cost_rate, true);
		$criteria->compare('updated_by', $this->updated_by);
		$criteria->compare('created_datetime', $this->created_datetime, true);
		$criteria->compare('updated_datetime', $this->updated_datetime, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return InvoiceItem the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}



}
