<?php

/**
 * This is the model class for table "{{invoice}}".
 *
 * The followings are the available columns in table '{{invoice}}':
 * @property string $id
 * @property string $delivery_ids
 * @property integer $file_id
 * @property string $order_id
 * @property integer $project_id
 * @property string $invoice_no
 * @property string $customer_id
 * @property integer $contact_id
 * @property integer $lead_owner_id
 * @property string $billing_address
 * @property string $invoice_date
 * @property integer $sales_group_id
 * @property string $reference
 * @property integer $currency_id
 * @property string $exchange_rate
 * @property integer $payment_terms_id
 * @property string $shipping_by
 * @property string $notes
 * @property string $remarks
 * @property integer $terms_id
 * @property string $terms_and_conditions
 * @property string $is_direct_invoice
 * @property string $invoice_status
 * @property integer $invoice_type
 * @property string $added_from
 * @property string $posted
 * @property string $grand_total
 * @property string $round_off_amount
 * @property integer $warehouse_id
 * @property string $isActive
 * @property integer $ticket_id
 * @property string $total_discount_percentage
 * @property string $total_discount_amount
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_datetime
 * @property string $updated_datetime
 * @property string $inco_term_id
 */
class Invoice extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	 
	
    public $customer_name;
    public $contact_name;
    public $lead_owner_id;
    public $lead_owner_name;
    
	public function tableName()
	{
		return '{{invoice}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			 array('file_id, customer_id,project_id,invoice_date, sales_group_id, currency_id, payment_terms_id, invoice_type, lead_owner_id,created_by', 'required'),
			array('file_id, lead_owner_id, sales_group_id, currency_id, payment_terms_id, terms_id, invoice_type, warehouse_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			 array('exchange_rate, net_amount, grand_total,total_tax_amount,total_discount_percentage,total_discount_amount', 'numerical'),
			array('delivery_ids, invoice_no, reference, shipping_by', 'length', 'max'=>255),
			array('exchange_rate, grand_total, round_off_amount, total_discount_percentage, total_discount_amount,inco_term_id', 'length', 'max'=>15),
			array(
                'exchange_rate',
                'compare',
                'compareValue' => 1,
                'operator' => '>=',
                'allowEmpty' => false,
                'message' => '{attribute} must be greater than or equal to "{compareValue}".'
            ),
			array('is_direct_invoice, invoice_status, added_from, posted, isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, delivery_ids, file_id, order_id, project_id, invoice_no,sales_inv_type,customer_id,inco_term_id, contact_id, lead_owner_id, billing_address, invoice_date, sales_group_id, reference, currency_id, exchange_rate, payment_terms_id, shipping_by, notes, remarks, terms_id, terms_and_conditions, is_direct_invoice, invoice_status, invoice_type, added_from, posted, grand_total, round_off_amount, warehouse_id, isActive, ticket_id, total_discount_percentage, total_discount_amount, created_by, updated_by, created_datetime, updated_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'contact' => array(self::BELONGS_TO, 'CustomerContact', 'contact_id'),
            'leadowner' => array(self::BELONGS_TO, 'User', 'lead_owner_id'),
            'invoicetype' => array(self::BELONGS_TO, 'MasInvoiceType', 'invoice_type'),
            'order_details' => array(self::BELONGS_TO, 'Order', 'order_id'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            'currency' => array(self::BELONGS_TO, 'MasCurrency', 'currency_id'),
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'netSales' => array(self::STAT, 'InvoiceItem', 'invoice_id', 'join' => ' INNER JOIN {{invoice}} I ON I.id = t.invoice_id', 'select' => 'SUM(t.net_amount+t.tax_vat_amount)*I.exchange_rate'),
            'netAmount' => array(self::STAT, 'InvoiceItem', 'invoice_id', 'join' => ' INNER JOIN {{invoice}} I ON I.id = t.invoice_id', 'select' => 'SUM(t.net_amount)*I.exchange_rate'),
            'netVat' => array(self::STAT, 'InvoiceItem', 'invoice_id', 'join' => ' INNER JOIN {{invoice}} I ON I.id = t.invoice_id', 'select' => 'SUM(t.tax_vat_amount)*I.exchange_rate'),
            'netQuantity' => array(self::STAT, 'InvoiceItem', 'invoice_id', 'select' => 'SUM(quantity)'),
            //'processedInvoice' => array(self::HAS_MANY, 'ReceivedInvoices', 'invoice_id'),
            //'receivedAmount' => array(self::STAT, 'ReceivedInvoices', 'invoice_id', 'select' => 'SUM(received_amt)'),
            'items' => array(self::HAS_MANY, 'InvoiceItem', 'invoice_id'),
            'currencyname' => array(self::BELONGS_TO, 'MasCurrency', 'currency_id'),
            //'taxtype' => array(self::BELONGS_TO, 'MasInvTax', 'tax_type'),
            'paymentTerm' => array(self::BELONGS_TO, 'MasPaymentTerm', 'payment_terms_id'),
            //'adItems' => array(self::HAS_MANY, 'InvoiceAddition', 'invoice_id'),
            //'dedItems' => array(self::HAS_MANY, 'InvoiceDeduction', 'invoice_id'),
            //'adTotal' => array(self::STAT, 'InvoiceAddition', 'inoice_id', 'select' => 'SUM(calculated_value)'),
            //'dedTotal' => array(self::STAT, 'InvoiceDeduction', 'inoice_id', 'select' => 'SUM(calculated_value)'),
            // 'costTotal' => array(self::STAT, 'InvoiceItem', 'invoice_id', 'select' => 'SUM(cost_rate*quantity)'),
            'salesgroup' => array(self::BELONGS_TO, 'MasSalesGroup', 'sales_group_id'),
            'returned' => array(self::HAS_ONE, 'Creditnote', 'invoice_id'),
            'returnedAmount' => array(self::STAT, 'Creditnote', 'invoice_id', 'select' => 'SUM(credited_amount)'),
            'returnedVATAmount' => array(self::STAT, 'Creditnote', 'invoice_id', 'select' => 'SUM(total_tax_amount)'),
            'returnedAmountInBC' => array(self::STAT, 'Creditnote', 'invoice_id',
                'join' => 'INNER JOIN {{invoice}} `inv` ON `inv`.`id` = `t`.`invoice_id`
                    INNER JOIN {{order}} `tc` ON `tc`.`id` = `inv`.`order_id`', 'select' => 'SUM(t.credited_amount*tc.exchange_rate)'),
            'createdby' => array(self::BELONGS_TO, 'User', 'created_by'),
            'warehouse' => array(self::BELONGS_TO, 'MasInventoryWarehouse', 'warehouse_id'),
            'incoterm' => array(self::BELONGS_TO, 'MasIncoTerms', 'inco_term_id'),

		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'delivery_ids' => 'Delivery Ids',
			'file_id' => 'File',
			'order_id' => 'Order',
			'project_id' => 'Project',
			'invoice_no' => 'Invoice No',
			'customer_id' => 'Customer',
			'contact_id' => 'Contact',
			'lead_owner_id' => 'Lead Owner',
			'billing_address' => 'Billing Address',
			'invoice_date' => 'Invoice Date',
			'sales_group_id' => 'Sales Group',
			'reference' => 'Reference',
			'currency_id' => 'Currency',
			'exchange_rate' => 'Exchange Rate',
			'payment_terms_id' => 'Payment Terms',
			'shipping_by' => 'Shipping By',
			'notes' => 'Notes',
			'remarks' => 'Remarks',
			'terms_id' => 'primary key to masterms ',
			'terms_and_conditions' => 'Terms And Conditions',
			'is_direct_invoice' => 'Is Direct Invoice',
			'invoice_status' => 'Y-Active,C-Cancelled',
			'invoice_type' => 'Primary key of crmmas_invoice_type id',
			'added_from' => 'Added From',
			'posted' => 'Posted',
			'grand_total' => 'Grand Total',
			'round_off_amount' => 'Round Off Amount',
			'warehouse_id' => 'Warehouse',
			'isActive' => 'Is Active',
			'ticket_id' => 'Ticket',
			'total_discount_percentage' => 'Total Discount Percentage',
			'total_discount_amount' => 'Total Discount Amount',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'created_datetime' => 'Created Datetime',
			'updated_datetime' => 'Updated Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('delivery_ids',$this->delivery_ids,true);
		$criteria->compare('file_id',$this->file_id);
		$criteria->compare('order_id',$this->order_id,true);
		$criteria->compare('project_id',$this->project_id);
		$criteria->compare('invoice_no',$this->invoice_no,true);
		$criteria->compare('customer_id',$this->customer_id,true);
		$criteria->compare('contact_id',$this->contact_id);
		$criteria->compare('lead_owner_id',$this->lead_owner_id);
		$criteria->compare('billing_address',$this->billing_address,true);
		$criteria->compare('invoice_date',$this->invoice_date,true);
		$criteria->compare('sales_group_id',$this->sales_group_id);
		$criteria->compare('reference',$this->reference,true);
		$criteria->compare('currency_id',$this->currency_id);
		$criteria->compare('exchange_rate',$this->exchange_rate,true);
		$criteria->compare('payment_terms_id',$this->payment_terms_id);
		$criteria->compare('shipping_by',$this->shipping_by,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('remarks',$this->remarks,true);
		$criteria->compare('terms_id',$this->terms_id);
		$criteria->compare('terms_and_conditions',$this->terms_and_conditions,true);
		$criteria->compare('is_direct_invoice',$this->is_direct_invoice,true);
		$criteria->compare('invoice_status',$this->invoice_status,true);
		$criteria->compare('invoice_type',$this->invoice_type);
		$criteria->compare('added_from',$this->added_from,true);
		$criteria->compare('posted',$this->posted,true);
		$criteria->compare('grand_total',$this->grand_total,true);
		$criteria->compare('round_off_amount',$this->round_off_amount,true);
		$criteria->compare('warehouse_id',$this->warehouse_id);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('ticket_id',$this->ticket_id);
		$criteria->compare('total_discount_percentage',$this->total_discount_percentage,true);
		$criteria->compare('total_discount_amount',$this->total_discount_amount,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);
		$criteria->compare('updated_datetime',$this->updated_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Invoice the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public function getFullinvoice() {
        return $this->invoicetype->inv_code . '-' . $this->invoice_no;
    }

    public function getCustomername() {
        return $this->customer->customer_name;
    }

    public function getFullcurrency() {
        return $this->currencyname->currency_code;
    }

    public function getTotals($ids) {
        $ids = implode(",", $ids);
        $connection = Yii::app()->db;
        if (!empty($ids)) {
            $command = $connection->createCommand("SELECT SUM(i.grand_total*i.exchange_rate)-SUM(IFNULL(c.credited_amount, 0)*i.exchange_rate) FROM `crm_invoice` i
                join `crm_order` o
                on o.id=i.order_id
                left outer join `crm_creditnote` c
               on i.id=c.invoice_id where i.id in ($ids)");
            return $command->queryScalar();

            /* $command = $connection->createCommand("SELECT SUM(credited_amount) FROM `crm_creditnote` where invoice_id in ($ids)");
              $total_credit_amnt = $command->queryScalar();
              return (($total_inv_amnt - $total_credit_amnt) - $this->file->order->exchange_rate); */
        } else
            return "";
    }

    public function calcIndividualProfit($items) {
        $costrate = true;
        foreach ($items as $eachItem) {
            if (empty($eachItem->cost_rate) || $eachItem->cost_rate == 0) {
                if ($eachItem->product->rate != 0) {
                    $eachItem->cost_rate = $eachItem->product->rate;
                    $eachItem->save();
                } else
                    $costrate = true; //false; //commneted for removing CRO from GP
            }
        }
        if ($costrate) {
            if ($this->file->current_process_status == "C" /* && ($this->grand_total == $this->returnedAmount) */) {
                $profit = '0.00';
            } else {
                $profit = $this->grandTotalLC - $this->costTotal;
            }
            return $profit;
        } else {
            return false;
        }
    }

    public function getSumOfProfits($ids = null) {
        $sumOfprofit = 0;
        if (count($ids) > 0) {
            $ids = implode(",", $ids);

            $invoices = self::model()->findAll('id in (' . $ids . ')');
            foreach ($invoices as $eachInvoice) {
                $sumOfprofit += $eachInvoice->calcIndividualProfit($eachInvoice->items);
            }
        }
        return $sumOfprofit;
    }

    public function getGrandTotalLC() {
        //return (($this->grand_total - $this->returnedAmount) * $this->file->order->exchange_rate);
        return (($this->grand_total - $this->returnedAmount) * $this->exchange_rate);
    }

    public function getGrandTotal() {
        return (($this->grand_total - $this->returnedAmount) );
    }

    public function getProfit() {
        $profit = $this->calcIndividualProfit($this->items);
        return (!$profit) ? '<span color="red">CR0</span>' : $profit;
    }

    public function getProfitInPercentage() {
        return (($this->profit / $this->costTotal) * 100);
    }

    public function getStatus() {
        if (count($this->returned) > 0)
            return 'CN';
        else
            return 'INVOICE';
    }

    public function getGrand_total_bc() {
        //return ($this->grand_total * $this->file->order->exchange_rate);
        return ($this->grand_total * $this->exchange_rate);
    }

    public function invoiceFiles($lead_owner_id) {
        $model = MasterFile::model()->findAll(array('condition' => 'lead_owner_id=' . $lead_owner_id));
        $criteria = new CDbCriteria;
        $criteria->with = array('file');
        foreach ($model as $eachItem) {
            $criteria->addCondition('t.file_id=' . $eachItem->id, 'OR');
        }
        $criteria->addCondition('(file.current_process_status="I" OR file.current_process_status="PI")', 'AND');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.invoice_date ASC',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 20) : false,
        ));
    }

    public function getSumOfCostTotal($ids = null) {
        $sumCostTotal = 0;
        if (count($ids) > 0) {
            $ids = implode(",", $ids);
            $query = "SELECT SUM(cost_rate*quantity) AS grant_cost_total FROM {{invoice_item}} WHERE invoice_id IN(" . $ids . ")";
            $arr_cost_total = Yii::app()->db->createCommand($query)->queryAll();
            $sumCostTotal = $arr_cost_total[0]['grant_cost_total'];
        }
        return $sumCostTotal;
    }

    public function getTotalGrandTotalLC($arr_data) {
        $total_grand_total_amount = 0;
        foreach ($arr_data as $record) {
            $order_id = $record->order_id;
            $invoice_id = $record->id;
            $total_invoice_amount = $record->grand_total;
            $exchange_rate = $record->exchange_rate;

            $SQL = "SELECT SUM(credited_amount) FROM `crm_creditnote` WHERE invoice_id=" . $invoice_id;
            $total_credited_amount = Yii::app()->db->createCommand($SQL)->queryScalar();

            if ($exchange_rate <= 0) {
                $SQL_ORDER = "SELECT exchange_rate FROM `crm_order` WHERE id=" . $order_id;
                $exchange_rate = Yii::app()->db->createCommand($SQL_ORDER)->queryScalar();
            }

            $grand_total_value = (($total_invoice_amount - $total_credited_amount) * $exchange_rate);
            $total_grand_total_amount += $grand_total_value;
        }
        return $total_grand_total_amount;
    }

    public function getGrandtotalvalue() {
        return ( round(($this->grand_total * $this->exchange_rate), 2) );
    }

    public function generateInvoice() {
        if ($this->invoice_type > 0) {
            $model = MasInvoiceType::model()->findByPk($this->invoice_type);
            $this->invoice_no = ( $model->current_serial_no > 0 ) ? $model->current_serial_no + 1 : $model->start_serial_no;
            $model->current_serial_no = $this->invoice_no;
            $model->save(false);
        }
    }

    public function getCreated_user() {
        $usermodel = User::model()->findByPK($this->created_by);
        return $usermodel->fullname;
    }

    public function getcostTotal() {
        if ($this->id) {
            $sql = "SELECT SUM(cost_rate*quantity) AS costTotal FROM erp_invoice_item WHERE invoice_id=" . $this->id;
            $cost_Total = Yii::app()->db->createCommand($sql)->queryScalar();
            return (float) $cost_Total;

            // $sql = "SELECT SUM(cost_price * abs(quantity)) AS costTotal FROM erp_stock_ledger WHERE header_id = " . $this->id . " AND transaction_from = 'DIRECT_INVOICE'";
            // $cost_Total = Yii::app()->db->createCommand($sql)->queryScalar();
            // return (float) $cost_Total;
        }
    }
}
