<?php

/**
 * This is the model class for table "{{inventory_indirect_received_items}}".
 *
 * The followings are the available columns in table '{{inventory_indirect_received_items}}':
 * @property integer $id
 * @property integer $indirect_transferitem_id
 * @property integer $item_id
 * @property string $item_name
 * @property string $item_description
 * @property integer $transfer_qty
 * @property string $receive_qty
 * @property integer $damaged_qty
 */
class InventoryIndirectReceivedItems extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{inventory_indirect_received_items}}';
	}
        public $from_material_receipt;
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('indirect_receive_transfer_id, item_id, receive_qty, transfer_qty', 'required'),
			array('indirect_transferitem_id, item_id', 'numerical', 'integerOnly'=>true),
			array('transfer_qty, damaged_qty', 'numerical'),
			array('item_name', 'length', 'max'=>255),
			array('receive_qty', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, indirect_transferitem_id, item_id, item_name, item_description, transfer_qty, receive_qty, damaged_qty', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'indirect_item' => array(self::BELONGS_TO, 'InventoryIndirectTransferItem', 'indirect_transferitem_id'),
                    'parent'=>array(self::BELONGS_TO, 'InventoryIndirectReceived', 'indirect_receive_transfer_id'),
					'stock' => array(self::BELONGS_TO, 'Store', 'item_id'),
					'unitdetails' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit'),
					
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'indirect_transferitem_id' => 'Indirect Transferitem',
			'item_id' => 'Item',
			'item_name' => 'Item Name',
			'item_description' => 'Item Description',
			'transfer_qty' => 'Transfer Qty',
			'receive_qty' => 'Received Qty',
			'damaged_qty' => 'Damage Quantity',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('indirect_transferitem_id',$this->indirect_transferitem_id);
		$criteria->compare('item_id',$this->item_id);
		$criteria->compare('item_name',$this->item_name,true);
		$criteria->compare('item_description',$this->item_description,true);
		$criteria->compare('transfer_qty',$this->transfer_qty);
		$criteria->compare('receive_qty',$this->receive_qty,true);
		$criteria->compare('damaged_qty',$this->damaged_qty);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return InventoryIndirectReceivedItems the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
