<?php

/**
 * This is the model class for table "{{inventory_hiring_transfer}}".
 *
 * The followings are the available columns in table '{{inventory_hiring_transfer}}':
 * @property string $id
 * @property string $from_warehouse_id
 * @property string $direct_transfer_description
 * @property string $reference
 * @property string $transfer_date
 * @property string $status
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_date_time
 * @property string $updated_date_time
 */
class InventoryHiringTransfer extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{inventory_hiring_transfer}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('from_warehouse_id,to_warehouse_id, transfer_date', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('from_warehouse_id,to_warehouse_id', 'length', 'max'=>20),
			array('reference', 'length', 'max'=>255),
			array('status', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, from_warehouse_id,to_warehouse_id,direct_transfer_description, reference, transfer_date, status, created_by, updated_by, created_date_time, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'warehouseTo' => array(self::BELONGS_TO, 'MasInventoryWarehouse', 'to_warehouse_id'),
            'warehouseFrom' => array(self::BELONGS_TO, 'MasInventoryWarehouse', 'from_warehouse_id'),
            'items' => array(self::HAS_MANY, 'InventoryDirectTransferItem', 'direct_transfer_id'),
        );
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'from_warehouse_id' => 'From Warehouse',
			'to_warehouse_id' => 'To Warehouse',
			'direct_transfer_description' => 'Description',
			'reference' => 'Reference',
			'transfer_date' => 'Transfer Date',
			'status' => 'T - in transit, P - Packing, C- Completed',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'created_date_time' => 'Created Date Time',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('from_warehouse_id',$this->from_warehouse_id,true);
		$criteria->compare('to_warehouse_id',$this->to_warehouse_id,true);
		$criteria->compare('direct_transfer_description',$this->direct_transfer_description,true);
		$criteria->compare('reference',$this->reference,true);
		$criteria->compare('transfer_date',$this->transfer_date,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return InventoryHiringTransfer the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
