<?php

/**
 * This is the model class for table "{{inventory_goods_receipt_item}}".
 *
 * The followings are the available columns in table '{{inventory_goods_receipt_item}}':
 * @property integer $id
 * @property integer $goods_receipt_id
 * @property integer $product_id
 * @property string $product_name
 * @property string $description
 * @property string $unit
 * @property integer $picked_qty
 */
class InventoryGoodsReceiptItem extends CActiveRecord {

    public $current_cost;
    public $s_unit;
    public $free_qty;
    public $warehouse_id;
   
    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{inventory_goods_receipt_item}}';
    }

    /**
     * @return array validation rules for model attributes.
     */

    //  inventory_goods_receipt_id name changed to  goods_receipt_id by arun sir on 10-11-2025

    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('product_id, product_name, description,rate,unit, picked_qty', 'required'),
            array('goods_receipt_id, product_id', 'numerical', 'integerOnly' => true),
            array('picked_qty', 'checkAvailableQty'),
            //array('picked_qty', 'numerical'),
            array('product_name, description, unit,rate', 'length', 'max' => 255),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, goods_receipt_id, product_id, product_name, description, unit, picked_qty', 'safe', 'on' => 'search'),
        );
    }
    
    public function checkAvailableQty($attribute,$params)
    {
    	if($this->picked_qty!="" && $this->picked_qty<=0){
    		$this->addError('picked_qty','Picked quantity should be grater than 0');
    	}
    }

   
    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'unitdetails' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit'),
            'inventorygoodsreceipt' => array(self::BELONGS_TO, 'InventoryGoodsReceipt', 'goods_receipt_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'goods_receipt_id' => 'Inventory Goods Receipt',
            'product_id' => 'Product',
            'product_name' => 'Product Name',
            'description' => 'Description',
            'unit' => 'Unit',
            'rate' => 'Rate',
            'picked_qty' => 'Picked Quantity',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date',
            'created_date_time' => 'Created Date',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('goods_receipt_id', $this->goods_receipt_id);
        $criteria->compare('product_id', $this->product_id);
        $criteria->compare('product_name', $this->product_name, true);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('unit', $this->unit, true);
        $criteria->compare('picked_qty', $this->picked_qty);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return InventoryGoodsReceiptItem the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
