<?php

/**
 * This is the model class for table "{{inventory_direct_transfer_item_details}}".
 *
 * The followings are the available columns in table '{{inventory_direct_transfer_item_details}}':
 * @property integer $id
 * @property integer $transfer_id
 * @property integer $from_material_receipt
 * @property integer $to_material_receipt
 * @property string $old_qty
 */
class InventoryDirectTransferItemDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{inventory_direct_transfer_item_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('transfer_id, from_material_receipt, to_material_receipt, old_qty', 'required'),
			array('transfer_id, from_material_receipt, to_material_receipt', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, transfer_id, from_material_receipt, to_material_receipt, old_qty', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'mr_in' => array(self::BELONGS_TO, 'MaterialReceiptStockDetails', 'from_material_receipt'),
                    'mr_out' => array(self::BELONGS_TO, 'MaterialReceiptStockDetails', 'to_material_receipt'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'transfer_id' => 'Transfer',
			'from_material_receipt' => 'From Material Receipt',
			'to_material_receipt' => 'To Material Receipt',
			'old_qty' => 'Old Qty',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('transfer_id',$this->transfer_id);
		$criteria->compare('from_material_receipt',$this->from_material_receipt);
		$criteria->compare('to_material_receipt',$this->to_material_receipt);
		$criteria->compare('old_qty',$this->old_qty,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return InventoryDirectTransferItemDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
