<?php

/**
 * This is the model class for table "{{hiring_damage_history}}".
 *
 * The followings are the available columns in table '{{hiring_damage_history}}':
 * @property integer $id
 * @property integer $hiring_package_details
 * @property integer $product_id
 * @property string $damage_quantity
 * @property string $damage_date
 * @property string $damage_remarks
 * @property string $repair_date
 * @property integer $created_by
 * @property integer $created_date_time
 */
class HiringDamageHistory extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hiring_damage_history}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('hiring_package_details,pdt_loc_id, product_id, damage_quantity, damage_date, created_by, created_date_time', 'required'),
			array('hiring_package_details, product_id, created_by', 'numerical', 'integerOnly'=>true),
			array('damage_quantity', 'length', 'max'=>15),
			array('damage_remarks', 'length', 'max'=>500),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, hiring_package_details, product_id, damage_quantity, damage_date, damage_remarks, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'hiring_package_details' => 'Hiring Package Details',
			'product_id' => 'Product',
			'damage_quantity' => 'Damage Quantity',
			'damage_date' => 'Damage Date',
			'damage_remarks' => 'Damage Remarks',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('hiring_package_details',$this->hiring_package_details);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('damage_quantity',$this->damage_quantity,true);
		$criteria->compare('damage_date',$this->damage_date,true);
		$criteria->compare('damage_remarks',$this->damage_remarks,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HiringDamageHistory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
