<?php

/**
 * This is the model class for table "{{finance_emi_category}}".
 *
 * The followings are the available columns in table '{{finance_emi_category}}':
 * @property integer $id
 * @property string $name
 * @property string $isActive
 * @property string $created_date_time
 * @property string $updated_date_time
 * @property integer $updated_by
 * @property integer $created_by
 */
class EmiCategory extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{finance_emi_category}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('name, isActive, created_date_time, updated_date_time, updated_by, created_by', 'required'),
            array('updated_by, created_by', 'numerical', 'integerOnly' => true),
            array('name', 'length', 'max' => 300),
            array('isActive,type', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, name, isActive, created_date_time, updated_date_time, updated_by, created_by', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'name' => 'Name',
            'isActive' => 'Is Active',
            'created_date_time' => 'Created Date Time',
            'updated_date_time' => 'Updated Date Time',
            'updated_by' => 'Updated By',
            'created_by' => 'Created By',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('name', $this->name, true);
        $criteria->compare('isActive', $this->isActive, true);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('created_by', $this->created_by);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return EmiCategory the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getActiveCategory() {
        $condition = "t.isActive = 'Y' ";
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'name'));
        return CHtml::listData($model, 'id', 'name');
    }

}
