<?php

/**
 * This is the model class for table "{{direct_invoice_item}}".
 *
 * The followings are the available columns in table '{{direct_invoice_item}}':
 * @property integer $id
 * @property integer $product_id
 * @property integer $invoice_id
 * @property string $description
 * @property string $quantity
 * @property string $unit
 * @property string $rate
 * @property string $deduction_amount
 * @property string $amount
 * @property string $tax_vat_percentage
 * @property string $tax_vat_amount
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_datetime
 * @property string $updated_datetime
 */
class DirectInvoiceItem extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $part_no;
	public $unit;
	public $deduction_percentage;
	public $actual_tax_vat_percentage;
	public $actual_tax_vat_amount;
	public $actual_rate;
	public function tableName()
	{
		return '{{direct_invoice_item}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('invoice_id, product_id, description, part_no, quantity, unit_id, rate, amount', 'required'),
			array('product_id, invoice_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('quantity, rate, deduction_amount, amount, tax_vat_percentage, tax_vat_amount', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, product_id, invoice_id, description, quantity, unit_id, rate, deduction_amount, amount, tax_vat_percentage, tax_vat_amount, created_by, updated_by, created_datetime, updated_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'parent' => array(self::BELONGS_TO, 'DirectInvoice', 'invoice_id'),
            'product_id' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'invoiceunit' => array(self::BELONGS_TO, 'Unit', 'unit_id'),
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'uomdetails' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_id' => 'Product',
			'invoice_id' => 'Invoice',
			'description' => 'Description',
			'quantity' => 'Quantity',
			'unit_id' => 'Unit',
			'rate' => 'Rate',
			'deduction_amount' => 'deduction_amount',
			'amount' => 'Amount',
			'tax_vat_percentage' => 'Tax Percentage',
			'tax_vat_amount' => 'Tax Amount',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'created_datetime' => 'Created Datetime',
			'updated_datetime' => 'Updated Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('invoice_id',$this->invoice_id);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('quantity',$this->quantity,true);
		$criteria->compare('unit_id',$this->unit,true);
		$criteria->compare('rate',$this->rate,true);
		$criteria->compare('deduction_amount',$this->deduction_amount,true);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('tax_vat_percentage',$this->tax_vat_percentage,true);
		$criteria->compare('tax_vat_amount',$this->tax_vat_amount,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);
		$criteria->compare('updated_datetime',$this->updated_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return DirectInvoiceItem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
