<?php

/**
 * This is the model class for table "{{dining_table}}".
 *
 * The followings are the available columns in table '{{dining_table}}':
 * @property integer $id
 * @property string $code
 * @property integer $seat
 */
class DiningTable extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{dining_table}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('id, code, seat', 'required'),
            array('id, seat', 'numerical', 'integerOnly' => true),
            array('code', 'length', 'max' => 2),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, code, seat', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'code' => 'Code',
            'seat' => 'Seat',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('code', $this->code, true);
        $criteria->compare('seat', $this->seat);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return DiningTable the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getOccupied() {
        $sql = "SELECT COUNT(DISTINCT `seat_num`) FROM `erp_table_order`  where table_id = " . $this->id . " and is_billed = 'N'  ";
        $count = Yii::app()->db->createCommand($sql)->queryScalar();
        return $count;
    }

    public function getSeatList() {
        $sql = "SELECT DISTINCT `seat_num` FROM `erp_table_order`  where table_id = " . $this->id . " and is_billed = 'N'  ";
        $data = Yii::app()->db->createCommand($sql)->queryAll();
        $list = [];
        foreach ($data as $value) {
            $list[] = [
                "id" => $value['seat_num']
            ];
        }
        return $list;
    }

}
