<?php

/**
 * This is the model class for table "{{demo_item_details}}".
 *
 * The followings are the available columns in table '{{demo_item_details}}':
 * @property integer $id
 * @property integer $demo_monitoring_id
 * @property integer $product_id
 * @property string $part_number
 * @property string $description
 * @property string $item_serial_no
 * @property integer $quantity
 * @property string $unit
 * @property integer $picked_qty
 * @property string $item_return_date
 */
class DemoItemDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
        public $product_name;
        public $unit_name;
        public function tableName()
	{
		return '{{demo_item_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_id,picked_qty', 'required'),
			array('demo_monitoring_id, product_id', 'numerical', 'integerOnly'=>true),
			array('quantity, picked_qty', 'numerical'),
			array('part_number, description, item_serial_no', 'length', 'max'=>255),
			array('unit', 'length', 'max'=>20),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, demo_monitoring_id, product_id, part_number, description, item_serial_no, quantity, unit, picked_qty, item_return_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'demo' => array(self::BELONGS_TO, 'DemoItemGeneral', 'demo_monitoring_id'),
                    'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
                    'unt' => array(self::BELONGS_TO, 'Unit', 'unit'),
                    'customer_detail' => array(self::BELONGS_TO, 'Customer', 'demo_monitoring_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'demo_monitoring_id' => 'Demo Monitoring',
			'product_id' => 'Product',
			'part_number' => 'Part Number',
			'description' => 'Description',
			'item_serial_no' => 'Item Serial No',
			'quantity' => 'Return Quantity',
			'unit' => 'Unit',
			'picked_qty' => 'Picked Qty',
			'item_return_date' => 'Item Return Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('demo_monitoring_id',$this->demo_monitoring_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('part_number',$this->part_number,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('item_serial_no',$this->item_serial_no,true);
		$criteria->compare('quantity',$this->quantity);
		$criteria->compare('unit',$this->unit,true);
		$criteria->compare('picked_qty',$this->picked_qty);
		$criteria->compare('item_return_date',$this->item_return_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return DemoItemDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
