<?php

/**
 * This is the model class for table "{{delivery_item}}".
 *
 * The followings are the available columns in table '{{delivery_item}}':
 * @property integer $id
 * @property integer $delivery_note_id
 * @property integer $product_id
 * @property string $description
 * @property double $quantity
 * @property integer $unit
 * @property double $picked_qty
  *
 * The followings are the available model relations:
 * @property DeliveryNote $deliveryNote
 * @property Store $product
 */
class DeliveryNoteItem extends CActiveRecord {

    public $product_name;
    public $unit_name;
    public $factor;
    public $pickable_quantity;
    public $pickable_bonus_quantity;
    public $free_quantity;
    public $inventory_type;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{delivery_item}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('product_id, description, quantity, picked_qty,order_item_id', 'required'),
            array('delivery_note_id, product_id', 'numerical', 'integerOnly' => true),
            array('quantity, picked_qty', 'numerical'),
            array('product_name,alternate_id', 'length', 'max' => 255),
            array('description', 'length', 'max' => 10000),
           
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, delivery_note_id, product_id, description, quantity, unit_id, picked_qty', 'safe', 'on' => 'search'),
        );
    }

    

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'deliveryNote' => array(self::BELONGS_TO, 'DeliveryNote', 'delivery_note_id'),
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),            
            'unitdetails' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit_id'),
            'unit_2' => array(self::BELONGS_TO, 'Unit', 'unit_id'),
            'orderitem' => array(self::BELONGS_TO, 'OrderItem', 'order_item_id'),    
            'doitem' => array(self::BELONGS_TO, 'DirectInvoiceItem', 'order_item_id'),    
                /* 'totalQuantity'=> array(self::STAT, 'DeliveryNoteItem', 'id', 'select' => 'SUM(quantity)'),
                  'totalPickedQuantity'=> array(self::STAT, 'DeliveryNoteItem', 'id', 'select' => 'SUM(picked_qty)'), */
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'delivery_note_id' => 'Delivery Note',
            'product_id' => 'Product',
            'description' => 'Description',
            'quantity' => 'Quantity',
            'unit_id' => 'Unit',
            'picked_qty' => 'Picked Qty',
            
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('product');

        $criteria->addCondition('picked_qty !=0' ,'OR'); 
        $criteria->compare('id', $this->id);
        $criteria->compare('delivery_note_id', $this->delivery_note_id);
        $criteria->compare('product_id', $this->product_id);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('quantity', $this->quantity);
        $criteria->compare('unit_id', $this->unit_id);
        $criteria->compare('picked_qty', $this->picked_qty);
        
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 5) : false,
        ));
    }

    public function getPickedqty() {
        $connection = Yii::app()->db;
        $command = $connection->createCommand("SELECT SUM(picked_qty) FROM 
            {{delivery_item}} 
            where product_id=" . $this->product_id . " AND delivery_note_id=" . $this->delivery_note_id);
        if ($command->queryScalar() > 0)
            return Yii::app()->format->formatNumber($command->queryScalar());
        else
            return 0;
    }

    public function getTobepickedqty() {
        $connection = Yii::app()->db;
        $command = $connection->createCommand("SELECT SUM(picked_qty) FROM 
            {{delivery_item}} 
            where product_id=" . $this->product_id . " AND delivery_note_id=" . $this->delivery_note_id);
        if ($command->queryScalar() > 0)
            $picked_qty = Yii::app()->format->formatNumber($command->queryScalar());
        else
            $picked_qty = 0;
        $command1 = $connection->createCommand("SELECT SUM(quantity) FROM 
            {{order_item}} 
            where product_id=" . $this->product_id . " AND order_id=" . $this->deliveryNote->file->order->id);
        if ($command1->queryScalar() > 0)
            $ordered_qty = Yii::app()->format->formatNumber($command1->queryScalar());
        else
            $ordered_qty = 0;
        return ($ordered_qty - $picked_qty);
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return DeliveryItem the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
