<?php

/**
 * This is the model class for table "{{damaged_store_details}}".
 *
 * The followings are the available columns in table '{{damaged_store_details}}':
 * @property integer $id
 * @property integer $damaged_store_id
 * @property integer $product_id
 * @property string $part_number
 * @property string $quantity
 * @property integer $unit
 * @property integer $created_by
 * @property string $created_date_time
 */
class DamagedStoreDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
    public $rate;
    public $s_unit;
    public $warehouse;
    public $total_quantity;
    public $allocated_qty;
    public $total_qty;
    public $pickable_quantity;  
    public $description;
    public $avail_qty;
    public function tableName()
	{
		return '{{damaged_store_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('damaged_store_id, product_id, quantity, unit', 'required'),
			array('damaged_store_id, product_id, unit, created_by', 'numerical', 'integerOnly'=>true),
			array('part_number', 'length', 'max'=>255),
			array('quantity', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, damaged_store_id, product_id, part_number, quantity, unit, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
                    'damagedstore_details' => array(self::BELONGS_TO, 'DamagedStore', 'damaged_store_id'),
                    'unitdetails' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'damaged_store_id' => 'Damaged Store',
			'product_id' => 'primary key to crm_store',
			'part_number' => 'Part Number',
			'quantity' => 'Quantity',
			'unit' => 'Unit',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('damaged_store_id',$this->damaged_store_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('part_number',$this->part_number,true);
		$criteria->compare('quantity',$this->quantity,true);
		$criteria->compare('unit',$this->unit);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return DamagedStoreDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
