<?php

/**
 * This is the model class for table "{{company_pricing_group}}".
 *
 * The followings are the available columns in table '{{company_pricing_group}}':
 * @property string $id
 * @property string $customer_id
 * @property integer $brand_id
 * @property integer $pricing_group_id
 */
class CustomerPricingGroup extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{customer_pricing_group}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_id, brand_id, pricing_group_id', 'required'),
			array('brand_id, pricing_group_id', 'numerical', 'integerOnly'=>true),
			array('customer_id', 'length', 'max'=>20),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_id, brand_id, pricing_group_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'brand' => array(self::BELONGS_TO, 'ProductClass', 'brand_id'),
                    'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
                    'priceGroup' => array(self::BELONGS_TO, 'SalesPriceGroupName', 'pricing_group_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_id' => 'Company',
			'brand_id' => 'Brand',
			'pricing_group_id' => 'Pricing Group',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('customer_id',$this->customer_id,true);
		$criteria->compare('brand_id',$this->brand_id);
		$criteria->compare('pricing_group_id',$this->pricing_group_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CompanyPricingGroup the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
