<?php

/**
 * This is the model class for table "{{purchasingcredits_item}}".
 *
 * The followings are the available columns in table '{{purchasingcredits_item}}':
 * @property integer $id
 * @property integer $purchasingcredits_id
 * @property integer $product_id
 * @property double $purchased_quantity
 * @property string $description
 * @property double $rate
 * @property double $returned_quantity
 * @property double $net_amount
 */
class CreditnoteItem extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $product_name;
    public $picked_qty;
    public $unit;
    public $amount;
    public $credited_qty;

    public function tableName() {
        return '{{creditnote_item}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            //array('purchasingcredit_id, product_id, purchased_quantity, description, rate, returned_quantity, net_amount', 'required'),
            array('creditnote_id, product_id,deliverynote_id,returned_unit_id', 'numerical', 'integerOnly' => true),
            array('quantity, rate, returned_quantity,returned_bonus_qty,bonus_qty, net_amount,invoice_item_id', 'numerical'),
            array('remarks', 'length', 'max' => 5000),
            /*array(
                'returned_quantity',
                'compare',
                'compareAttribute' => 'quantity',
                'operator' => '<=',
                'allowEmpty' => false,
                'message' => '{attribute} must be greater than "{compareValue}".'
            ),*/
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, creditnote_id, product_id, quantity, description, rate, returned_quantity, net_amount,invoice_item_id', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'parent' => array(self::BELONGS_TO, 'Creditnote', 'creditnote_id'),
            'orderunit' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit'),
            'pdtloc'=>array(self::BELONGS_TO,'ProductLocationHiringDetails','product_loc_hiring_id'),
            'inv_item' => array(self::BELONGS_TO,'InvoiceItem','invoice_item_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'product_id' => 'Product',
            'quantity' => 'Sale Quantity',
            'description' => 'Description',
            'rate' => 'Rate',
            'returned_quantity' => 'Returned Quantity',
            'net_amount' => 'Net Amount',
        	'invoice_item_id'=> 'Invoice Item Id'	
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;
        $criteria->compare('id', $this->id);
        $criteria->compare('creditnote_id', $this->creditnote_id);
        $criteria->compare('product_id', $this->product_id);
        $criteria->compare('quantity', $this->quantity);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('rate', $this->rate);
        //$criteria->compare('returned_quantity', $this->returned_quantity);
        $criteria->compare('returned_quantity', 0, false, '>');
        $criteria->compare('net_amount', $this->net_amount);
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 5) : false,
        ));
    }

    public function getTotals($ids) {
        //$ids = implode(",", $ids);
        $connection = Yii::app()->db;
        if (!empty($ids)) {
            $total = 0;
            foreach ($ids as $id) {
                $product = CreditnoteItem::model()->findByPk($id);
                $total+=$product->net_amount;
            }
            return $total;
        }
        else
            return "";
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return PurchasingcreditsItem the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
