<?php

/**
 * This is the model class for table "{{cost_price_group}}".
 *
 * The followings are the available columns in table '{{cost_price_group}}':
 * @property integer $id
 * @property integer $product_id
 * @property string $cost_price1
 * @property string $cost_price3
 * @property string $cost_price4
 * @property string $cost_price5
 * @property string $cost_price_group_file_name
 * @property integer $uploaded_by
 * @property string $uploaded_date
 * @property integer $last_updated_by
 * @property string $last_updated_date
 */
class CostPriceGroup extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{cost_price_group}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
                        array('product_id', 'required'),
			array('product_id, uploaded_by, last_updated_by', 'numerical', 'integerOnly'=>true),
			array('cost_price1', 'length', 'max'=>15),
			array('cost_price_group_file_name', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, product_id, cost_price1, cost_price_group_file_name, uploaded_by, uploaded_date, last_updated_by, last_updated_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_id' => 'Product',
			'cost_price1' => 'Cost Price1',
			'cost_price_group_file_name' => 'Cost Price Group File Name',
			'uploaded_by' => 'Uploaded By',
			'uploaded_date' => 'Uploaded Date',
			'last_updated_by' => 'Last Updated By',
			'last_updated_date' => 'Last Updated Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('cost_price1',$this->cost_price1,true);
		$criteria->compare('cost_price_group_file_name',$this->cost_price_group_file_name,true);
		$criteria->compare('uploaded_by',$this->uploaded_by);
		$criteria->compare('uploaded_date',$this->uploaded_date,true);
		$criteria->compare('last_updated_by',$this->last_updated_by);
		$criteria->compare('last_updated_date',$this->last_updated_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CostPriceGroup the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
