<?php

/**
 * This is the model class for table "{{inventory_mtom_transfer}}".
 *
 * The followings are the available columns in table '{{inventory_mtom_transfer}}':
 * @property integer $id
 * @property string $transfer_date
 * @property string $note
 * @property integer $from_product
 * @property integer $from_unit
 * @property integer $from_qty
 * @property integer $to_product
 * @property integer $to_unit
 * @property integer $to_qty
 * @property integer $created_by
 * @property string $created_date_time
 */
class ChangeRackBin extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{change_rack_bin}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('warehouse_id, partno', 'required'),
			array('warehouse_id, partno, rack, bin, created_by', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, warehouse_id, partno, rack, bin, created_by, created_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			//'product' => array(self::BELONGS_TO, 'Store', 'partno'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'warehouse_id' => 'Warehouse',
			'partno' => 'Partno',
			'rack' => 'Rack',
			'bin' => 'Bin',
			'created_by' => 'Created By',
			'created_datetime' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('warehouse_id',$this->warehouse_id,true);
		$criteria->compare('partno',$this->partno,true);
		$criteria->compare('rack',$this->rack);
		$criteria->compare('bin',$this->bin);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MtomTransfer the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
