<?php

/**
 * This is the model class for table "{{activity}}".
 *
 * The followings are the available columns in table '{{activity}}':
 * @property integer $id
 * @property integer $customer_id
 * @property integer $contact_id
 * @property integer $file_id
 * @property string $notes
 * @property string $type_of_activity
 * @property integer $activity_id
 * @property string $date_to_do
 * @property string $date_of_activity
 * @property string $meeting_subject
 * @property string $meeting_location
 * @property string $added_from
 * @property integer $crm_user_id
 * @property string $isComplete
 * @property string $isActive
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_date_time
 * @property string $updated_date_time
 *
 * The followings are the available model relations:
 * @property CustomerContact $contact
 * @property Customer $company
 */
class Activity extends CActiveRecord {

    public $customer_name;
    public $searchstartdate;
    public $searchenddate;
    public $_old;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{activity}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
// NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('notes', 'required'),
            array('customer_id, contact_id, file_id, crm_user_id, created_by, updated_by', 'numerical', 'integerOnly' => true),
            //array('type_of_activity, added_from , isComplete, isActive', 'length', 'max'=>1),
            array('type_of_activity , isComplete, isActive', 'length', 'max' => 1),
            array('meeting_subject, meeting_location', 'length', 'max' => 255),
            array('date_to_do', 'required', 'on' => 'task'),
            array('date_to_do,date_of_activity', 'length', 'max' => 255),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, customer_id, contact_id, file_id, notes, type_of_activity, date_to_do, date_of_activity, meeting_subject, meeting_location, added_from , crm_user_id, isComplete, isActive, created_by, updated_by, created_date_time, updated_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
// NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'user' => array(self::BELONGS_TO, 'User', 'crm_user_id'),
            'contact_details' => array(self::BELONGS_TO, 'CustomerContact', 'contact_id'),
            'vendor_contact_details' => array(self::BELONGS_TO, 'VendorContact', 'contact_id'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            'pros' => array(self::BELONGS_TO, 'ProspectsActivityMaster', 'activity_id'),
            'vendor' => array(self::BELONGS_TO, 'Vendor', 'customer_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'customer_id' => 'Customer',
            'contact_id' => 'Contact Person',
            'file_id' => 'File',
            'notes' => 'Remarks / Details / Agenda',
            'type_of_activity' => 'C-Call,T-Task,M-meeting,V-visit,N-notes',
            'date_to_do' => 'Date To Do',
            'date_of_activity' => 'Date Of Activity',
            'meeting_subject' => 'Meeting Subject',
            'meeting_location' => 'Meeting Location',
            'added_from ' => 'Added From',
            'crm_user_id' => 'Crm User',
            'isComplete' => 'Mark as complete ?',
            'isActive' => 'Is Active',
            'activity_id' =>"Type",
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'created_date_time' => 'Created Date Time',
            'updated_date_time' => 'Updated Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.
        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('customer_id', $this->customer_id);
        $criteria->compare('contact_id', $this->contact_id);
        $criteria->compare('file_id', $this->file_id);
        $criteria->compare('notes', $this->notes, true);
        $criteria->compare('type_of_activity', $this->type_of_activity, true);
        $criteria->compare('date_to_do', $this->date_to_do, true);
        $criteria->compare('date_of_activity', $this->date_of_activity, true);
        $criteria->compare('meeting_subject', $this->meeting_subject, true);
        $criteria->compare('meeting_location', $this->meeting_location, true);
        $criteria->compare('added_from ', $this->added_from, true);
        $criteria->compare('crm_user_id', $this->crm_user_id);
        $criteria->compare('isComplete', $this->isComplete, true);
        $criteria->compare('isActive', $this->isActive, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Activity the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getActivity() {
        switch ($this->type_of_activity) {
            case 'C':
                return 'Call';
                break;
            case 'T':
                return 'Task';
                break;
            case 'M':
                return 'Meeting';
                break;
            case 'V':
                return 'Visit';
                break;
            case 'N':
                return 'Notes';
                break;
        }
    }

    // starting for the new changes made

    public static function getActivities() {
       /* $activities = Yii::app()->db->createCommand(
                        " SELECT CONCAT(id, '-', activity_type) AS id, activity
				FROM erp_prospects_activity_master
				WHERE isActive = 'Y' "
                )
                ->queryAll();*/
                
         $activities = Yii::app()->db->createCommand(
                        " SELECT id, activity
				FROM erp_prospects_activity_master
				WHERE isActive = 'Y' "
                )
                ->queryAll();        

        foreach ($activities as $activity) {
            $activity_dropdown[] = array(
                'id' => $activity['id'],
                'value' => $activity['activity'],
            );
        }
        return $activity_dropdown;
    }

    public static function getActivityHistoryCustomer($condition) {
        return Yii::app()->db->createCommand("SELECT ea.*, epam.activity, ec.customer_name, ecc.person_name, u.first_name, epam.activity_type
				FROM erp_activity AS ea
                LEFT JOIN erp_customer AS ec ON ea.customer_id = ec.id
                LEFT JOIN erp_customer_contact AS ecc ON ea.contact_id = ecc.id
                LEFT JOIN erp_prospects_activity_master AS epam ON ea.activity_id = epam.id 
                LEFT JOIN ".MasCompany::MainDB.".{{user}} AS u ON ea.crm_user_id = u.id
				WHERE ea.isActive = 'Y'  $condition"
                )->queryAll();
    }

    // ending new changes made
    public function afterFind() {
        $this->_old = $this->attributes;
        parent::afterFind();
    }

    public function afterSave() {
        //Models::ModelAfterSave($this);
        parent::afterSave();
    }

    public function getLabelValue($field) {
        $return_val = "";
        switch ($field) {
            case "isActive": $return_val = array("Y" => "Yes", "N" => "No");
                break;
        }
        return $return_val;
    }

}
