<?php

class TaxController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'Save', 'Delete', 'Disable', 'UploadTax', 'DownloadSampleCsv', 'DownloadSampleCsv', 'SaveTaxUploadCsv', 'UploadTaxCsv', 'DownloadErrorCsv'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function actionIndex()
    {
        if (
            Yii::app()->user->authorised_user == 1 ||
            (
                isset(Yii::app()->user->havePermissionOn['masters_menu_view']) &&
                isset(Yii::app()->user->havePermissionOn['mas_tax_view']) &&
                Yii::app()->user->havePermissionOn['masters_menu_view'] &&
                Yii::app()->user->havePermissionOn['mas_tax_view']
            )
        ) {
            $this->render('index');
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }



    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionGetList()
    {
        $model = new MasInvTax();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'tax_code',

        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        // $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (tax_code LIKE '%" . $searchString . "%' OR percentage  LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            $div = '';
            //if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_rack_edit"])){
            $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'tax/create&id=' . $row['id'] . '\',\'Edit Tax Code\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            //  }
            // if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_rack_delete"])){
            //     $div .=  '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteTax('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
            //   }
            $rowData[] = array(
                $m,
                $row['tax_code'],
                $row['percentage'],
                $row['isDefault'],
                array('id' => $row['id'], 'code' => $row['tax_code'], 'status' => $row->isActive)
            );

            $m++;

        }



        //                foreach ($model as $row)
//                {
//                    $rowData[]=array($m,$row['name'],'<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'rack/create&id='.$row['id'].'\',\'Edit Rack\',\'lg\')"><i class="fa fa-pencil"></i></button> '
//             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteRack('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
//                    $m++;
//                }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate()
    {
        $model = new MasInvTax();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('tax_form', array('model' => $model), false, false);
    }


    public function actionSave()
    {
        $model = new MasInvTax();
        if (isset($_POST['MasInvTax'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            if ((int) @$_POST['MasInvTax']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $id = (int) @$_POST['MasInvTax']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';
                $edit_flag = 1;
            } else {
                $audit_type = 'CREATED';
            }
            if ($_POST['MasInvTax']['isDefault'] == "Y") {
                MasInvTax::model()->updateAll(array('isDefault' => 'N'), 'isDefault = "Y"');
            }
            $model->isDefault = $_POST['MasInvTax']['isDefault'];
            $model->attributes = $_POST['MasInvTax'];
            if ($model->save()) {

                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'TAX_MASTER',
                    Yii::app()->user->id,
                    $audit_type,
                    " with code: - {$model->tax_code}  "
                );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['rack_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }

        }
    }
    public function actionDelete()
    {
        $id = $_POST['id'];
        $model = new MasInvTax();
        $del = $model->findByPk($id); // audit log changes
        $model->deleteByPk($id);
        // inserting to audit log
        AuditLog::saveAuditLogs(
            'TAX_MASTER',
            Yii::app()->user->id,
            'DELETED',
            " with code: - {$del->tax_code}  "
        );
        echo "success";
    }
    public function actionDisable()
    {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasInvTax();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y") ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

    // csv bulk upload section
    public function actionUploadTax()
    {
        //added by nisha on 28-02-2023
        $model = new MasInvTax();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_tax', array('model' => $model), false, true);
    }

    public function actionDownloadSampleCsv()
    {
        $filename = 'tax_list.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'Tax Name*,Percentage';
        Yii::app()->end();
    }

    public function readTaxCSV($csvFile)
    {
        if (!file_exists($csvFile)) {
            throw new Exception("File not found: $csvFile");
        }

        $file_handle = fopen($csvFile, 'r');
        $line_of_text = [];
        while (($contents = fgetcsv($file_handle, 1024, ',')) !== false) {
            $line_of_text[] = $contents;
        }
        fclose($file_handle);

        return $line_of_text;
    }
    public function actionSaveTaxUploadCsv()
    {
        $file_name = Yii::app()->request->getParam('filename');
        $batch = (int) Yii::app()->request->getParam('batch', 1);
        $url = Yii::app()->basePath . '/../uploads/tax_csv/' . $file_name;
        $mas_tax_list = $this->readTaxCSV($url);
        $error_url = Yii::app()->basePath . '/../uploads/tax_csv/error/' . $file_name;
        $error_list = [];
        $error_occurred = false;
        $batch_size = 200;
        $success_count = 0;
        $error_count = 0;
        $non_empty_row_count = 0;
        if (!empty($mas_tax_list)) {
            $header = array_shift($mas_tax_list); // Remove header row only once
        }
        $total_records = count($mas_tax_list);
        $start_index = ($batch - 1) * $batch_size;
        $batch_data = array_slice($mas_tax_list, $start_index, $batch_size);
        // print_r($batch_data);
        // die();
        foreach ($mas_tax_list as $index => $data) {
            if (!empty($data)) {
                $line_number = $index + 2; // Adjust for header row
                $log_remarks = [];

                // Sanitize and validate data

                if ($batch == 1) {
                    $log_remarks = $this->validateAndPrepareLog($data, $log_remarks);
                }


                if (empty($log_remarks)) {
                    $error_list[$line_number] = [
                        'tax_code' => $data[0],
                        'percentage' => $data[1],
                        'log_remarks' => ''
                    ];
                } else {
                    $error_occurred = true;
                    $error_count++;
                    $error_list[$line_number] = [
                        'tax_code' => $data[0],
                        'percentage' => $data[1],
                        'log_remarks' => implode(" | ", $log_remarks)
                    ];
                }
            }
        }
        // var_dump($log_remarks);
        // die();
        if ($error_occurred) {
            // echo 'hii';
            $file_error = fopen($error_url, "w+");
            $error_directory = Yii::app()->basePath . '/../uploads/tax_csv/error/';

            if (!is_dir($error_directory)) {
                mkdir($error_directory, 0777, true);  // Create the directory with appropriate permissions
            }
            if ($file_error === false) {
                // Handle the error if the file cannot be opened
                throw new Exception("Unable to open file for writing: $error_url");
            }
            // Add headers to the CSV file
            $headers = ['Tax Name', 'Percentage', 'Log Remarks'];
            fputcsv($file_error, $headers);

            // Add each line from the original CSV, including rows with no errors
            foreach ($error_list as $error_detail) {
                $line = [
                    $error_detail['tax_code'],
                    $error_detail['percentage'],
                    $error_detail['log_remarks'], // Include log remarks, empty if no error
                ];
                fputcsv($file_error, $line);
            }
            fclose($file_error);

            $jsonData['error_url'] = $error_url;
            $jsonData['filename'] = $file_name;
            $jsonData['link'] = CHtml::link('Download Log', array('tax/DownloadErrorCsv', 'id' => $file_name), array(
                'target' => '_blank',
                'style' => '
                   display: inline-block; border: 2px solid #ff4d4f; padding: 5px 15px;border-radius: -3px;font-size: 12px;
                   font-weight: bold; background: #ff4d4f; color: #fff;text-decoration: none;text-align: center; margin-bottom: 10px;'
            )) . '</div>
               <div style="
                   font-size: 12px;
                   font-weight: bold;
                   color: #ff4d4f;
                   margin-top: 10px; 
               ">
                   Data updation failed. Please see this file.
               </div>';
            echo json_encode($jsonData);

            return; // Return to stop further execution
        }

        foreach ($batch_data as $index => $data) {

            $non_empty_row_count++;
            if (!empty($data)) {
                $line_number = $start_index + $index + 2;
                $log_remarks = [];

                // Sanitize and validate data
                $tax_code = $this->sanitizeData($data[0]);
                // var_dump($tax_code);
                $tax_percentage = $this->sanitizeNumber($data[1]);
                if ($this->isTypeNameExists($tax_code)) {
                    $existing_count++;
                } else if ($this->isPercentageExists($tax_percentage)) {
                    $existing_count++;
                    // $error_count++;
                } else {
                    // Save to DB
                    $model = new MasInvTax();
                    $model->created_by = Yii::app()->user->id;
                    $model->updated_by = Yii::app()->user->id;
                    $model->created_datetime = date('Y-m-d H:i:s');
                    $model->updated_datetime = date('Y-m-d H:i:s');
                    $model->tax_code = ucfirst(strtolower($tax_code));
                    $model->percentage = $tax_percentage;
                    $model->isDefault = 'N';
                    if ($model->save()) {
                        $success_count++;
                    }
                }


            }
        }
        // die();
        // $existing_count = ($batch - 1) * $batch_size;

        // Yii::app()->session['batch_no'] = $batch + 1;

        if ($start_index + $batch_size < $total_records) {
            $next_batch = $batch + 1;
            echo json_encode([
                'status' => 'success',
                'message' => '',
                'flag' => 'continue',
                'next_button' => '<a href="javascript:void(0);" 
                               id="next-batch-btn" 
                               data-url="' . Yii::app()->createUrl('tax/SaveTaxUploadCsv', [
                        'filename' => $file_name,
                        'batch' => $next_batch

                    ]) . '"
                               style="display: inline-block; border: 2px solid #000080; padding: 5px 15px; font-size: 12px; font-weight: bold; background: #000080; color: #fff; text-decoration: none;">
                               Upload Next 200
                             </a>',
                'total_records' => $total_records,
                'success_count' => $success_count,
                'error_count' => $error_count,
                'non_empty_row_count' => $non_empty_row_count,
                'existing_count' => $existing_count,
            ]);
        } else {
            echo json_encode([
                'status' => 'success',
                'message' => '',
                'success_count' => $success_count,
                'error_count' => $error_count,
                'non_empty_row_count' => $non_empty_row_count,
                'existing_count' => $existing_count,
                'total_records' => $total_records,
            ]);
        }
    }
    public function actionDownloadErrorCsv()
    {
        $file_name = $event_id = Yii::app()->request->getParam('id');
        $error_url = Yii::app()->basePath . '/../uploads/tax_csv/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }
    private function sanitizeData($data)
    {
        return !empty($data) ? trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data), '"') : '';
    }

    private function sanitizeNumber($data)
    {
        $sanitizedData = str_replace(',', '', trim($data));
        return is_numeric($sanitizedData) ? (float) $sanitizedData : 0.0;
    }
    private function validateAndPrepareLog($data, &$log_remarks)
    {
        $log_remarks = [];

        // Sanitize and assign data
        $tax_code = $this->sanitizeData($data[0]);
        $percentage = $this->sanitizeData($data[1]);



        // Validate 'code'
        if (empty($tax_code)) {

            $log_remarks[] = "Tax Name is required.";
        }
        if (empty($percentage)) {
            $log_remarks[] = "Percentage is required.";


        }
        // var_dump($log_remarks);

        return $log_remarks;
    }
    private function isTypeNameExists($code)
    {
        $code = strtolower(trim($code));
        return MasInvTax::model()->exists('LOWER(TRIM(tax_code)) = :code', [':code' => $code]);
    }

    private function isPercentageExists($code)
    {
        $code = strtolower(trim($code));
        return MasInvTax::model()->exists('(TRIM(percentage)) = :code', [':code' => $code]);
    }

    public function actionUploadTaxCsv($folder = null)
    {
        Yii::import("ext.EAjaxUpload.qqFileUploader");

        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';

        // Check if directory exists or create it
        if (!is_dir($folder)) {
            mkdir($folder, 0777, true);
        }

        // Define allowed extensions and size limit
        $allowedExtensions = array();
        $sizeLimit = 2 * 1024 * 1024; // 2MB

        // Handle file upload
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);

        // Return JSON response
        echo htmlspecialchars(json_encode($result), ENT_NOQUOTES);
    }

}