<?php

class StorageswapController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index','GetProduct','GetbinDetails','Fetchproductdetails','Getbin','SaveChangeRackBin'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function actionIndex(){  
        $this->render('index');
    }
    public function actionGetProduct() {
        $searchTerm = $_GET['term'];
        $model= Store::model()->findAll(array('condition' =>'(part_number LIKE "%' . $searchTerm . '%" OR hiring_part_number LIKE "%' . $searchTerm . '%") AND isActive = "Y"'));
        $i = 0;
        $data=array();
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->hiring_part_number;
            $data[$i]['label'] = $eachModel->hiring_part_number;
            $data[$i]['product_id'] = $eachModel->id;
            $data[$i]['serialno'] = $eachModel->have_serial_no;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionGetbinDetails(){
        $rack_id = $_POST['rack_id'];
        $drop = array();
        $drop['bindetails'] = CHtml::dropdownlist("hiring_bin_id",'',MasInvBin::getBins_rackwise($rack_id), array('class' => 'tooltipster', 'data-label' => 'Bin','empty'=>'Select','data-search'=>true));        
        echo CJSON::encode($drop);
    }
    public function actionFetchproductdetails(){   
        $product_id    = (int)$_POST['product_id'];
        $warehouse_id  = $_POST['warehouse_id'];
        $rack_id       = $_POST['rack_id'];
        $bin_id        = $_POST['bin_id'];
        $serialno        = $_POST['serialno'];
        $condition  = 't.product_id ="'.$product_id.'" AND t.warehouse_id ="'.$warehouse_id.'" AND quantity>0';
        if($rack_id != ''){
            $condition .= ' AND t.rack_id="' . $rack_id.'"';
        }
        if($bin_id != ''){
            $condition .= ' AND t.bin_id="' . $bin_id.'"';
        }          
        $model_stock_details = ProductLocationHiringDetails::model()->findAll(array('condition' => $condition));
        $model_new_location=new ProductLocationHiringDetails();
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        if($serialno=='Y'){
            $this->render('product_with_serialno', array('model_new_location' => $model_new_location,'model_stock_details' => $model_stock_details, 'warehouse_id' => $warehouse_id,'product_id'=>$product_id), false, true);           
        }else{
            $this->render('product_without_serialno', array('model_new_location' => $model_new_location,'model_stock_details' => $model_stock_details, 'warehouse_id' => $warehouse_id,'product_id'=>$product_id), false, true);           
        }
    }
    public function actionGetbin(){
        $row = $_POST['row_field'];
        $rack_id = $_POST['rack_id'];
        $drop = array();
        $model = new ProductLocationHiringDetails() ;
        $drop['dropdown'] = CHtml::activedropdownlist($model, "[".$row."]bin_id",MasInvBin::getBins_rackwise($rack_id), array('class'=>'form-control','empty'=>'Select'));        
        echo CJSON::encode($drop);
    }
    public function actionSaveChangeRackBin(){
        if (isset($_POST['ProductLocationHiringDetails'])) {  
            date_default_timezone_set("Asia/Dubai");  
            $product_id=0;
            $warehouse_id=0;
            $rack_id=0;
            foreach ($_POST['ProductLocationHiringDetails'] as $i => $items) {
                if($items['old_location']>0 && $items['quantity']>0){
                    //Adding to New Location
                    $model_new_location = new ProductLocationHiringDetails();
                    $model_new_location->product_id   = $items['product_id'];
                    $product_id=$items['product_id'];
                    $model_new_location->warehouse_id = $items['warehouse_id'];
                    $warehouse_id= $items['warehouse_id'];
                    $model_new_location->rack_id = $items['rack_id'];
                    $rack_id=$items['rack_id'];
                    if($items['bin_id']!=''){
                        $model_new_location->bin_id = $items['bin_id'];
                    }else{
                        $model_mas_bin = MasInvBin::model()->find(array('condition' => 'is_base_bin="Y" and isActive="Y"'));
                        if($model_mas_bin->id>0){
                            $model_new_location->bin_id =$model_mas_bin->id;
                        }
                    }
                    if($items['serial_no']!=''){
                        $model_new_location->serial_no = $items['serial_no'];
                    }
                    $model_new_location->quantity  = $items['quantity'];
                    $model_new_location->transaction_type  = "Change Rack Bin";
                    $model_new_location->created_by = Yii::app()->user->id;
                    $model_new_location->created_date = date('Y-m-d');
                    $model_new_location->isActive  = "Y";
                    $model_new_location->save(false);
                        
                    //Adding to Rack Bin Change History
                    $model_rackbin_history = new ProductHiringChangeRackbin();
                    $model_rackbin_history->old_pdt_location_id   = $items['old_location'];
                    $model_rackbin_history->product_location_id = $model_new_location->id;
                    $model_rackbin_history->product_id   = $items['product_id'];
                    $model_rackbin_history->quantity  = $items['quantity'];
                    $model_rackbin_history->created_by    = Yii::app()->user->id;
                    $model_rackbin_history->created_date_time  = date('Y-m-d h:i:s');
                    $model_rackbin_history->save();
                    
                    //Updating Old Product Location
                    $model_quantity = ProductLocationHiringDetails::model()->findByPK($items['old_location']);
                    if($model_quantity->quantity>0){
                        $total_quantity=$model_quantity->quantity;
                        $transfer_quantity=$items['quantity'];
                        $balance_quantity=$total_quantity-$transfer_quantity;
                        ProductLocationHiringDetails::model()->updateByPK($items['old_location'], array('quantity' =>$balance_quantity));
                    }
                }
            }
            // inserting to audit log
            AuditLog::saveAuditLogs(
                'HIRING_CHANGE_RACK_BIN',
                Yii::app()->user->id,
                'CREATED',
                " with PRDT ID: - {$product_id} - and WareHouse ID: - {$warehouse_id} to Rack ID:- {$rack_id}"
            );
            // end audit log
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
            Yii::app()->end();
            
            
        }
    
    }
}
