<?php



class StockReorderLevelController extends Controller

{



    public function accessRules()

    {

        return array(

            array(

                'allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array('login', 'error', 'logout'),

                'users' => array('*'),

            ),

            array(

                'allow', // allow authenticated user to perform 'create' and 'update' actions

                'actions' => array('Index', 'Create', 'GetList', 'SavestockReorderLevel', 'Disable', 'Addreorderlevel'),

                'expression' => '$user->isMember()',

            ),

            array(

                'deny', // deny all users

                'users' => array('*'),

            ),

        );

    }



    public function actionIndex()

    {

        $this->render('index');

    }



    // Uncomment the following methods and override them if needed



    public function filters()

    {

        return array(

            'accessControl', // perform access control for CRUD operations

        );

    }







    public function actionGetList()

    {

        $model = new Store();

        $draw    = $_POST['draw'];

        $offset = $_POST['start'];

        $limit  = $_POST['length'];

        $brand_id = $_POST['brand_id'];

        $warehouse_id = (int) $_POST['warehouse_id'];

        $columns = array(

            // datatable column index  => database column name

            0 => 'product_id',

            1 => 'part_number',

            2 => 'description',

            3 => 'reorder_quantity',

            4 => 'warehouse_name',

            5 => 'brand',

        );



        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder  = $_POST['order'][0]['dir'];

        $orderBy   = $filterColumn . " " . $filterOrder;





        $condition = '1=1';







        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = trim($_POST['search']['value']);

            $condition = "  (part_number LIKE '%" . $searchString . "%' OR description LIKE '%" . $searchString . "%' OR brand LIKE '%" . $searchString . "%' OR warehouse_id LIKE '%" . $searchString . "%' OR brand LIKE '%" . $searchString . "%') ";

        }



        if ((int)$brand_id > 0)

            $condition .= ' AND brand_id = ' . (int)$brand_id;



        if ((int)$warehouse_id > 0) {

            $condition .= ' AND (warehouse_id = ' . (int)$warehouse_id . ' OR warehouse_id=0)';

        }





        $query = 'SELECT part_number,description,quantity,reorder_quantity,warehouse_name,brand,isActive,product_id,warehouse_id FROM view_reorder_quantity_stock WHERE ' . $condition . ' ORDER BY ' . $orderBy . ' LIMIT ' . $limit . ' OFFSET ' . $offset . ' ';



        $count = Yii::app()->db->createCommand('SELECT COUNT(product_id) FROM view_reorder_quantity_stock WHERE ' . $condition . ' ')->queryScalar();





        $model = Yii::app()->db->createCommand($query)->queryAll();





        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {



            $rowData[] = array(

                $m,

                $row['part_number'],

                $row['description'],

                $row['warehouse_name'],

                $row['brand'],

                Yii::app()->numberFormatter->formatCurrency($row['reorder_quantity'], " "), 

                array('warehouse_id' => $row['warehouse_id'], 'product_id' => $row['product_id'], 'part_number' =>  $row['part_number'], 'status' => $row['isActive']),

            );

            $m++;

        }



        $data['data'] = $rowData;

        echo json_encode($data);

    }











    public function actionCreate()

    {

        $model        = new StockReorderLevel();

        $warehouse_id = (int)Yii::app()->request->getParam('warehouse_id');

        $product_id   = (int)Yii::app()->request->getParam('product_id');

        
        if ($warehouse_id > 0 && $product_id > 0) {

           // $model = $model->findByPk($id);

            $condition  = 'product_id = ' . (int)$product_id;

            $condition .= ' AND warehouse_id = ' . (int)$warehouse_id;

            $model      = $model->find(array('condition' => $condition));

            if(empty($model))
            {
                $model        = new StockReorderLevel();
            }

           

        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->render('restock_form', array('model' => $model), false, false);

    }







    public function actionSavestockReorderLevel()

    {

        $model = new StockReorderLevel();



        if (isset($_POST['StockReorderLevel'])) {

            $model->created_by = Yii::app()->user->id;

            $model->created_datetime = date('Y-m-d h:i:s');

            if ((int)@$_POST['StockReorderLevel']['id'] > 0) {



                $id = (int)@$_POST['StockReorderLevel']['id'];

                $model = $model->findByPk($id);



                $model->updated_by = Yii::app()->user->id;

                $model->updated_datetime = date('Y-m-d h:i:s');



                $audit_type = 'UPDATED';

            } else {

                $audit_type = 'CREATED';

            }

            $model->attributes = $_POST['StockReorderLevel'];







            if ($model->save()) {





                //inserting to audit log



                AuditLog::saveAuditLogs(

                    'StockAdjustmentType',

                    Yii::app()->user->id,

                    $audit_type,

                    " with id : - {$model->id}"

                );

                // end audit log



                $jsonData['status'] = 'success';

                echo CJSON::encode($jsonData);

            } else {

                $error = CActiveForm::validate($model, '', false);

                if ($error != '[]')

                    echo $error;

            }

        }

    }









    public function actionDisable()

    {

        $id = Yii::app()->request->getparam('id');

        $status = Yii::app()->request->getparam('status');

        

        $model = new StockReorderLevel();



        $warehouse_id = (int)Yii::app()->request->getParam('warehouse_id');

        $product_id   = (int)Yii::app()->request->getParam('product_id');



        if ($warehouse_id > 0 && $product_id > 0) {

           // $model = $model->findByPk($id);

            $condition  = 'product_id = ' . (int)$product_id;

            $condition .= ' AND warehouse_id = ' . (int)$warehouse_id;

            $model      = $model->find(array('condition' => $condition));

            

           

        }

        

        

        

      //  $model = $model->findByPk($id);

        $model->isActive = ($status == "Y") ? "N" : "Y";

        $model->save();

        echo json_encode(array("status" => "success"));

    }





    public function actionAddreorderlevel()

    {

        // ----------------------------------------------------------------

            //only use one time / clear the table restock and then  run

        //-----------------------------------------------------------------

        $modelstore = new Store();

        $modelstore = $modelstore->findAll();

        $modelwarehouse = new MasInventoryWarehouse();

        $modelwarehouse = $modelwarehouse->findAll();

        foreach ($modelwarehouse as $eachwarehouse) {

            foreach ($modelstore as $eachproduct) {

                $modelreorder = new StockReorderLevel();

                $modelreorder->product_id = $eachproduct->id;

                $modelreorder->warehouse_id = $eachwarehouse->id;



                $modelreorder->reorder_quantity = 0;

                $modelreorder->save(false);

            }

        }

    }

}

