<?php

class RequisitionController extends Controller
{
    public $layout = 'layout';
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'SaveRequisition', 'GetRequisitionList', 'GetProducts', 'UploadDocuments', 'DeleteRequisitionItem', 'GetDocumentList', 'PrintRequistionReportPDF', 'CreateNote', 'SaveNote', 'GetNotesList', 'DeleteNote', 'DeleteDocument', 'DeleteNonStockItem', 'AddEnquiry', 'CancelRequisition', 'GetUnitDrop'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters()
    {
        return array('accessControl'); // perform access control for CRUD operations
    }


    public function actionIndex()
    {
        if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['purchase_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['requisition_view']) &&
            Yii::app()->user->havePermissionOn['purchase_menu_view'] && 
            Yii::app()->user->havePermissionOn['requisition_view']
        )
    ) {
        // Authorized: render the main view
        $this->render('index');
    } else {
        // Unauthorized: show custom unauthorized page
        $this->layout = false;
        $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
    }
    public function actionCreate()
    {
        $model = new PurchasingRequisition();
        $modelmasterfile = new MasterFile();
        $file_id = (int) Yii::app()->request->getParam('file_id');
        $modelRequisitionItems = array(new PurchasingRequisitionStockItem);
        $modelNonStock = array(new PurchasingRequisitionNonStockItem);
        $id = (int) Yii::app()->request->getParam('id');
        $project_id = (int) Yii::app()->request->getParam('project_id');
        $type = Yii::app()->request->getParam('type');
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelRequisitionItems = PurchasingRequisitionStockItem::model()->findAll(array('condition' => 't.purchasing_requisition_id = "' . $id . '" and stock_item_id > 0'));
            if (empty($modelRequisitionItems)) {
                $modelRequisitionItems = array(new PurchasingRequisitionStockItem);
            }
            $modelNonStock = PurchasingRequisitionNonStockItem::model()->findAll(array('condition' => 't.purchasing_requisition_id = "' . $id . '"'));
            if (empty($modelNonStock)) {
                $modelNonStock = array(new PurchasingRequisitionNonStockItem);
            }
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model, 'modelRequisitionItems' => $modelRequisitionItems, 'modelNonStock' => $modelNonStock, 'id' => $id, 'type' => $type, 'project_id' => $project_id, 'model_master' => $modelmasterfile, 'file_id' => $file_id));
    }
    public function actionSaveRequisition()
    {

        $model = new PurchasingRequisition();
        $modelNonStock = array(new PurchasingRequisitionNonStockItem);
        $modelPurchaseReqItem = array(new PurchasingRequisitionStockItem);
        /*         * ********** START Code for Save ************** */
        if (isset($_POST['PurchasingRequisition'])) {
            $scenario = '';
            if ((int) @$_POST['PurchasingRequisition']['id'] > 0) {
                $model->id = (int) $_POST['PurchasingRequisition']['id'];
                $model = $model->findByPK($model->id);
                $model->scenario = 'update';
                $scenario = 'update';
                $audit_type = 'UPDATED';
            } else {
                $model->crm_user_id = Yii::app()->user->id;
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime = date('Y-m-d H:i:s');
                $model->scenario = 'add';
                $scenario = 'add';
                $audit_type = 'CREATED';
            }
            $model->updated_by = Yii::app()->user->id;
            $model->updated_datetime = date('Y-m-d h:i:s');
            $model->reference = $_POST['PurchasingRequisition']['reference'];
            $model->project_id = $_POST['PurchasingRequisition']['project_id'];
            $model->attributes = $_POST['PurchasingRequisition'];
            $model->file_title = $_POST['PurchasingRequisition']['file_title'];
            $model->requested_by = $_POST['PurchasingRequisition']['requested_by'];
            if ($_POST['PurchasingRequisition']['requisition_date'] != '' && $_POST['PurchasingRequisition']['requisition_date'] != '0000-00-00') {
                $model->requisition_date = str_replace('/', '-', $_POST['PurchasingRequisition']['requisition_date']);
                $model->requisition_date = date("Y-m-d h:i", strtotime($model->requisition_date));
            }
            if ($_POST['PurchasingRequisition']['required_date'] != '' && $_POST['PurchasingRequisition']['required_date'] != '0000-00-00') {
                $model->required_date = str_replace('/', '-', $_POST['PurchasingRequisition']['required_date']);
                $model->required_date = date("Y-m-d h:i", strtotime($model->required_date));
            }
            $model->convert_status = $_POST['PurchasingRequisition']['convert_status'];
            $model->status = 'Y';
            $valid = $model->validate();

            $item_entry_count = 0;

            if (!empty($_POST['PurchasingRequisitionStockItem'])) {
                foreach ($_POST['PurchasingRequisitionStockItem'] as $j => $rowItem) {
                    if ($rowItem['stock_item_id'] > 0) {

                        $modelPurchaseReqItem[$j] = new PurchasingRequisitionStockItem();
                        $modelPurchaseReqItem[$j]->created_by = Yii::app()->user->id;
                        $modelPurchaseReqItem[$j]->created_datetime = date('Y-m-d h:i:s');
                        $modelPurchaseReqItem[$j]->updated_by = Yii::app()->user->id;
                        $modelPurchaseReqItem[$j]->updated_datetime = date('Y-m-d h:i:s');
                        $modelPurchaseReqItem[$j]->purchasing_requisition_id = '0';
                        $modelPurchaseReqItem[$j]->stock_item_id = $rowItem['stock_item_id'];
                        $modelPurchaseReqItem[$j]->stock_item_quantity = $rowItem['stock_item_quantity'];
                        $modelPurchaseReqItem[$j]->stock_item_name = $rowItem['stock_item_name'];
                        $modelPurchaseReqItem[$j]->stock_item_description = $rowItem['stock_item_description'];
                        $modelPurchaseReqItem[$j]->stock_item_unit = $rowItem['stock_item_unit'];
                        $valid = $modelPurchaseReqItem[$j]->validate() && $valid;

                        $item_entry_count++;
                    }

                }
            }
            if (!empty($_POST['PurchasingRequisitionNonStockItem'])) {
                foreach ($_POST['PurchasingRequisitionNonStockItem'] as $k => $rowItem) {
                    if (trim($rowItem['non_stock_item_name']) != '') {

                        $modelNonStock[$k] = new PurchasingRequisitionNonStockItem();
                        $modelNonStock[$k]->created_by = Yii::app()->user->id;
                        $modelNonStock[$k]->created_datetime = date('Y-m-d h:i:s');
                        $modelNonStock[$k]->updated_by = Yii::app()->user->id;
                        $modelNonStock[$k]->updated_datetime = date('Y-m-d h:i:s');
                        $modelNonStock[$k]->purchasing_requisition_id = '0';
                        $modelNonStock[$k]->non_stock_item_quantity = $rowItem['non_stock_item_quantity'];
                        $modelNonStock[$k]->non_stock_item_name = $rowItem['non_stock_item_name'];
                        $modelNonStock[$k]->non_stock_item_brand = $rowItem['non_stock_item_brand'];
                        $modelNonStock[$k]->non_stock_item_description = $rowItem['non_stock_item_description'];
                        $modelNonStock[$k]->non_stock_item_unit = $rowItem['non_stock_item_unit'];
                        $valid = $modelNonStock[$k]->validate() && $valid;
                        $item_entry_count++;
                    }
                }
            }

            if ($valid && $item_entry_count > 0) {

                if (isset($_POST['hid_file_id'])) {

                    $satus = MasterFile::model()->findByPk($_POST['hid_file_id']);
                    if ($_POST['hid_action_type'] == 1) {
                        MasterFile::model()->updateByPk($_POST['hid_file_id'], array('is_approved' => "Y", 'current_process_status' => 'P_R', 'date_of_approval' => date('Y-m-d'), 'approved_by' => Yii::app()->user->id));
                    } 
                    if ($_POST['hid_action_type'] == 2) {
                        
                        MasterFile::model()->updateByPk($_POST['hid_file_id'], array('is_approved' => "N", 'current_process_status' => 'P_R', 'date_of_approval' => date('Y-m-d'), 'approved_by' => Yii::app()->user->id));
                        date_default_timezone_set("Asia/Dubai");

                        $approval_history = new ApprovalHistory;

                        $approval_history->file_id = $_POST['hid_file_id'];

                        $approval_history->status = "Y";

                        $approval_history->action_by = Yii::app()->user->id;

                        $approval_history->created_by = Yii::app()->user->id;

                        $approval_history->created_datetime = date('Y-m-d h:i:s');

                        $approval_history->date = date('Y-m-d h:i:s');

                        $approval_history->state = 'Q';

                        $approval_history->save();
                    } 

                }
                if ((int) $_POST['hid_file_id'] > 0) {

                    $model->file_id = $_POST['hid_file_id'];
                    // MasterFile::model()->updateByPk($_POST['hid_file_id'], array('is_approved' => "Y", 'current_process_status' => 'P_R', 'date_of_approval' => date('Y-m-d'), 'approved_by' => Yii::app()->user->id));

                } else {

                    $masterFile = new MasterFile;

                    $masterFile->crm_user_id = Yii::app()->user->id;

                    $masterFile->customer_id = $_POST['Quotes']['customer_id'];

                    $masterFile->file_title = $_POST['Quotes']['title'];

                    $masterFile->start_from = "P_R";

                    $masterFile->ticket_id = $_POST['Quotes']['ticket_id'];

                    $masterFile->current_process_status = "P_R";

                    $masterFile->lead_owner_id = $_POST['Quotes']['lead_owner_id'];

                    $masterFile->is_approved = "Y";

                    $masterFile->date_of_approval = date('Y-m-d');

                    $masterFile->approved_by = Yii::app()->user->id;

                    $masterFile->save(false);

                    $model->file_id = $masterFile->id;
                }
                if ($model->save()) {

                    // inserting to audit log
                    AuditLog::saveAuditLogs(
                        'REQUISITION',
                        Yii::app()->user->id,
                        $audit_type,
                        " with No: - {$model->id}  "
                    );
                    // end audit log

                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                    PurchasingRequisitionStockItem::model()->deleteAll('purchasing_requisition_id=:refer_id', array(':refer_id' => $model->id));
                    if (!empty($modelPurchaseReqItem)) {
                        foreach ($modelPurchaseReqItem as $j => $eachItem) {
                            $eachItem->purchasing_requisition_id = $model->id;
                            $eachItem->save(false);

                        }
                    }
                    PurchasingRequisitionNonStockItem::model()->deleteAll('purchasing_requisition_id=:refer_id', array(':refer_id' => $model->id));
                    if (!empty($modelNonStock)) {
                        foreach ($modelNonStock as $k => $rowItem) {
                            $rowItem->purchasing_requisition_id = $model->id;
                            $rowItem->save(false);
                        }
                    }
                    if ($scenario == 'add') {
                        /*$model_mail_setting=Notification::model()->find(array('condition' => 'event_id="11"'));
                        Yii::import('application.controllers.front.MasternotificationController'); 
                        if($model_mail_setting->mail_required=='Y'){       
                            MasternotificationController::sendmail(11,$model->id);
                        }
                        if($model_mail_setting->notification_required=='Y'){                    
                        MasternotificationController::sendnotification(11,$model->id);
                        }
                        if($model_mail_setting->sms_required=='Y'){                    
                            MasternotificationController::sendsms(11,$model->id);
                        }*/
                    }
                }


            } else {
                $error1 = array();
                $error2 = array();
                $error3 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($modelPurchaseReqItem[0]->stock_item_id != '')
                    $error2 = json_decode(CActiveForm::validateTabular($modelPurchaseReqItem, '', false), true);
                else
                    $error2[] = "Please add atleast one stock item";
                if ($modelNonStock[0]->non_stock_item_name != '')
                    $error3 = json_decode(CActiveForm::validateTabular($modelNonStock, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error3, $error2, $error1));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionGetRequisitionList()
    {

        $model = new PurchasingRequisition();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(

            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.file_title',
            2 => 't.requisition_date',
            3 => 't.required_date',
            4 => 't.reference',
            5 => 't.convert_status',
            6 => 't.id',
            7 => 't.id',
            8 => 't.id'
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" AND t.convert_status!="0"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "t.isActive='Y' AND  (t.file_title LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' OR t.reference LIKE '%" . $searchString . "%' OR t.requisition_date LIKE '%" . $searchString . "%' OR t.required_date LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'id DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($model as $x => $row) {
            $req_date = date("d/m/Y", strtotime($row->requisition_date));
            $required_date = date("d/m/Y", strtotime($row->required_date));
            $chk = '';
            if ($row['convert_status'] != '0') {
                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["requisition_convert_enq"])) {
                    $convert_button = ' <button id="convert_to_enquiry" title ="Convert to Enquiry" class="btn btn-primary btn-xs" onclick="loadPopupModal(\'enquiry/create&req_id=' . $row['id'] . '\',\'Convert to Enquiry - ' . $row['id'] . '\',\'lg\');"><i class="fa fa-retweet"></i></button>';
                }
                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["requisition_convert_po"])) {
                    $convert_po_button = ' <button title ="Convert to Purchase Order" class="btn btn-primary btn-xs" onclick="loadPopupModal(\'purchasingorder/create&req_id=' . $row['id'] . '\',\'Convert to Order - ' . $row['id'] . '\',\'xl\');"><i class="fa fa-retweet"></i></button>';
                }
                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["requisition_edit"])) {
                    $edit_button = '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'requisition/create&id=' . $row['id'] . '\',\' Edit Requisition /' . $row['id'] . '\',\'lg\')" title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></button>';
                    ;
                }
                $chk = CHtml::checkBox('Enquiry[' . $x . '][check]', false, array('class' => 'req_check'));
            } else {
                $convert_button = $convert_po_button = '';
                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["requisition_view"])) {
                    $edit_button = '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'requisition/create&id=' . $row['id'] . '\',\' Edit Requisition /' . $row['id'] . '\',\'lg\')" title="Edit"><i class="fa fa-eye"></i></button>';
                    ;
                }
            }

            if ($row['convert_status'] != "0") {
                $state = "Active";
            } else {
                $state = "Closed";
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["requisition_pdf"])) {
                $print_button = '   <button class="btn btn-primary btn-xs" title="Print Requistion " target="_blank" onclick="printreq(' . $row['id'] . ')"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></button>';
            }
            $is_approved = MasterFile::model()->findByPk($row['file_id'])->is_approved;
            $rowData[] = array('<div class="text-center">' . $chk . '</div>', $row['id'], $req_date, $required_date, $row['reference'], $state,$row->requested->fullname, $row['convert_status'], $row['status'], $is_approved, $row['file_id']);

        }

        $data['data'] = $rowData;

        echo json_encode($data);

    }
    public function actionGetProducts()
    {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        //$condition = 'isActive = "Y" AND ( inventory_item_type =1 OR inventory_item_type=3) ';
        $condition = 'isActive = "Y" AND (part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%") ';
        $model = new Store();
        $model = $model->findAll(array('condition' => $condition,'order'=>'part_number ASC'));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number . ' : ' . $eachModel->description;
            $data[$i]['part_number'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            $unit_id = (int) UnitOfMeasurement::getSecondaryBaseunit($eachModel->id);
            $data[$i]['unit_id'] = $unit_id;
            $data[$i]['unit_name'] = $eachModel->unit->symbol;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionGetUnitDrop()
    {
        $row = $_POST['row_field'];
        $product_id = (int) $_POST['product_id'];
        $type = $_POST['type'];
        $item_type = $_POST['item_type'];
        $drop = array();
        $modelRequisition = new PurchasingRequisitionStockItem;



        if ($product_id > 0) {

            //code added by mereena on 07/09/2022 to get default sales unit_id
            $modelStore = new Store();
            $modelStore = $modelStore->findByPk($product_id);
            //end

            /* if($default_purchase_unit_id > 0){
                  $modelRequisition->stock_item_unit = $default_purchase_unit_id;
             }
             else{*/
            $arr_uom = UnitOfMeasurement::getSecondaryBaseUnitWithName($product_id);
            //$modelOrder->unit_id = UnitOfMeasurement::getBaseunit($product_id);
            $modelRequisition->stock_item_unit = UnitOfMeasurement::getSecondaryBaseunit($product_id);
            //}


            $drop['drop'] = CHtml::activedropdownlist($modelRequisition, "[" . $row . "]stock_item_unit", UnitOfMeasurement::getUnits($product_id), array('class' => 'unit go'));
        }
        echo CJSON::encode($drop);
    }
    public function actionDeleteRequisitionItem()
    {

        $id = $_POST['id'];

        $model = new PurchasingRequisitionStockItem();

        $model->deleteByPk($id);

        $jsonData['status'] = 'success';

        $jsonData['id'] = $id;

        echo CJSON::encode($jsonData);

    }
    public function actionDeleteNonStockItem()
    {

        $id = $_POST['id'];

        $model = new PurchasingRequisitionNonStockItem();

        $model->deleteByPk($id);

        $jsonData['status'] = 'success';

        $jsonData['id'] = $id;

        echo CJSON::encode($jsonData);

    }
    public function actionGetDocumentList()
    {

        $model = new Document();

        // echo $file_id;
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.document_name',
            2 => 't.created_by',
            3 => 't.created_datetime',

        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';

        $condition .= ' and t.isActive="Y" and t.file_id ="' . $_POST['file_id'] . '"';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (document_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $model2 = User::model()->find(array('condition' => 't.id = "' . $row['created_by'] . '"'));
            $rowData[] = array(
                $m,
                $row['document_name'],
                $model2->username,
                date("d/m/Y h:m:s", strtotime($row['created_datetime'])),
                '<div class="btn-wrap text-center">'
                . '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a></div>'
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionPrintRequistionReportPDF()
    {

        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = PurchasingRequisition::model()->findByPk($id);
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.requisition_list', array('model' => $model, 'id' => $id, 'title' => $title), true));
            $mPDF1->Output("RequistionReport.pdf", 'I');
        } else
            echo 'failed';

    }
    public function actionGetNotesList()
    {
        $id = $_POST['id'];
        $model = new FileNotes();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(

            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.notes',
            2 => 't.created_by',
            3 => 't.created_datetime',






        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;
        if ($id == '') {
            $id = 0;
        }
        $condition = 't.file_id="' . $id . '"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " and (notes LIKE '%" . $searchString . "%')";

        }

        $count = $model->count(array('condition' => $condition));

        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;



        foreach ($model as $row) {
            $model2 = User::model()->find(array('condition' => 't.id = "' . $row['created_by'] . '"'));
            $rowData[] = array(
                $m,
                $row['notes'],
                $model2->username,
                date("d/m/Y h:m:s", strtotime($row['created_datetime'])),
                '<div class="btn-wrap text-center">'
                . '</div>'
            );



            $m++;

        }

        $data['data'] = $rowData;

        echo json_encode($data);

    }
    public function actionCreateNote()
    {

        $model = new FileNotes();
        $file_id = (int) Yii::app()->request->getParam('file_id');
        $vendor_id = (int) Yii::app()->request->getParam('vendor_id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('note_add_details_2', array('modelNotes' => $model, 'file_id' => $file_id, 'vendor_id' => $vendor_id));

    }

    public function actionSaveNote()
    {
        $modelNotes = new FileNotes();

        if (!empty($_POST['FileNotes'])) {
            if ((int) @$_POST['FileNotes']['id'] > 0) {
                $id = (int) @$_POST['FileNotes']['id'];
                $modelNotes->updated_by = Yii::app()->user->id;
                $modelNotes->updated_datetime = date('Y-m-d h:i:s');
                $modelNotes = $modelNotes->findByPk($id);

            } else {
                $modelNotes->created_by = Yii::app()->user->id;
                $modelNotes->created_datetime = date('Y-m-d h:i:s');
                $modelNotes->notes = $_POST['FileNotes']['notes'];

                $modelNotes->crm_user_id = Yii::app()->user->id;
                $modelNotes->customer_vendor_id = $_POST['vendor_id'];
                $modelNotes->customer_vendor_type = 2;
                $modelNotes->file_note_from = 1;
                $modelNotes->file_id = $_POST['file_id'];
                $modelNotes->save(false);
            }
            $modelNotes->attributes = $_POST['FileNotes'];
            $modelNotes->save(false);

            $jsonData['status'] = 'success';
            $jsonData['frm'] = $_POST['requisition-form'];
            $model1 = PurchasingRequisition::model()->find(array('condition' => 't.file_id = "' . $_POST['file_id'] . '"'));
            $jsonData['id'] = $model1->id;
            echo CJSON::encode($jsonData);










        }




    }
    public function actionDeleteDocument()
    {
        $id = $_POST['id'];
        $modelDocument = new Document();
        $modelDocument->deleteByPk($id);
        echo "success";
    }
    public function actionDeleteNote()
    {
        $id = $_POST['id'];
        $modelNote = new FileNotes();
        $modelNote->deleteByPk($id);
        echo "success";
    }
    public function actionAddEnquiry()
    {


        $req_ids = explode(',', $_POST['req_ids']);
        // die();
        if (!empty($req_ids)) {
            $model = new PurchasingEnquirytemp();
            $model->crm_user_id = Yii::app()->user->id;
            $model->created_by = Yii::app()->user->id;
            $model->title = 'Created from ' . implode(',', $req_ids);
            $model->enquiry_date = date('Y-m-d');
            $model->required_date = date('Y-m-d', strtotime('+1 Week'));
            $model->created_datetime = date('Y-m-d h:i:s');
            $model->requisition_id = implode(',', $req_ids);
            if ($model->save(false)) {
                foreach ($req_ids as $i => $each) {
                    if ($each > 0) {
                        $modelReq = PurchasingRequisitionStockItem::model()->findAll(array('condition' => 'purchasing_requisition_id = ' . $each));
                        $modelNonReq = PurchasingRequisitionNonStockItem::model()->findAll(array('condition' => 'purchasing_requisition_id = ' . $each));
                        if (!empty($modelReq)) {
                            foreach ($modelReq as $rowItem) {

                                $enqItem = new PurchasingEnquiryStockItemtemp;
                                $enqItem->created_by = Yii::app()->user->id;
                                $enqItem->created_datetime = date('Y-m-d h:i:s');
                                $enqItem->stock_item_id = $rowItem['stock_item_id'];
                                $enqItem->stock_item_quantity = $rowItem['stock_item_quantity'];
                                $enqItem->stock_item_name = $rowItem['stock_item_name'];
                                $enqItem->stock_item_description = $rowItem['stock_item_description'];
                                $enqItem->stock_item_unit = $rowItem['stock_item_unit'];
                                $enqItem->purchasing_enquiry_id = $model->id;
                                $enqItem->save(false);

                            }
                        }
                        if (!empty($modelNonReq)) {
                            foreach ($modelNonReq as $rowItem) {
                                if ($rowItem['non_stock_item_name'] != '') {
                                    $enqItem = new PurchasingEnquiryNonStockItemtemp;
                                    $enqItem->created_by = Yii::app()->user->id;
                                    $enqItem->created_datetime = date('Y-m-d h:i:s');
                                    //$enqItem->non_stock_item_id = $rowItem['non_stock_item_id'];
                                    $enqItem->non_stock_item_quantity = $rowItem['non_stock_item_quantity'];
                                    $enqItem->non_stock_item_name = $rowItem['non_stock_item_name'];
                                    $enqItem->non_stock_item_description = $rowItem['non_stock_item_description'];
                                    $enqItem->non_stock_item_unit = $rowItem['non_stock_item_unit'];
                                    $enqItem->purchasing_enquiry_id = $model->id;
                                    $enqItem->save(false);
                                }
                            }
                        }
                    }
                }

            }
            $jsonData['status'] = 'success';
            $jsonData['id'] = $model->id;
            $jsonData['vendor_id'] = $vendor_id;

        } else {
            $jsonData['status'] = 'failed';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionCancelRequisition()
    {
        $id = $_POST['PurchasingRequisition']['id'];
        if ($id > 0) {
            $model = PurchasingRequisition::model()->findByPk($id);
            $model->status = 'C';
            $model->convert_status = 0;
            $model->save();
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

}