<?php

class QuotationController extends Controller
{

    public $layout = 'layout';
    public $title = 'Quotation';

    public function accessRules()
    {

        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'GetQuotationsList',
                    'Create',
                    'SaveQuotation',
                    'Approve',
                    'GetNotesList',
                    'CreateNote',
                    'SaveNote',
                    'DeleteNotes',
                    'DocumentUpload',
                    'GetDocumentList',
                    'UploadDocument',
                    'DeleteDocument',
                    'MissingList',
                    'CreatePrint',
                    'PrintQuotationReportPDF',
                    'PrintQuotationWithoutDiscountPDF',
                    'PrintQuotationPdfVat',
                    'QuoteItemsview',
                    'GetProducts',
                    'Getunitdrop',
                    'GetAllDetailsForProduct',
                    'QuotationHelper',
                    'getSalesGroup',
                    'Fetchcontactdetails',
                    'getCustomerContactdetails',
                    'GetContextMenuItems',
                    'MaterialAllocation',
                    'GetAjaxQuotationDetails',
                    'PrintQuotationAvailableQtyPDF',
                    'GetApprovalHistory',
                    'Analysis',
                    'SearchAnalysisProducts',
                    'GetApprovalHistoryList',
                    'GetOptionalProduct',
                    'Removeoptionalitem',
                    'PrintQuotation', //in controller
                    'GetPreviousCustomerRates',
                    'SendQuotationConversionMail',
                    'GetItemHistory',
                    'UploadQuotationImage',
                    'PrintQuotationProfitReportPDF',
                    'deleteQtnItemImage',
                    'RevisionHistory',
                    'DownloadQuotationPDF',
                    'GetunitRate',
                    'SendQuotationMail',
                    'GetProductsDetails',
                    'GetCustomerPriceDetails',
                    'AnalysisDemo',
                    'AnalysisNonAvailProducts',
                    'GetFilterQtnData',
                    'UploadDocumentQuotation',
                    'GetServiceProducts',
                    'PrintQuotationReportPDFNew',
                    'ContractIndex',
                    'TrialIndex',
                    'CreateYearly',
                    'PrintQuotationYearlyReportPDF',
                    'PrintQuotationReportPDFMonthly',
                    'ApproveLevel'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters()
    {

        return array('accessControl'); // perform access control for CRUD operations
    }

    /*

     * function to list quotes

     * modified by jisha on 18-9-18.

     */

    // public function actionIndex() {

    //     $frm = (int) Yii::app()->request->getParam('frm');

    //     $this->render('index', array('frm' => $frm));
    // }
    public function actionIndex()
    {
        $frm = (int) Yii::app()->request->getParam('frm');

        if (
            Yii::app()->user->authorised_user == 1 ||
            (
                isset(Yii::app()->user->havePermissionOn['sales_menu_view']) &&
                isset(Yii::app()->user->havePermissionOn['quotes_view']) &&
                Yii::app()->user->havePermissionOn['sales_menu_view'] &&
                Yii::app()->user->havePermissionOn['quotes_view']
            )
        ) {
            $this->render('index', array('frm' => $frm));
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }


    /*

     * function to list quotes in datatable

     * modified by jisha on 18-9-18.

     */

    public function actionGetQuotationsList()
    {

        $model = new Quotes();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $frm = $_POST['frm'];

        $type = $_POST['type'];

        if ($type == 'C') {
            $prefix = 'service_contract';
        } elseif ($type == 'T') {
            $prefix = 'service_trial';
        } else {
            $prefix = 'quotes';
        }

        $columns = array(
            // datatable column index  => database column name

            0 => 't.id',
            1 => 'file_id',
            2 => 't.id',
            3 => 'customer.customer_name',
            4 => 'leadowner.first_name',
            5 => 't.qtn_start_date',
            6 => 't.qtn_validity',
            7 => 'currencyname.currency_code',
            8 => 't.grand_total',
            9 => 't.status',
            10 => 'file.current_process_status',
            17 => 't.created_by',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        //echo $orderBy;
        // $condition = 't.isActive="Y" AND (file.current_process_status="Q") AND t.status = "Y" AND t.quotes_type="sale"';

        //$condition = 't.isActive="Y" AND (file.current_process_status="Q") AND t.quotes_type="sale"';
        //edited by abin on 23-01-2024
        $condition = 't.isActive="Y" AND (file.current_process_status="Q") ';


        if ((int) $_POST['status'] > 0) {

            $condition .= ' AND t.status="' . $_POST['status'] . '"';
        }



        if ($_POST['date_from'] != '' && $_POST['date_to'] != '') {

            $order_start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['date_from'])));

            $order_end_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['date_to'])));

            $condition .= ' AND (t.qtn_start_date>="' . $order_start_date . '" AND t.qtn_start_date<="' . $order_end_date . '")';
        }





        if (!isset(Yii::app()->user->havePermissionOn["{$prefix}_view_all"]) && Yii::app()->user->authorised_user != 1) {

            $condition .= ' AND (t.lead_owner_id= "' . Yii::app()->user->id . '" OR file.lead_owner_id="' . Yii::app()->user->id . '")';
        }

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $condition = 't.isActive="Y"';

            if (!isset(Yii::app()->user->havePermissionOn["{$prefix}_view_all"]) && Yii::app()->user->authorised_user != 1) {

                $condition .= ' AND (t.lead_owner_id= "' . Yii::app()->user->id . '" OR file.lead_owner_id="' . Yii::app()->user->id . '")';
            }

            $searchString = $_POST['search']['value'];

            $condition .= " AND (file.file_title LIKE '%" . $searchString . "%' OR t.file_id LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' OR customer.customer_name LIKE '%" . $searchString . "%' OR leadowner.first_name LIKE '%" . $searchString . "%' OR leadowner.last_name LIKE '%" . $searchString . "%' OR CONCAT(leadowner.first_name, ' ', leadowner.last_name) LIKE '%" . $searchString . "%')";
        }

        if (isset($_POST['status']) && $_POST['status'] != "" && $_POST['status'] != "all") {

            $select_status = $_POST['status'];

            if ($select_status == 'N') {



                $start_date = date('Y-m-d', strtotime('-7 days'));

                $end_date = date('Y-m-d');

                $condition .= " AND (t.qtn_start_date>='" . $start_date . "' AND t.qtn_start_date<='" . $end_date . "')";
            } else if ($select_status == 'M') {

                $condition .= ' AND (t.lead_owner_id= "' . Yii::app()->user->id . '" OR file.lead_owner_id="' . Yii::app()->user->id . '")';
            } else {

                $condition .= " AND t.status='$select_status'";
            }
        }



        if (isset($_POST['project_classification_id']) && (int) $_POST['project_classification_id'] != 0) {

            $condition .= " AND t.project_classification_id=" . (int) $_POST['project_classification_id'];
        }


        if ($frm == 3) {
            $condition .= ' AND t.qtn_type ="service"';
            if ($type == "C" || $type == "T") {
                // $sales_group_id = MasSalesGroup::getDefaultServiceGroupId($type);
                // if ($sales_group_id > 0)
                //     $condition .= ' AND t.sales_group_id ="' . $sales_group_id . '"';
            }
        } else {
            $condition .= ' AND t.qtn_type ="sales"';

        }

        // echo $condition;
        $model_settings = MasCompanySettings::model()->find();

        $count = $model->with('customer', 'file', 'currencyname', 'leadowner')->count(array('condition' => $condition));

        $model = $model->with('customer', 'file', 'currencyname', 'leadowner')->findAll(array('condition' => $condition, 'order' => $orderBy, 'limit' => $limit, 'offset' => $offset));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        foreach ($model as $row) {

            $state = 0;

            if (strtotime($row->qtn_validity) < strtotime(date('Y-m-d'))) {

                $state = 1;
            } elseif ($row->file->is_approved == 'N' && $row->file->current_process_status == 'Q') {

                $state = 2;
            }

            //   $status = $row['StatusOfQuote'];



            $status = $row['statusdet']['status'];

            // $status = $row['status'][];

            $file_status = $row['file']['status'].' - '.ucfirst($row['qtn_type']);

            /*             * **************** Code added by mereena on 28/11/2017 for allocate material checking************************* */

            $allocate_count = 0;

            if (isset($row->file_id) && $row->file_id > 0) {

                $modelAllocate = new AllocatedMaterial();

                $allocate_count = (int) $modelAllocate->count(array('condition' => 'file_id=' . $row->file_id));
            }



            $modelQuotesItem = new QuotesItem();

            $countcheckedQuoteItems = (int) $modelQuotesItem->count(array('condition' => 'checked=1 AND quotes_id=' . $row['id']));

            /*$rowData[] = array($state, $row['file_id'], $row['id'], $row['customer']['customer_name'], $row['leadowner']['first_name'] . ' ' . $row['leadowner']['last_name'], date("d/m/Y", strtotime($row['qtn_start_date'])), date("d/m/Y", strtotime($row['qtn_validity'])), Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'], ""),
                Yii::app()->numberFormatter->formatCurrency($row['grand_total'], ""), $status, $file_status, $row->file->current_process_status, $row->remarks, $row->file->is_approved, $row['customer_id'], $countcheckedQuoteItems, $row->created_user, $allocate_count);*/
            Yii::import('application.modules.features.models.FeaturesApproveLevel');
            $model_approval = new FeaturesApproveLevel();
            $approvalType = 'QU';
            $currentApproveLevel = $model_approval->getCurrentApproveLevel($approvalType, $row['file_id']);
            $accessApproveLevel = $model_approval->getAccessApproveLevel($currentApproveLevel, Yii::app()->user->id, $approvalType);
            $rowData[] = array(
                $row['file_id'], //0
                $row['id'], //1
                $row['customer']['customer_name'], //2
                $row['leadowner']['first_name'] . ' ' . $row['leadowner']['last_name'], //3
                date("d/m/Y", strtotime($row['qtn_start_date'])), //4
                date("d/m/Y", strtotime($row['qtn_validity'])), //5
                $row['currencyname']['currency_code'],//6
                Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'], ""),//7
                Yii::app()->numberFormatter->formatCurrency($row['grand_total'], ""), //8
                Yii::app()->numberFormatter->formatCurrency(($row['grand_total'] * $row['exchange_rate']), ""), //9
                $file_status, //10
                array(
                    'state' => $state,
                    'file_status' => $file_status,
                    'current_process_status' => $row->file->current_process_status,
                    'remarks' => $row->remarks,
                    'is_approved' => $row->file->is_approved,
                    'customer_id' => $row['customer_id'],
                    'checked_count' => $countcheckedQuoteItems,
                    'created_user' => $row->created_user,
                    'allocate_count' => $allocate_count,
                    'currentApproveLevel' => $currentApproveLevel,
                    'accessApproveLevel' => $accessApproveLevel,
                )//11
            );
        }

        $data['data'] = $rowData;

        $data['condition'] = $condition;

        echo json_encode($data);
    }

    /*

     * function to create quotes

     * modified by jisha on 18-9-18.

     */

    public function actionCreate()
    {

        $model = new Quotes();

        $modellead = new Lead();

        $modelDocument = new Document;

        $modelmasterfile = new MasterFile();

        $id = (int) Yii::app()->request->getParam('id');

        $leadid = (int) Yii::app()->request->getParam('lead_id');

        $ticket_id = (int) Yii::app()->request->getParam('ticket_id');

        $snag_id = (int) Yii::app()->request->getParam('snag_id');

        $type = Yii::app()->request->getParam('type');

        $file_id = (int) Yii::app()->request->getParam('file_id');

        $duplicate = (int) Yii::app()->request->getParam('duplicate');

        $hireduplicate = (int) Yii::app()->request->getParam('hireduplicate');
        $service_type = Yii::app()->request->getParam('service_type');

        $frm = (int) Yii::app()->request->getParam('frm');

        $modelQuoteItems = array(new QuotesItem);

        $modelQuoteContract = array(new QuotesContractItem);


        $modelQuoteAdditions = array(new QuotesAddition);

        $modelQuoteDeductions = array(new QuotesDeduction);

        $modelNotes = new Activity();

        if ($id > 0) {

            $model = $model->findByPk($id);

            $model->import_code = $model->customer->customer_shj_imp_code;

            $condition = 'quotes_id="' . $id . '"'; //To fetch all

            $modelQuoteItems = QuotesItem::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));

            if (empty($modelQuoteItems)) {

                $modelQuoteItems = array(new QuotesItem);
            }

            $modelQuoteContract = QuotesContractItem::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));

            if (empty($modelQuoteContract)) {

                $modelQuoteContract = array(new QuotesContractItem);
            }

            $modelQuoteAdditions = QuotesAddition::model()->findAll(array('condition' => 'quotes_id="' . $id . '"', 'order' => 'id ASC'));

            if (empty($modelQuoteAdditions)) {

                $modelQuoteAdditions = array(new QuotesAddition);
            }

            $modelQuoteDeductions = QuotesDeduction::model()->findAll(array('condition' => 'quotes_id="' . $id . '"', 'order' => 'id ASC'));

            if (empty($modelQuoteDeductions)) {

                $modelQuoteDeductions = array(new QuotesDeduction);
            }

            if ($duplicate == '1') {

                $model->id = '';

                $model->file_id = '';
            }
        }

        if ($leadid > 0) {

            $modellead = $modellead->findByPk($leadid);

            //$model->enq_ref = $modellead->id;

            $model->customer_id = $modellead->customer_id;
            $model->import_code = $modellead->customer->customer_shj_imp_code;

            $model->currency_id = $modellead->currency;

            $model->exchange_rate = 1;//default currency exchnage rate is 1
        }

        if ($file_id > 0) {

            $model_lead = Lead::model()->find(array('condition' => 'file_id="' . $file_id . '"'));

            $modellead = $modellead->findByPk($model_lead->id);

            $modelmasterfile = $modelmasterfile->findByPk($file_id);

            $modelmasterfile->file_title = $modellead->title;
        }





        if ($snag_id > 0) {

            $snag_model = new FmSnag();

            $snag_model = $snag_model->findByPk($snag_id);

            $ticket_id = $snag_model->job_id;

            $ticketModel = TicketHeader::model()->findByPk($snag_model->job_id);

            $custModel = Customer::model()->findByPk($ticketModel->unit_details->customer_id);

            $model->customer_id = $custModel->id;

            $model->payment_terms = $custModel->customer_payment_term;

            $model->terms_and_conditions = MasTermsAndConditions::model()->findByPk(1)->terms;

            $model->terms_id = 1;

            $model->project_classification_id = $ticketModel->project_classification_id;

            $model->contract_id = $ticketModel->contract_id;

            $model->ticket_id = $ticket_id;

            $model->snag_id = $snag_id;

            $model->enq_ref = "JO/" . $ticket_id;

            $condition = "header_id  = " . $snag_id . " AND qty >0 AND chargeable = 'Y' ";

            $snag_model_items = new FmSnagItems();

            $snag_model_items = $snag_model_items->findAll(["condition" => $condition]);

            $p = 0;

            foreach ($snag_model_items as $key => $item) {

                $modelQuoteItems[$p] = new QuotesItem();

                $store = Store::model()->findByPk($item->snag->service_id);

                $description = $item->snag->area_rel->name . " - " . $item->snag->name;

                $modelQuoteItems[$p]->product_name = $store->part_number;

                $modelQuoteItems[$p]->product_id = $store->id;

                $modelQuoteItems[$p]->description = $description;

                //$modelQuoteItems[$p]->snag_item_id = $item->id;

                $modelQuoteItems[$p]->quantity = $item->qty;

                $modelQuoteItems[$p]->unit_id = $store->unit_id;

                $modelQuoteItems[$p]->rate = 0;

                $p++;
            }
        } else {

            if ($ticket_id > 0) {

                $ticketModel = TicketHeader::model()->findByPk($ticket_id);

                $custModel = Customer::model()->findByPk($ticketModel->unit_details->customer_id);

                $model->customer_id = $custModel->id;

                $model->payment_terms = $custModel->customer_payment_term;

                $model->terms_and_conditions = MasTermsAndConditions::model()->findByPk(1)->terms;

                $model->terms_id = 1;

                $model->project_classification_id = $ticketModel->project_classification_id;

                $model->contract_id = $ticketModel->contract_id;

                $model->ticket_id = $ticket_id;

                $model->enq_ref = "JO/" . $ticket_id;

                $condition = "ticket_id = " . (int) $ticket_id;

                $p = 0;
            }
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array(
            'model' => $model,
            'modelQuoteItems' => $modelQuoteItems,
            'modelQuoteContract' => $modelQuoteContract,
            'modelQuoteAdditions' => $modelQuoteAdditions,
            'modelQuoteDeductions' => $modelQuoteDeductions,
            'modellead' => $modellead,
            'model_master' => $modelmasterfile,
            'file_id' => $file_id,
            'modelNotes' => $modelNotes,
            'modelDocument' => $modelDocument,
            'leadid' => $leadid,
            'type' => $type,
            'duplicate' => $duplicate,
            'frm' => $frm,
            'service_type' => $service_type,
        ));
    }

    /*

     * function to save quotes

     * modified by jisha on 18-9-18.

     */

    public function actionSaveQuotation()
    {

        $valid = TRUE;

        $file_id = $_POST['hid_file_id'];

        $modelQuote = new Quotes;

        $other = array();

        //$modelQuote->terms_and_conditions = MasTermsAndConditions::model()->findByPk(1)->terms;

        $modelQuoteItems = array(new QuotesItem);

        $modelQuoteAdditions = array(new QuotesAddition);

        $modelContractItems = array(new QuotesContractItem);


        $modelQuoteDeductions = array(new QuotesDeduction);

        $modelNotes = new Activity();

        $modelDocument = new Document();

        $quotes_id = (int) Yii::app()->request->getParam('id');

        // $modelQuote->exchange_rate = 1;

        //$quotation_validity = MasValidity::model()->find()->quotation_validity;

        $quotation_validity = 30;

        $modelQuote->qtn_validity = date('Y-m-d', strtotime('+ ' . $quotation_validity . 'day', strtotime(date('Y-m-d'))));

        if ($quotes_id > 0) {

            $modelQuote = $modelQuote->findByPK($quotes_id);

            $modelQuote->customer_id = $modelQuote->file->customer_id;

            $modelQuote->title = $modelQuote->file->file_title;

            $modelQuote->lead_owner_id = $modelQuote->file->lead_owner_id;

            $modelQuote->terms_and_conditions = $modelQuote->terms_and_conditions;

            $modelQuote->terms_id = $modelQuote->terms_id;

            $modelQuoteItems = $modelQuote->items;

            $modelContractItems = $modelQuote->contract;

            $modelQuoteAdditions = count($modelQuote->adItems) > 0 ? $modelQuote->adItems : $modelQuoteAdditions;

            $modelQuoteDeductions = count($modelQuote->dedItems) > 0 ? $modelQuote->dedItems : $modelQuoteDeductions;
        }
        if (isset($_POST['Quotes'])) {

            $scenario = '';

            if ((int) $_POST['Quotes']['id'] > 0) {

                $modelQuote = $modelQuote->findByPK($_POST['Quotes']['id']);

                $modelQuote->scenario = 'update';

                $scenario = 'update';

                $audit_type = 'UPDATED';

                $modelQuote->updated_by = Yii::app()->user->id;

                $modelQuote->updated_date_time = date('y-m-d H:i:s');
            } else {

                $modelQuote->scenario = 'add';

                $scenario = 'add';

                $audit_type = 'CREATED';

                $modelQuote->created_by = Yii::app()->user->id;

                $modelQuote->created_date_time = date('Y-m-d H:i:s');
            }

            $modelQuote->attributes = $_POST['Quotes'];

            $modelQuote->currency_id = $_POST['Quotes']['currency_id'];

            $modelQuote->revision = $_POST['Quotes']['revision'];

            $modelQuote->ticket_id = $_POST['Quotes']['ticket_id'];

            $modelQuote->project_id = $_POST['Quotes']['project_id'];
            $modelQuote->customer_outlet_id = $_POST['Quotes']['customer_outlet_id'];//Added by Dinny On 10-12-2025

            if ($_REQUEST['hid_frm'] == 3) {
                $modelQuote->qtn_type = 'service';
            }

            //$modelQuote->crm_user_id = Yii::app()->user->id;

            $modelQuote->job_order_id = $_POST['Quotes']['job_order_id'];

            //$modelQuote->materials_allocated = (isset($_POST['allocate_materials']) && $_POST['allocate_materials'] == "Y") ? "Y" : "N";

            /*if (($_POST['Quotes']['invoice_type'] == '1' OR $_POST['Quotes']['invoice_type'] == '2' ) AND ($_POST['customer_country_id'] == '143')) {



                $modelQuote->emirates_id = $_POST['Quotes']['emirates_id'];
            } else {

                $modelQuote->emirates_id = "0";
            }*/


            //code added by mereena on 12/01/2024
            $modelQuote->total_discount_percentage = $_POST['Quotes']['total_discount_percentage'];
            $modelQuote->total_discount_amount = $_POST['Quotes']['total_discount_amount'];
            //end

            //code added by mereena on 07/02/2020 for ckeditor content
            //$modelQuote->terms_and_conditions =  $_POST['terms_conditions'];
            $modelQuote->terms_id = $_POST['Quotes']['terms_id'];
            $modelQuote->terms_and_conditions = $_POST['Quotes']['terms_and_conditions'];
            $modelQuote->ambient_scent_for = $_POST['Quotes']['ambient_scent_for'];

            $valid = $valid && $modelQuote->validate();

            $p = 0;

            if (is_array($_POST['QuotesItem'])) {

                $prod_id = 0;

                foreach ($_POST['QuotesItem'] as $i => $item) {



                    if (($item['product_id'] > 0 && $item['product_name'] != 'memo') || $item['product_name'] == 'memo') {

                        $modelQuoteItems[$p] = new QuotesItem;

                        $modelQuoteItems[$p]->attributes = $_POST['QuotesItem'][$i];

                        $modelQuoteItems[$p]->unit_id = $item['unit_id'];

                        $modelQuoteItems[$p]->description = $item['description'];

                        $modelQuoteItems[$p]->brand_class_id = $item['brand_class_id'];


                        $modelQuoteItems[$p]->tax_vat_percentage = $item['tax_vat_percentage'];

                        $modelQuoteItems[$p]->checked = $item['checked'];

                        $modelQuoteItems[$p]->image_file_name = $item['image_file_name'];

                        $arr_secondary_unit = UnitOfMeasurement::model()->findByPk((int) $item['unit_id']);

                        $item_actual_rate = number_format((float) $item['actual_rate'], 2);

                        if (isset($arr_secondary_unit->factor) && (int) $arr_secondary_unit->factor > 0) {

                            $item_actual_rate = number_format(((float) $item['actual_rate'] * $arr_secondary_unit->factor), 2);
                        }



                        if (!isset(Yii::app()->user->havePermissionOn['edit_selling_price'])) {



                            if ((float) $item['rate'] < (float) $item_actual_rate) {

                                $other[] = 'Rate should be greater than or equal to ' . (float) $item_actual_rate . ' [' . $item['product_name'] . ']';

                                $valid = false;
                            }
                        }







                        if ($item['product_name'] == 'memo')
                            $modelQuoteItems[$p]->product_id = '999999';

                        $modelQuoteItems[$p]->checked = $item['checked'];

                        if ($item['product_name'] != 'memo')
                            $valid = $modelQuoteItems[$p]->validate() && $valid;

                        $p++;

                        //echo "1 = ".$item['product_id']."<br/>";
                    }
                }
            }

            $valid = $valid && ($modelQuoteItems[0]->product_id > 0);

            if (is_array($_POST['QuotesContractItem'])) {

                $p = 0;
                $valid = true;
                $other = [];

                foreach ($_POST['QuotesContractItem'] as $i => $itemc) {
                    if (($itemc['product_id'] > 0 && strtolower($itemc['product_name']) != 'memo') || strtolower($itemc['product_name']) == 'memo') {

                        $modelContractItems[$p] = new QuotesContractItem;
                        $modelContractItems[$p]->attributes = $itemc;
                        $modelContractItems[$p]->unit_id = $itemc['unit_id'];
                        $modelContractItems[$p]->unit_id = $itemc['unit_id'];
                        $modelContractItems[$p]->unit_id = $itemc['unit_id'];
                        $modelContractItems[$p]->description = $itemc['description'];
                        $modelContractItems[$p]->quantity = $itemc['quantity'];
                        $modelContractItems[$p]->contract_month = isset($itemc['contract_month']) ? $itemc['contract_month'] : null;
                        if (strtolower($itemc['product_name']) == 'memo') {
                            $modelContractItems[$p]->product_id = 999999;
                        }

                        if (strtolower($itemc['product_name']) != 'memo') {
                            $valid = $modelContractItems[$p]->validate() && $valid;
                        }


                        $p++;
                    }
                }


            }


            $valid = $valid && ($modelQuoteItems[0]->product_id > 0);
            $modelsToBeValidated = array($modelQuote, $modelQuoteItems, $modelContractItems);

            /*if (is_array($_POST['QuotesAddition'])) {

                foreach ($_POST['QuotesAddition'] as $i => $item) {

                    $modelQuoteAdditions[$i] = new QuotesAddition;

                    $modelQuoteAdditions[$i]->attributes = $_POST['QuotesAddition'][$i];

                    if ($item['particular_value'] > 0 && $item['particular'] == '') {

                        $other[] = 'Addition description Cannot Blank';

                        $valid = false;
                    }
                }

                $modelsToBeValidated[] = $modelQuoteAdditions;
            }

            if (is_array($_POST['QuotesDeduction'])) {

                foreach ($_POST['QuotesDeduction'] as $i => $item) {

                    $modelQuoteDeductions[$i] = new QuotesDeduction;

                    $modelQuoteDeductions[$i]->attributes = $_POST['QuotesDeduction'][$i];

                    if ($item['particular_value'] > 0 && $item['particular'] == '') {

                        $other[] = 'Deduction description Cannot Blank';

                        $valid = false;
                    }
                }

                $modelsToBeValidated[] = $modelQuoteDeductions;
            }*/

            // check if already quoation send for this job;

            $ticket_id = trim($_POST['Quotes']['ticket_id']);

            if (!empty($ticket_id)) {

                $condition = "t.ticket_id = " . $ticket_id;

                if (!empty($modelQuote->id)) {

                    $condition .= " AND t.id NOT IN ($modelQuote->id) ";
                }

                $count = $modelQuote->count(['condition' => $condition]);

                if (!empty($count)) {

                    $valid = false;

                    $other[] = "Quotation already sent for this ticket.";
                }
            }

            ///

            if ($valid) {

                $grand_total = 0;

                if (isset($_POST['hid_file_id'])) {

                    $satus = MasterFile::model()->findByPk($_POST['hid_file_id']);

                    MasterFile::model()->updateByPk($_POST['hid_file_id'], array('is_approved' => "N", 'current_process_status' => 'Q', 'date_of_approval' => date('Y-m-d'), 'approved_by' => Yii::app()->user->id));

                    if ($_POST['hid_action_type'] == 2) {//To identify unapprove
                        date_default_timezone_set("Asia/Dubai");

                        $approval_history = new ApprovalHistory;

                        $approval_history->file_id = $_POST['hid_file_id'];

                        $approval_history->status = "Y";

                        $approval_history->action_by = Yii::app()->user->id;

                        $approval_history->created_by = Yii::app()->user->id;

                        $approval_history->created_datetime = date('Y-m-d h:i:s');

                        $approval_history->date = date('Y-m-d h:i:s');

                        $approval_history->state = 'Q';

                        $approval_history->save();
                    }
                }

                $modelQuote->file_id = $_POST['hid_file_id'];

                if ($_POST['Quotes']['qtn_start_date'] != '00/00/0000') {

                    $modelQuote->qtn_start_date = str_replace('/', '-', $_POST['Quotes']['qtn_start_date']);

                    $modelQuote->qtn_start_date = date("Y-m-d", strtotime($modelQuote->qtn_start_date));
                }

                if ($_POST['Quotes']['qtn_validity'] != '00/00/0000') {

                    $modelQuote->qtn_validity = str_replace('/', '-', $_POST['Quotes']['qtn_validity']);

                    $modelQuote->qtn_validity = date("Y-m-d", strtotime($modelQuote->qtn_validity));
                }



                $modelQuote->billing_address = $_POST['Quotes']['billing_address'];





                if ((int) $_POST['hid_file_id'] > 0) {

                    $modelQuote->file_id = $_POST['hid_file_id'];
                } else {

                    $masterFile = new MasterFile;

                    $masterFile->crm_user_id = Yii::app()->user->id;

                    $masterFile->customer_id = $_POST['Quotes']['customer_id'];

                    $masterFile->file_title = $_POST['Quotes']['title'];

                    $masterFile->start_from = "Q";

                    $masterFile->ticket_id = $_POST['Quotes']['ticket_id'];

                    $masterFile->current_process_status = "Q";

                    $masterFile->lead_owner_id = $_POST['Quotes']['lead_owner_id'];

                    $masterFile->is_approved = "N";

                    $masterFile->date_of_approval = date('Y-m-d');

                    $masterFile->approved_by = Yii::app()->user->id;

                    $masterFile->save(false);

                    $modelQuote->file_id = $masterFile->id;
                }



                $modelQuote->save(false);

                if ((int) $_POST['Quotes']['id'] > 0) {

                    $allocated_count = AllocatedMaterial::model()->count(array('condition' => 'header_id="' . (int) $_POST['Quotes']['id'] . '"'));

                    if ($allocated_count > 0) {

                        AllocatedMaterial::model()->updateAll(array('allocation_date' => $modelQuote->qtn_start_date, 'allocation_end_date' => $modelQuote->qtn_validity), 'header_id=' . (int) $_POST['Quotes']['id']);
                    }
                }





                // inserting to audit log

                AuditLog::saveAuditLogs(
                    'QUOTATIONS',
                    Yii::app()->user->id,
                    $audit_type,
                    " with QTN No - {$modelQuote->id}  "
                );

                // end audit log

                $modelQuote->refresh();

                $quotes_id = $modelQuote->id;

                QuotesItem::model()->deleteAll('quotes_id=:refer_id', array(':refer_id' => $modelQuote->id));
                QuotesContractItem::model()->deleteAll('quotes_id=:refer_id', array(':refer_id' => $modelQuote->id));


                //QuotesAddition::model()->deleteAll('quotes_id=:refer_id', array(':refer_id' => $modelQuote->id));

                //QuotesDeduction::model()->deleteAll('quotes_id=:refer_id', array(':refer_id' => $modelQuote->id));

                $total_tax_amount = 0;

                if (!empty($modelQuoteItems)) {

                    foreach ($modelQuoteItems as $eachModel) {

                        if ($eachModel->cost_rate == "0.00") {

                            $eachModel->cost_rate = $eachModel->actual_cost_rate;
                        }

                        $eachModel->quotes_id = $quotes_id;

                        $total_tax_amount += $eachModel->tax_vat_amount;

                        $eachModel->save(false);

                        $grand_total += $eachModel->net_amount;
                    }
                }

                if (!empty($modelContractItems)) {

                    foreach ($modelContractItems as $eachModel) {
                        $eachModel->quotes_id = $quotes_id;

                        if (!$eachModel->save(false)) {
                            // Print or log the error
                            echo "Error saving contract item ID: " . $eachModel->id . "<br>";
                            // Optionally show database-level errors (if any)
                            if ($eachModel->hasErrors()) {
                                print_r($eachModel->getErrors());
                            }
                        }
                    }
                }




                /*if (!empty($modelQuoteAdditions)) {

                    foreach ($modelQuoteAdditions as $eachModel) {

                        $eachModel->quotes_id = $quotes_id;

                        $total_tax_amount += $eachModel->addition_tax_amount;

                        $eachModel->save();

                        $grand_total += $eachModel->calculated_value;
                    }
                }

                if (!empty($modelQuoteDeductions)) {

                    foreach ($modelQuoteDeductions as $eachModel) {

                        $eachModel->quotes_id = $quotes_id;

                        $total_tax_amount += $eachModel->deduction_tax_amount;

                        $eachModel->save();

                        $grand_total -= $eachModel->calculated_value;
                    }
                }*/

                if (!empty($_POST['Activity']['notes'])) {

                    $modelNotes->created_by = Yii::app()->user->id;

                    $modelNotes->created_date_time = date('Y-m-d h:i:s');

                    $modelNotes->notes = $_POST['Activity']['notes'];

                    $modelNotes->crm_user_id = Yii::app()->user->id;

                    $modelNotes->customer_id = $modelQuote->customer_id;

                    $modelNotes->contact_id = $modelQuote->contact_id;

                    $modelNotes->type_of_activity = 'N';

                    $modelNotes->added_from = 'Q';

                    $modelNotes->file_id = $modelQuote->file_id;

                    $modelNotes->save(false);
                }
                if (isset($_POST['Icon']['file']) && $_POST['Icon']['file'] != '') {

                    $doc_test = Document::model()->find(array('condition' => 'file_id=' . $modelQuote->file_id . ' AND document_name="' . $_POST['Icon']['file'] . '"'));

                    if (empty($doc_test)) {

                        $modelDocument = new Document;

                        $modelDocument->uploaded_from = "Q";

                        $modelDocument->file_id = $_POST['hid_file_id'];

                        $modelDocument->created_by = Yii::app()->user->id;

                        $modelDocument->created_datetime = date('Y-m-d h:i:s');

                        $modelDocument->document_name = $_POST['Icon']['file'];

                        $modelDocument->save(false);
                    }
                }



                $grand_total += $total_tax_amount;

                //$grand_total -= $modelQuote->total_discount_amount;

                $modelQuote->updateByPk($modelQuote->id, array('grand_total' => $grand_total, 'total_tax_amount' => $total_tax_amount));

                /* if(count($modelDocument)>0){

                  $this->documents($modelQuote->file_id, 'Q');

                  } */



                if ($scenario == 'add') {

                    Yii::import('application.controllers.front.MasternotificationController');

                    $model_mail_setting = Notification::model()->find(array('condition' => 'event_id="3"'));

                    if ($model_mail_setting->mail_required == 'Y') {

                        // MasternotificationController::sendmail(3,$modelQuote->id);
                    }

                    if ($model_mail_setting->notification_required == 'Y') {

                        // MasternotificationController::sendnotification(3,$modelQuote->id);
                    }

                    if ($model_mail_setting->sms_required == 'Y') {

                        // MasternotificationController::sendsms(3,$modelQuote->id);
                    }
                }

                /// write for update Tciket section
                if (isset(Yii::app()->user->fm_module) && Yii::app()->user->fm_module == 'Y') {
                    TicketHeader::model()->updateByPK($modelQuote->ticket_id, [
                        "quotation_id" => $modelQuote->id,
                        'master_file_id' => $modelQuote->file_id
                    ]);
                }
                Yii::import('application.modules.features.models.FeaturesOperations');
                Yii::import('application.modules.features.models.FeaturesApproveLevel');
                $operationType = "QU";
                $model_level_approval = FeaturesApproveLevel::model()->find(array('condition' => ' operations_type="' . $operationType .'"'));
                $approveStatus = "N";
                if ($model_level_approval->max_level == 0) {
                    $approveStatus = "Y";
                }
                FeaturesOperations::model()->updateAll(
                    array(
                        'is_active' => 'N',
                        'updated_by' => Yii::app()->user->id,
                        'updated_date_time' => date('Y-m-d H:i:s'),
                    ),
                    'file_no = :fid',
                    array(':fid' => (int)$modelQuote->file_id)
                );
                MasterFile::model()->updateByPk($modelQuote->file_id, array('current_process_status' => "Q", 'is_approved' => $approveStatus, 'updated_by' => Yii::app()->user->id, 'updated_datetime' => date('Y-m-d H:i:s')));
                
                $jsonData['qtn_id'] = $modelQuote->id;

                $jsonData['file_id'] = $modelQuote->file_id;

                $jsonData['quotation'] = $modelQuote;

                $jsonData['status'] = 'success';

                //$this->SendQuotationMail($modelQuote->id);

                echo CJSON::encode($jsonData);
            } else {

                $error5 = array();

                $error1 = json_decode(CActiveForm::validate($modelQuote, '', false), true);

                if ($modelQuoteItems[0]->product_id > 0)
                    $error2 = json_decode(CActiveForm::validateTabular($modelQuoteItems, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";

                $error3 = json_decode(CActiveForm::validateTabular($modelQuoteAdditions, '', false), true);

                $error4 = json_decode(CActiveForm::validateTabular($modelQuoteDeductions, '', false), true);

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4, $other));

                if ($error != '[]')
                    echo $error;
            }
        } else {

            echo 'error';
        }
    }

    /*

     * function to aprove quotes

     * modified by jisha on 18-9-18.

     */

    public function actionApprove()
    {

        $valid = TRUE;

        $file_id = $_POST['hid_file_id'];

        $modelQuote = new Quotes;

        $other = array();

        //$modelQuote->terms_and_conditions = MasTermsAndConditions::model()->findByPk(1)->terms;

        $modelQuoteItems = array(new QuotesItem);

        $modelQuoteAdditions = array(new QuotesAddition);

        $modelContractItems = array(new QuotesContractItem);

        $modelQuoteDeductions = array(new QuotesDeduction);

        $modelNotes = new Activity();

        $modelDocument = new Document();

        $quotes_id = (int) Yii::app()->request->getParam('id');

        $modelQuote->exchange_rate = 1;

        //$quotation_validity = MasValidity::model()->find()->quotation_validity;

        $quotation_validity = 30;

        $modelQuote->qtn_validity = date('Y-m-d', strtotime('+ ' . $quotation_validity . 'day', strtotime(date('Y-m-d'))));

        if ($quotes_id > 0) {

            $modelQuote = $modelQuote->findByPK($quotes_id);

            $modelQuote->customer_id = $modelQuote->file->customer_id;

            $modelQuote->title = $modelQuote->file->file_title;

            $modelQuote->lead_owner_id = $modelQuote->file->lead_owner_id;

            $modelQuote->terms_and_conditions = $modelQuote->terms_and_conditions;

            $modelQuote->terms_id = $modelQuote->terms_id;

            $modelQuoteItems = $modelQuote->items;

            $modelContractItems = $modelQuote->contract;


            $modelQuoteAdditions = count($modelQuote->adItems) > 0 ? $modelQuote->adItems : $modelQuoteAdditions;

            $modelQuoteDeductions = count($modelQuote->dedItems) > 0 ? $modelQuote->dedItems : $modelQuoteDeductions;
        }



        if (isset($_POST['Quotes'])) {

            if ((int) $_POST['Quotes']['id'] > 0) {

                $modelQuote = $modelQuote->findByPK($_POST['Quotes']['id']);

                $modelQuote->scenario = 'update';

                $modelQuote->updated_by = Yii::app()->user->id;

                $modelQuote->updated_date_time = date('y-m-d H:i:s');
            }

            $modelQuote->attributes = $_POST['Quotes'];

            $modelQuote->currency_id = $_POST['Quotes']['currency_id'];
            $modelQuote->exchange_rate = $_POST['Quotes']['exchange_rate'];
            //$modelQuote->probability = $_POST['Quotes']['probability'];

            $modelQuote->revision = $_POST['Quotes']['revision'];

            //$modelQuote->project_reference = $_POST['Quotes']['project_reference'];

            //$modelQuote->crm_user_id = Yii::app()->user->id;

            //$modelQuote->materials_allocated = (isset($_POST['allocate_materials']) && $_POST['allocate_materials'] == "Y") ? "Y" : "N";

            // if (($_POST['Quotes']['invoice_type'] == '1' OR $_POST['Quotes']['invoice_type'] == '2' ) AND ($_POST['customer_country_id'] == '143')) {



            //     $modelQuote->emirates_id = $_POST['Quotes']['emirates_id'];
            // } else {

            //     $modelQuote->emirates_id = "0";
            // }

            //code added by mereena on 07/02/2020 for ckeditor content
            $modelQuote->terms_id = $_POST['Quotes']['terms_id'];
            $modelQuote->terms_and_conditions = $_POST['Quotes']['terms_and_conditions'];

            $valid = $valid && $modelQuote->validate();

            $p = 0;

            if (is_array($_POST['QuotesItem'])) {

                foreach ($_POST['QuotesItem'] as $i => $item) {

                    if (($item['product_id'] > 0 && $item['product_name'] != 'memo') || $item['product_name'] == 'memo') {

                        $modelQuoteItems[$p] = new QuotesItem;

                        $modelQuoteItems[$p]->attributes = $_POST['QuotesItem'][$i];

                        $modelQuoteItems[$p]->unit_id = $item['unit_id'];

                        $modelQuoteItems[$p]->description = $item['description'];

                        $modelQuoteItems[$p]->brand_class_id = $item['brand_class_id'];

                        // $modelQuoteItems[$p]->product_generic_name = $item['product_generic_name'];

                        $modelQuoteItems[$p]->image_file_name = $item['image_file_name'];

                        $modelQuoteItems[$p]->tax_vat_percentage = $item['tax_vat_percentage'];

                        if ($item['product_name'] == 'memo')
                            $modelQuoteItems[$p]->product_id = '999999';

                        $modelQuoteItems[$p]->checked = $item['checked'];

                        if ($item['product_name'] != 'memo')
                            $valid = $modelQuoteItems[$p]->validate() && $valid;

                        $p++;
                    }
                }
            }
            $valid = $valid && ($modelQuoteItems[0]->product_id > 0);

            $modelsToBeValidated = array($modelQuote, $modelQuoteItems);
            if (is_array($_POST['QuotesContractItem'])) {

                $p = 0;
                $valid = true;
                $other = [];

                foreach ($_POST['QuotesContractItem'] as $i => $itemc) {
                    if (($itemc['product_id'] > 0 && strtolower($itemc['product_name']) != 'memo') || strtolower($itemc['product_name']) == 'memo') {

                        $modelContractItems[$p] = new QuotesContractItem;
                        $modelContractItems[$p]->attributes = $itemc;
                        $modelContractItems[$p]->unit_id = $itemc['unit_id'];
                        $modelContractItems[$p]->unit_id = $itemc['unit_id'];
                        $modelContractItems[$p]->unit_id = $itemc['unit_id'];
                        $modelContractItems[$p]->description = $itemc['description'];
                        $modelContractItems[$p]->quantity = $itemc['quantity'];
                        $modelContractItems[$p]->contract_month = isset($itemc['contract_month']) ? $itemc['contract_month'] : null;
                        if (strtolower($itemc['product_name']) == 'memo') {
                            $modelContractItems[$p]->product_id = 999999;
                        }

                        if (strtolower($itemc['product_name']) != 'memo') {
                            $valid = $modelContractItems[$p]->validate() && $valid;
                        }


                        $p++;
                    }
                }


            }







            if (is_array($_POST['QuotesAddition'])) {

                foreach ($_POST['QuotesAddition'] as $i => $item) {

                    $modelQuoteAdditions[$i] = new QuotesAddition;

                    $modelQuoteAdditions[$i]->attributes = $_POST['QuotesAddition'][$i];

                    if ($item['particular_value'] > 0 && $item['particular'] == '') {

                        $other[] = 'Addition description Cannot Blank';

                        $valid = false;
                    }
                }

                $modelsToBeValidated[] = $modelQuoteAdditions;
            }

            if (is_array($_POST['QuotesDeduction'])) {

                foreach ($_POST['QuotesDeduction'] as $i => $item) {

                    $modelQuoteDeductions[$i] = new QuotesDeduction;

                    $modelQuoteDeductions[$i]->attributes = $_POST['QuotesDeduction'][$i];

                    if ($item['particular_value'] > 0 && $item['particular'] == '') {

                        $other[] = 'Deduction description Cannot Blank';

                        $valid = false;
                    }
                }

                $modelsToBeValidated[] = $modelQuoteDeductions;
            }



            if ($valid) {

                $grand_total = 0;

                if (isset($_POST['hid_file_id'])) {

                    $satus = MasterFile::model()->findByPk($_POST['hid_file_id']);

                    MasterFile::model()->updateByPk($_POST['hid_file_id'], array('is_approved' => "Y", 'current_process_status' => 'Q', 'date_of_approval' => date('Y-m-d'), 'approved_by' => Yii::app()->user->id));
                }

                $modelQuote->file_id = $_POST['hid_file_id'];

                if ($_POST['Quotes']['qtn_start_date'] != '00/00/0000') {

                    $modelQuote->qtn_start_date = str_replace('/', '-', $_POST['Quotes']['qtn_start_date']);

                    $modelQuote->qtn_start_date = date("Y-m-d", strtotime($modelQuote->qtn_start_date));
                }

                if ($_POST['Quotes']['qtn_validity'] != '00/00/0000') {

                    $modelQuote->qtn_validity = str_replace('/', '-', $_POST['Quotes']['qtn_validity']);

                    $modelQuote->qtn_validity = date("Y-m-d", strtotime($modelQuote->qtn_validity));
                }



                $modelQuote->billing_address = $_POST['Quotes']['billing_address'];





                if ((int) $_POST['hid_file_id'] > 0) {

                    $modelQuote->file_id = $_POST['hid_file_id'];
                } else {

                    $masterFile = new MasterFile;

                    $masterFile->crm_user_id = Yii::app()->user->id;

                    $masterFile->customer_id = $_POST['Quotes']['customer_id'];

                    $masterFile->file_title = $_POST['Quotes']['title'];

                    $masterFile->start_from = "Q";

                    $masterFile->current_process_status = "Q";

                    $masterFile->lead_owner_id = $_POST['Quotes']['lead_owner_id'];

                    $masterFile->is_approved = "N";

                    $masterFile->save(false);

                    $modelQuote->file_id = $masterFile->id;
                }



                $modelQuote->save();

                $modelQuote->refresh();

                $quotes_id = $modelQuote->id;

                if ((int) $_POST['Quotes']['id'] > 0) {

                    $allocated_count = AllocatedMaterial::model()->count(array('condition' => 'header_id="' . (int) $_POST['Quotes']['id'] . '"'));

                    if ($allocated_count > 0) {

                        AllocatedMaterial::model()->updateAll(array('allocation_date' => $modelQuote->qtn_start_date, 'allocation_end_date' => $modelQuote->qtn_validity), 'header_id=' . (int) $_POST['Quotes']['id']);
                    }
                }







                QuotesItem::model()->deleteAll('quotes_id=:refer_id', array(':refer_id' => $modelQuote->id));

                QuotesContractItem::model()->deleteAll('quotes_id=:refer_id', array(':refer_id' => $modelQuote->id));

                QuotesAddition::model()->deleteAll('quotes_id=:refer_id', array(':refer_id' => $modelQuote->id));

                QuotesDeduction::model()->deleteAll('quotes_id=:refer_id', array(':refer_id' => $modelQuote->id));

                $total_tax_amount = 0;

                if (!empty($modelQuoteItems)) {

                    foreach ($modelQuoteItems as $eachModel) {

                        $eachModel->quotes_id = $quotes_id;

                        $total_tax_amount += $eachModel->tax_vat_amount;

                        $eachModel->save(false);

                        $grand_total += $eachModel->net_amount;
                    }
                }


                if (!empty($modelContractItems)) {

                    foreach ($modelContractItems as $eachModel) {
                        $eachModel->quotes_id = $quotes_id;

                        if (!$eachModel->save(false)) {
                            // Print or log the error
                            echo "Error saving contract item ID: " . $eachModel->id . "<br>";
                            // Optionally show database-level errors (if any)
                            if ($eachModel->hasErrors()) {
                                print_r($eachModel->getErrors());
                            }
                        }
                    }
                }

                if (!empty($modelQuoteAdditions)) {

                    foreach ($modelQuoteAdditions as $eachModel) {

                        $eachModel->quotes_id = $quotes_id;

                        $eachModel->save();

                        $grand_total += $eachModel->calculated_value;
                    }
                }

                if (!empty($modelQuoteDeductions)) {

                    foreach ($modelQuoteDeductions as $eachModel) {

                        $eachModel->quotes_id = $quotes_id;

                        $eachModel->save();

                        $grand_total -= $eachModel->calculated_value;
                    }
                }



                if (!empty($_POST['Activity']['notes'])) {

                    $modelNotes->created_by = Yii::app()->user->id;

                    $modelNotes->created_date_time = date('Y-m-d h:i:s');

                    $modelNotes->notes = $_POST['Activity']['notes'];

                    $modelNotes->crm_user_id = Yii::app()->user->id;

                    $modelNotes->customer_id = $modelQuote->customer_id;

                    $modelNotes->contact_id = $modelQuote->contact_id;

                    $modelNotes->type_of_activity = 'N';

                    $modelNotes->added_from = 'Q';

                    $modelNotes->file_id = $modelQuote->file_id;

                    $modelNotes->save(false);
                }



                if (isset($_POST['Icon']['file']) && $_POST['Icon']['file'] != '') {

                    $doc_test = Document::model()->find(array('condition' => 'file_id=' . $modelQuote->file_id . ' AND document_name="' . $_POST['Icon']['file'] . '"'));

                    if (empty($doc_test)) {

                        $modelDocument = new Document;

                        $modelDocument->uploaded_from = "Q";

                        $modelDocument->file_id = $_POST['hid_file_id'];

                        $modelDocument->created_by = Yii::app()->user->id;

                        $modelDocument->created_datetime = date('Y-m-d h:i:s');

                        $modelDocument->document_name = $_POST['Icon']['file'];

                        $modelDocument->save(false);
                    }
                }



                $grand_total += $total_tax_amount;

                $modelQuote->updateByPk($modelQuote->id, array('grand_total' => $grand_total, 'total_tax_amount' => $total_tax_amount));

                /*                 * *************** START code added by mereena on 22-10-2019 for approval history******************* */

                date_default_timezone_set("Asia/Dubai");

                $approval_history = new ApprovalHistory;

                $approval_history->file_id = $modelQuote->file_id;

                $approval_history->status = $modelQuote->file->is_approved;

                $approval_history->action_by = Yii::app()->user->id;

                $approval_history->created_by = Yii::app()->user->id;

                $approval_history->created_datetime = date('Y-m-d h:i:s');

                $approval_history->date = date('Y-m-d h:i:s');

                $approval_history->state = 'Q';

                $approval_history->save();

                //code added by mereena on 06-04-2021

                if (isset($_POST['hid_file_id']) && (int) $_POST['hid_file_id']) {



                    $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

                    $quotes_customer_name = $modelQuote->customer->customer_name;

                    $filename = "Quotation_" . $quotes_id . "_" . strtoupper($quotes_customer_name) . "_" . date('Y-m-dh:i:s') . ".pdf";

                    $folder = Yii::getPathOfAlias('webroot') . '/uploads/quotationpdf/';

                    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

                    $mPDF1->WriteHTML($stylesheet, 1);

                    $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_list_individual', array('id' => $quotes_id, 'type' => 1), true));

                    $mPDF1->Output($folder . $filename, 'F');

                    $modelQuotesRevisionHistory = new QuotesRevisionHistory();

                    $modelQuotesRevisionHistory->file_id = $_POST['hid_file_id'];

                    $modelQuotesRevisionHistory->quotes_id = $quotes_id;

                    $modelQuotesRevisionHistory->file_name = $filename;

                    $modelQuotesRevisionHistory->created_by = Yii::app()->user->id;

                    $modelQuotesRevisionHistory->created_date_time = date('Y-m-d h:i:s');

                    $modelQuotesRevisionHistory->save(false);
                }

                //end

                /*                 * *************** End code added by mereena on 22-10-2019 for approval history******************* */

                //$this->documents($modelQuote->file_id, 'Q');

                Yii::import('application.controllers.front.MasternotificationController');

                $model_mail_setting = Notification::model()->find(array('condition' => 'event_id="4"'));

                if ($model_mail_setting->mail_required == 'Y') {

                    // MasternotificationController::sendmail(4,$modelQuote->id);
                }

                if ($model_mail_setting->notification_required == 'Y') {

                    // MasternotificationController::sendnotification(4,$modelQuote->id);
                }

                if ($model_mail_setting->sms_required == 'Y') {

                    // MasternotificationController::sendsms(4,$modelQuote->id);
                }



                // inserting to audit log

                AuditLog::saveAuditLogs(
                    'QUOTATIONS',
                    Yii::app()->user->id,
                    'UPDATED',
                    " with APRVL LVL 1 QTN No - {$modelQuote->id}  "
                );

                // end audit log



                $jsonData['file'] = $modelQuote->file;

                $jsonData['quotation'] = $modelQuote;

                $jsonData['status'] = 'success';

                echo CJSON::encode($jsonData);
            } else {

                $error5 = array();

                $error1 = json_decode(CActiveForm::validate($modelQuote, '', false), true);

                if ($modelQuoteItems[0]->product_id > 0)
                    $error2 = json_decode(CActiveForm::validateTabular($modelQuoteItems, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";

                $error3 = json_decode(CActiveForm::validateTabular($modelQuoteAdditions, '', false), true);

                $error4 = json_decode(CActiveForm::validateTabular($modelQuoteDeductions, '', false), true);

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4, $other));

                if ($error != '[]')
                    echo $error;
            }
        } else {

            echo 'error';
        }
    }

    /*

     * function to more button in quotes

     * modified by jisha on 18-9-18.

     */

    public function actionCreatePrint()
    {

        $id = (int) Yii::app()->request->getParam('id');

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);

        $this->render('create_print', array('id' => $id));
    }

    /*

     * function to print quotes

     * modified by jisha on 18-9-18.

     */

    public function actionPrintQuotationReportPDF()
    {



        $model = new Quotes();
        $id = Yii::app()->request->getParam('id');
        $type = Yii::app()->request->getParam('type');
        $preview = Yii::app()->request->getParam('preview');
        $print_type = Yii::app()->request->getParam('print_type');
        if ($id > 0) {

            $model = new Quotes();
            $model = Quotes::model()->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $borderHeader = '
        <htmlpageheader name="pageBorderHeader">
            <div style="
                position: absolute;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                border: 5px solid red;
                box-sizing: border-box;
                z-index: -1000;
            ">
            </div>
        </htmlpageheader>
        
        <sethtmlpageheader name="pageBorderHeader" value="on" show-this-page="1" />
        ';
        $mPDF1->WriteHTML($borderHeader, \Mpdf\HTMLParserMode::HEADER_CSS);
        if ($preview == 'Y') {//preview

            $mPDF1->SetWatermarkText('PREVIEW');

            $mPDF1->showWatermarkText = true;

        }

        //$mPDF1->SetWatermarkImage('images/watermark.jpg', 0.10);// 10% opacity
        //$mPDF1->showWatermarkImage = true;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);
        if ($type == 3 || $type == 4)
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_list_individual_without_part_no', array('model' => $model, 'id' => $id, 'title' => $title, 'title' => $title, 'type' => $type, 'mpdf' => $mPDF1), true));
        else if ($type == 5)
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_technical_offer', array('model' => $model, 'id' => $id, 'title' => $title, 'title' => $title, 'type' => $type, 'mpdf' => $mPDF1), true));
        else
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_list_individual', array('model' => $model, 'id' => $id, 'title' => $title, 'title' => $title, 'type' => $type,'print_type'=>$print_type, 'mpdf' => $mPDF1), true));

        $page_title = $id . '-Q-' . $model->customer->customer_name . '.pdf';
        $mPDF1->Output($page_title, 'I');
    }

    /*

     * function to print quotes

     * modified by jisha on 18-9-18.

     */

    public function actionPrintQuotationWithoutDiscountPDF()
    {



        $model = new Quotes();

        $id = Yii::app()->request->getParam('id');

        $type = Yii::app()->request->getParam('type');

        if ($id > 0) {

            $model = new Quotes();
        }

        if ($type == '1') {

            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4-L');
        } else {

            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        }

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_without_discount', array('model' => $model, 'id' => $id, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    /*

     * function to print quotes

     * modified by jisha on 18-9-18.

     */

    public function actionPrintQuotationPdfVat()
    {



        $model = new Quotes();

        $id = Yii::app()->request->getParam('id');

        $type = Yii::app()->request->getParam('type');

        if ($id > 0) {

            $model = new Quotes();
        }

        if ($type == '1') {

            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4-L');
        } else {

            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        }

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_with_vat', array('model' => $model, 'id' => $id, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    /*

     * function to view itemdetails more in  quotes

     * modified by jisha on 18-9-18.

     */

    public function actionQuoteItemsview()
    {

        $model = new Quotes();

        $id = Yii::app()->request->getParam('id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_items_list', array('model' => $model, 'id' => $id, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    /* jisha for adding list of received itemneed to be ordered

     * modified by jisha on 18-9-18.

     */

    public function actionMissingList()
    {

        $model = new Quotes();

        $id = Yii::app()->request->getParam('id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_received_list', array('model' => $model, 'id' => $id, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    /*

     * function to Upload doc in  quotes

     * modified by jisha on 18-9-18.

     */

    public function actionDocumentUpload()
    {

        $file_id = Yii::app()->request->getparam("file_id");
        $type = Yii::app()->request->getparam("type");

        $modelDocument = Document::model()->find(array('condition' => 'file_id = "' . $file_id . '"'));

        if (empty($modelDocument)) {

            $modelDocument = new Document();
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);

        $this->renderPartial('document_index', array('modelDocument' => $modelDocument, 'file_id' => $file_id, 'type' => $type), false, true);
    }

    /*

     * function to list note for datatable in  quotes

     * modified by jisha on 18-9-18.

     */

    public function actionGetNotesList()
    {

        $id = $_POST['id'];

        $model = new Activity();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(
            // datatable column index  => database column name

            0 => 't.id',
            1 => 't.notes',
            2 => 't.created_by'
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        if ($id == '') {

            $id = 0;
        }

        $condition = 't.file_id > 0 AND t.file_id="' . $id . '" and t.type_of_activity = "N"';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " and (notes LIKE '%" . $searchString . "%')";
        }

        $count = $model->count(array('condition' => $condition));

        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'date_of_activity DESC'));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {

            $model2 = User::model()->find(array('condition' => 't.id = "' . $row['created_by'] . '"'));

            $rowData[] = array($m, $row->notes, $model2->username, date('d/m/Y', STRTOTIME($row->created_date_time)));

            $m++;
        }

        $data['data'] = $rowData;

        echo json_encode($data);
    }

    /*

     * function to create note in  quotes

     * modified by jisha on 18-9-18.

     */

    public function actionCreateNote()
    {

        $modelNotes = new Activity();

        $file_id = (int) Yii::app()->request->getParam('file_id');

        $id = (int) Yii::app()->request->getParam('id');

        $customer_id = (int) Yii::app()->request->getParam('customer_id');

        $contact_id = (int) Yii::app()->request->getParam('contact_id');

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->render('quotes_note_form', array('modelNotes' => $modelNotes, 'file_id' => $file_id, 'id' => $id, 'customer_id' => $customer_id, 'contact_id' => $contact_id));
    }



    // function to save note in  quotes

    // modified by jisha on 18-9-18.



    public function actionSaveNote()
    {



        date_default_timezone_set("Asia/Dubai");

        $modelNotes = new Activity();

        if (!empty($_POST['Activity'])) {



            $modelNotes->created_by = Yii::app()->user->id;

            $modelNotes->created_date_time = date('Y-m-d h:i:s');

            $modelNotes->notes = $_POST['Activity']['notes'];

            $modelNotes->date_of_activity = date('Y-m-d h:i:s');

            $modelNotes->crm_user_id = Yii::app()->user->id;

            $modelNotes->customer_id = $_POST['customer_id'];

            $modelNotes->contact_id = $_POST['contact_id'];

            $modelNotes->file_id = $_POST['file_id'];

            $modelNotes->type_of_activity = 'N';

            $modelNotes->added_from = 'Q';

            $modelNotes->save(false);

            $modelNotes->attributes = $_POST['Activity'];

            $modelNotes->save(false);

            $jsonData['status'] = 'success';

            $jsonData['customer_id'] = 'success';

            echo CJSON::encode($jsonData);
        }
    }

    /*

     * function to list docs for datatable in  quotes

     * modified by jisha on 18-9-18.

     */

    public function actionGetDocumentList()
    {

        $model = new Document();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(
            // datatable column index  => database column name

            0 => 't.file_id',
            1 => 't.document_name',
            2 => 't.created_by',
            3 => 't.created_datetime',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = 't.isActive="Y" and t.file_id = "' . $_POST['file_id'] . '" AND t.file_id > 0';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " and (document_name LIKE '%" . $searchString . "%')";
        }

        $count = $model->count(array('condition' => $condition));

        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {

            $button_string = "";

            $model2 = User::model()->find(array('condition' => 't.id = "' . $row['created_by'] . '"'));

            if ($type == 'C') {
                $permission = 'service_contract_document_upload';
            } elseif ($type == 'T') {
                $permission = 'service_trial_document_upload';
            } else {
                $permission = 'quotes_document';
            }
            if (isset(Yii::app()->user->havePermissionOn[$permission]) || Yii::app()->user->authorised_user == 1) {

                $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a> &nbsp;';
            }

            $button_string .= '<a href ="' . Yii::app()->createUrl('lead/downloaddocument&id=' . $row['id']) . '" class=" btn btn-primary btn-xs"><i class="fa fa-download"></i></a>';
            // var_dump(Yii::app()->user->havePermissionOn['quotes_document']);
            // die;
            $rowData[] = array($m, $row['document_name'], $model2->username, date("d/m/Y h:m:s", strtotime($row['created_datetime'])), '<div class="btn-wrap text-center">' . $button_string . '</div>');

            $m++;
        }

        $data['data'] = $rowData;

        echo json_encode($data);
    }

    /*

     * function to delete docs for datatable in  quotes

     * modified by jisha on 18-9-18.

     */

    public function actionDeleteDocument()
    {

        $id = $_POST['id'];

        $modelDocument = new Document();

        $model_doc = Document::model()->findbyPK($id);

        $document_details = explode(',', $model_doc->document_name);

        foreach ($document_details as $value) {

            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $value;

            unlink($path);
        }

        $modelDocument->deleteByPk($id);

        echo "success";
    }

    public function actionGetProducts()
    {

        $from = $_GET['frm'];

        $searchTerm = $_GET['term'];

        $payment_terms_id = (int) $_GET['payment_terms_id'];

        $customer_id = (int) $_GET['customer_id'];

        $modelCustomer = new Customer();

        $arr_customer_details = $modelCustomer->findByPk($customer_id);
        //$customer_price_group_id = $arr_customer_details->default_pricing_group_id;


        $modelSalesPriceGroupName = new SalesPriceGroupName();

        $arr_sales_price_group = $modelSalesPriceGroupName->find(array('condition' => 'default_pricing_group="Y"'));

        $condition = '(part_number LIKE "%' . $searchTerm . '%" OR bar_code LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%") and isActive="Y"';

        //$model = new Store();
        //$model = $model->with('tax')->findAll(array('select' => 'id,part_number,description,unit_id,inventory_item_type,purchase_from,rate', 'condition' => $condition, 'limit' => 200));

        $limit = 50;

        $query = 'SELECT * FROM view_all_stock_items WHERE ' . $condition . ' ORDER BY part_number ASC LIMIT ' . $limit;

        $model = Yii::app()->db->createCommand($query)->queryAll();

        $i = 0;

        $payment_term_type = '';

        if ($payment_terms_id > 0) {

            $payment_term_type = MasPaymentTerm::model()->findByPk($payment_terms_id)->payment_type;
        }

        foreach ($model as $eachModel) {



            $warehouse_id = (int) Yii::app()->user->getState('user_warehouse_id');

            $availble_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity*unit_factor),0) as availble_qty FROM `erp_stock_ledger` WHERE product_id=' . $eachModel['id'] . ' AND warehouse_id=' . (int) $warehouse_id)->queryScalar();

            $pricing_condition = 'product_id=' . $eachModel['id'];

            //code added by mereena on 19/07/2022 for   new pricing concept base on unit id

            if ((int) $arr_sales_price_group->id > 0) {

                $pricing_condition .= ' AND pricing_group_id=' . (int) $arr_sales_price_group->id;
            }



            $arr_price_list = SalesPriceGroup::model()->find(array('condition' => $pricing_condition, 'order' => 'id DESC'));

            /* if($payment_term_type=='CA'){

              $cash_credit_price = $arr_price_list->cash_price;

              }

              else{

              $cash_credit_price = $arr_price_list->credit_price;

              } */



            if ((int) $eachModel['id'] > 0 && $customer_id > 0) {

                $SQL_stock_ledger = 'SELECT sales_price FROM erp_stock_ledger WHERE product_id=' . (int) $eachModel['id'] . ' AND customer_vendor_id=' . $customer_id . ' ORDER BY id DESC LIMIT 0,1';

                $customer_last_sales_price = (float) Yii::app()->db->createCommand($SQL_stock_ledger)->queryScalar();
            }





            if ($customer_last_sales_price > $arr_price_list->sales_price) {

                $sales_price = $customer_last_sales_price;
            } else {

                $sales_price = $arr_price_list->sales_price;
            }

            //code added by mereena to avoid damaged qty

            $modelMasInventoryWarehouse = new MasInventoryWarehouse();

            $damage_warehouse_id = $modelMasInventoryWarehouse->find(array('condition' => 'warehouse_code="DAM"'))->id;

            $SQL = "SELECT SUM(quantity) AS damage_quantity FROM erp_stock_ledger WHERE product_id=" . (int) $eachModel['id'] . ' AND warehouse_id=' . $damage_warehouse_id;

            //echo $SQL;

            $total_damage_qty = (float) Yii::app()->db->createCommand($SQL)->queryScalar();

            //end





            $data[$i]['value'] = $eachModel['id'];

            //  $data[$i]['label'] = $eachModel['part_number'].' : '.$eachModel['description']." [Qty: ".Yii::app()->numberFormatter->formatCurrency(($eachModel['quantity']-$total_damage_qty),"")."]";



            $data[$i]['label'] = $eachModel['part_number'] . ' : ' . $eachModel['description'] . " [Qty: " . Yii::app()->numberFormatter->formatCurrency(($availble_qty), "") . "]";

            $data[$i]['part_number'] = $eachModel['part_number'];

            $data[$i]['description'] = $eachModel['description'];

            $data[$i]['unit_id'] = $eachModel['unit_id'];

            $data[$i]['unit_name'] = $eachModel['unit'];

            //$data[$i]['tax_code'] = $eachModel['tax;

            $data[$i]['tax_code'] = $eachModel['tax_code'];

            $data[$i]['part_no'] = $eachModel['part_number'];

            $data[$i]['other'] = $eachModel['type'];

            $data[$i]['rate'] = $eachModel['rate'];

            //$data[$i]['selling_price']=$eachModel['selling_price_1'];

            $data[$i]['selling_price'] = $sales_price;

            $data[$i]['unit_factor'] = $eachModel['second_unit_factor'];

            $data[$i]['pricing_condition'] = $pricing_condition;
            
            $data[$i]['volume'] =  $eachModel['volume'];

            $i++;
        }

        echo CJSON::encode($data);

        Yii::app()->end();
    }

    public function actionGetProductsDetails()
    {

        $from = $_GET['frm'];

        $searchTerm = $_GET['term'];

        $payment_terms_id = (int) $_GET['payment_terms_id'];

        $customer_id = (int) $_GET['customer_id'];

        $hid_frm = (int) $_GET['hid_frm'];

        $modelCustomer = new Customer();

        $arr_customer_details = $modelCustomer->findByPk($customer_id);
        $customer_price_group_id = $arr_customer_details->default_pricing_group_id;

        $condition = '(part_number LIKE "%' . $searchTerm . '%" OR bar_code LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%") and isActive="Y"';

        // if ($hid_frm == 3) {
        //     $condition .= ' AND type="2"';
        // }
        //$model = new Store();
        //$model = $model->with('tax')->findAll(array('select' => 'id,part_number,description,unit_id,inventory_item_type,purchase_from,rate', 'condition' => $condition, 'limit' => 200));

        $limit = 50;

        $query = 'SELECT * FROM view_all_stock_items WHERE ' . $condition . ' ORDER BY part_number LIMIT ' . $limit;

        $model = Yii::app()->db->createCommand($query)->queryAll();

        $i = 0;

        $payment_term_type = '';

        if ($payment_terms_id > 0) {

            $payment_term_type = MasPaymentTerm::model()->findByPk($payment_terms_id)->payment_type;
        }

        foreach ($model as $eachModel) {
            $warehouse_id = (int) Yii::app()->user->getState('user_warehouse_id');

            //$availble_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity*unit_factor),0) as availble_qty FROM `erp_stock_ledger` WHERE product_id=' . $eachModel['id'] . ' AND warehouse_id=' . (int) $warehouse_id)->queryScalar();
            $availble_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity*unit_factor),0) as availble_qty FROM `erp_stock_ledger` WHERE product_id=' . $eachModel['id'])->queryScalar();
            $pricing_condition = 'product_id=' . $eachModel['id'];
            //code added by abin on 21/12/2023 for   new pricing concept base on customer price group name
            //code modified by abin on 05/01/2023 to list all products for default pricing group
            if ((int) $customer_price_group_id > 1) {
                $pricing_condition = ' pricing_group_id = ' . $customer_price_group_id . ' AND product_id=' . $eachModel['id'];
            }
            $arr_price_list = SalesPriceGroup::model()->find(array('condition' => $pricing_condition, 'order' => 'id DESC'));

            $sales_price = '';

            if (isset($arr_price_list->sales_price) && $arr_price_list->sales_price != '') {

                $sales_price = $arr_price_list->sales_price;
            }

            //code added by mereena to avoid damaged qty

            $modelMasInventoryWarehouse = new MasInventoryWarehouse();

            $damage_warehouse_id = $modelMasInventoryWarehouse->find(array('condition' => 'warehouse_code="DAM"'))->id;

            $SQL = "SELECT SUM(quantity) AS damage_quantity FROM erp_stock_ledger WHERE product_id=" . (int) $eachModel['id'] . ' AND warehouse_id=' . $damage_warehouse_id;

            //echo $SQL;

            $total_damage_qty = (float) Yii::app()->db->createCommand($SQL)->queryScalar();

            //end

            //if ($sales_price != '') {
            $data[$i]['value'] = $eachModel['id'];

            $data[$i]['label'] = $eachModel['part_number'] . ' : ' . $eachModel['description'] . " [Qty: " . Yii::app()->numberFormatter->formatCurrency(($availble_qty), "") . "]";

            $data[$i]['part_number'] = $eachModel['part_number'];

            $data[$i]['description'] = $eachModel['description'];

            $data[$i]['unit_id'] = $eachModel['unit_id'];

            $data[$i]['unit_name'] = $eachModel['unit'];

            $data[$i]['tax_code'] = $eachModel['tax_code'];

            $data[$i]['part_no'] = $eachModel['part_number'];

            $data[$i]['other'] = $eachModel['type'];
            //                manu 30-12-2023
//                $data[$i]['rate'] = $eachModel['rate'];
//                $data[$i]['selling_price'] = $sales_price2;

            $data[$i]['rate'] = $eachModel['rate'];
            $data[$i]['selling_price'] = $sales_price;

            $data[$i]['unit_factor'] = $eachModel['second_unit_factor'];

            $data[$i]['pricing_condition'] = $pricing_condition;

            $product_rate = $eachModel['rate'];
            $produt_markup_percent = $eachModel['markup_percent'];
            $produt_markup_rate = ($product_rate * $produt_markup_percent) / 100;
            $final_rate = $product_rate + $produt_markup_rate;

            $data[$i]['mark_up_rate'] = $final_rate;

            $i++;
            //}
        }

        echo CJSON::encode($data);

        Yii::app()->end();
    }

    public function actionGetunitdrop()
    {

        $row = $_POST['row_field'];

        $product_id = (int) $_POST['product_id'];

        $type = $_POST['type'];

        $item_type = $_POST['item_type'];

        $selling_price = $_POST['selling_price'];

        $drop = array();

        $modelOrder = new QuotesItem;

        if ($product_id > 0) {



            //code added by mereena on 07/09/2022 to get default sales unit_id

            $modelStore = new Store();

            $modelStore = $modelStore->findByPk($product_id);


            //end



            $arr_uom = UnitOfMeasurement::getSecondaryBaseUnitWithName($product_id);

            if ($item_type == 4) {



                $unit_id = $_POST['unit_id'];

                $modelOrder->unit_id = $unit_id;

                $drop['drop'] = CHtml::activedropdownlist($modelOrder, "[" . $row . "]unit_id", Unit::getUnits(), array('class' => 'unit go', 'onchange' => 'checkUnit(this.id);'));
            } else {

                //$modelOrder->unit_id = UnitOfMeasurement::getSecondaryBaseunit($product_id);



                $modelOrder->unit_id = UnitOfMeasurement::getSecondaryBaseunit($product_id);

                $drop['drop'] = CHtml::activedropdownlist($modelOrder, "[" . $row . "]unit_id", UnitOfMeasurement::getUnits($product_id), array('class' => 'unit go', 'onchange' => 'checkUnit(this.id);'));
            }

            $drop['factor'] = $arr_uom->factor;

            //$drop['selling_price'] =  number_format(($selling_price * $arr_uom->factor),2);
            //$drop['selling_price'] = number_format(((float) $selling_price), 2);
            $drop['selling_price'] = ((float) $selling_price);
        }

        echo CJSON::encode($drop);
    }

    /*

     * function to get salesgroup dropdwn in  quotes

     * modified by jisha on 31-7-19.

     */

    public function actionGetSalesGroup()
    {

        $frm = $_POST['frm'];

        $type = $_POST['type'];

        $drop = array();

        $model = new Quotes();

        if ($frm == 'quotes')
            $model = new Quotes();

        if ($type == 'H') {

            $drop['salesgrouplist'] = CHtml::activedropdownlist($model, "sales_group", MasSalesGroup::getHiringSalesGroup(), array('data-label' => 'Sales Group <span style="color:red">*</span>'));
        } else {

            $drop['salesgrouplist'] = CHtml::activedropdownlist($model, "sales_group", MasSalesGroup::getNonHiringSalesGroup(), array('data-label' => 'Sales Group <span style="color:red">*</span>'));
        }

        echo CJSON::encode($drop);
    }

    /*

     * function to get  quotes helper

     * modified by jisha on 18-9-18.

     */

    public function actionQuotationHelper()
    {

        $product_id = (int) $_POST['id'];

        $customer_id = (int) $_POST['customer_id'];

        $this->renderPartial('quotation_helper', array('id' => $product_id, 'customer_id' => $customer_id), false, true);
    }

    /*

     * function to get  customer pricing for autocomplete in quotes details,order details

     * modified by jisha on 18-9-18.

     */

    public function actionGetAllDetailsForProduct()
    {

        if ($_GET['product_id'] > 0)
            $product_id = $_GET['product_id'];
        else
            $product_id = $_POST['product_id'];

        if ($_GET['customer_id'] > 0)
            $customer_id = $_GET['customer_id'];
        else
            $customer_id = $_POST['customer_id'];

        $modelCustomer = new Customer();

        $arr_customer_pricing_details = $modelCustomer->findByPk($customer_id);

        $payment_terms_id = (int) $_GET['payment_terms_id'];

        $payment_term_type = '';

        if ($payment_terms_id > 0) {

            $payment_term_type = MasPaymentTerm::model()->findByPk($payment_terms_id)->payment_type;
        }



        $arr_price_list = SalesPriceGroup::model()->find(array('condition' => 'product_id=' . $product_id));
        $sales_price = $arr_price_list->sales_price;
        if ($payment_term_type == 'CA') {

            $sales_price = $arr_price_list->sales_price;
        } else {

            //$cash_credit_price = $arr_price_list->credit_price;
        }





        $jsonData['price'] = number_format(floatval($sales_price), 2, '.', '');

        echo CJSON::encode($jsonData);

        Yii::app()->end();
    }

    /*

     * function to get  customer contact in quotes add

     * modified by jisha on 18-9-18.

     */

    public function actionFetchcontactdetails()
    {



        $data = CustomerContact::model()->find('id=:c_id', array(':c_id' => (int) $_POST['contact_id']));

        echo CJSON::encode($data);
    }

    /*

     * function to get  customer contact in quotes add

     * modified by jisha on 18-9-18.

     */

    public function actiongetCustomerContactdetails()
    {

        $id = Yii::app()->request->getparam("id");

        $payment_term = Yii::app()->request->getparam("payment_term");



        $models = CustomerContact::getCustomerContacts($id);

        $model = new Quotes;

        if (!empty($payment_term)) {
            $model->payment_terms_id = $payment_term;
        }

        $drop['contact'] = CHtml::activedropDownList($model, 'contact_id', $models, array('class' => 'tooltipster', 'title' => 'Please Select Contact', 'data-label' => 'Contact <span style="color:red;">*</span>', 'data-search' => true, 'onchange' => 'getcontactdetails(this.value)'));

        $drop['paymentterm'] = CHtml::activedropDownList($model, 'payment_terms_id', MasPaymentTerm::getPaymentTerms(), array('class' => '', 'title' => 'Select Payment Terms', 'data-label' => 'Payment Terms <span style="color:red;">*</span> '));

        //$status = array("dt" => $drop);

        echo CJSON::encode($drop);
    }

    public function actionGetContextMenuItems()
    {

        echo '{"\"edit\": {name: \"Edit\", icon: \"edit\"}"},';
    }

    /*     * *************** Code Added By mereena on 07/06/2019 *************************** */

    public function actionGetInventoryHiringProducts()
    {

        $from = $_GET['frm'];

        $searchTerm = $_GET['term'];

        $customer_id = $_GET['customer_id'];

        $qtn_type = $_GET['qtn_type'];

        $application = $_GET['application'];

        $sales_group = (int) $_GET['sales_group'];

        if ($sales_group > 0) {

            $model_salesgroup = MasSalesGroup::model()->findByPK($sales_group);
        }

        $condition = '(t.part_number LIKE "%' . $searchTerm . '%" OR t.description LIKE "%' . $searchTerm . '%" OR t.oem_number LIKE "%' . $searchTerm . '%") and t.isActive="Y"';

        if ($qtn_type == 'H') {

            if ($from == 'orderhireitem' || $from == 'quoteshireitem') {

                //                $condition = '(t.part_number LIKE "%' . $searchTerm . '%" OR t.description LIKE "%' . $searchTerm . '%" OR product.oem_number LIKE "%' . $searchTerm . '%")';
//                $modelHI = new HiringItems();
//                $model = $modelHI->with('product','unitdetails')->findAll(array( 'condition' => $condition,'group'=>'t.product_id', 'limit' => 200));

                $condition = '(t.hiring_part_number LIKE "%' . $searchTerm . '%" OR t.description LIKE "%' . $searchTerm . '%") and t.isActive="Y"';

                $model = new Store();

                $model = $model->findAll(array('condition' => $condition, 'limit' => 200));
            } else {

                $condition = '(t.part_number LIKE "%' . $searchTerm . '%" OR t.description LIKE "%' . $searchTerm . '%" OR storedetails.oem_number LIKE "%' . $searchTerm . '%") and storedetails.isActive="Y"';

                if ($application != '')
                    $condition .= ' AND t.application_id="' . $application . '" AND storedetails.machine_type="M"'; /* .'" AND 	hiring_status="IN" */

                $model = new Hiring();

                $model = $model->with('storedetails', 'unitdetails')->findAll(array(/* 'select' => 'id,part_number,description,unit_id,1 AS inventory_item_type', */ 'condition' => $condition, 'limit' => 200));
            }
        } elseif (isset($model_salesgroup->type) && $model_salesgroup->type == 'P') {

            $condition = '(product.hiring_part_number LIKE "%' . $searchTerm . '%" OR product.description LIKE "%' . $searchTerm . '%" OR product.oem_number LIKE "%' . $searchTerm . '%") AND (t.transaction_type="HIRING_TRANSFER_IN" OR t.transaction_type="UPLOAD_HIRING_TRANSFER_IN") and product.isActive="Y"'; //code chaged by mereena on 18/02/2020

            $model = new ProductLocationHiringDetails();

            $model = $model->with('product')->findAll(array('select' => 'product.id AS id,product.hiring_part_number AS part_number,product.description AS description,product.unit_id AS unit_id,product.inventory_item_type AS inventory_item_type', 'condition' => $condition, 'group' => 't.product_id', 'order' => 'product.part_number ASC', 'limit' => 200));
        } else {

            $condition = '(t.part_number LIKE "%' . $searchTerm . '%" OR t.description LIKE "%' . $searchTerm . '%" OR t.oem_number LIKE "%' . $searchTerm . '%") and t.isActive="Y"';

            $model = new Store();

            $model = $model->with('tax')->findAll(array('select' => 'id,part_number,description,unit_id,inventory_item_type', 'condition' => $condition, 'limit' => 200));
        }

        $i = 0;

        $data = array();

        foreach ($model as $eachModel) {



            if ($qtn_type == 'H') {

                if ($from == 'orderhireitem' || $from == 'quoteshireitem') {

                    $model_avail_qty = ProductLocationHiringDetails::model()->with('warehouse')->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'product_id="' . $eachModel->id . '" AND warehouse.warehouse_code!="DAM"'));

                    if (empty($model_avail_qty) || ($model_avail_qty->quantity == '')) {

                        $model_avail_qty->quantity = 0;
                    }

                    $inventory_item_type = 1; //stock item

                    $hiring_id = 0;

                    $quantity = 1;

                    $condition_hiring = 't.product_id="' . $eachModel->id . '"';

                    if ($application != '') {

                        $condition_hiring .= ' AND hiringdetails.application_id="' . $application . '"';
                    }

                    $model_hiring_item = HiringItems::model()->with('hiringdetails')->find(array('condition' => $condition_hiring));

                    if ($model_hiring_item->id > 0) {

                        $hiring_id = $model_hiring_item->id;

                        $quantity = $model_hiring_item->quantity;
                    }

                    $data[$i]['value'] = $eachModel->id;

                    //$data[$i]['default_hour'] = $eachModel->default_hrs_per_day;

                    $data[$i]['part_number'] = $eachModel->hiring_part_number;

                    $data[$i]['description'] = $eachModel->description;

                    $data[$i]['unit_id'] = $eachModel->unit->id;

                    $data[$i]['unit_name'] = $eachModel->unit->symbol;

                    $data[$i]['tax_code'] = $eachModel->tax;

                    $data[$i]['other'] = $inventory_item_type . "##" . $hiring_id;

                    $data[$i]['total_qty'] = $quantity;

                    $data[$i]['label'] = $eachModel->hiring_part_number . '(Qty-' . (int) $model_avail_qty->quantity . ')' . ' : ' . $eachModel->description;
                } else {

                    $model_avail_qty = ProductLocationHiringDetails::model()->with('warehouse')->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'product_id="' . $eachModel->product_id . '" AND warehouse.warehouse_code!="DAM"'));

                    if ($model_avail_qty->quantity == '') {

                        $model_avail_qty->quantity = 0;
                    }

                    $inventory_item_type = 1; //stock item

                    $hiring_id = $eachModel->id;

                    $data[$i]['value'] = $eachModel->product_id;

                    $data[$i]['default_hour'] = $eachModel->default_hrs_per_day;

                    $data[$i]['part_number'] = $eachModel->part_number;

                    $data[$i]['description'] = $eachModel->description;

                    $data[$i]['unit_id'] = $eachModel->unit_id;

                    $data[$i]['unit_name'] = $eachModel->unitdetails->symbol;

                    $data[$i]['tax_code'] = $eachModel->storedetails->tax;

                    $data[$i]['other'] = $inventory_item_type . "##" . $hiring_id;

                    $data[$i]['total_qty'] = $eachModel->quantity;

                    $data[$i]['label'] = $eachModel->part_number . '(Qty-' . (int) $model_avail_qty->quantity . ')' . ' : ' . $eachModel->description;
                }

                $data[$i]['serialno'] = 'H';
            } else if (isset($model_salesgroup->type) && $model_salesgroup->type == 'P') {

                $model_avail_qty = ProductLocationHiringDetails::model()->with('warehouse')->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'product_id="' . $eachModel->product->id . '" AND warehouse.warehouse_code!="DAM"'));

                if ($model_avail_qty->quantity == '') {

                    $model_avail_qty->quantity = 0;
                }

                $data[$i]['value'] = $eachModel->product->id;

                $data[$i]['pdt_loc_hiring'] = $eachModel->id;

                $data[$i]['part_number'] = $eachModel->product->hiring_part_number;

                $data[$i]['description'] = $eachModel->product->description;

                $data[$i]['unit_id'] = $eachModel->product->unit->id;

                $data[$i]['unit_name'] = $eachModel->product->unit->symbol;

                $data[$i]['tax_code'] = $eachModel->product->tax;

                $data[$i]['other'] = $eachModel->product->inventory_item_type;

                $data[$i]['total_qty'] = 1;

                $data[$i]['serialno'] = $model_salesgroup->type;

                $data[$i]['label'] = $eachModel->product->hiring_part_number . '(Qty-' . (int) $model_avail_qty->quantity . ')' . ' : ' . $eachModel->product->description;
            } else {

                $total_available_product = ProductLocationDetails::model()->find(array('select' => 'IFNULL(sum(quantity),0) as quantity', 'condition' => 'product_id="' . $eachModel->id . '"'));

                $allocated_product = AllocatedMaterial::model()->find(array('select' => 'IFNULL(sum(quantity),0) as quantity', 'condition' => 'product_id="' . $eachModel->id . '"'));

                $stock_qty = $total_available_product->quantity - $allocated_product->quantity;

                $data[$i]['value'] = $eachModel->id;

                $data[$i]['part_number'] = $eachModel->part_number;

                $data[$i]['description'] = $eachModel->description;

                $data[$i]['unit_id'] = $eachModel->unit->id;

                $data[$i]['unit_name'] = $eachModel->unit->symbol;

                $data[$i]['tax_code'] = $eachModel->tax;

                $data[$i]['other'] = $eachModel->inventory_item_type;

                $data[$i]['total_qty'] = 1;

                $data[$i]['label'] = $eachModel->part_number . '(Qty-' . $stock_qty . ')' . ' : ' . $eachModel->description;

                $data[$i]['serialno'] = $model_salesgroup->type;
            }



            $data[$i]['part_no'] = $eachModel->part_number;

            $i++;
        }

        echo CJSON::encode($data);

        Yii::app()->end();
    }

    public function actionGetHiringProductDetails()
    {

        $hiring_id = $_POST['hiring_id'];

        $hiring_type = $_POST['hiring_type'];

        $model = new HiringItems();

        $condition = ' 1=1';

        if ($hiring_type == 1) {

            $condition .= ' AND type!=2';
        } else if ($hiring_type == 2) {

            $condition .= ' AND type!=1';
        }

        $model = $model->with('product', 'unitdetails', 'product.tax')->findAll(array('condition' => 'hiring_id=' . $hiring_id . ' AND ' . $condition));

        $modelQuoteItems = array(new HiringQuotesItem);

        foreach ($model as $i => $eachItem) {

            $modelQuoteItems[$i] = new HiringQuotesItem;

            $modelQuoteItems[$i]['product_id'] = $eachItem->product_id;

            $modelQuoteItems[$i]['product_name'] = $eachItem->part_number;

            $modelQuoteItems[$i]['description'] = $eachItem->description;

            $modelQuoteItems[$i]['unit_id'] = $eachItem->unit_id;

            $modelQuoteItems[$i]['quantity'] = $eachItem->quantity;

            ;

            $modelQuoteItems[$i]['net_amount'] = 0;

            $modelQuoteItems[$i]['tax_vat_percentage'] = $eachItem->product->tax->percentage;
        }

        //echo '<pre>';
        //print_r($modelQuoteItems);
        //exit;

        $this->renderPartial('hiring_fetch_details', array('id' => $product_id, 'hiring_id' => $hiring_id, 'modelQuoteItems' => $modelQuoteItems), false, true);
    }

    public function actionPrintHiringQuotationReportPDF()
    {

        $model = new Quotes();

        $id = Yii::app()->request->getParam('id');

        $print_type = Yii::app()->request->getParam('print_type');

        $type = Yii::app()->request->getParam('type');

        if ($id > 0) {

            $model = new Quotes();
        }



        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.hiring_quotation_individual', array('model' => $model, 'id' => $id, 'title' => $title, 'title' => $title), true));

        $mPDF1->Output("Quotation.pdf", 'I');
    }

    public function actionGetAjaxQuotationDetails()
    {

        $model = new Quotes();

        $id = Yii::app()->request->getParam('id');

        $sales_group_id = Yii::app()->request->getParam('id');

        $condition = 'quotes_id="' . $id . '"'; //To fetch master

        $modelQuoteItems = QuotesItem::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));

        if (empty($modelQuoteItems)) {

            $modelQuoteItems = array(new QuotesItem);
        }

        $this->renderPartial('ajax_quotes_details', array('model' => $model, 'modelQuoteItems' => $modelQuoteItems, 'id' => $id, 'sales_group_id' => $sales_group_id));
    }

    public function actionPrintQuotationAvailableQtyPDF()
    {

        $id = Yii::app()->request->getParam('id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_availability', array('id' => $id), true));

        $mPDF1->Output("Quotation.pdf", 'I');
    }

    public function actionPrintHiringQuotationWord()
    {

        $model = new Quotes();

        $id = Yii::app()->request->getParam('id');

        if ($id > 0) {

            $model = new Quotes();
        }

        $filename = 'quotation' . $id . '.doc';

        header("Content-type: application/vnd.ms-word");

        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");

        $this->renderPartial("application.views.front..word.hiring_quotation_individual", array('model' => $model, 'id' => $id), false, true);

        Yii::app()->end();
    }

    //code added by mereena on 22/10/2019 -- To get approval history

    public function actionGetApprovalHistory()
    {

        $file_id = Yii::app()->request->getparam("file_id");

        $modelHistory = ApprovalHistory::model()->find(array('condition' => 'file_id = "' . $file_id . '"'));

        if (empty($modelHistory)) {

            $modelHistory = new ApprovalHistory();
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);

        $this->renderPartial('approval_history', array('modelHistory' => $modelHistory, 'file_id' => $file_id), false, true);
    }

    public function actionGetApprovalHistoryList()
    {

        $model = new ApprovalHistory();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(
            // datatable column index  => database column name

            0 => 't.action_by',
            1 => 't.created_datetime',
            2 => 't.state',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = 't.file_id = "' . $_POST['file_id'] . '"';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " AND (approvedby.first_name LIKE '%" . $searchString . "%' OR approvedby.last_name LIKE '%" . $searchString . "%' OR state LIKE '%" . $searchString . "%')";
        }

        $count = $model->with('approvedby')->count(array('condition' => $condition));

        $model = $model->with('approvedby')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'created_datetime DESC'));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {

            $button_string = "";

            $status = "Approved";

            if ($row['status'] == 'N') {

                $status = "Un Approved";
            }

            $state = "Quotation";

            if ($row['state'] == 'O') {

                $state = "Order";
            }

            $rowData[] = array($m, $row['approvedby']['first_name'] . " " . $row['approvedby']['last_name'], date("d/m/Y h:i:s", strtotime($row['created_datetime'])), $status, $state);

            $m++;
        }

        $data['data'] = $rowData;

        echo json_encode($data);
    }

    //end

    public function actionPrintHiringQuotationWordNew()
    {

        $model = new Quotes();

        $modelHiringItems = new Hiring();

        $id = Yii::app()->request->getParam('id');

        if ($id > 0) {

            $model = Quotes::model()->findByPk($id);
        }

        function ordinalSuffix($num)
        {

            $suffixes = array("st", "nd", "rd");

            $lastDigit = $num % 10;

            if (($num < 20 && $num > 9) || $lastDigit == 0 || $lastDigit > 3)
                return "th";



            return $suffixes[$lastDigit - 1];
        }

        $addr = '';

        if (!empty($model->customer->customer_address)) {

            $addr .= $model->customer->customer_address . ",";
        }

        if (!empty($model->customer->customer_postal_code)) {

            $addr .= "P. O. Box " . $model->customer->customer_postal_code . ",";
        }

        if (!empty($model->customer->customer_city)) {

            $addr .= $model->customer->customer_city . ",";
        }

        if (!empty($model->customer->customer_country)) {

            $addr .= " - " . $model->customer->country->country_name;
        }



        $attention = $model->customercontact->prefix . ' ' . $model->customercontact->person_name;

        $subject = 'Hire of ' . $model->qtn_hiring_text;

        $companyname = $model->customer->customer_name;

        $address = $addr;

        $reference = 'Q ' . $model->id;

        $tel = $model->customer->customer_phone_no;

        $fax = $model->customer->customer_fax;

        $date = date("j", strtotime($model->qtn_start_date)) . ordinalSuffix(date("j", strtotime($model->qtn_start_date))) . ' ' . date("M Y", strtotime($model->qtn_start_date));

        $contactperson = $attention;

        $data = array();

        $data['customer_name'] = str_replace("&", " AND ", $companyname);

        $data['address'] = str_replace("&", " AND ", $addr);

        $data['subject'] = str_replace("&", " AND ", $subject);

        $data['telephone'] = str_replace("&", " AND ", $tel);

        $data['fax'] = str_replace("&", " AND ", $fax);

        $data['id'] = $id;

        $data['qn_date'] = $date;

        $data['attention'] = str_replace("&", " AND ", $contactperson);

        $data['reference'] = str_replace("&", " AND ", $reference);

        $data['grand_total'] = $model->grand_total;

        $data['leadowner'] = $model->name1;

        $data['leadownercontact'] = $model->phn1;

        //$data['leadownerdesignation'] =$model->designation1;
//        $data['sig_name'] =$model->name2;
//        $data['sig_mobile'] =$model->phn2;
//        $data['sig_designation'] =$model->designation2;
        //code added by mereena on 19/11/2019

        if (!empty($model->customercontact->contact_email_id)) {

            $data['contactemail'] = str_replace("&", " AND ", $model->customercontact->contact_email_id);
        } else {

            $data['contactemail'] = str_replace("&", " AND ", $model->customer->customer_email_id);
        }

        if (!empty($model->customercontact->contact_mobile_no)) {

            $data['contactmobile'] = str_replace("&", " AND ", $model->customercontact->contact_mobile_no);
        } else {

            $data['contactmobile'] = str_replace("&", " AND ", $model->customer->customer_phone_no);
        }



        $data['qtncurrency'] = str_replace("&", " AND ", $model->currency0->currency_code);

        $condition_1 = 't.quotes_id ="' . $model->id . '" AND hiring_master="N"';

        $modelQuotessubItems = QuotesItem::model()->with('hiringitem')->findAll(array('condition' => $condition_1, 'order' => 't.id ASC'));

        $condition = 't.quotes_id ="' . $model->id . '" AND hiring_master="Y"';

        $modelQuotesMainItems = QuotesItem::model()->find(array('condition' => $condition));

        $modelHiringItems = Hiring::model()->findByPk($modelQuotesMainItems->hiring_id);

        if (!empty($modelHiringItems->template_file_name)) {

            $data['template_file'] = '../uploadfiles/' . $modelHiringItems->template_file_name;
        } else {



            $data['template_file'] = 'template2.docx';
        }





        $next_serial_no = 2;

        $items = array();

        foreach ($modelQuotessubItems as $i => $eachItem) {

            if ($eachItem->hiringitem->type == 4 || $eachItem->hiring_item_id == 0) {

                $item[$i]['sl_no'] = $i + 1;

                $item[$i]['description'] = nl2br($eachItem->description);

                $item[$i]['qty'] = $eachItem->quantity;

                $item[$i]['rate'] = $eachItem->rate;
            }
        }

        // $data['items']=$item;

        $json_data = json_encode($data);

        // $json_data1 = json_encode($data1);

        header("Location: https://cumuluserp.me/acecentro/upload/msoffice/word/mini_code.php?data=" . $json_data);
    }

    public function actionGetOptionalProduct()
    {

        $searchTerm = $_GET['term'];

        $qtn_type = $_GET['qtn_type'];

        $condition = '(t.description LIKE "%' . $searchTerm . '%") and t.isActive="Y"';

        if ($qtn_type == 'H') {

            $condition .= ' OR t.hiring_part_number LIKE "%' . $searchTerm . '%"';
        } else {

            $condition .= ' OR t.part_number LIKE "%' . $searchTerm . '%"';
        }



        $model = Store::model()->findAll(array('select' => 'id,hiring_part_number,part_number,description', 'condition' => $condition, 'limit' => 200));

        $i = 0;

        $data = array();

        foreach ($model as $eachModel) {

            $part_number = $eachModel->part_number;

            if ($qtn_type == 'H') {

                $part_number = $eachModel->hiring_part_number;
            }

            $data[$i]['value'] = $eachModel->id;

            $data[$i]['part_number'] = $part_number;

            $data[$i]['description'] = $eachModel->description;

            $data[$i]['total_qty'] = 1;

            $data[$i]['label'] = $part_number . ' : ' . $eachModel->description;

            $i++;
        }

        echo CJSON::encode($data);

        Yii::app()->end();
    }

    public function actionRemoveoptionalitem()
    {

        $id = $_POST['id'];

        if ($id > 0) {

            QuotesOptionalItem::model()->deleteByPk($id);

            $status['status'] = 'success';
        } else {

            $status['status'] = 'error';
        }

        echo CJSON::encode($status);
    }

    public function actionPrintQuotation()
    {

        $model = new Quotes();

        $id = Yii::app()->request->getParam('id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.pdf_quotation', array('model' => $model, 'id' => $id), true));

        $mPDF1->Output("Quotation.pdf", 'I');
    }

    public function actionGetPreviousCustomerRates()
    {

        $product_id = $_POST['id'];

        $customer_id = $_POST['customer_id'];

        $model = new QuotesItem();

        $arr_prev_rates = $model->with('quotes')->findAll(array('condition' => 'quotes.customer_id=' . $customer_id . ' AND t.product_id=' . $product_id, 'order' => 't.id DESC', 'limit' => 5));

        $table = '<table class="table table-primary">';

        if (!empty($arr_prev_rates)) {

            foreach ($arr_prev_rates as $each) {

                $table .= '<tr>';

                $table .= '<td>' . $each->quotes->qtn_start_date . '</td>';

                $table .= '<td class="text-right">' . $each->rate . '</td>';

                $table .= '</tr>';
            }
        } else {

            $table .= '<tr>';

            $table .= '<td colspan="2">No Data</td>';

            $table .= '</tr>';
        }

        echo $table;
    }

    public function actionSendQuotationConversionMail()
    {

        $subject = "Mail Regarding Open Quotations that were not Converted to Order";

        $view = "lead_notification_mail";

        $from = 'john@mailbluesky.com';

        $to = 'jisha@mailbluesky.com';

        $content = '';

        $applicant_name = 'Diatech ERP TEAM';

        $salutation = 'Dear Sir';

        //setting details

        $model_settings = new MasCompanySettings();

        $crm_login_company_id = Yii::app()->user->master_user_company_id;

        $model_settings = $model_settings->find(array('condition' => 'crm_company_id=' . $crm_login_company_id));

        $quotation_to_order_days = $model_settings->quotation_to_order_days;

        //quotation details

        $condition = 't.status = "Y" AND t.isActive="Y"';

        if ($quotation_to_order_days > 0) {

            $condition .= ' AND TIMESTAMPDIFF(day,t.qtn_start_date,NOW())>' . $quotation_to_order_days;
        }

        $model_quotation = Quotes::model()->findAll(array('condition' => $condition));

        //SELECT * FROM `erp_quotes` `t` WHERE t.status = "O" AND t.isActive="Y"AND TIMESTAMPDIFF(day,t.qtn_start_date,NOW())>1

        if (!empty($model_quotation)) {

            $content .= '<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">

                <tbody>

                    <tr>

                        <th style="border: 1px solid #666;padding: 4px 5px;" width="10px">

                        File #

                        </th>

                        <th style="border: 1px solid #666;padding: 4px 5px;" width="10px">

                        Qtn #

                        </th>

                        <th style="border: 1px solid #666;padding: 4px 5px;" width="12px">

                        Customer

                        </th>

                        <th style="border: 1px solid #666;padding: 4px 5px;" width="12px">

                        Lead Owner

                        </th>

                        <th style="border: 1px solid #666;padding: 4px 5px;" width="10px">

                        Qtn Date

                        </th>

                        <th style="border: 1px solid #666;padding: 4px 5px;" width="10px">

                        Validity

                        </th>

                        <th style="border: 1px solid #666;padding: 4px 5px;" width="10px">

                        Qtn Value

                        </th>

                    </tr>';

            foreach ($model_quotation as $value) {

                $qtn_start_date = '-';

                if ($value->qtn_start_date != '' && $value->qtn_start_date != '0000-00-00') {

                    $qtn_start_date = date("d/m/Y", strtotime($value->qtn_start_date));
                }

                $qtn_validity = '-';

                if ($value->qtn_validity != '' && $value->qtn_validity != '0000-00-00') {

                    $qtn_validity = date("d/m/Y", strtotime($value->qtn_validity));
                }

                $qtn_value = Yii::app()->numberFormatter->formatCurrency($value['grand_total'], "");

                $content .= '<tr>

                    <td style="border: 1px solid #666;padding: 4px 5px;">' . $value['file_id'] . '</td>

                    <td style="border: 1px solid #666;padding: 4px 5px;">' . $value['id'] . '</td>

                    <td style="border: 1px solid #666;padding: 4px 5px;text-align: left;">' . $value->customer->customer_name . '</td>

                    <td style="border: 1px solid #666;padding: 4px 5px;text-align: left;">' . $value->leadowner->first_name . " " . $value->leadowner->last_name . '</td>

                    <td style="border: 1px solid #666;padding: 4px 5px;">' . $qtn_start_date . '</td>

                    <td style="border: 1px solid #666;padding: 4px 5px;">' . $qtn_validity . '</td>

                    <td style="border: 1px solid #666;padding: 4px 5px;text-align: right;">' . $qtn_value . '</td>

                    </tr>';
            }

            $content .= '</tbody>

            </table>';

            $mailContent = array();

            $mailContent['body'] = '

                <table cellpadding="0" cellspacing="0" align="left" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit">

                    <tbody>

                        <tr style="vertical-align: top">

                            <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">

                                <div>' . $salutation . ',</div>

                            </td>

                        </tr>

                        <tr>

                            <td height="30"></td>

                        </tr>

                        <tr style="vertical-align: top">

                            <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">

                                <strong style="font-size: 15px">Sub: ' . $subject . '</strong>

                            </td>

                        </tr>

                        <tr>

                            <td height="30"></td>

                        </tr>

                        <tr style="vertical-align: top">

                            <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">'
                . $content . '<br>

                                <br>

                                <br>

                                Thanking you,

                                <br>

                                <br>

                                Yours sincerely,

                                <br>

                                <br>

                                ' . $applicant_name . '

                            </td>

                        </tr>

                    </tbody>

                </table>';

            ////End Mail Content

            $message = new YiiMailMessage;

            $message->view = $view;

            $message->setBody(array('mailContent' => $mailContent), 'text/html');

            $message->subject = $subject;

            $message->from = $from;

            $message->addTo($to);

            //$message->addCC($custom_mail_id);

            Yii::app()->mail->send($message);

            echo CJSON::encode(array('status' => 'success'));
        }
    }

    public function actionGetItemHistory()
    {

        $product_id = $_POST['product_id'];

        $customer_id = $_POST['customer_id'];

        $availble_qty = Yii::app()->db->createCommand('SELECT SUM(quantity) as availble_qty FROM `view_all_stock_items` WHERE id=' . $product_id . ' GROUP BY id')->queryScalar();

        /* $model=new QuotesItem();

          $arr_prev_rates = $model->with('quotes')->findAll(array('condition'=>'quotes.customer_id='.$customer_id.' AND t.product_id='.$product_id,'order'=>'t.id DESC','limit'=>5)); */



        $model = new InvoiceItem();

        $arr_prev_rates = $model->with('invoice')->findAll(array('condition' => 'invoice.customer_id=' . $customer_id . ' AND t.product_id=' . $product_id, 'order' => 't.id DESC', 'limit' => 5));

        $table = '<table class="table table-sm table-theme table-bordered">

                              <thead>

                               <tr>

                               <th>Available Qty</th>

                               <th>' . $availble_qty . '</td>

                               </tr>

                               <tr><th colspan="2" style="background:#f5fca9;">Previous Rate</th></tr>

                                <tr>

                                    <th>Date</th>

                                    <th>Rate</th>

                                </tr>

                              </thead>

                              <tbody>';

        if (!empty($arr_prev_rates)) {

            foreach ($arr_prev_rates as $each) {

                $table .= '<tr>';

                //$table .= '<td>'.date('d/m/Y',strtotime($each->quotes->qtn_start_date)).'</td>';

                $table .= '<td>' . date('d/m/Y', strtotime($each->invoice->invoice_date)) . '</td>';

                $table .= '<td class="text-right">' . $each->rate . '</td>';

                $table .= '</tr>';
            }
        } else {

            $table .= '<tr>';

            $table .= '<td colspan="2">No Data</td>';

            $table .= '</tr>';
        }



        $table .= '</tbody></table>';

        $jsonData['table'] = $table;

        echo CJSON::encode($jsonData);
    }

    public function actionUploadQuotationImage($folder = null)
    {

        Yii::import("ext.EAjaxUpload.qqFileUploader");

        $field_id = "";

        if (isset($_GET['field_id'])) {

            $field_id = Yii::app()->request->getParam('field_id');
        }

        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';

        // make the directory to store the pic:

        if (!is_dir($folder)) {

            mkdir($folder, 0777, TRUE);
        }

        $allowedExtensions = array("jpg", "jpeg", "gif", "png"); //array("jpg","jpeg","gif","exe","mov" and etc...

        $sizeLimit = 2 * 1024 * 1024; // maximum file size in bytes

        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);

        $result = $uploader->handleUpload($folder);

        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);

        $result['field_id'] = $field_id;

        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);

        $fileName = $result['filename']; //GETTING FILE NAME

        $imagename = Yii::app()->basePath . '/../uploads/quotationimage/' . $fileName;

        $imagename_thumb = Yii::app()->basePath . '/../uploads/quotationimage/thumbs/' . $fileName;

        Yii::import("ext.EPhpThumb.EPhpThumb");

        $thumb = new EPhpThumb();

        $thumb->init(); //this is needed
        //chain functions

        $thumb->create($imagename)->resize(120, 120)->save($imagename_thumb);

        echo $return; // it's array
    }

    public function actionPrintQuotationProfitReportPDF()
    {



        $model = new Quotes();

        $id = Yii::app()->request->getParam('id');

        $type = Yii::app()->request->getParam('type');

        $preview = Yii::app()->request->getParam('preview');

        if ($id > 0) {

            $model = new Quotes();
        }

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        if ($preview == 'Y') {//preview
            $mPDF1->SetWatermarkText('PREVIEW');

            $mPDF1->showWatermarkText = true;
        }

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_profit_report', array('model' => $model, 'id' => $id, 'title' => $title, 'title' => $title), true));

        $mPDF1->Output("Quotation.pdf", 'I');
    }

    public function actiondeleteQtnItemImage()
    {

        $id = $_POST['id'];

        $modelItem = QuotesItem::model()->findbyPK($id);

        if (!empty($modelItem)) {

            $document_details = explode(',', $modelItem->image_file_name);

            foreach ($document_details as $value) {

                $path = Yii::getPathOfAlias('webroot') . "/uploads/quotationimage/" . $value;

                unlink($path);
            }

            $modelItem->image_file_name = '';

            $modelItem->save(false);

            echo "success";
        } else {

            echo "fail";
        }
    }

    public function actionRevisionHistory()
    {

        $id = Yii::app()->request->getParam('id');

        $modelQuotesRevisionHistory = new QuotesRevisionHistory();

        $modelQuotesRevisionHistory = $modelQuotesRevisionHistory->findAll(array('condition' => 'quotes_id=' . $id));

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);

        $this->render('revision_history', array('modelQuotesRevisionHistory' => $modelQuotesRevisionHistory));
    }

    public function actionDownloadQuotationPDF()
    {

        $id = Yii::app()->request->getParam('id');

        $modelQuotesRevisionHistory = new QuotesRevisionHistory();

        $modelQuotesRevisionHistory = $modelQuotesRevisionHistory->findByPk($id);

        $file = $modelQuotesRevisionHistory->file_name;

        $path = Yii::getPathOfAlias('webroot') . "/uploads/quotationpdf/" . $file;

        header("Content-type:application/octet-stream"); //for txt file

        header("Content-Type: application/download");

        header('Content-Disposition: attachment; filename="' . basename($path) . '"');

        header('Content-Length: ' . filesize($path));

        flush(); // Flush system output buffer

        readfile($path);

        Yii::app()->end();
    }

    public function actionGetunitRate()
    {

        $product_id = (int) $_POST['product_id'];

        $unit_id = $_POST['unit'];

        $selling_price = $_POST['selling_price'];

        $customer_id = (int) $_POST['customer_id'];

        $drop = array();

        if ($product_id > 0) {

            $arr_customer_details = Customer::model()->findByPk($customer_id);
            $customer_price_group_id = $arr_customer_details->default_pricing_group_id;

            $arr_uom = UnitOfMeasurement::model()->findByPK($unit_id);

            $pricing_condition = ' pricing_group_id = ' . $customer_price_group_id . ' and product_id=' . $product_id;

            //echo $pricing_condition;

            $arr_price_list = SalesPriceGroup::model()->find(array('condition' => $pricing_condition));

            if ($product_id > 0 && $customer_id > 0) {

                $SQL_stock_ledger = 'SELECT sales_price FROM erp_stock_ledger WHERE product_id=' . $product_id . ' AND customer_vendor_id=' . $customer_id . ' AND unit_id=' . $unit_id . ' ORDER BY id DESC LIMIT 0,1';

                $customer_last_sales_price = (float) Yii::app()->db->createCommand($SQL_stock_ledger)->queryScalar();

                //echo $SQL_stock_ledger;
            }

            //if($customer_last_sales_price > $arr_price_list->sales_price){

            if ($customer_last_sales_price > 0) {

                $sales_price = (float) $customer_last_sales_price;
            } else {

                $sales_price = (float) $arr_price_list->sales_price;
            }







            $drop['factor'] = $arr_uom->factor;

            //if(!empty($arr_price_list->sales_price) && (int) $arr_price_list->sales_price > 0){

            if ((int) $sales_price > 0) {

                $drop['selling_price'] = number_format(((float) $sales_price), 2, '.', '');
            } else {

                $drop['selling_price'] = number_format(((float) $selling_price * $arr_uom->factor), 2, '.', '');
            }
        }

        echo CJSON::encode($drop);
    }

    public function SendQuotationMail($quotation_id)
    {

        $subject = "Mail Regarding Quotation";

        $view = "quotes";

        $from = 'john@mailbluesky.com';

        $to = 'jisha@mailbluesky.com';

        $content = '';

        $applicant_name = 'F M T S TECHNICAL SERVICES L.L.C';

        $salutation = 'Dear Sir';

        $mailContent = array();

        $mailContent['body'] = '

                <table cellpadding="0" cellspacing="0" align="left" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit">

                    <tbody>

                        <tr style="vertical-align: top">

                            <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">

                                <div>' . $salutation . ',</div>

                            </td>

                        </tr>

                        <tr>

                            <td height="30"></td>

                        </tr>

                        <tr style="vertical-align: top">

                            <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">

                                <strong style="font-size: 15px">Sub: ' . $subject . '</strong>

                            </td>

                        </tr>

                        <tr>

                            <td height="30"></td>

                        </tr>

                        <tr style="vertical-align: top">

                            <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">'
            . $content . '<br>

                                <br>

                                <br>

                                Thanking you,

                                <br>

                                <br>

                                Yours sincerely,

                                <br>

                                <br>

                                ' . $applicant_name . '

                            </td>

                        </tr>

                    </tbody>

                </table>';

        ////End Mail Content

        $message = new YiiMailMessage;

        $message->view = $view;

        $message->setBody(array('mailContent' => $mailContent), 'text/html');

        $message->subject = $subject;

        $message->from = $from;

        $message->addTo($to);

        //$message->addCC($custom_mail_id);

        Yii::app()->mail->send($message);
    }

    //added by abin on 05-01-2024 to calculate quotation net amount
    public function actionGetCustomerPriceDetails()
    {
        $product_id = $_POST['product_id'];
        $customer_id = $_POST['customer_id'];
        $qty = $_POST['qty'];
        $modelCustomer = new Customer();
        $arr_customer_pricing_details = $modelCustomer->findByPk($customer_id);
        $pricing_group_id = (int) $arr_customer_pricing_details->default_pricing_group_id;
        $current_date = date('Y-m-d');
        //$current_date = "2019-07-03";
        $model = new UploadPriceList();
        $arr_price_details = $model->find(array('condition' => 'product_id=' . $product_id . ' AND price_group_id=' . $pricing_group_id . ' AND (valid_from<="' . $current_date . '" AND valid_to>="' . $current_date . '") AND (' . $qty . '  BETWEEN min_sales_qty AND max_sales_qty)'));
        $price = 0;
        if (!empty($arr_price_details->sales_price)) {
            $price = $arr_price_details->sales_price;
        }
        $bonus_qty = "";
        if (!empty($arr_price_details->bonus_qty)) {
            $bonus_qty = $arr_price_details->bonus_qty;
        }



        $jsonData['price'] = number_format(floatval($price), 2, '.', '');
        $jsonData['bonus_qty'] = $bonus_qty;
        echo CJSON::encode($jsonData);
        Yii::app()->end();
    }

    public function actionAnalysis()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $this->render('analysis', array('id' => $id));
    }
    public function actionAnalysisDemo()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $this->render('analysis_demo', array('id' => $id));
    }
    public function actionSearchAnalysisProducts()
    {
        $id = (int) Yii::app()->request->getParam('quotes_id');
        $term = Yii::app()->request->getParam('term');
        if ($id > 0 && $term != "") {
            $condition = '(stock.part_number LIKE "%' . $term . '%" OR stock.description LIKE "%' . $term . '%" )  AND q.quotes_id = ' . $id;
            $query = 'SELECT stock.product_id,generic_id,stock.part_number,stock.description,bar_code,brand_id,brand,SUM(stock.quantity) AS quantity, 
         isActive,inventory_item_type,stock.rate,selling_price_1,item_type,q.quotes_id FROM erp_quotes_item as q 
         JOIN view_warehousewise_stock as stock ON q.product_id=stock.product_id WHERE ' . $condition . ' GROUP BY stock.product_id;';

            $modelStore = Yii::app()->db->createCommand($query)->queryRow();
            $result_data = "";
            if ($modelStore['quantity'] > 0) {
                $result_data .= "Available Quantity is: <b>" . $modelStore['quantity'] . "</b><br>";
                $result_data .= "Rate is: <b>" . $modelStore['rate'] . "</b><br>";
                echo $result_data;
            } else {
                echo "not";
            }
        } else
            echo "test";



    }

    public function actionAnalysisNonAvailProducts()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $this->render('analysisnonavailproducts', array('id' => 10065));
    }


    public function actionGetFilterQtnData()
    {

        $filter = Yii::app()->request->getPost('filter');
        $type = Yii::app()->request->getPost('type');
        if ($type == 'C') {
            $prefix = 'service_contract';
        } elseif ($type == 'T') {
            $prefix = 'service_trial';
        } else {
            $prefix = 'quotes';
        }
        $model = new Quotes();

        $qty = 0;
        $total = 0;
        $extra_years = [];
        $current_year = date('Y');

        // Helper function to get date range for filter and year offset
        $getDateRange = function ($filter, $yearOffset = 0) {
            $targetDate = strtotime("-{$yearOffset} year");
            $year = date('Y', $targetDate);

            switch ($filter) {
                case 'today':
                    $date = date('Y-m-d', $targetDate);
                    return [$date, $date, $year];

                case 'yesterday':
                    $date = date('Y-m-d', strtotime('-1 day', $targetDate));
                    return [$date, $date, $year];

                case 'this_month':
                    $month = date('m');
                    $start = "{$year}-{$month}-01";
                    $end = date('Y-m-t', strtotime($start));
                    return [$start, $end, $year];

                case 'this_year':
                    return ["{$year}-01-01", "{$year}-12-31", $year];

                case 'this_week':
                    $monday = date('Y-m-d', strtotime("monday this week", $targetDate));
                    $sunday = date('Y-m-d', strtotime("sunday this week", $targetDate));
                    return [$monday, $sunday, $year];

                case 'last_week':
                    $monday = date('Y-m-d', strtotime("monday last week", $targetDate));
                    $sunday = date('Y-m-d', strtotime("sunday last week", $targetDate));
                    return [$monday, $sunday, $year];

                case 'quarterly':
                    $month = date('n', $targetDate); // 1-12
                    if ($month >= 1 && $month <= 3) {
                        $start = "$year-01-01";
                        $end = "$year-03-31";
                    } elseif ($month >= 4 && $month <= 6) {
                        $start = "$year-04-01";
                        $end = "$year-06-30";
                    } elseif ($month >= 7 && $month <= 9) {
                        $start = "$year-07-01";
                        $end = "$year-09-30";
                    } else {
                        $start = "$year-10-01";
                        $end = "$year-12-31";
                    }
                    return [$start, $end, $year];

                default:
                    return [null, null, null];
            }
        };

        // Step 1: Get current period range
        list($startDate, $endDate, $current_year) = $getDateRange($filter, 0);

        if (!$startDate || !$endDate) {
            echo CJSON::encode(['status' => 'error', 'message' => 'Invalid filter']);
            Yii::app()->end();
        }

        // Step 2: Fetch current data
        $condition = 'qtn_start_date >= :startDate AND qtn_start_date <= :endDate';
        $params = [':startDate' => $startDate, ':endDate' => $endDate];

        if (!(Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["{$prefix}_view_all"])) {
            $condition .= ' AND t.lead_owner_id = :leadOwnerId';
            $params[':leadOwnerId'] = Yii::app()->user->id;
        }

        $quotes = $model->findAll($condition, $params);
        $qty = count($quotes);
        foreach ($quotes as $row) {
            $total += $row->grand_total * $row->exchange_rate;
        }

        // Step 3: Fetch previous 2 years
        for ($i = 1; $i <= 2; $i++) {
            list($prevStart, $prevEnd, $yearLabel) = $getDateRange($filter, $i);

            $conditionPrev = 'qtn_start_date >= :startDate AND qtn_start_date <= :endDate';
            $paramsPrev = [':startDate' => $prevStart, ':endDate' => $prevEnd];

            if (!(Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["{$prefix}_view_all"])) {
                $conditionPrev .= ' AND t.lead_owner_id = :leadOwnerId';
                $paramsPrev[':leadOwnerId'] = Yii::app()->user->id;
            }

            $prevQuotes = $model->findAll($conditionPrev, $paramsPrev);
            $prevQty = count($prevQuotes);
            $prevTotal = 0;

            foreach ($prevQuotes as $row) {
                $prevTotal += $row->grand_total * $row->exchange_rate;
            }

            $extra_years[] = [
                'year' => $yearLabel,
                'qty' => $prevQty,
                'total' => $prevTotal,
                'date' => in_array($filter, ['today', 'yesterday'])
                    ? date('d-m-Y', strtotime($prevStart))
                    : null,
            ];
        }

        // Final output
        echo CJSON::encode([
            'status' => 'success',
            'data' => [
                'qty' => $qty,
                'total' => $total,
                'current_period' => in_array($filter, ['today', 'yesterday'])
                    ? date('d-m-Y', strtotime($startDate))
                    : $current_year,
                'previous_years' => $extra_years,
            ]
        ]);
        Yii::app()->end();
    }


    public function actionGetServiceProducts()
    {

        $from = $_GET['frm'];

        $searchTerm = $_GET['term'];

        $payment_terms_id = (int) $_GET['payment_terms_id'];

        $customer_id = (int) $_GET['customer_id'];

        $modelCustomer = new Customer();

        $arr_customer_details = $modelCustomer->findByPk($customer_id);
        //$customer_price_group_id = $arr_customer_details->default_pricing_group_id;


        $modelSalesPriceGroupName = new SalesPriceGroupName();

        $arr_sales_price_group = $modelSalesPriceGroupName->find(array('condition' => 'default_pricing_group="Y"'));

        $condition = '(part_number LIKE "%' . $searchTerm . '%" OR bar_code LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%") and isActive="Y"  and type=2 ';

        //$model = new Store();
        //$model = $model->with('tax')->findAll(array('select' => 'id,part_number,description,unit_id,inventory_item_type,purchase_from,rate', 'condition' => $condition, 'limit' => 200));

        $limit = 50;

        $query = 'SELECT * FROM view_all_stock_items WHERE ' . $condition . ' ORDER BY part_number LIMIT ' . $limit;

        $model = Yii::app()->db->createCommand($query)->queryAll();

        $i = 0;

        $payment_term_type = '';

        if ($payment_terms_id > 0) {

            $payment_term_type = MasPaymentTerm::model()->findByPk($payment_terms_id)->payment_type;
        }

        foreach ($model as $eachModel) {



            $warehouse_id = (int) Yii::app()->user->getState('user_warehouse_id');

            $availble_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity*unit_factor),0) as availble_qty FROM `erp_stock_ledger` WHERE product_id=' . $eachModel['id'] . ' AND warehouse_id=' . (int) $warehouse_id)->queryScalar();

            $pricing_condition = 'product_id=' . $eachModel['id'];

            //code added by mereena on 19/07/2022 for   new pricing concept base on unit id

            if ((int) $arr_sales_price_group->id > 0) {

                $pricing_condition .= ' AND pricing_group_id=' . (int) $arr_sales_price_group->id;
            }



            $arr_price_list = SalesPriceGroup::model()->find(array('condition' => $pricing_condition, 'order' => 'id DESC'));

            /* if($payment_term_type=='CA'){

              $cash_credit_price = $arr_price_list->cash_price;

              }

              else{

              $cash_credit_price = $arr_price_list->credit_price;

              } */



            if ((int) $eachModel['id'] > 0 && $customer_id > 0) {

                $SQL_stock_ledger = 'SELECT sales_price FROM erp_stock_ledger WHERE product_id=' . (int) $eachModel['id'] . ' AND customer_vendor_id=' . $customer_id . ' ORDER BY id DESC LIMIT 0,1';

                $customer_last_sales_price = (float) Yii::app()->db->createCommand($SQL_stock_ledger)->queryScalar();
            }





            if ($customer_last_sales_price > $arr_price_list->sales_price) {

                $sales_price = $customer_last_sales_price;
            } else {

                $sales_price = $arr_price_list->sales_price;
            }

            //code added by mereena to avoid damaged qty

            $modelMasInventoryWarehouse = new MasInventoryWarehouse();

            $damage_warehouse_id = $modelMasInventoryWarehouse->find(array('condition' => 'warehouse_code="DAM"'))->id;

            $SQL = "SELECT SUM(quantity) AS damage_quantity FROM erp_stock_ledger WHERE product_id=" . (int) $eachModel['id'] . ' AND warehouse_id=' . $damage_warehouse_id;

            //echo $SQL;

            $total_damage_qty = (float) Yii::app()->db->createCommand($SQL)->queryScalar();

            //end





            $data[$i]['value'] = $eachModel['id'];

            //  $data[$i]['label'] = $eachModel['part_number'].' : '.$eachModel['description']." [Qty: ".Yii::app()->numberFormatter->formatCurrency(($eachModel['quantity']-$total_damage_qty),"")."]";



            $data[$i]['label'] = $eachModel['part_number'] . ' : ' . $eachModel['description'] . " [Qty: " . Yii::app()->numberFormatter->formatCurrency(($availble_qty), "") . "]";

            $data[$i]['part_number'] = $eachModel['part_number'];

            $data[$i]['description'] = $eachModel['description'];

            $data[$i]['unit_id'] = $eachModel['unit_id'];

            $data[$i]['unit_name'] = $eachModel['unit'];

            //$data[$i]['tax_code'] = $eachModel['tax;

            $data[$i]['tax_code'] = $eachModel['tax_code'];

            $data[$i]['part_no'] = $eachModel['part_number'];

            $data[$i]['other'] = $eachModel['type'];

            $data[$i]['rate'] = $eachModel['rate'];

            //$data[$i]['selling_price']=$eachModel['selling_price_1'];

            $data[$i]['selling_price'] = $sales_price;

            $data[$i]['unit_factor'] = $eachModel['second_unit_factor'];

            $data[$i]['pricing_condition'] = $pricing_condition;

            $i++;
        }

        echo CJSON::encode($data);

        Yii::app()->end();
    }

    public function actionPrintQuotationReportPDFNew()
    {
        $model = new Quotes();

        $id = Yii::app()->request->getParam('id');

        $type = Yii::app()->request->getParam('type');
        $print_type = Yii::app()->request->getParam('print_type');

        $preview = Yii::app()->request->getParam('preview');

        if ($id > 0) {

            $model = new Quotes();
            $model = Quotes::model()->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');



        $borderHeader = '
<htmlpageheader name="pageBorderHeader">
    <div style="
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        border: 5px solid red;
        box-sizing: border-box;
        z-index: -1000;
    ">
    </div>
</htmlpageheader>
 
<sethtmlpageheader name="pageBorderHeader" value="on" show-this-page="1" />
';
        $mPDF1->WriteHTML($borderHeader, \Mpdf\HTMLParserMode::HEADER_CSS);

        if ($preview == 'Y') {//preview
            $mPDF1->SetWatermarkText('PREVIEW');

            $mPDF1->showWatermarkText = true;
        }
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_list_individual_new', array('model' => $model, 'id' => $id, 'title' => $title, 'title' => $title, 'type' => $type, 'mpdf' => $mPDF1, 'print_type' => $print_type), true));

        $page_title = $id . '-Q-' . $model->customer->customer_name . '.pdf';
        $mPDF1->Output($page_title, 'I');
    }

    public function actionContractIndex()
    {
        $frm = 3;//(int) Yii::app()->request->getParam('frm');
        $type = "C";
        $prefix_menu = ($frm == 3) ? 'service' : 'sales';
        if (
            Yii::app()->user->authorised_user == 1 ||
            (
                isset(Yii::app()->user->havePermissionOn["{$prefix_menu}_menu_view"]) &&
                isset(Yii::app()->user->havePermissionOn['service_contract_view']) &&
                Yii::app()->user->havePermissionOn["{$prefix_menu}_menu_view"] &&
                Yii::app()->user->havePermissionOn['service_contract_view']
            )
        ) {
            $this->render('index', array('frm' => $frm, 'type' => $type));
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }
    public function actionTrialIndex()
    {
        $frm = 3;//(int) Yii::app()->request->getParam('frm');
        $type = "T";

        if (
            Yii::app()->user->authorised_user == 1 ||
            (
                isset(Yii::app()->user->havePermissionOn['service_menu_view']) &&
                isset(Yii::app()->user->havePermissionOn['service_trial_view']) &&
                Yii::app()->user->havePermissionOn['service_menu_view'] &&
                Yii::app()->user->havePermissionOn['service_trial_view']
            )
        ) {
            $this->render('index', array('frm' => $frm, 'type' => $type));
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }



    public function actionCreateYearly()
    {
        $type = (int) Yii::app()->request->getParam('type');
        $id = (int) Yii::app()->request->getParam('id');

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);

        $this->render('create_yearly_print', array('id' => $id, 'type' => $type));

    }



    public function actionPrintQuotationYearlyReportPDF()
    {



        $model = new Quotes();

        $id = Yii::app()->request->getParam('id');

        $type = Yii::app()->request->getParam('type');

        $year = Yii::app()->request->getParam('year');

        $preview = Yii::app()->request->getParam('preview');


        if ($id > 0) {

            $model = $model->findByPk($id);

        }

        /*if($type=='1'){

            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4-L'); 

        }else{*/

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        //}





        if ($preview == 'Y') {//preview

            $mPDF1->SetWatermarkText('PREVIEW');

            $mPDF1->showWatermarkText = true;

        }

        // $mPDF1->SetWatermarkImage('images/watermark.jpg');
        $mPDF1->SetWatermarkImage('images/watermark.jpg', 0.10);// 10% opacity
        $mPDF1->showWatermarkImage = true;
        //$mPDF1->curlAllowUnsafeSslRequests = true;
//$mPDF1->showImageErrors = true;



        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        if ($type == 3 || $type == 4)

            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_list_individual_without_part_no', array('model' => $model, 'id' => $id, 'title' => $title, 'title' => $title, 'type' => $type, 'mpdf' => $mPDF1), true));
        else if ($type == 5)

            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_technical_offer', array('model' => $model, 'id' => $id, 'title' => $title, 'title' => $title, 'type' => $type, 'mpdf' => $mPDF1), true));
        else {

            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_list_individual_yearly', array('model' => $model, 'id' => $id, 'title' => $title, 'title' => $title, 'type' => $type, 'year' => $year, 'mpdf' => $mPDF1), true));
        }
        $mPDF1->Output($model->customer->customer_name . "_" . $id . "_" . "quotation.pdf", 'I');

    }



    public function actionPrintQuotationReportPDFMonthly()
    {
        $model = new Quotes();
        $id = Yii::app()->request->getParam('id');
        $type = Yii::app()->request->getParam('type');
        $preview = Yii::app()->request->getParam('preview');

        if ($id > 0) {
            $model = $model->findByPk($id);
        }

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        if ($preview == 'Y') {//preview
            $mPDF1->SetWatermarkText('PREVIEW');
            $mPDF1->showWatermarkText = true;
        }
        $mPDF1->SetWatermarkImage('images/watermark.jpg', 0.10);// 10% opacity
        $mPDF1->showWatermarkImage = true;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);
        if ($type == 3 || $type == 4)
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_list_individual_without_part_no', array('model' => $model, 'id' => $id, 'title' => $title, 'title' => $title, 'type' => $type, 'mpdf' => $mPDF1), true));
        else if ($type == 5)
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_technical_offer', array('model' => $model, 'id' => $id, 'title' => $title, 'title' => $title, 'type' => $type, 'mpdf' => $mPDF1), true));
        else
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.quotation_list_individual_monthly', array('model' => $model, 'id' => $id, 'title' => $title, 'title' => $title, 'type' => $type, 'mpdf' => $mPDF1), true));
        $mPDF1->Output($model->customer->customer_name . "_" . $id . "_" . "quotation.pdf", 'I');

    }

    public function actionApproveLevel()
    {
        $model = new Quotes();
        $id = (int) Yii::app()->request->getParam('id');
        $level = (int) Yii::app()->request->getParam('level');
        $modelQuoteItems = array(new QuotesItem);
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model->import_code = $model->customer->customer_shj_imp_code;
            $condition = 'quotes_id="' . $id . '"'; //To fetch all
            $modelQuoteItems = QuotesItem::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));
            if (empty($modelQuoteItems)) {
                $modelQuoteItems = array(new QuotesItem);
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('approvelevel', array(
            'model' => $model,
            'modelQuoteItems' => $modelQuoteItems,
            'level' => $level
        ));
    }
}
