<?php

class PurchaseInvoiceController extends Controller
{

    public $layout = 'layout';

    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'GetVendors',
                    'GetInvoiceList',
                    'Create',
                    'PurchasedFiles',
                    'GetPurchasingInvoiceDetails',
                    'Saveinvoice',
                    'GetReceiptsDetails',
                    'PrintInvoiceReportPDF',
                    'PrintInvoiceSerialNoReportPDF',
                    'AddLandedCost',
                    'SaveLandedCost',
                    'PurchasedInvoices',
                    'getPurchaseInvoiceDetails',
                    'CalculateLandingCost',
                    'CalculateLandingCostInvoice',
                    'GetAllServices',
                    'CalculateLandingCostInvoices',
                    'EditInvoice',
                    'Updateinvoice',
                    'UploadDocuments',
                    'editCost',
                    'saveedittedCost',
                    'UploadPurchaseDocuments',
                    // ------------------------start---landing cost----------------------------------------------------- 
                    'Directinvoice',
                    'SaveDirectinvoice',
                    'ViewLandingCost',
                    'getunitdrop',
                    'ViewCalculateLCInvoice',
                    'CalculateLcPurchaseInvoice',
                    'LockInvoice',
                    'UnLockInvoice',
                    'saveLockPurchase',
                    'saveUnlockPurchase'
                    // ------------------------End---landing cost-----------------------------------------------------

                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters()
    {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndex()
    {
        if (
            Yii::app()->user->authorised_user == 1 ||
            (
                isset(Yii::app()->user->havePermissionOn['purchase_menu_view']) &&
                isset(Yii::app()->user->havePermissionOn['purchase_invoice_view']) &&
                Yii::app()->user->havePermissionOn['purchase_menu_view'] &&
                Yii::app()->user->havePermissionOn['purchase_invoice_view']
            )
        ) {
            $this->render('index');
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }

    public function actionGetInvoiceList()
    {
        $model = new PurchasingInvoice();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $invoice_type = $_POST['invoice_type'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.invoice_no',
            1 => 't.po_id',
            2 => 't.id',
            3 => 't.materialreceived',
            4 => 'vendor_details.vendor_name',
            5 => 't.invoice_date',
            6 => 't.grand_total',
            7 => 't.file_id',
            8 => 't.currency_id',
            9 => 'file.current_process_status',
            10 => ''
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';

        if (!empty($invoice_type)) {
            $condition .= ' AND t.purchase_invoice="' . $invoice_type . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            //materialreceived
            $condition .= " AND ( t.invoice_no LIKE '%" . $searchString . "%' OR vendor_details.vendor_name LIKE '%" . $searchString . "%' OR  t.materialreceived LIKE '%" . $searchString . "%' OR  t.file_id LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' OR awb_no LIKE '%" . $searchString . "%' OR t.po_id LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('file', 'vendor_details')->count(array('condition' => $condition));
        $model = $model->with('file', 'vendor_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $status = '';
        foreach ($model as $row) {
            switch ($row['file']['current_process_status']) {
                case 'P_I':
                    $status = 'PI';
                    break;
                case 'M_R':
                    $status = 'MR';
                    break;
                case 'Q_C':
                    $status = 'QC';
                    break;
            }
            if ($row['is_direct_invoice'] == 'Y') {
                //Code commented by mereena on 28/02/2020
                //$row['file_id'] = '##DP';
                $row['po_id'] = '##DP';
                //$row['invoice_no'] = '##DP';
                //end
                $row['materialreceived'] = '##DP';
            }

            //            $div = '';
            //            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["purchase_invoice_pdf"])) {
            //                $div .= '<a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=purchaseinvoice/PrintInvoiceReportPDF&id=' . $row['id'] . '&c_id=' . $row['crm_user_id'] . '"><i class="fa fa-file-pdf-o"></i></a>';
            //            }
            $debitnote = Purchasingdebitnote::model()->find(array('condition' => 'purchasing_invoice_id =' . $row['id']));
            ($debitnote->id > 0) ? $dn_status = 'Yes' : $dn_status = 'No';
            $service_invoice = 'N';
            if ($row['purchase_invoice'] == 'LC' && !empty($row['purchase_invoice_id'])) {
                $service_invoice = 'Y';
            }
            $have_landing_cost = 'N';
            $check_landing_cost = PurchasingInvoice::model()->find(array('condition' => 'purchase_invoice_id like "' . $row['id'] . '" OR purchase_invoice_id like "' . $row['id'] . ',%" OR purchase_invoice_id like "%,' . $row['id'] . ',%" OR purchase_invoice_id like "%,' . $row['id'] . '"'));
            if (!empty($check_landing_cost)) {
                $have_landing_cost = 'Y';
            }
            $billytpe = ($row['purchase_invoice'] == "LC") ? "LC Bills" : "Purchase Invoice";
            $rowData[] = array(
                $row['po_id'], //0
                $row['id'], //1
                $row['materialreceived'], //2
                 date("d/m/Y", strtotime($row['invoice_date'])), //3
                $row['vendor_details']['vendor_name'], //4
                 $billytpe, //5
                $row->currencyname->currency_code, //6
                '<div class="text-right">' . Yii::app()->numberFormatter->formatCurrency($row['grand_total'], "") . '</div>', //7
                $row->file_id, //8
                $status, //9
                $dn_status, //10
                $row['crmUser']['first_name'] . ' ' . $row['crmUser']['last_name'], //11
                $row['is_direct_invoice'], //12
                $row['crm_user_id'], //13
                $row['posted'], //14
                $row['invoice_no'], //15
                $row['purchase_invoice'], //16
                $row['lc_calulation'], //17
                $row['lock_status'], //18
                $have_landing_cost, //19
            );
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate()
    {
        $model = new PurchasingInvoice();
        $id = (int) Yii::app()->request->getParam('id');
        $mr_id = (int) Yii::app()->request->getParam('mr_id');

        $file_id = (int) Yii::app()->request->getParam('file_id');

        $modelItems = array(new PurchasingInvoiceItem);
        $modelNotes = new FileNotes();
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelmasterfile = MasterFile::model()->findByPk($file_id);
            $modelItems = PurchasingInvoiceItem::model()->findAll(array('condition' => 'purchasing_invoice_id="' . $id . '"'));
            if (empty($modelItems)) {
                $modelItems = array(new PurchasingInvoiceItem);
            }
        }
        if ($file_id > 0) {
            $model->file_id = $file_id;
            $modOrder = PurchasingOrder::model()->find(array('condition' => 'file_id =' . $file_id));
            $model->vendor_id = $modOrder->vendor_id;
            $model->vendor_name = $modOrder->vendor_details->vendor_name;
            $model->po_id = $modOrder->id;
            $model->project_id = $modOrder->project_det->project_name . ' - ' . $modOrder->project_ids;
            //$model->purchased_file_search = $modOrder->id;

            $model->payment_terms = $modOrder->payment_terms;

            if ((int) $model->payment_terms > 0) {
                $arr_payment_term = MasPaymentTerm::model()->findByPK((int) $model->payment_terms);

                $payment_days = (int) $arr_payment_term->no_of_days;

                if ($payment_days > 0) {
                    $current_date = date('Y-m-d');
                    $current_date = new DateTime();
                    $current_date = $current_date->modify('+' . $payment_days . ' day');
                    $payment_date = $current_date->format('d/m/Y');

                    $model->payment_date = $payment_date;
                } else {
                    $model->payment_date = date('d/m/Y');
                }
            }
            $model->currency = $modOrder->currency;
            $model->exchange_rate = $modOrder->exchange_rate;
            $model->project_classification_id = $modOrder->project_classification_id;
            $model->contract_id = $modOrder->contract_id;
            $model->notes = $modOrder->start_text;
            $model->invoice_type = $modOrder->invoice_type;
            $model->terms_and_conditions = $modOrder->terms_and_conditions;
            if ((int)$mr_id > 0) {
                $modelPurchasingMaterialreceipt          = new PurchasingMaterialreceipt();
                $modelPurchasingMaterialreceipt = $modelPurchasingMaterialreceipt->findByPk($mr_id);
                $model->ticket_id = $modelPurchasingMaterialreceipt->ticket_id;
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array(
            'model' => $model,
            'file_id' => $file_id,
            'modelInvoiceItems' => $modelItems,
            'modelAdd' => $modelAdd,
            'modelNotes' => $modelNotes,
            'modelDed' => $modelDed,
            'modelmasterfile' => $modelmasterfile
        ));
    }

    public function actionGetVendors()
    {
        $data_array = array();
        if (isset($_GET['term'])) {
            $condition = 'isActive =  "Y" AND (vendor_name like "%' . $_GET['term'] . '%")';
            $model = Vendor::model()->findAll(array('condition' => $condition));
            $i = 0;
            foreach ($model as $eachModel) {
                $mr_model = PurchasingOrder::model()->findAll(array('condition' => 'vendor_id =' . $eachModel->id));
                $data_array[$i]['value'] = $eachModel->id;
                $data_array[$i]['label'] = $eachModel->vendor_name;
                $data_array[$i]['tble'] = '';
                foreach ($mr_model as $j => $rowModel) {
                    $slno = $j + 1;
                    if ($rowModel->order_date != '') {
                        $rowModel->order_date = date('d/m/y', strtotime($rowModel->order_date));
                    }
                    $data_array[$i]['tble'] .= '<tr>
                        <td>' . $slno . '</td>
                        <td>' . $rowModel->id . '</td>
                        <td>' . $rowModel->vendor_details->vendor_name . '</td>
                        <td>' . $rowModel->order_date . '</td>
                        <td><button title="Convert to Invoice" class="btn btn-primary btn-xs convert" type="button" onclick=fill_invoice(' . $rowModel->file_id . ');><i class="fa fa-retweet"  aria-hidden="true"></i></button></td>
                    </tr>';
                }
                $i++;
            }
            echo CJSON::encode($data_array);
            Yii::app()->end();
        }
    }

    public function actionPurchasedFiles()
    {
        $data_array = array();
        if (isset($_GET['term'])) {
            $condition = 'isActive="Y" AND current_process_status in ("M_R","Q_C","P_I") AND (t.id like "%' . $_GET['term'] . '%" OR purchaseorder.id like "%' . $_GET['term'] . '%")';
            $model = MasterFile::model()->with('purchaseorder')->findAll(array('condition' => $condition, 'order' => 't.id DESC'));
            $i = 0;
            foreach ($model as $eachModel) {
                $data_array[$i]['value'] = $eachModel->id;
                $data_array[$i]['label'] = $eachModel->id . ':' . $eachModel->purchaseorder->id;
                $i++;
            }
        }
        echo CJSON::encode($data_array);
        Yii::app()->end();
    }

    public function actionGetPurchasingInvoiceDetails($file_id = 0)
    {

        $invoice = PurchasingInvoice::model()->findByPK((int) $_POST['model_id']);
        if (isset($_POST['byvendor'])) {
            Yii::app()->session['file_id'] = $file_id == 0 ? $invoice->file_id : $file_id;
        } else {
            Yii::app()->session['file_id'] = $file_id == 0 ? (int) $_POST['file_id'] : $file_id;
        }

        if (isset($_POST['needed_model'])) {
            $masterFile = MasterFile::model()->findByPK(Yii::app()->session['file_id']);
            $jsonData['file'] = $masterFile;
            if (isset($_POST['model_id'])) {
                $jsonData[$_POST['needed_model']] = PurchaseInvoice::model()->findByPK((int) $_POST['model_id']);
            } else {
                $jsonData[$_POST['needed_model']] = $masterFile->{$_POST['needed_model']};
            }

            $jsonData['vendor'] = Vendor::model()->findByPK($jsonData[$_POST['needed_model']]->vendor_id);
            if (in_array($_POST['needed_model'], array("purchaseorder"))) {


                // $modelPurchasingOrder = new PurchasingOrder();
                //  $modelPurchasingOrder = $modelPurchasingOrder->findByPk((int) $rowModel->po_id);

                $jsonData['currency'] = MasCurrency::model()->findByPK($jsonData[$_POST['needed_model']]->currency);
                //$jsonData['paymentterms'] = MasPaymentTerm::model()->findByPK($jsonData[$_POST['needed_model']]->payment_terms); 
                //$jsonData['paymentterms'] = MasPaymentTerm::model()->findByPK($jsonData[$_POST['needed_model']]->payment_terms);


                //$mr_model = PurchasingMaterialreceipt::model()->findAll(array('condition' => 'is_convertable = "Y" AND file_id =' . Yii::app()->session['file_id']));
                $mr_model = PurchasingMaterialreceipt::model()->findAll(array('condition' => 'is_convertable = "Y" AND qcchecked="Y" AND file_id =' . Yii::app()->session['file_id']));
                $jsonData['tble'] = '';
                foreach ($mr_model as $j => $rowModel) {
                    $slno = $j + 1;
                    if ($rowModel->mrv_receipt_date != '') {
                        $rowModel->mrv_receipt_date = date('d/m/y', strtotime($rowModel->mrv_receipt_date));
                    }
                    $jsonData['tble'] .= '<tr>
                        <td>' . $slno . '</td>
                        <td>' . $rowModel->file_id . '</td>
                        <td>' . $rowModel->po_id . '</td>
                        <td>' . $rowModel->id . '</td>
                        <td>' . $rowModel->mrv_receipt_date . '</td>
                        <td>' . $rowModel->vendor_details->vendor_name . '</td>
                        <td class="mr_ids_checkbox text-center"><input type="checkbox" value="' . $rowModel->id . '" name="materialreceiptfileId[]" id="materialreceiptfileId_' . $j . '" class="check_each" onclick="loadMrvsForInvoice()"></td>
                    </tr>';
                }
            }
            if (in_array($_POST['needed_model'], array("purchaseinvoice"))) {
                $criteria = new CDbCriteria();
                $criteria->addInCondition("purchasing_materialreceipt_id", explode(',', $jsonData[$_POST['needed_model']]->materialreceived));
                $criteria->order = "id ASC";
                $items = PurchasingMaterialreceiptItem::model()->findAll($criteria);
                $jsonData['model_items'] = '';
                foreach ($items as $i => $model) {
                    $temp = new PurchasingcreditItem;
                    $temp->attributes = $model->attributes;
                    $temp->purchased_quantity = $model->qcchecked_quantity;
                    $temp->description = $model->description;
                    $model = $temp;
                    $product = Store::model()->findByPk($model->product_id);

                    $jsonData['model_items'] .= '
            <tr>
            <td><label>' . ($i + 1) . CHtml::activeHiddenField($model, "[$i]order_item_id") . '</label></td>
            <td>' . CHtml::activeTextField($model, "[$i]purchasing_materialreceipt_id", array('readonly' => true, 'value' => $model->purchasing_materialreceipt_id)) . '</td>
            <td>' . CHtml::activeTextField($model, "[$i]product_name", array('class' => 'description', 'readonly' => true, 'value' => $product->part_number)) . CHtml::activeHiddenField($model, "[$i]product_id") . '</td>
            <td>' . CHtml::activeTextField($model, "[$i]description", array('class' => 'description', 'readonly' => true, 'value' => $model->description)) . '</td>
            <td>' . CHtml::activeTextField($model, "[$i]warehouse_name", array('readonly' => true, 'value' => $model->warehousename->name)) .
                        CHtml::activeHiddenField($model, "[$i]warehouse", array('readonly' => true, 'value' => $model->warehouse)) . '</td>
            <td>' . CHtml::activeTextField($model, "[$i]purchased_quantity", array('class' => 'cell-center', 'value' => preg_replace('/\s\d+\.00/', '', floatval($model->purchased_quantity)), 'readonly' => true)) . '</td>
            <td>' . CHtml::activeTextField($model, "[$i]returned_quantity", array('class' => 'cell-center', 'class' => 'cell-center', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculatecrediteamount($("#purchasingcredit_item_table"));')) . '</td>
           <td>' . CHtml::activeTextField($model, "[$i]rate", array('class' => 'cell-right to_be_calculated', 'value' => $product->rate, 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculatecrediteamount($("#purchasingcredit_item_table"));')) . '</td>
            <td>' . CHtml::activeTextField($model, "[$i]net_amount", array('class' => 'cell-right', 'onkeypress' => 'return isNumberKey(event)', 'readonly' => true)) . '</td>
            <td>' . CHtml::link('<i class="icon-remove"></i>', 'javascript:void(0);', array('onclick' => 'removeTableRow($("#purchasingcredit_item_table"), this);')) . '</td>
            </tr>';
                }
            }
            echo CJSON::encode($jsonData);
        }
    }

    public function actionGetReceiptsDetails()
    {
        $company_id = (int) Yii::app()->user->master_user_company_id;

        $modelMasCompany = new MasCompany();
        
        $arr_mas_company_details = $modelMasCompany->findByPk($company_id);
        $no_of_decimals = $arr_mas_company_details->no_of_decimals;

        if (is_array($_POST['mrv_no'])) {
            foreach ($_POST['mrv_no'] as $eachDNote) {
                $mrv_nos[] = $eachDNote['value'];
            }
        }
        if (is_array($mrv_nos)) {
            $selected_mrv_nos = implode(',', $mrv_nos);
        }

        $purchaseorder = PurchasingOrder::model()->with('items')->find(array('condition' => 'file_id=' . (int) $_POST['file_id'], 'order' => 'items.id ASC'));
        $modelPurchasingOrderItems = PurchasingOrderStockItem::model()->with('purchaseorder')->findAll(
            array('condition' => 'purchaseorder.file_id=' . (int) $_POST['file_id'], 'order' => 't.id ASC')
        );

        $jsonData = array();
        $jsonData['materialreceipts'] = $selected_mrv_nos;
        if (!empty($mrv_nos)) {
            $model_mrv = PurchasingMaterialreceipt::model()->findByPk(end($mrv_nos));
        }
        $jsonData['lastmaterialreceipts'] = $model_mrv;

        $total = 0; // <th style="width:12%">Additions</th>
        $tax_amt = 0;
        $jsonData['model_items'] = '<tr>
        <th style="width:1%">#</th>
        <th style="width:20%">Item</th>
        <th style="width:30%">Description</th>
        <th style="width:5%">Qty</th>
        <th style="width:2%">Unit</th>
        <th style="width:5%">Rate</th>
        <th style="width:5%">Tax(%)</th>
        <th style="width:5%">Amount</th>
        <th class="bg-danger" style="width:12%">Discount</th>
        <th style="width:5%">Net</th>
        <!--th style="width:5%">FOC</th-->
    </tr>';

        $i = 0;

        $model_settings = MasCompanySettings::model()->find();

        $purchase_invoice = $_POST['purchase_invc'];
        if ($purchase_invoice == "MR") {
            $qty_to_be = 'received_quantity';
        } else {
            $qty_to_be = 'qc_checked_quantity';
        }
        $arr_product_id = array();
        foreach ($modelPurchasingOrderItems as $j => $eachItem) {

            $model = new PurchasingInvoiceItem;
            $model_mrv_item = PurchasingMaterialreceiptItem::model()->findAll(array('condition' => 'purchasing_materialreceipt_id IN (' . $selected_mrv_nos . ') AND product_id=' . $eachItem->stock_item_id));
            //echo '<pre>';
            //print_r($model_mrv_item);

            foreach ($model_mrv_item as $model_mrv_item) {


                $model->attributes = $eachItem->attributes;
                $model->order_item_id = $eachItem->id;
                $model->product_id = $eachItem->stock_item_id;
                $model->product_name = $eachItem->stock_item_name;
                $model->description = $eachItem->stock_item_description;
                $model->unit = $eachItem->stock_item_unit;
                $model->rate = $eachItem->stock_item_rate;
                //$model->quantity = $eachItem->stock_item_quantity;

                $model->quantity = $model_mrv_item->received_quantity;
                //$model->warehouse = $model_mrv_item->warehouse;
                /*        if (!in_array($eachItem->stock_item_id, $arr_product_id)) {
                  $arr_product_id[] = $eachItem->stock_item_id;
                  //code added by mereena on 07/04/2020
                  if($eachItem->product->inventory_item_type==2){
                  $model->quantity = $eachItem->stock_item_quantity;
                  }
                  else{

                  $con = 'select SUM(`' . $qty_to_be . '`) as `quantity`, AVG(rate) AS rate
                  from {{purchasing_material_receipt_item}}
                  where product_id=' . $eachItem->stock_item_id . ' AND purchasing_materialreceipt_id in (' . $selected_mrv_nos . ')';
                  $itemDetails = PurchasingMaterialreceiptItem::model()->findBySql($con, array());
                  $model->quantity = $itemDetails->quantity;
                  $eachItem->stock_item_rate = $itemDetails->rate;
                  $model->rate = $itemDetails->rate;
                  }
                  //end
                  } else {
                  $model->quantity = 0;
                  } */

                $model->quantity = $model->quantity > 0 ? $model->quantity : 0;
                if ($model->quantity > 0) {

                    $model->amount = number_format($model->rate * $model->quantity, 2, '.', '');
                    $model->net_amount = $model->amount;
                    $total += $model->net_amount;

                    $model_1 = "PurchasingInvoiceItem";
                    //$tax_percentage=5;
                    //$tax_amount=0;

                    $tax_percentage = $model->product->tax->percentage;
                    $tax_amount = ($model->net_amount * $tax_percentage) / 100;
                    $actualtax_percentage = $tax_percentage;
                    $inv_type = $_POST['inv_type'];
                    if (empty($inv_type)) {
                        $inv_type = $eachItem->purchaseorder->invoice_type;
                    }
                    $modelInvoiceType = new MasInvoiceType();
                    $modelInvoiceType = $modelInvoiceType->findByPk($inv_type);
                    $tax_type = $modelInvoiceType->tax;
                    if ($tax_type == "Y") {
                        $tax_amt += $tax_amount;
                    } else {
                        $tax_percentage = 0;
                        $tax_amount = 0;
                    }

                    $model->quantity = preg_replace('/\s\d+\.00/', '', floatval($model->quantity));
                    //code added by mereena on 07/04/2020
                    if (!empty($model->product->oem_number)) {
                        $product_name = $model->product->oem_number;
                    } else {
                        $product_name = $model->product->part_number;
                    }
                    //end
                    $jsonData['model_items'] .= '
        <tr>
        <td><label>' . ($i + 1) . '</label></td>
        <td class="cell-left">' . CHtml::textField('PurchasingInvoiceItem[' . $i . '][product_name]', $product_name, array('class' => 'tooltipster go des', 'readonly' => 'true')) .
                        CHtml::hiddenField('PurchasingInvoiceItem[' . $i . '][mr_id]', $model_mrv_item->purchasing_materialreceipt_id, array('class' => 'tooltipster go des', 'readonly' => 'true')) .
                        CHtml::hiddenField('PurchasingInvoiceItem[' . $i . '][mr_item_id]', $model_mrv_item->id, array('class' => 'tooltipster go des', 'readonly' => 'true')) .
                        CHtml::activehiddenField($model, "[$i]product_id") . CHtml::activehiddenField($model, "[$i]warehouse") . CHtml::activehiddenField($model, "[$i]order_item_id") . CHtml::hiddenField('PurchasingInvoiceItem[' . $i . '][tax_amount]', $tax_amount) . '</td>
        <td class="cell-left">' . $eachItem->stock_item_description . CHtml::activeHiddenField($model, "[$i]description", array('class' => 'tooltipster desc desc2 go', 'readonly' => 'true', 'value' => $eachItem->stock_item_description)) . '</td>
        <td class="text-right">' . number_format($model->quantity, $no_of_decimals, '.', '') . CHtml::activeHiddenField($model, "[$i]quantity", array('class' => 'qty go cell-center text-right', 'readonly' => 'true')) . '</td>
        <td class="cell-left">' . $eachItem->unitdetails->name . CHtml::activeHiddenField($model, "[$i]unit", array('readonly' => true, 'value' => $eachItem->stock_item_unit)) . '</td>
        <td>' . CHtml::textField('PurchasingInvoiceItem[' . $i . '][rate]', number_format($eachItem->stock_item_rate, $no_of_decimals, '.', ''), array(
                            'class' => 'rate go text-right to_be_calculated',
                            'onkeypress' => 'return isNumberKey(event)',
                            'onkeyup' => 'calculateTableValues($("#purchasingInvoice_item_table"),this.id);',
                            'readonly' => true
                        )) .
                        CHtml::error($model, "[$i]rate") . '</td>


        <td>' . CHtml::textField('PurchasingInvoiceItem[' . $i . '][tax_percentage]', number_format($tax_percentage, $no_of_decimals, '.', ''), array('class' => 'go unit text-right', 'readonly' => 'true')) .
                        CHtml::hiddenField('PurchasingInvoiceItem[' . $i . '][actual_tax_amount]', $tax_amount, array('class' => 'go unit ', 'readonly' => 'true')) .
                        CHtml::hiddenField('PurchasingInvoiceItem[' . $i . '][actual_tax_percentage]', number_format($actualtax_percentage, $no_of_decimals, '.', ''), array('class' => 'go unit', 'readonly' => 'true')) . '</td>



        <td>' . CHtml::textField('PurchasingInvoiceItem[' . $i . '][amount]', number_format($model->amount, $no_of_decimals, '.', ''), array(
                            'class' => 'amt go text-right amount-field text-right',
                            'onkeypress' => 'return isNumberKey(event)',
                            'readonly' => true
                        )) .
                        CHtml::error($model, "[$i]amount") . '</td>'
                        . '<td class="bg-danger">' . CHtml::hiddenfield('PurchasingInvoiceItem[' . $i . '][addition_percentage]', '', array(
                            'class' => 'txt-6 go text-right',
                            'onkeypress' => 'return isNumberKey(event)',
                            'value' => $addition,
                            'onkeyup' => 'calculateTableValues($("#purchasingInvoice_item_table"),this.id);'
                        )) .
                        CHtml::error($model, "[$i]addition_percentage")
                        . ' ' . CHtml::hiddenfield('PurchasingInvoiceItem[' . $i . '][addition_amount]', '', array('class' => 'txt-6 go text-right additions', 'readonly' => true)) .
                        CHtml::error($model, "[$i]addition_amount")
                        . CHtml::textField('PurchasingInvoiceItem[' . $i . '][deduction_percentage]', '', array(
                            'class' => 'txt-6 go text-right',
                            'onkeypress' => 'return isNumberKey(event)',
                            'onkeyup' => 'calculateTableValues($("#purchasingInvoice_item_table"),this.id);'
                        )) .
                        CHtml::error($model, "[$i]deduction_percentage")
                        . ' ' . CHtml::textField('PurchasingInvoiceItem[' . $i . '][deduction_amount]', '', array('class' => 'txt-6 go text-right deductions', 'readonly' => true)) .
                        CHtml::error($model, "[$i]deduction_amount") . '</td>
        <td>' . CHtml::textField('PurchasingInvoiceItem[' . $i . '][net_amount]', number_format($model->net_amount, $no_of_decimals, '.', ''), array('class' => 'cell-right amt go text-right', 'readonly' => true, 'onkeyup' => 'calculateTableValues($("#purchasingInvoice_item_table"),this.id);')) .
                        CHtml::error($model, "[$i]net_amount") . '</td>
                ';
                    /* if($eachItem->product->inventory_item_type==1){
                      $jsonData['model_items'] .= CHtml::checkBox('PurchasingInvoiceItem[' . $i . '][foc_checked]', '', array('class' => 'cell-right amt go'));
                      } */
                    $jsonData['model_items'] .= '
                        </tr>';
                    $jsonData['total'] += $model->net_amount;
                    $i++;
                }
            }
        }

        $total = number_format($total, 2, '.', '');
        $tax_amt = number_format($tax_amt, 2, '.', '');
        $jsonData['total'] = '<tr class="bg-total">
        <td colspan="7" class="text-right table_total_title" width="70%"><h2>Total</h2></td>
        <td colspan="4" class="cell-right table_total text-right"><h2 class="total  cell-right" width="30%">' . $total . '</h2></td>
    </tr>';

        $jsonData['stock_ledger'] = '';
        $sl_row = 0;
        foreach ($mrv_nos as $eachDNote) {

            $mr_id = $eachDNote;
            $modelMRItems = PurchasingMaterialreceiptItem::model()->findAll(array('condition' => 'purchasing_materialreceipt_id=' . $mr_id));
            if (!empty($modelMRItems)) {

                foreach ($modelMRItems as $z => $modelMRItems) {
                    $mr_item_id = $modelMRItems->id;
                    $modelStockLedger = StockLedger::model()->findAll(array('condition' => 'header_id=' . $mr_id . ' AND header_item_id=' . $mr_item_id . ' AND transaction_from="QUALITY_CHECK"'));
                    if (!empty($modelStockLedger)) {
                        foreach ($modelStockLedger as $y => $modelStockLedger) {
                            $jsonData['stock_ledger'] .= '
                                <tr>
                                <td class="cell-left">' . CHtml::hiddenField('StockLedger[' . $sl_row . '][header_id]', $mr_id, array('class' => 'tooltipster go des', 'readonly' => 'true')) . '</td>
                                                        <td class="cell-left">' . CHtml::hiddenField('StockLedger[' . $sl_row . '][header_item_id]', $mr_item_id, array('class' => 'tooltipster go des', 'readonly' => 'true')) . '</td>
                                                        <td class="cell-left">' . CHtml::hiddenField('StockLedger[' . $sl_row . '][product_id]', $modelStockLedger->product_id, array('class' => 'tooltipster go des', 'readonly' => 'true')) . '</td>
                                                        <td class="cell-left">' . CHtml::hiddenField('StockLedger[' . $sl_row . '][quantity]', $modelStockLedger->quantity, array('class' => 'tooltipster go des', 'readonly' => 'true')) . '</td>
                                                        <td class="cell-left">' . CHtml::hiddenField('StockLedger[' . $sl_row . '][id]', $modelStockLedger->id, array('class' => 'tooltipster go des', 'readonly' => 'true')) . '</td>
                                                        <td class="cell-left">' . CHtml::hiddenField('StockLedger[' . $sl_row . '][warehouse_id]', $modelStockLedger->warehouse_id, array('class' => 'tooltipster go des', 'readonly' => 'true')) . '</td>
                                                        <td class="cell-left">' . CHtml::hiddenField('StockLedger[' . $sl_row . '][rack_id]', $modelStockLedger->rack_id, array('class' => 'tooltipster go des', 'readonly' => 'true')) . '</td>
                                                        <td class="cell-left">' . CHtml::hiddenField('StockLedger[' . $sl_row . '][bin_id]', $modelStockLedger->bin_id, array('class' => 'tooltipster go des', 'readonly' => 'true')) . '</td>
                                </tr>';

                            $sl_row++;
                        }
                    }
                }
            }
        }

        $addition = 0;

        $deduction = 0;
        $jsonData['addition'] = '';
        // echo '<pre>';print_r($purchaseorder->netTotal);exit;
        if ($purchaseorder->netTotal) {
            $productpercentage = ($purchaseorder->netTotal > 0) ? ($total / $purchaseorder->netTotal) : 0;
        }

        $jsonData['productpercentage'] = $productpercentage;
        if ($purchaseorder->netTotal) {
            $jsonData['ordernetTotal'] = $purchaseorder->netTotal;
        }
        $modelAddition = new PurchasingInvoiceAddition;
        /* if (!empty($purchaseorder->adItems)) {

          foreach ($purchaseorder->adItems as $i => $eachAddition) {
          $rounded_addition = round(($productpercentage * $eachAddition->calculated_value), 2);
          $eachAddition->calculated_value = number_format($rounded_addition, 2, '.', '');
          $eachAddition->particular_value = number_format($rounded_addition, 2, '.', '');
          $addition += $eachAddition->calculated_value;
          $jsonData['addition'] .= '<tr><td class="text-right td-in-6">Additions<span>' .
          CHtml::link('<i class="fa fa-plus"></i>', 'javascript:void(0);', array('onclick' => 'addTableRow($(\'#purchasingInvoice_final_add_table\'))', 'class' => 'btn btn-sm btn-theme ')) . ' ' .
          '</span></td>
          <td>' .
          CHtml::activedropDownList($modelAddition, "[$i]particular", MasFooterItems::getPurchaseAdditions(), array('prompt' => 'Select', 'options' => array($eachAddition->particular => array('selected' => true)), 'placeholder' => 'Particulars', 'class' => 'paricular go', 'style' => 'float: none;width: 150px;')) . '</td><td> ' .
          CHtml::activeTextField($modelAddition, "[$i]particular_value", array('value' => $eachAddition->particular_value,
          'onkeyup' => 'calculateTableValues($(\'#purchasingInvoice_item_table\'),this.id);', 'onkeypress' => 'return isNumberKey(event)', 'class' => 'value_rate go text-right', 'placeholder' => 'value')) . ' </td><td>' .
          CHtml::activeTextField($modelAddition, "[$i]calculated_value", array('value' => $eachAddition->calculated_value, 'class' => 'value_rate go text-right additions_value')) . ' </td><td>' . '<span>' .
          CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class' => 'btn btn-sm btn-danger', 'onclick' => 'removeExtrasRow($(\'#purchasingInvoice_final_add_table\'), this)')) .
          '</span></td></tr>';
          }
          } else {

          $i = 0;
          $jsonData['addition'] .= '<tr><td class="text-right td-in-6">Additions<span>' .
          CHtml::link('<i class="fa fa-plus"></i>', 'javascript:void(0);', array('onclick' => 'addTableRow($(\'#purchasingInvoice_final_add_table\'))', 'class' => 'btn btn-sm btn-theme ')) . ' ' .
          '</span></td>
          <td>' .
          CHtml::activedropDownList($modelAddition, "[$i]particular", MasFooterItems::getPurchaseAdditions(), array('prompt' => 'Select', 'placeholder' => 'Particulars', 'class' => 'paricular go', 'style' => 'float: none;width: 150px;')) . '</td><td> ' .
          CHtml::activeTextField($modelAddition, "[$i]particular_value", array(
          'onkeyup' => 'calculateTableValues($(\'#purchasingInvoice_item_table\'),this.id);', 'onkeypress' => 'return isNumberKey(event)', 'class' => 'value_rate go text-right', 'placeholder' => 'value')) . ' </td><td>' .
          CHtml::activeTextField($modelAddition, "[$i]calculated_value", array('class' => 'value_rate go text-right additions_value')) . ' </td><td>' . '<span>' .
          CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class' => 'btn btn-sm btn-danger', 'onclick' => 'removeExtrasRow($(\'#purchasingInvoice_final_add_table\'), this)')) .
          '</span></td></tr>';
          }

          $jsonData['deduction'] = '';
          $modelDeduction = new PurchasingInvoiceDeduction;
          if (!empty($purchaseorder->dedItems)) {
          foreach ($purchaseorder->dedItems as $i => $eachDeduction) {
          $rounded_deduction = round(($productpercentage * $eachDeduction->calculated_value), 2);
          $eachDeduction->calculated_value = number_format($rounded_deduction, 2, '.', '');
          $eachDeduction->particular_value = number_format($rounded_deduction, 2, '.', '');
          $deduction += $eachDeduction->calculated_value;
          $jsonData['deduction'] .= '<tr><td  class="text-right td-in-6">Deductions<span>' .
          CHtml::link('<i class="fa fa-plus"></i>', 'javascript:void(0);', array('onclick' => 'addTableRow($(\'#purchasingInvoice_final_ded_table\'))', 'class' => 'btn btn-sm btn-theme')) . ' ' .
          '</span></td><td> ' .
          CHtml::activedropDownList($modelDeduction, "[$i]particular", MasFooterItems::getPurchaseDeductions(), array('prompt' => 'Select', 'options' => array($eachDeduction->particular => array('selected' => true)), 'placeholder' => 'Particulars', 'class' => 'paricular go', 'style' => 'float: none;width: 150px;')) . '</td><td> ' .
          CHtml::activeTextField($modelDeduction, "[$i]particular_value", array('value' => $eachDeduction->particular_value,
          'onkeyup' => 'calculateTableValues($(\'#purchasingInvoice_item_table\'),this.id);', 'onkeypress' => 'return isNumberKey(event)', 'class' => 'go text-right value_rate', 'placeholder' => 'value')) . '</td><td>  ' .
          CHtml::activeTextField($modelDeduction, "[$i]calculated_value", array('value' => $eachDeduction->calculated_value, 'class' => 'go text-right value_rate additions_value')) . ' </td><td> ' . '<span>' .
          CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class' => 'btn btn-sm btn-danger', 'onclick' => 'removeExtrasRow($(\'#purchasingInvoice_final_ded_table\'), this)')) .
          '</span></td></tr>';
          }
          } else {
          $i = 0;
          $jsonData['deduction'] .= '<tr><td  class="text-right td-in-6">Deductions<span>' .
          CHtml::link('<i class="fa fa-plus"></i>', 'javascript:void(0);', array('onclick' => 'addTableRow($(\'#purchasingInvoice_final_ded_table\'))', 'class' => 'btn btn-sm btn-theme')) . ' ' .
          '</span></td><td> ' .
          CHtml::activedropDownList($modelDeduction, "[$i]particular", MasFooterItems::getPurchaseDeductions(), array('prompt' => 'Select', 'placeholder' => 'Particulars', 'class' => 'paricular go', 'style' => 'float: none;width: 150px;')) . '</td><td> ' .
          CHtml::activeTextField($modelDeduction, "[$i]particular_value", array(
          'onkeyup' => 'calculateTableValues($(\'#purchasingInvoice_item_table\'),this.id);', 'onkeypress' => 'return isNumberKey(event)', 'class' => 'go text-right value_rate', 'placeholder' => 'value')) . '</td><td>  ' .
          CHtml::activeTextField($modelDeduction, "[$i]calculated_value", array('class' => 'go text-right value_rate additions_value')) . ' </td><td> ' . '<span>' .
          CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class' => 'btn btn-sm btn-danger', 'onclick' => 'removeExtrasRow($(\'#purchasingInvoice_final_ded_table\'), this)')) .
          '</span></td></tr>';
          } */

        $gd_total = number_format($total + $tax_amt + $addition - $deduction, 2, '.', '');

        $jsonData['vat_amt'] = '<tr class="summary_tr bg-total">
        <td width="70%" class="text-right table_total_title"><h1>VAT</h1></td>
        <td width="30%" class="text-right table_total"><h1 class="vat_amount cell-right">' . $tax_amt . '</h1></td>
    </tr>';
        $jsonData['grand_total'] = '

        <tr class="summary_tr bg-total">
            <td width="70%" class="text-right table_total_title"><h1>Grand Total</h1></td>
            <td width="30%" class="text-right table_total"><h1 class="grandtotal cell-right">' . $gd_total . '</h1></td>
        </tr>';

        echo CJSON::encode($jsonData);
    }

    public function actionSaveinvoice()
    {

        $other = array();
        $valid = true;
        $modelInvoice = new PurchasingInvoice();
        //$modelItem = array(new PurchasingInvoiceItem());
        if (isset($_POST['PurchasingInvoice'])) {

            //aaded by priya 0n 11.9.24 check stocklockflag
            $modelCompanySettings = new MasCompanySettings();
            $condition = 'crm_company_id = ' . (int) Yii::app()->user->master_user_company_id;
            $modelCompanySettings = $modelCompanySettings->find(array('condition' => $condition));
            $stock_lock_flag = $modelCompanySettings->stock_lock_flag;
            if ($stock_lock_flag == "N") {
                /////////////
                $total = $net_total = $tot_tax = 0;
                $modelInvoice->attributes = $_POST['PurchasingInvoice'];

                $manual_invoice_no = $_POST['PurchasingInvoice']['invoice_no'];

                $modelInvoice->exchange_rate = $_POST['PurchasingInvoice']['exchange_rate'];
                $modelInvoice->currency = $_POST['PurchasingInvoice']['currency'];
                $modelInvoice->ticket_id = $_POST['PurchasingInvoice']['ticket_id'];
                $modelInvoice->project_classification_id = $_POST['PurchasingInvoice']['project_classification_id'];
                $modelInvoice->contract_id = $_POST['PurchasingInvoice']['contract_id'];

                $invoice_exchange_rate = $_POST['PurchasingInvoice']['exchange_rate'];

                if ($_POST['PurchasingInvoice']['invoice_date'] != '') {
                    $modelInvoice->invoice_date = str_replace('/', '-', $_POST['PurchasingInvoice']['invoice_date']);
                    $modelInvoice->invoice_date = date("Y-m-d", strtotime($modelInvoice->invoice_date));
                }
                if ($_POST['PurchasingInvoice']['payment_date'] != '') {
                    $modelInvoice->payment_date = str_replace('/', '-', $_POST['PurchasingInvoice']['payment_date']);
                    $modelInvoice->payment_date = date("Y-m-d", strtotime($modelInvoice->payment_date));
                }
                $modelInvoice->invoice_type = $_POST['PurchasingInvoice']['invoice_type'];
                $modelInvoice->warehouse_id = (int) Yii::app()->user->getState('user_warehouse_id');

                $modelInvoice->crm_user_id = Yii::app()->user->id;
                $other_errors = array();
                $grand_total = $total_net_value = 0;
                $valid = $modelInvoice->validate();

                //   ---------------------AccAuditClose check------------------------------------


                $invoice_datex = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['PurchasingInvoice']['invoice_date'])));

                $modelAccAuditClose = new AccAuditClose();
                $existing_date = strtotime($modelAccAuditClose->lastCloseddate());
                $invoice_date = strtotime($invoice_datex);
                if ($invoice_date <= $existing_date) {
                    $valid = false;
                    $other[] = ' Given PurchasingInvoice date must be Greater than Audit Close Date ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';
                }
                //   --------------------//-AccAuditClose check------------------------------------


                if (is_array($_POST['PurchasingInvoiceItem'])) {
                    foreach ($_POST['PurchasingInvoiceItem'] as $i => $item) {

                        if (!empty($item['product_id'])) {

                            $modelItem[$i] = new PurchasingInvoiceItem;
                            $modelItem[$i]->attributes = $_POST['PurchasingInvoiceItem'][$i];
                            $modelItem[$i]->tax_amount = $item['tax_amount'];

                            $modelItem[$i]->mr_id = $item['mr_id'];
                            $modelItem[$i]->mr_item_id = $item['mr_item_id'];
                            //$modelItem[$i]->foc_checked = $item['foc_checked'];
                            $total += $item['net_amount'];
                            $net_total += $item['net_amount'];
                            $tot_tax += $item['tax_amount'];
                            $valid = $modelItem[$i]->validate() && $valid;
                            $total_net_value += ($item['net_amount'] + $item['tax_amount']);
                        }
                    }
                }

                if (is_array($_POST['PurchasingInvoiceAddition'])) {
                    foreach ($_POST['PurchasingInvoiceAddition'] as $i => $item) {
                        $modelInvoiceAddition[$i] = new PurchasingInvoiceAddition;
                        $modelInvoiceAddition[$i]->attributes = $_POST['PurchasingInvoiceAddition'][$i];

                        $modelInvoiceAddition[$i]->particular = $item['particular'];
                        $modelInvoiceAddition[$i]->particular_value = $item['particular_value'];
                        $modelInvoiceAddition[$i]->calculated_value = $item['calculated_value'];

                        $net_total += $item['calculated_value'];
                        $valid = $modelInvoiceAddition[$i]->validate() && $valid;
                    }
                    $modelsToBeValidated[] = $modelInvoiceAddition;
                }
                if (is_array($_POST['PurchasingInvoiceDeduction'])) {
                    foreach ($_POST['PurchasingInvoiceDeduction'] as $i => $item) {
                        $modelInvoiceDeduction[$i] = new PurchasingInvoiceDeduction;
                        $modelInvoiceDeduction[$i]->attributes = $_POST['PurchasingInvoiceDeduction'][$i];

                        $modelInvoiceDeduction[$i]->particular = $item['particular'];
                        $modelInvoiceDeduction[$i]->particular_value = $item['particular_value'];
                        $modelInvoiceDeduction[$i]->calculated_value = $item['calculated_value'];

                        $net_total -= $item['calculated_value'];
                        $valid = $modelInvoiceDeduction[$i]->validate() && $valid;
                    }
                    $modelsToBeValidated[] = $modelInvoiceDeduction;
                }

                if ($valid) {
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);

                    MasterFile::model()->updateByPk($modelInvoice->file_id, array('is_approved' => "Y", 'current_process_status' => 'P_I'));

                    $modelInvoice->save();
                    // inserting to audit log
                    AuditLog::saveAuditLogs(
                        'PURCHASE_INVOICE',
                        Yii::app()->user->id,
                        'CREATED',
                        " INV No: - {$modelInvoice->id} "
                    );
                    // end audit log
                    $invoice_id = $modelInvoice->id;
                    $file_id = $modelInvoice->file_id;
                    //$include_vat="Y";

                    $modelCompanySettings = new MasCompanySettings();
                    $modelCompanySettings = $modelCompanySettings->find(array('condition' => 'crm_company_id=' . (int) Yii::app()->user->master_user_company_id));
                    if (!empty($modelCompanySettings)) {
                        $include_vat = $modelCompanySettings->include_vat;
                    } else {
                        $include_vat = 'N';
                    }


                    $tot_of_net = $tot_tax = 0;
                    $old_total_qty = $old_rate = array();
                    $footer_value = 0;
                    if (!empty($modelInvoiceAddition)) {
                        foreach ($modelInvoiceAddition as $eachModel) {
                            $eachModel->purchasing_invoice_id = $modelInvoice->id;
                            $eachModel->save();
                            $grand_total += $eachModel->calculated_value;
                            $footer_value += $eachModel->calculated_value;
                        }
                    }
                    if (!empty($modelInvoiceDeduction)) {
                        foreach ($modelInvoiceDeduction as $eachModel) {
                            $eachModel->purchasing_invoice_id = $modelInvoice->id;
                            $eachModel->save();
                            $grand_total -= $eachModel->calculated_value;
                            $footer_value -= $eachModel->calculated_value;
                        }
                    }
                    if (!empty($modelItem)) {
                        foreach ($modelItem as $eachItem) {
                            $eachItem->purchasing_invoice_id = $modelInvoice->id;
                            $eachItem->save(false);
                            $eachItem->fill_up_previous();

                            $grand_total += $eachItem->net_amount;
                            $tot_of_net += $eachItem->net_amount;
                            $tot_tax += $eachItem->tax_amount;
                            $modelStore = Store::model()->findBypk($eachItem->product_id);

                            $rate = $modelStore->rate;
                            $old_qty = $modelStore->totalQuantity;

                            ($include_vat == 'Y') ? $actual_cost = ($eachItem->net_amount + $eachItem->tax_amount) : $actual_cost = $eachItem->net_amount;
                            $actual_cost_percentage = ($total_net_value > 0) ? $actual_cost / $total_net_value : 0;
                            $actual_cost_percentage = round($actual_cost_percentage, 6);
                            $item_footer_value = $actual_cost_percentage * $footer_value;
                            $total_item_net_value = $actual_cost + $item_footer_value;
                            $quantity_with_unit_factor = $eachItem->quantity * $eachItem->unitdetails->factor;
                            $variance_value = ($quantity_with_unit_factor > 0) ? $total_item_net_value / $quantity_with_unit_factor : 0;
                            $variance_value = round($variance_value, 6);
                            $cost_with_variance = $variance_value * $modelInvoice->exchange_rate;

                            $cur_total = $cost_with_variance * $quantity_with_unit_factor;
                            $old_net_amount = $rate * $old_qty;
                            $total_quantity = $old_qty + $quantity_with_unit_factor;
                            $total_amount = $old_net_amount + $cur_total;
                            $new_amount = ($total_quantity > 0) ? $total_amount / $total_quantity : $rate;
                            $new_amount = round($new_amount, 6);
                            if ($eachItem->product->inventory_item_type !=2) {
                                Store::model()->updateByPk($eachItem->product_id, array('rate' => $new_amount));
                            }


                            //code added by jisha to update buying_price--start
                            $arr_stockledger = StockLedger::model()->findAll(array('condition' => 'product_id=' . (int) $eachItem->product_id . ' AND header_id=' . (int) $eachItem->mr_id . ' AND header_item_id=' . (int) $eachItem->mr_item_id . ' AND transaction_from="QUALITY_CHECK"', 'order' => 't.id asc'));
                            if (!empty($arr_stockledger)) {
                                foreach ($arr_stockledger as $i => $eachSLItem) {
                                    if ($eachItem->unitdetails->factor > 0) {
                                        $buy_rate = $eachItem->rate / $eachItem->unitdetails->factor;
                                    } else {
                                        $buy_rate = $eachItem->rate;
                                    }
                                    $buy_rate = $buy_rate * $modelInvoice->exchange_rate;

                                    StockLedger::model()->updateByPk($eachSLItem['id'], array(
                                        'buying_price' => $buy_rate
                                    ));
                                    //StockLedger::model()->update_cost((int) $eachItem->product_id,$eachSLItem['id']);
                                }
                            }
                            //end jisha
                        }
                    }
                    if (is_array($_POST['StockLedger'])) {
                        foreach ($_POST['StockLedger'] as $i => $eachItem) {
                            $modelStore = Store::model()->findBypk($eachItem['product_id']);

                            StockLedger::model()->updateByPk($eachItem['id'], array(
                                'stock_updated' => 'Y',
                                'cost_price' => (float) $modelStore->rate,
                                'reference_id' => $invoice_id,
                                'reference_no' => $manual_invoice_no
                            ));
                            //StockLedger::model()->updateByPk($eachItem['id'], array('stock_updated' => 'Y'));
                        }
                    }
                    /* if (is_array($_POST['StockLedger'])) {
                  foreach ($_POST['StockLedger'] as $i => $eachItem) {

                  $modelStore = Store::model()->findBypk($eachItem['product_id']);

                  $stockLedger = new StockLedger;
                  $stockLedger->header_id = $eachItem['header_id'];
                  $stockLedger->header_item_id = $eachItem['header_item_id'];
                  $stockLedger->transaction_date = $modelInvoice->invoice_date;
                  $stockLedger->transaction_type = "PURCHASE";
                  $stockLedger->product_id = $eachItem['product_id'];
                  $stockLedger->quantity = $eachItem['quantity'];
                  $stockLedger->product_location_id = $eachItem['product_location_id'];
                  $stockLedger->unit_id = $modelStore['unit_id'];
                  $stockLedger->warehouse_id = $eachItem['warehouse_id'];
                  $stockLedger->rack_id = $eachItem['rack_id'];
                  $stockLedger->bin_id = $eachItem['bin_id'];
                  $stockLedger->created_by = Yii::app()->user->id;
                  $stockLedger->created_date = date('Y-m-d h:i:s');
                  $stockLedger->cost_price = $modelStore->rate;
                  $stockLedger->save(false);
                  /*if($eachItem['header_item_id']==$_POST['PurchasingInvoiceItem'][$i]['mr_item_id'] && $_POST['PurchasingInvoiceItem'][$i]['foc_checked']==1){
                  $model_warehouse_details = MasInventoryWarehouse::model()->find(array('condition' =>'warehouse_code="FOC"'));
                  if($modelStore->have_serial_no=='Y'){
                  ProductLocationDetails::model()->updateAll(array('warehouse_id'=>$model_warehouse_details->id,'foc_checked'=>1,'isActive' => "Y"), 'header_id="'.$eachItem['header_id'].'" and product_id="'.$eachItem['product_id'].'"');
                  }
                  else{
                  ProductLocationDetails::model()->updateByPk($eachItem['product_location_id'], array('warehouse_id'=>$model_warehouse_details->id,'foc_checked'=>1,'isActive' => "Y"));
                  }
                  }else{
                  //ProductLocationDetails::model()->updateByPk($eachItem['product_location_id'], array('isActive' => "Y"));
                  //}
                  }

                  } */

                    $tot_of_net += $tot_tax;
                    $net_total += $tot_tax;
                    $grand_total += $tot_tax;
                    $modelInvoice->updateByPk($modelInvoice->id, array('grand_total' => $grand_total, 'total_tax_amount' => $tot_tax));

                    if (is_array($_POST['materialreceiptfileId'])) {
                        foreach ($_POST['materialreceiptfileId'] as $i => $each) {
                            PurchasingMaterialreceipt::model()->updateByPk((int) $each, array('is_convertable' => 'N'));
                        }
                    }


                    // ----------added-by-indhu-30-12-2022---------------------------
                    // ---------------------------------------------------------------

                    // -----------------accounts--------------------
                     Yii::import('application.modules.accounts.controllers.PostingController');
                    $from = 'purchase';
                    PostingController::DirectPost((int)$modelInvoice->id, $from);
                    // ---------------------------------------------------------------



                    $model_mail_setting = Notification::model()->find(array('condition' => 'event_id="17"'));
                    Yii::import('application.controllers.front.MasternotificationController');
                    if ($model_mail_setting->mail_required == 'Y') {
                        //MasternotificationController::sendmail(17,$modelInvoice->id);
                    }
                    if ($model_mail_setting->notification_required == 'Y') {
                        //MasternotificationController::sendnotification(17,$modelInvoice->id);
                    }
                    if ($model_mail_setting->sms_required == 'Y') {
                        //MasternotificationController::sendsms(17,$modelInvoice->id);
                    }
                } else {
                    $error1 = $error2 = $error3 = $error4 = array();
                    $error1 = json_decode(CActiveForm::validate($modelInvoice, '', false), true);
                    if (!empty($modelItem[0]->product_id)) {
                        $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                    } else {
                        $error2[] = "Please add atleast one line item";
                    }

                    if (!empty($modelInvoiceAddition)) {
                        $error3 = json_decode(CActiveForm::validateTabular($modelInvoiceAddition, '', false), true);
                    }

                    if (!empty($modelInvoiceDeduction)) {
                        $error4 = json_decode(CActiveForm::validateTabular($modelInvoiceDeduction, '', false), true);
                    }

                    $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4, $other));

                    if ($error != '[]') {
                        echo $error;
                    }
                }
                Yii::app()->end();
            } else {
                echo CJSON::encode(array('error' => ' Transactions are already locked!'));
            }
        } else {
            echo 'error';
        }
    }

    public function actionPrintInvoiceReportPDF()
    {

        $id = Yii::app()->request->getParam('id');
        $c_id = Yii::app()->request->getParam('c_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.purchase_invoice_list_individual', array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title), true));
        $mPDF1->Output("PurchaseInvoice.pdf", 'I');
    }
    
    public function actionPrintInvoiceSerialNoReportPDF()
    {

        $id = Yii::app()->request->getParam('id');
        $c_id = Yii::app()->request->getParam('c_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.purchase_invoice_serialno_list_individual', array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title), true));
        $mPDF1->Output("PurchaseInvoice.pdf", 'I');
    }

    public function actionAddLandedCost()
    {
        $modelInvoice = new PurchasingInvoice();
        $id = (int) Yii::app()->request->getParam('id');

        $modePurchasingInvoiceLandedCost = array(new PurchasingInvoiceLandedCost);
        if ($id > 0) {
            $modelInvoice = $modelInvoice->findByPk($id);
            $modelInvoice->invoice_date = date("d/m/Y", strtotime($modelInvoice->invoice_date));
            if (empty($modelInvoiceItems)) {
                $modelInvoiceItems = array(new PurchasingInvoiceItem);
            }
            $modelAdditionInvoiceItems = PurchasingInvoiceAddition::model()->findAll(array('condition' => 'purchasing_invoice_id="' . $id . '"'));
            if (empty($modelAdditionInvoiceItems)) {
                $modelAdditionInvoiceItems = array(new PurchasingInvoiceAddition);
            }
            $modelDeductionInvoiceItems = PurchasingInvoiceDeduction::model()->findAll(array('condition' => 'purchasing_invoice_id="' . $id . '"'));
            if (empty($modelDeductionInvoiceItems)) {
                $modelDeductionInvoiceItems = array(new PurchasingInvoiceDeduction);
            }

            $modePurchasingInvoiceLandedCost = PurchasingInvoiceLandedCost::model()->findAll(array('condition' => 'purchasing_invoice_id="' . $id . '"'));
            if (empty($modePurchasingInvoiceLandedCost)) {
                $modePurchasingInvoiceLandedCost = array(new PurchasingInvoiceLandedCost);
            }

            $i = 0;
            $footer_items = array();
            foreach ($modelAdditionInvoiceItems as $addition) {
                if ($addition->particular > 0) {
                    $footer_items[$i]['id'] = $addition->id;
                    $footer_items[$i]['particular'] = $addition->item->item_name;
                    $footer_items[$i]['particular_value'] = $addition->particular_value;
                    $footer_items[$i]['type'] = 'Addition';
                    $footer_items[$i]['symbol'] = '+';
                    $footer_items[$i]['vendor'] = $addition->purchasinginvoice->vendor_details->vendor_name;
                    $footer_items[$i]['currency'] = $addition->purchasinginvoice->currency;
                    $footer_items[$i]['currency_code'] = $addition->purchasinginvoice->currencyname->currency_code;
                    $i++;
                }
            }

            foreach ($modelDeductionInvoiceItems as $deduction) {
                if ($deduction->particular > 0) {
                    $footer_items[$i]['id'] = $deduction->id;
                    $footer_items[$i]['particular'] = $deduction->item->item_name;
                    $footer_items[$i]['particular_value'] = $deduction->particular_value;
                    $footer_items[$i]['type'] = 'Deduction';
                    $footer_items[$i]['symbol'] = '-';
                    $footer_items[$i]['vendor'] = $deduction->purchasinginvoice->vendor_details->vendor_name;
                    $footer_items[$i]['currency'] = $deduction->purchasinginvoice->currency;
                    $footer_items[$i]['currency_code'] = $deduction->purchasinginvoice->currencyname->currency_code;
                    $i++;
                }
            }
        }
        /* echo '<pre>';
          print_r($footer_items); */

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('add_landed_cost', array('modelInvoice' => $modelInvoice, 'id' => $id, 'existing_footer_items' => $footer_items, 'modePurchasingInvoiceLandedCost' => $modePurchasingInvoiceLandedCost));
    }

    public function actionSaveLandedCost()
    {

        $LandingCost = array();
        $i = 0;
        $valid = true;
        PurchasingInvoiceLandedCost::model()->deleteAll('purchasing_invoice_id=:refer_id', array(':refer_id' => (int) $_POST['PurchasingInvoice']['id']));

        if (isset($_POST['PurchasingInvoice']) && $_POST['PurchasingInvoice']['id'] > 0) {

            foreach ($_POST['PurchasingInvoiceLandedCost'] as $i => $item) {
                if ((float) $item['particular_value'] > 0) {
                    $LandingCost[$i] = new PurchasingInvoiceLandedCost;
                    $LandingCost[$i]->attributes = $item;
                    $LandingCost[$i]->purchasing_invoice_id = (int) $_POST['PurchasingInvoice']['id'];
                    $LandingCost[$i]->particular = (int) $item['particular'];
                    $LandingCost[$i]->particular_value = (float) $item['particular_value'];
                    $LandingCost[$i]->notes = $item['notes'];
                    $LandingCost[$i]->landed_cost_type = MasLandedCostItems::getLandedCostItemType($item['particular']);
                    $LandingCost[$i]->created_by = Yii::app()->user->id;
                    $LandingCost[$i]->created_datetime = date('Y-m-d h:i:s');
                    $valid = $valid && $LandingCost[$i]->validate();
                    $i++;
                }
            }
        }

        if ($valid && count($LandingCost) > 0) {
            echo CJSON::encode(array('status' => 'success'));
            foreach ($LandingCost as $each) {
                $each->exchange_rate = MasCurrency::model()->findBypk($each->currency_id)->exchange_rate;
                $each->save(false);
            }
            PurchasingInvoice::model()->findBypk((int) $_POST['PurchasingInvoice']['id'])->update_landed_cost();
        } else {
            $error1 = array();
            if (count($LandingCost) == 0)
                $error1[] = "Add atleast one item";

            $error2 = json_decode(CActiveForm::validateTabular($LandingCost, '', false), true);
            echo CJSON::encode(array_merge_recursive($error1, $error2));
        }
    }



    public function actionSaveDirectinvoice26_06_2025()
    {
        $other = array();
        $valid = true;
        $modelInvoice = new PurchasingInvoice();
        //$modelItem = array(new PurchasingInvoiceItem());
        if ((int) $_POST['PurchasingInvoice']['id'] > 0) {
            $id = (int) $_POST['PurchasingInvoice']['id'];
            $modelInvoice = $modelInvoice->findByPk($id);
        }
        if (isset($_POST['PurchasingInvoice'])) {

            $total = $net_total = $tot_tax = 0;
            $modelInvoice->attributes = $_POST['PurchasingInvoice'];
            $modelInvoice->exchange_rate = $_POST['PurchasingInvoice']['exchange_rate'];
            $modelInvoice->currency = $_POST['PurchasingInvoice']['currency'];
            $modelInvoice->ticket_id = $_POST['PurchasingInvoice']['ticket_id'];
            $invoice_exchange_rate = $_POST['PurchasingInvoice']['exchange_rate'];

            if ($_POST['PurchasingInvoice']['invoice_date'] != '') {
                $modelInvoice->invoice_date = str_replace('/', '-', $_POST['PurchasingInvoice']['invoice_date']);
                $modelInvoice->invoice_date = date("Y-m-d", strtotime($modelInvoice->invoice_date));
            }
            if ($_POST['PurchasingInvoice']['payment_date'] != '') {
                $modelInvoice->payment_date = str_replace('/', '-', $_POST['PurchasingInvoice']['payment_date']);
                $modelInvoice->payment_date = date("Y-m-d", strtotime($modelInvoice->payment_date));
            }
            $modelInvoice->invoice_type = $_POST['PurchasingInvoice']['invoice_type'];
            $modelInvoice->crm_user_id = Yii::app()->user->id;
            $other_errors = array();
            $grand_total = $total_net_value = 0;
            $valid = $modelInvoice->validate();

            //   ---------------------AccAuditClose check------------------------------------


            $invoice_datex = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['PurchasingInvoice']['invoice_date'])));

            $modelAccAuditClose = new AccAuditClose();
            $existing_date = strtotime($modelAccAuditClose->lastCloseddate());
            $invoice_date = strtotime($invoice_datex);
            if ($invoice_date <= $existing_date) {
                $valid = false;
                $other[] = ' Given PurchasingInvoice date must be Greater than Audit Close Date :- ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';
            }
            //   --------------------//-AccAuditClose check------------------------------------



            if (is_array($_POST['PurchasingInvoiceItem'])) {
                foreach ($_POST['PurchasingInvoiceItem'] as $i => $item) {

                    if (!empty($item['product_id'])) {

                        if (empty($item['id'])) {
                            $modelItem[$i] = new PurchasingInvoiceItem;
                        } else {
                            $modelItem[$i] = PurchasingInvoiceItem::model()->findByPk((int) $item['id']);
                        }
                        $modelItem[$i]->attributes = $_POST['PurchasingInvoiceItem'][$i];
                        $modelItem[$i]->tax_amount = $item['tax_amount'];

                        $modelItem[$i]->mr_id = $item['mr_id'];
                        $modelItem[$i]->mr_item_id = $item['mr_item_id'];
                        $total += $item['net_amount'];
                        $net_total += $item['net_amount'];
                        $tot_tax += $item['tax_amount'];
                        $valid = $modelItem[$i]->validate() && $valid;
                        $total_net_value += ($item['net_amount'] + $item['tax_amount']);
                    }
                }
            }

            if (is_array($_POST['PurchasingInvoiceAddition'])) {
                foreach ($_POST['PurchasingInvoiceAddition'] as $i => $item) {
                    if (empty($item['id'])) {
                        $modelInvoiceAddition[$i] = new PurchasingInvoiceAddition;
                    } else {
                        $modelInvoiceAddition[$i] = PurchasingInvoiceAddition::model()->findByPk($item['id']);
                    }
                    $modelInvoiceAddition[$i]->attributes = $_POST['PurchasingInvoiceAddition'][$i];
                    $modelInvoiceAddition[$i]->particular = $item['particular'];
                    $modelInvoiceAddition[$i]->particular_value = $item['particular_value'];
                    $modelInvoiceAddition[$i]->calculated_value = $item['calculated_value'];

                    $net_total += $item['calculated_value'];
                    $valid = $modelInvoiceAddition[$i]->validate() && $valid;
                }
                $modelsToBeValidated[] = $modelInvoiceAddition;
            }
            if (is_array($_POST['PurchasingInvoiceDeduction'])) {
                foreach ($_POST['PurchasingInvoiceDeduction'] as $i => $item) {
                    if (empty($item['id'])) {
                        $modelInvoiceDeduction[$i] = new PurchasingInvoiceDeduction;
                    } else {
                        $modelInvoiceDeduction[$i] = PurchasingInvoiceDeduction::model()->findByPk($item['id']);
                    }
                    $modelInvoiceDeduction[$i]->attributes = $_POST['PurchasingInvoiceDeduction'][$i];

                    $modelInvoiceDeduction[$i]->particular = $item['particular'];
                    $modelInvoiceDeduction[$i]->particular_value = $item['particular_value'];
                    $modelInvoiceDeduction[$i]->calculated_value = $item['calculated_value'];

                    $net_total -= $item['calculated_value'];
                    $valid = $modelInvoiceDeduction[$i]->validate() && $valid;
                }
                $modelsToBeValidated[] = $modelInvoiceDeduction;
            }
            if ($valid) {
                if (isset($_POST['PurchasingInvoice']['file_id']) && $_POST['PurchasingInvoice']['file_id'] > 0) {
                    MasterFile::model()->updateByPk($_POST['PurchasingInvoice']['file_id'], array('current_process_status' => 'P_I'));
                    $modelInvoice->file_id = $_POST['PurchasingInvoice']['file_id'];
                } else {
                    $modelfile = new MasterFile();
                    $modelfile->start_from = "P_I";
                    $modelfile->crm_user_id = Yii::app()->user->id;
                    $modelfile->customer_id = $modelInvoice->vendor_id;
                    $modelfile->file_title = $modelInvoice->title;
                    $modelfile->current_process_status = "P_I";
                    $modelfile->is_approved = "Y";
                    $modelfile->approved_by = Yii::app()->user->id;
                    $modelfile->date_of_approval = date('Y-m-d');
                    $modelfile->save(false);
                    $modelInvoice->file_id = $modelfile->id;
                }


                $parent_invoice_ids = $_POST['PurchasingInvoice']['purchase_invoice_id'];
                //REVERSE CALCULATION OF LANDING COST
                if (!empty($modelInvoice->purchase_invoice_id)) {
                    LandingCost::model()->deleteAll(array('condition' => 'service_invoice_id=' . $modelInvoice->id));
                    $ids = explode(',', $modelInvoice->purchase_invoice_id);
                    foreach ($ids as $eachInvoice) {
                        if ((int) $eachInvoice > 0) {
                            $invoice = PurchasingInvoice::model()->findByPk($eachInvoice);
                            foreach ($invoice->items as $i => $eachItem) {
                                $cost_rate = ($eachItem->rate * $invoice->exchange_rate);
                                if ($invoice->purchase_invoice == 'DP') {
                                    $head = $invoice->id;
                                } else {
                                    $head = $invoice->materialreceived;
                                }
                                StockLedger::model()->updateAll(array('cost_price' => $cost_rate), 'product_id=' . $eachItem->product_id . ' AND transaction_type ="PURCHASE"' . ' AND header_id ="' . $head . '"');
                                $store = Store::model()->findByPk($eachItem->product_id);
                                $SQL_AVG = 'select (SUM(cost_price*quantity)/SUM(quantity)) AS cost from {{stock_ledger}} where quantity > 0 AND product_id=' . $eachItem->product_id;
                                $avg_stock_value = Yii::app()->db->createCommand($SQL_AVG)->queryScalar();
                                $store->rate = (float) $avg_stock_value;
                                $store->save(false);
                                if ($i > 0) {
                                    $product .= ',' . $eachItem->product_id;
                                } else {
                                    $product .= $eachItem->product_id;
                                }
                            }
                            if (!empty($product)) {
                                $SQL = 'select invoice_id,invoice_date from {{invoice_item}} AS IT INNER JOIN {{invoice}} AS I ON IT.invoice_id=I.id where product_id IN (' . $product . ') group by invoice_id';
                                $data = Yii::app()->db->createCommand($SQL)->queryAll();
                                foreach ($data as $eachRow) {
                                    $invoice_no = $eachRow['invoice_id'];
                                    $invoice_date = $invoice->invoice_date;
                                    $invoice_items = InvoiceItem::model()->findAll(array('condition' => 'invoice_id=' . $invoice_no));
                                    $sales_cost_price = 0;
                                    foreach ($invoice_items as $eachSalesItems) {
                                        $qty = $eachSalesItems->quantity;
                                        $stock = Yii::app()->db->createCommand("select SUM(cost_price*quantity)/SUM(quantity) from erp_stock_ledger where product_id='" . $eachSalesItems->product_id . "' AND quantity>0 AND (transaction_date>='" . $invoice_date . "')")->queryScalar();
                                        InvoiceItem::model()->updateAll(array('cost_rate' => $stock), 'id=' . $eachSalesItems->id);
                                        $sales_cost_price += ($stock * $qty);
                                    }
                                    Yii::app()->db->createCommand("update erp_finance_voucher_items I join erp_finance_voucher_head H on H.id=I.header_id set I.amount = '$sales_cost_price' WHERE H.voucher_type=7 AND H.voucher_no='$invoice_no' AND I.ledger_id=105")->execute();
                                    Yii::app()->db->createCommand("update erp_finance_voucher_items I join erp_finance_voucher_head H on H.id=I.header_id set I.amount = '-$sales_cost_price' WHERE H.voucher_type=7 AND H.voucher_no='$invoice_no' AND I.ledger_id=10")->execute();
                                }
                            }
                        }
                    }
                }
                //END REVERSE CALCULATION OF LANDING COST
                if (!empty($parent_invoice_ids)) {
                    $modelInvoice->purchase_invoice_id = implode(",", $parent_invoice_ids);
                }
                $modelInvoice->purchase_invoice = 'LC';
                $modelInvoice->save();

                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'PURCHASE_INVOICE',
                    Yii::app()->user->id,
                    'CREATED',
                    " INV No: - {$modelInvoice->id} "
                );
                // end audit log

                $invoice_id = $modelInvoice->id;
                $file_id = $modelInvoice->file_id;
                $model_settings = new MasCompanySettings();
                $model_settings = $model_settings->find();
                if (!empty($model_settings)) {
                    $include_vat = $model_settings->include_vat;
                }
                $tot_of_net = $tot_tax = 0;
                $old_total_qty = $old_rate = array();
                $footer_value = 0;
                if (!empty($modelInvoiceAddition)) {
                    foreach ($modelInvoiceAddition as $eachModel) {
                        $eachModel->purchasing_invoice_id = $modelInvoice->id;
                        $eachModel->save();
                        $grand_total += $eachModel->calculated_value;
                        $footer_value += $eachModel->calculated_value;
                    }
                }
                if (!empty($modelInvoiceDeduction)) {
                    foreach ($modelInvoiceDeduction as $eachModel) {
                        $eachModel->purchasing_invoice_id = $modelInvoice->id;
                        $eachModel->save();
                        $grand_total -= $eachModel->calculated_value;
                        $footer_value -= $eachModel->calculated_value;
                    }
                }
                if (!empty($modelItem)) {
                    foreach ($modelItem as $eachItem) {
                        $eachItem->purchasing_invoice_id = $modelInvoice->id;
                        $eachItem->save(false);
                        $sales_item_id = $eachItem->id;
                        $eachItem->fill_up_previous();

                        $grand_total += $eachItem->amount;
                        $tot_of_net += $eachItem->amount;
                        $tot_tax += $eachItem->tax_amount;
                        $modelStore = Store::model()->findBypk($eachItem->product_id);

                        $rate = $modelStore->rate;
                        $old_qty = $modelStore->totalQuantity;

                        ($include_vat == 'Y') ? $actual_cost = ($eachItem->net_amount + $eachItem->tax_amount) : $actual_cost = $eachItem->net_amount;
                        $actual_cost_percentage = ($total_net_value > 0) ? $actual_cost / $total_net_value : 0;
                        $actual_cost_percentage = round($actual_cost_percentage, 6);
                        $item_footer_value = $actual_cost_percentage * $footer_value;
                        $total_item_net_value = $actual_cost + $item_footer_value;
                        $quantity_with_unit_factor = $eachItem->quantity * $eachItem->unitdetails->factor;
                        $variance_value = ($quantity_with_unit_factor > 0) ? $total_item_net_value / $quantity_with_unit_factor : 0;
                        $variance_value = round($variance_value, 6);
                        $cost_with_variance = $variance_value * $modelInvoice->exchange_rate;

                        $cur_total = $cost_with_variance * $quantity_with_unit_factor;
                        $old_net_amount = $rate * $old_qty;
                        $total_quantity = $old_qty + $quantity_with_unit_factor;
                        $total_amount = $old_net_amount + $cur_total;
                        $new_amount = ($total_quantity > 0) ? $total_amount / $total_quantity : 0;
                        $new_amount = round($new_amount, 6);
                        Store::model()->updateByPk($eachItem->product_id, array('rate' => $new_amount));
                        if ($sales_item_id > 0) {
                            StockLedger::model()->deleteAll(array('condition' => 'header_id=' . $modelInvoice->id . ' AND header_item_id=0 AND product_id=' . $eachItem->product_id));
                            StockLedger::model()->deleteAll(array('condition' => 'header_id=' . $modelInvoice->id . ' AND header_item_id=' . $sales_item_id . ' AND product_id=' . $eachItem->product_id));
                        }
                        $stockLedger = new StockLedger;
                        $stockLedger->header_id = $modelInvoice->id;
                        $stockLedger->header_item_id = $sales_item_id;
                        $stockLedger->transaction_date = date('Y-m-d');
                        $stockLedger->transaction_type = 'DIRECT PURCHASE';
                        $stockLedger->product_id = $eachItem->product_id;
                        $stockLedger->quantity = $eachItem->quantity;
                        //        				$stockLedger->product_location_id   = 0;
                        $stockLedger->unit_id = $modelStore->unit_id;
                        $stockLedger->warehouse_id = $modelStore->warehouse_id;
                        $stockLedger->rack_id = 0;
                        $stockLedger->bin_id = 0;
                        $stockLedger->created_by = Yii::app()->user->id;
                        $stockLedger->created_date = date('Y-m-d h:i:s');
                        $stockLedger->cost_price = $eachItem->rate;
                        $stockLedger->save(false);
                    }
                }

                $tot_of_net += $tot_tax;
                $total_net_value = $tot_of_net;
                $net_total += $tot_tax;
                $grand_total += $tot_tax;
                $modelInvoice->updateByPk($modelInvoice->id, array('grand_total' => $grand_total, 'total_tax_amount' => $tot_tax));
                //code added by mereena on 06/04/2020
                if (isset($_POST['PurchasingInvoice']['po_id']) && $_POST['PurchasingInvoice']['po_id'] > 0) {
                    PurchasingOrder::model()->updateByPk($_POST['PurchasingInvoice']['po_id'], array('convert_status' => 'N'));
                }
                //end
                // Landing Cost Calculation
                if (!empty($modelInvoice->purchase_invoice_id)) {
                    LandingCost::model()->deleteAll(array('condition' => 'service_invoice_id=' . $modelInvoice->id));
                    $modelInvoice = PurchasingInvoice::model()->findByPk((int) $modelInvoice->id);
                    $grand_total = ((float) $modelInvoice->grand_total - (float) $modelInvoice->total_tax_amount) * (float) $modelInvoice->exchange_rate;
                    $SQL_GrandTotal = 'select (SUM(grand_total*exchange_rate)) AS tot from {{purchasinginvoice}} where id IN (' . $modelInvoice->purchase_invoice_id . ')';
                    $AllInvoiceGrandTotal = Yii::app()->db->createCommand($SQL_GrandTotal)->queryScalar();
                    $SQL_NetVatOrg = 'select (SUM(t.tax_amount*I.exchange_rate)) AS tot from {{purchasinginvoice_item}} t INNER JOIN {{purchasinginvoice}} I ON t.purchasing_invoice_id=I.id where t.purchasing_invoice_id IN (' . $modelInvoice->purchase_invoice_id . ')';
                    $NetVatOrg = Yii::app()->db->createCommand($SQL_NetVatOrg)->queryScalar();
                    foreach ($parent_invoice_ids as $eachInvoice) {
                        $invoice = PurchasingInvoice::model()->findByPk($eachInvoice);
                        foreach ($invoice->items as $eachItem) {
                            $landing_cost_item = 0;
                            $item_percentage = ($eachItem->amount * $invoice->exchange_rate) / ($AllInvoiceGrandTotal - $NetVatOrg);
                            $landing_cost_item = ($item_percentage * $grand_total) / $eachItem->quantity;
                            $modelLandingCost = new LandingCost;
                            $modelLandingCost->parent_invoice_id = $invoice->id;
                            $modelLandingCost->parent_invoice_item_id = $eachItem->id;
                            $modelLandingCost->product_id = $eachItem->product_id;
                            $modelLandingCost->service_invoice_id = $modelInvoice->id;
                            $modelLandingCost->quantity = $eachItem->quantity;
                            $modelLandingCost->rate = $eachItem->rate;
                            $modelLandingCost->amount = $eachItem->amount;
                            $modelLandingCost->currency = $invoice->currency;
                            $modelLandingCost->exchange_rate = $invoice->exchange_rate;
                            $modelLandingCost->service_amount_percentage = 100 * $item_percentage;
                            $modelLandingCost->service_invoice_value = $landing_cost_item;
                            $modelLandingCost->created_by = Yii::app()->user->id;
                            $time = date('Y-m-d H:i:s');
                            $timestamp = strtotime($time) + 4 * 60 * 60;
                            $time = date('Y-m-d H:i:s', $timestamp);
                            $modelLandingCost->created_date_time = $time;
                            $modelLandingCost->save(false);
                        }
                    }
                }
                // End Landing Cost Calculation
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                if (is_array($_POST['materialreceiptfileId'])) {
                    foreach ($_POST['materialreceiptfileId'] as $i => $each) {
                        PurchasingMaterialreceipt::model()->updateByPk((int) $each, array('is_convertable' => 'N'));
                    }
                }
            } else {
                $error1 = $error2 = $error3 = $error4 = array();
                $error1 = json_decode(CActiveForm::validate($modelInvoice, '', false), true);
                if (!empty($modelItem[0]->product_id)) {
                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                } else {
                    $error2[] = "Please add atleast one line item";
                }

                if (!empty($modelInvoiceAddition)) {
                    $error3 = json_decode(CActiveForm::validateTabular($modelInvoiceAddition, '', false), true);
                }

                if (!empty($modelInvoiceDeduction)) {
                    $error4 = json_decode(CActiveForm::validateTabular($modelInvoiceDeduction, '', false), true);
                }

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4, $other));

                if ($error != '[]') {
                    echo $error;
                }
            }
            Yii::app()->end();
        } else {
            echo 'error';
        }
    }




    public function actionPurchasedInvoices()
    {
        $data_array = array();
        $searchTerm = Yii::app()->request->getParam('term');
        if ($searchTerm != '') {

            // $condition = 'file_id LIKE "%' . $searchTerm . '%" OR id LIKE "%' . $searchTerm . '%" OR invoice_no LIKE "%' . $searchTerm . '%"';
            $condition = 'id LIKE "%' . $searchTerm . '%" AND purchase_invoice_id!=""';
            $model = PurchasingInvoice::model()->findAll(array('condition' => $condition));
            $i = 0;
            foreach ($model as $eachModel) {
                $data[$i]['value'] = $eachModel->id;
                $data[$i]['label'] = $eachModel->id . ' : ' . $eachModel->invoice_no;
            }
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionCalculateLandingCost()
    {
        $model = new PurchasingInvoice();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('landingcost_calculation', array('model' => $model));
    }

    public function actionGetPurchaseInvoiceDetails()
    {
        $id = Yii::app()->request->getParam('id');
        if ($id > 0) {
            $condition = 'service_invoice_id=' . $id;
            $model = LandingCost::model()->findAll(array('condition' => $condition, 'order' => 'parent_invoice_id'));
            $total = 0;
            $pre = 0;
            if (!empty($model)) {
                $table = '<table class="table table-fixed table-bordered table-primary dataTable">';
                $table .= '<thead><tr><th>Product</th><th style="text-align:right">Qty</th><th style="text-align:right">Rate</th><th style="text-align:right">Amount</th><th>Currency</th><th style="text-align:right">Ex.Rate</th><th style="text-align:right">Percent(%)</th><th style="text-align:right">Value(AED/Item)</th><th style="text-align:right">Amount(AED)</th></tr></thead>';
                $tot = 0;
                $percent = 0;
                $tot_val = 0;
                foreach ($model as $eachModel) {
                    if ($pre != $eachModel->parent_invoice_id) {
                        $table .= '<thead><tr><th>Purchase Invoice No : ' . $eachModel->purchase_invoice->id . '</th><th>Vendor : ' . $eachModel->purchase_invoice->vendor_details->vendor_name . '</th><th></th><th style="text-align:right">Grand Total : ' . Yii::app()->numberFormatter->formatCurrency($eachModel->purchase_invoice->grand_total, "") . '</th><th>Currency : ' . $eachModel->purchase_invoice->currencyname->currency_code . '</th><th style="text-align:right">Ex.Rate : ' . Yii::app()->numberFormatter->formatCurrency($eachModel->purchase_invoice->exchange_rate, "") . '</th><th></th><th></th><th style="text-align:right">Grand Total(AED) : ' . Yii::app()->numberFormatter->formatCurrency(($eachModel->purchase_invoice->grand_total * $eachModel->purchase_invoice->exchange_rate), "") . '</th></tr></thead>';
                        $tot += ($eachModel->purchase_invoice->grand_total * $eachModel->purchase_invoice->exchange_rate);
                    }
                    $table .= '<tr><th>' . $eachModel->product->part_number . '</th><th>' . $eachModel->quantity . '</th><th style="text-align:right">' . Yii::app()->numberFormatter->formatCurrency($eachModel->rate, "") . '</th><th style="text-align:right">' . Yii::app()->numberFormatter->formatCurrency($eachModel->amount, "") . '</th><th>' . $eachModel->currencyname->currency_code . '</th><th style="text-align:right">' . Yii::app()->numberFormatter->formatCurrency($eachModel->exchange_rate, "") . '</th><th style="text-align:right">' . Yii::app()->numberFormatter->formatCurrency(($eachModel->service_amount_percentage), "") . '%</th><th style="text-align:right">' . Yii::app()->numberFormatter->formatCurrency(($eachModel->service_invoice_value), "") . '</th><th style="text-align:right">' . Yii::app()->numberFormatter->formatCurrency(($eachModel->quantity * $eachModel->service_invoice_value), "") . '</th></tr>';
                    $pre = $eachModel->parent_invoice_id;
                    $percent += $eachModel->service_amount_percentage;
                    $tot_val += $eachModel->quantity * $eachModel->service_invoice_value;
                }
                $table .= '<tr><th style="text-align:right" colspan="6">Total (AED)</th><th style="text-align:right">' . Yii::app()->numberFormatter->formatCurrency($percent, "") . '%</th><th></th><th style="text-align:right">' . Yii::app()->numberFormatter->formatCurrency($tot_val, "") . '</th></tr>';
                $table .= '<tr><th style="text-align:right" colspan="8">Total Invoice Amount(AED)</th><th style="text-align:right">' . Yii::app()->numberFormatter->formatCurrency($tot, "") . '</th></tr>';
                $table .= '</table>';
            }
        }
        $data['tbl'] = $table;
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionCalculateLandingCostInvoices()
    {
        $landed_inv_id = $_POST['PurchasingInvoice']['purchase_invoice_id'];
        if ($landed_inv_id > 0) {
            //            $modelItems = PurchasingInvoice::model()->findAll(array('condition'=>'purchase_invoice_id like "%,'.$landed_inv_id.',%" OR purchase_invoice_id like "'.$landed_inv_id.',%" OR purchase_invoice_id like "%,'.$landed_inv_id.'" OR purchase_invoice_id = "'.$landed_inv_id.'"'));
            //
            //            foreach ($modelItems as $each)
            //            {
            //             $id=$each->id;
            $id = $landed_inv_id;
            $model = PurchasingInvoice::model()->findByPk($id);
            $product_id = '';
            $ids = explode(',', $model->purchase_invoice_id);
            foreach ($ids as $eachInvoice) {
                $invoice = PurchasingInvoice::model()->findByPk($eachInvoice);
                foreach ($invoice->items as $i => $eachItem) {
                    $landing_cost = Yii::app()->db->createCommand('select SUM(service_invoice_value) AS cost from {{landing_cost}} where parent_invoice_item_id =' . $eachItem->id . ' AND product_id=' . $eachItem->product_id)->queryScalar();
                    if ($landing_cost != 0) {
                        $cost_rate = $landing_cost + ($eachItem->rate * $invoice->exchange_rate);
                    }
                    if ($invoice->purchase_invoice == 'DP') {
                        $head = $invoice->id;
                    } else {
                        $head = $invoice->materialreceived;
                    }
                    StockLedger::model()->updateAll(array('cost_price' => $cost_rate), 'product_id=' . $eachItem->product_id . ' AND transaction_from ="QUALITY_CHECK" AND transaction_type ="IN" AND header_id ="' . $head . '"');
                    $store = Store::model()->findByPk($eachItem->product_id);
                    $SQL_AVG = 'select (SUM(cost_price*quantity)/SUM(quantity)) AS cost from {{stock_ledger}} where transaction_type ="IN" AND product_id=' . $eachItem->product_id;
                    $avg_stock_value = Yii::app()->db->createCommand($SQL_AVG)->queryScalar();
                    $store->rate = (float) $avg_stock_value;
                    $store->save(false);
                    if ($i > 0) {
                        $product .= ',' . $eachItem->product_id;
                    } else {
                        $product .= $eachItem->product_id;
                    }
                }
                $SQL = 'select invoice_id,invoice_date from {{invoice_item}} AS IT INNER JOIN {{invoice}} AS I ON IT.invoice_id=I.id where product_id IN (' . $product . ') group by invoice_id';
                $data = Yii::app()->db->createCommand($SQL)->queryAll();
                foreach ($data as $eachRow) {
                    $invoice_no = $eachRow['invoice_id'];
                    $invoice_date = $invoice->invoice_date;
                    $invoice_items = InvoiceItem::model()->findAll(array('condition' => 'invoice_id=' . $invoice_no));
                    $sales_cost_price = 0;
                    foreach ($invoice_items as $eachSalesItems) {
                        $qty = $eachSalesItems->quantity;
                        $stock = Yii::app()->db->createCommand("select SUM(cost_price*quantity)/SUM(quantity) from erp_stock_ledger where product_id='" . $eachSalesItems->product_id . "' AND quantity>0 AND (transaction_date>='" . $invoice_date . "')")->queryScalar();
                        InvoiceItem::model()->updateAll(array('cost_rate' => $stock), 'id=' . $eachSalesItems->id);
                        $sales_cost_price += ($stock * $qty);
                    }
                    Yii::app()->db->createCommand("update erp_finance_voucher_items I join erp_finance_voucher_head H on H.id=I.header_id set I.amount = '$sales_cost_price',I.currency_id=1,I.exchange_rate=1 WHERE H.voucher_type=7 AND H.voucher_no='$invoice_no' AND I.ledger_id=25")->execute();
                    Yii::app()->db->createCommand("update erp_finance_voucher_items I join erp_finance_voucher_head H on H.id=I.header_id set I.amount = '-$sales_cost_price',I.currency_id=1,I.exchange_rate=1 WHERE H.voucher_type=7 AND H.voucher_no='$invoice_no' AND I.ledger_id=7")->execute();
                }
            }
            //        }
        }
        $data['status'] = 'success';
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionGetAllServices()
    {
        $from = $_GET['frm'];
        $product_ids = $_GET['products'];
        $searchTerm = $_GET['term'];
        $condition = 't.isActive = "Y" AND ( inventory_item_type !=1 OR inventory_item_type=3 OR inventory_item_type=2) AND (part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%")';
        $model = new Store();
        $model = $model->with('tax')->findAll(array('condition' => $condition, 'limit' => 300));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number . ' : ' . $eachModel->description;
            $data[$i]['part_number'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->unit->id;
            $data[$i]['unit_name'] = $eachModel->unit->symbol;
            $data[$i]['tax_code'] = $eachModel->tax;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionEditInvoice()
    {
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = PurchasingInvoice::model()->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('edit_invoice', array('model' => $model));
    }

    public function actionUpdateinvoice()
    {
        if (isset($_POST['PurchasingInvoice'])) {
            $id = $_POST['PurchasingInvoice']['id'];
            //Audit Log
            PurchasingInvoice::model()->updateByPk($id, array('invoice_no' => $_POST['PurchasingInvoice']['invoice_no'], 'updated_by' => Yii::app()->user->id, 'updated_datetime' => date('Y-m-d h:i:s')));
            AuditLog::saveAuditLogs(
                'PURCHASE_INVOICE',
                Yii::app()->user->id,
                'UPDATED',
                " with ID: - {$id}  "
            );
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }




    public function actionEditCost()
    {
        $model = new PurchasingInvoice();
        $id = (int) Yii::app()->request->getParam('id');

        $modelItems = array(new PurchasingInvoiceItem);
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelItems = PurchasingInvoiceItem::model()->findAll(array('condition' => 'purchasing_invoice_id="' . $id . '"'));
            if (empty($modelItems)) {
                $modelItems = array(new PurchasingInvoiceItem);
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create_edit_cost', array('model' => $model, 'modelInvoiceItems' => $modelItems));
    }

    public function actionSaveEdittedCost()
    {
        $modelInvoice = new PurchasingInvoice();
        $modelItem = array(new PurchasingInvoiceItem());
        if (isset($_POST['PurchasingInvoice'])) {
            if ((int) $_POST['PurchasingInvoice']['id'] > 0) {
                $id = (int) $_POST['PurchasingInvoice']['id'];
                $modelInvoice = $modelInvoice->findByPK($id);
            }
            $grand_total = $total_net_value = 0;
            $valid = $modelInvoice->validate();
            if (is_array($_POST['PurchasingInvoiceItem'])) {
                foreach ($_POST['PurchasingInvoiceItem'] as $i => $item) {
                    $modelItem[$i] = new PurchasingInvoiceItem;
                    if ((int) $item['id'] > 0) {
                        $modelItem[$i] = $modelItem[$i]->findByPK((int) $item['id']);
                        $modelItem[$i]->rate = $item['rate'];
                        $modelItem[$i]->amount = $item['amount'];
                        $modelItem[$i]->tax_percentage = $item['tax_percentage'];
                        $modelItem[$i]->tax_amount = $item['tax_amount'];
                        $modelItem[$i]->net_amount = $item['net_amount'];
                        $total += $item['net_amount'];
                        $net_total += $item['net_amount'];
                        $valid = $modelItem[$i]->validate() && $valid;
                        $total_net_value += ($item['net_amount'] + $item['tax_amount']);
                    }
                }
            }
            if ($valid) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'PURCHASE_INVOICE',
                    Yii::app()->user->id,
                    'UPDATED',
                    " INV No: - {$modelInvoice->id} "
                );
                // end audit log
                $invoice_id = $modelInvoice->id;
                $file_id = $modelInvoice->file_id;
                $model_settings = new MasCompanySettings();
                $model_settings = $model_settings->find();
                if (!empty($model_settings)) {
                    $include_vat = $model_settings->include_vat;
                }
                $tot_tax = 0;
                $footer_value = 0;

                if (!empty($modelItem)) {
                    foreach ($modelItem as $eachItem) {
                        $eachItem->purchasing_invoice_id = $modelInvoice->id;
                        $eachItem->save(false);
                        $eachItem->refresh();
                        $grand_total += $eachItem->net_amount;
                        $tot_tax += $eachItem->tax_amount;

                        ($include_vat == 'Y') ? $actual_cost = ($eachItem->net_amount + $eachItem->tax_amount) : $actual_cost = $eachItem->net_amount;
                        $actual_cost_percentage = ($total_net_value > 0) ? $actual_cost / $total_net_value : 0;
                        $actual_cost_percentage = round($actual_cost_percentage, 6);
                        $item_footer_value = $actual_cost_percentage * $footer_value;
                        $total_item_net_value = $actual_cost + $item_footer_value;
                        $quantity_with_unit_factor = $eachItem->quantity * $eachItem->unitdetails->factor;
                        $variance_value = ($quantity_with_unit_factor > 0) ? $total_item_net_value / $quantity_with_unit_factor : 0;
                        $variance_value = round($variance_value, 6);
                        $cost_with_variance = $variance_value * $modelInvoice->exchange_rate;

                        $arr_stockledger = StockLedger::model()->findAll(array('condition' => 'product_id=' . (int) $eachItem->product_id . ' AND header_id=' . (int) $eachItem->mr_id . ' AND header_item_id=' . (int) $eachItem->mr_item_id . ' AND transaction_from="QUALITY_CHECK"', 'order' => 't.id asc'));
                        if (!empty($arr_stockledger)) {
                            foreach ($arr_stockledger as $i => $eachSLItem) {
                                if ($eachItem->unitdetails->factor > 0) {
                                    $buy_rate = $eachItem->rate / $eachItem->unitdetails->factor;
                                } else {
                                    $buy_rate = $eachItem->rate;
                                }
                                $buy_rate = $buy_rate * $modelInvoice->exchange_rate;
                                StockLedger::model()->updateByPk($eachSLItem['id'], array('stock_updated' => 'Y', 'cost_price' => (float) $cost_with_variance, 'buying_price' => $buy_rate));
                                StockLedger::model()->update_cost((int) $eachItem->product_id, $eachSLItem['id']);
                            }
                        }
                    }
                }
                $grand_total += $tot_tax;
                $modelInvoice->updateByPk($modelInvoice->id, array('grand_total' => $grand_total, 'total_tax_amount' => $tot_tax));
            } else {
                $error1 = $error2 = array();
                $error1 = json_decode(CActiveForm::validate($modelInvoice, '', false), true);
                if (!empty($modelItem[0]->product_id)) {
                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                } else {
                    $error2[] = "Please add atleast one line item";
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2));

                if ($error != '[]') {
                    echo $error;
                }
            }
            Yii::app()->end();
        } else {
            echo 'error';
        }
    }
    public function actionUploadPurchaseDocuments($folder = null)
    {



        Yii::import("ext.EAjaxUpload.qqFileUploader");

        $field_id = "";

        if (isset($_GET['field_id'])) {

            $field_id = Yii::app()->request->getParam('field_id');
        }
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';

        // make the directory to store the pic:

        if (!is_dir($folder)) {

            mkdir($folder, 0777, TRUE);
        }

        //$allowedExtensions = array("jpg", "jpeg", "gif","png","pdf"); //array("jpg","jpeg","gif","exe","mov" and etc...
        $allowedExtensions = array("png", "jpg", "jpeg", "gif", "pdf", "doc", "docx", "xls", "xlsx");

        $sizeLimit = 8 * 1024 * 1024; // maximum file size in bytes


        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        ////////////////////////////////////////
        // 💡 Add date prefix to file name
        if ($result['success']) {
            $originalFile = $result['filename'];
            $datePrefix = date('Y-m-d') . '-';
            $newFileName = $datePrefix . $originalFile;

            $oldPath = $folder . $originalFile;
            $newPath = $folder . $newFileName;

            // Rename the file on the server
            if (file_exists($oldPath)) {
                rename($oldPath, $newPath);
                $result['filename'] = $newFileName;
            }
        }
        ///////////////////////////////////////
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        echo $return; // it's array




    }

    // ------------------------start---------landing cost-----------------------------------------------------


    // LANDING COST
    public function actionDirectInvoice()
    {
        $model = new PurchasingInvoice();
        $id = (int) Yii::app()->request->getParam('id');

        $modelItems = array(new PurchasingInvoiceItem);
        $modelNotes = new FileNotes();
        $modelInvoiceItemsAdditions = array(new PurchasingInvoiceAddition);
        $modelInvoiceItemsDeductions = array(new PurchasingInvoiceDeduction);
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelItems = $model->items;
            $modelNotes = new FileNotes();
            $modelInvoiceItemsAdditions = PurchasingInvoiceAddition::model()->findAll(array('condition' => 'purchasing_invoice_id=' . $model->id));
            $modelInvoiceItemsDeductions = PurchasingInvoiceDeduction::model()->findAll(array('condition' => 'purchasing_invoice_id=' . $model->id));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('direct_create', array(
            'model' => $model,
            'file_id' => $file_id,
            'modelInvoiceItems' => $modelItems,
            'modelInvoiceItemsAdditions' => $modelInvoiceItemsAdditions,
            'modelInvoiceItemsDeductions' => $modelInvoiceItemsDeductions,
            'modelNotes' => $modelNotes,
            'modelmasterfile' => $modelmasterfile
        ));
    }


    public function actionSaveDirectinvoice()
    {
        $other = array();
        $valid = true;
        $modelInvoice = new PurchasingInvoice();
        //$modelItem = array(new PurchasingInvoiceItem());
        if ((int) $_POST['PurchasingInvoice']['id'] > 0) {
            $id = (int) $_POST['PurchasingInvoice']['id'];
            $modelInvoice = $modelInvoice->findByPk($id);
        }
        if (isset($_POST['PurchasingInvoice'])) {

            $total = $net_total = $tot_tax = 0;
            $modelInvoice->attributes = $_POST['PurchasingInvoice'];
            $modelInvoice->exchange_rate = $_POST['PurchasingInvoice']['exchange_rate'];
            $modelInvoice->currency = $_POST['PurchasingInvoice']['currency'];
            $modelInvoice->ticket_id = $_POST['PurchasingInvoice']['ticket_id'];
            $invoice_exchange_rate = $_POST['PurchasingInvoice']['exchange_rate'];

            if ($_POST['PurchasingInvoice']['invoice_date'] != '') {
                $modelInvoice->invoice_date = str_replace('/', '-', $_POST['PurchasingInvoice']['invoice_date']);
                $modelInvoice->invoice_date = date("Y-m-d", strtotime($modelInvoice->invoice_date));
            }
            if ($_POST['PurchasingInvoice']['payment_date'] != '') {
                $modelInvoice->payment_date = str_replace('/', '-', $_POST['PurchasingInvoice']['payment_date']);
                $modelInvoice->payment_date = date("Y-m-d", strtotime($modelInvoice->payment_date));
            }
            $modelInvoice->invoice_type = $_POST['PurchasingInvoice']['invoice_type'];
            $modelInvoice->crm_user_id = Yii::app()->user->id;
            $other_errors = array();
            $grand_total = $total_net_value = 0;
            $valid = $modelInvoice->validate();

            //   ---------------------AccAuditClose check------------------------------------


            $invoice_datex = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['PurchasingInvoice']['invoice_date'])));

            $modelAccAuditClose = new AccAuditClose();
            $existing_date = strtotime($modelAccAuditClose->lastCloseddate());
            $invoice_date = strtotime($invoice_datex);
            if ($invoice_date <= $existing_date) {
                $valid = false;
                $other[] = ' Given PurchasingInvoice date must be Greater than Audit Close Date :- ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';
            }
            //   --------------------//-AccAuditClose check------------------------------------

            if ($modelInvoice->lc_calulation == "Y") {
                $valid = false;
                $other[] = "Error in Save: This invoice is already LC calculated! Please refresh the page.";
            }

            if ((int)$_POST['PurchasingInvoice']['purchase_invoice_id'] <= 0) {
                $valid = false;
                $other[] = 'Purchase Invoice cannot be blank!';
            }

            /*$parent_invoice_ids = [$_POST['PurchasingInvoice']['purchase_invoice_id']];

            if (!empty($parent_invoice_ids)) {
                foreach ($parent_invoice_ids as $parent_invoices) {
                    $modelInvoiceeach = PurchasingInvoice::model()->findByPk($parent_invoices);

                    if ($modelInvoiceeach->lock_status == "Y") {
                        $valid = false;
                        $other[] = '"' . $parent_invoices . '":-This Parent Invoice in a Lock Status"';
                    }
                }
            }*/

            if ((int)$_POST['PurchasingInvoice']['purchase_invoice_id'] > 0) {

                $modelInvoiceeach = PurchasingInvoice::model()->findByPk((int)$_POST['PurchasingInvoice']['purchase_invoice_id']);
                if ($modelInvoiceeach->lock_status == "Y") {
                    $valid = false;
                    $other[] = '"' . $parent_invoices . '":-This Parent Invoice in a Lock Status"';
                }
            }

            $modelItem = [];

            if (is_array($_POST['PurchasingInvoiceItem'])) {
                foreach ($_POST['PurchasingInvoiceItem'] as $i => $item) {

                    if ($item['product_id'] > 0) {

                        $modelItem[$i] = new PurchasingInvoiceItem;

                        /*if (empty($item['id'])) {
                            $modelItem[$i] = new PurchasingInvoiceItem;
                        } 
                        else {
                            $modelItem[$i] = PurchasingInvoiceItem::model()->findByPk((int) $item['id']);
                        }*/


                        $modelItem[$i]->attributes = $_POST['PurchasingInvoiceItem'][$i];
                        $modelItem[$i]->tax_amount = $item['tax_amount'];

                        $modelItem[$i]->mr_id = $item['mr_id'];
                        $modelItem[$i]->mr_item_id = $item['mr_item_id'];
                        $modelItem[$i]->net_amount = (float) $item['amount'];
                        // $total += (float)$item['net_amount'];
                        // $net_total += (float)$item['net_amount'];
                        $tot_tax += (float) $item['tax_amount'];
                        $valid = $modelItem[$i]->validate() && $valid;
                        $total_net_value += ((float) $item['amount'] + (float) $item['tax_amount']);
                    }
                }
            }



            if (is_array($_POST['PurchasingInvoiceAddition'])) {
                foreach ($_POST['PurchasingInvoiceAddition'] as $i => $item) {
                    if (empty($item['id'])) {
                        $modelInvoiceAddition[$i] = new PurchasingInvoiceAddition;
                    } else {
                        $modelInvoiceAddition[$i] = PurchasingInvoiceAddition::model()->findByPk($item['id']);
                    }
                    $modelInvoiceAddition[$i]->attributes = $_POST['PurchasingInvoiceAddition'][$i];
                    $modelInvoiceAddition[$i]->particular = $item['particular'];
                    $modelInvoiceAddition[$i]->particular_value = $item['particular_value'];
                    $modelInvoiceAddition[$i]->calculated_value = $item['calculated_value'];

                    //  $net_total += $item['calculated_value'];
                    $valid = $modelInvoiceAddition[$i]->validate() && $valid;
                }
                $modelsToBeValidated[] = $modelInvoiceAddition;
            }
            if (is_array($_POST['PurchasingInvoiceDeduction'])) {
                foreach ($_POST['PurchasingInvoiceDeduction'] as $i => $item) {
                    if (empty($item['id'])) {
                        $modelInvoiceDeduction[$i] = new PurchasingInvoiceDeduction;
                    } else {
                        $modelInvoiceDeduction[$i] = PurchasingInvoiceDeduction::model()->findByPk($item['id']);
                    }
                    $modelInvoiceDeduction[$i]->attributes = $_POST['PurchasingInvoiceDeduction'][$i];

                    $modelInvoiceDeduction[$i]->particular = $item['particular'];
                    $modelInvoiceDeduction[$i]->particular_value = $item['particular_value'];
                    $modelInvoiceDeduction[$i]->calculated_value = $item['calculated_value'];

                    // $net_total -= $item['calculated_value'];
                    $valid = $modelInvoiceDeduction[$i]->validate() && $valid;
                }
                $modelsToBeValidated[] = $modelInvoiceDeduction;
            }
            if ($valid) {
                if (isset($_POST['PurchasingInvoice']['file_id']) && $_POST['PurchasingInvoice']['file_id'] > 0) {
                    MasterFile::model()->updateByPk($_POST['PurchasingInvoice']['file_id'], array('current_process_status' => 'P_I'));
                    $modelInvoice->file_id = $_POST['PurchasingInvoice']['file_id'];
                } else {
                    $modelfile = new MasterFile();
                    $modelfile->start_from = "P_I";
                    $modelfile->crm_user_id = Yii::app()->user->id;
                    $modelfile->customer_id = $modelInvoice->vendor_id;
                    $modelfile->file_title = $modelInvoice->title;
                    $modelfile->current_process_status = "P_I";
                    $modelfile->is_approved = "Y";
                    $modelfile->approved_by = Yii::app()->user->id;
                    $modelfile->date_of_approval = date('Y-m-d');
                    $modelfile->save(false);
                    $modelInvoice->file_id = $modelfile->id;
                }


                //  $parent_invoice_ids = $_POST['PurchasingInvoice']['purchase_invoice_id'];

                //REVERSE CALCULATION OF LANDING COST
                // if (!empty($modelInvoice->purchase_invoice_id)) {
                if ((int)$modelInvoice->purchase_invoice_id > 0) {
                    LandingCost::model()->deleteAll(array('condition' => 'service_invoice_id=' . $modelInvoice->id));
                    // $ids = explode(',', $modelInvoice->purchase_invoice_id);
                    $eachInvoice = $modelInvoice->purchase_invoice_id;
                    //    foreach ($ids as $eachInvoice) {
                    if ((int) $eachInvoice > 0) {
                        $invoice = PurchasingInvoice::model()->findByPk($eachInvoice);
                        foreach ($invoice->items as $i => $eachItem) {
                            $cost_rate = ($eachItem->rate * $invoice->exchange_rate);
                            /* if ($invoice->purchase_invoice == 'DP') {
                                    $head = $invoice->id;
                                } else {
                                    $head = $invoice->materialreceived;
                                }*/

                            if ((int)$invoice->materialreceived > 0) {
                                $head = $invoice->materialreceived;
                            } else {
                                $head = $invoice->id;
                            }

                            // StockLedger::model()->updateAll(array('cost_price' => $cost_rate), 'product_id=' . $eachItem->product_id . ' AND transaction_type ="PURCHASE"' . ' AND header_id ="' . $head . '"');
                            StockLedger::model()->updateAll(array('cost_price' => $cost_rate), 'product_id=' . $eachItem->product_id . ' AND transaction_type ="QUALITY_CHECK"' . ' AND header_id ="' . $head . '"');
                            $store = Store::model()->findByPk($eachItem->product_id);
                            $SQL_AVG = 'select (SUM(cost_price*quantity)/SUM(quantity)) AS cost from {{stock_ledger}} where quantity > 0 AND product_id=' . $eachItem->product_id;
                            $avg_stock_value = Yii::app()->db->createCommand($SQL_AVG)->queryScalar();
                            $store->rate = (float) $avg_stock_value;
                            $store->save(false);
                            if ($i > 0) {
                                $product .= ',' . $eachItem->product_id;
                            } else {
                                $product .= $eachItem->product_id;
                            }
                        }
                        /*if (!empty($product)) {
                                $SQL = 'select invoice_id,invoice_date from {{invoice_item}} AS IT INNER JOIN {{invoice}} AS I ON IT.invoice_id=I.id where product_id IN (' . $product . ') group by invoice_id';
                                $data = Yii::app()->db->createCommand($SQL)->queryAll();
                                foreach ($data as $eachRow) {
                                    $invoice_no = $eachRow['invoice_id'];
                                    $invoice_date = $invoice->invoice_date;
                                    $invoice_items = InvoiceItem::model()->findAll(array('condition' => 'invoice_id=' . $invoice_no));
                                    $sales_cost_price = 0;
                                    foreach ($invoice_items as $eachSalesItems) {
                                        $qty = $eachSalesItems->quantity;
                                        $stock = Yii::app()->db->createCommand("select SUM(cost_price*quantity)/SUM(quantity) from erp_stock_ledger where product_id='" . $eachSalesItems->product_id . "' AND quantity>0 AND (transaction_date>='" . $invoice_date . "')")->queryScalar();
                                        InvoiceItem::model()->updateAll(array('cost_rate' => $stock), 'id=' . $eachSalesItems->id);
                                        $sales_cost_price += ($stock * $qty);
                                    }
                                    // Yii::app()->db->createCommand("update erp_finance_voucher_items I join erp_finance_voucher_head H on H.id=I.header_id set I.amount = '$sales_cost_price' WHERE H.voucher_type=7 AND H.voucher_no='$invoice_no' AND I.ledger_id=105")->execute();
                                    // Yii::app()->db->createCommand("update erp_finance_voucher_items I join erp_finance_voucher_head H on H.id=I.header_id set I.amount = '-$sales_cost_price' WHERE H.voucher_type=7 AND H.voucher_no='$invoice_no' AND I.ledger_id=10")->execute();
                                }
                            }*/
                    }
                    // }
                }

                //END REVERSE CALCULATION OF LANDING COST
                /* if (!empty($parent_invoice_ids)) {

                    $modelInvoice->purchase_invoice_id = implode(",", $parent_invoice_ids);
                }*/
                $modelInvoice->purchase_invoice_id = $_POST['PurchasingInvoice']['purchase_invoice_id'];
                $modelInvoice->purchase_invoice = 'LC';
                $modelInvoice->save();

                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'PURCHASE_INVOICE',
                    Yii::app()->user->id,
                    'CREATED',
                    " INV No: - {$modelInvoice->id} "
                );
                // end audit log

                $invoice_id = $modelInvoice->id;
                $file_id = $modelInvoice->file_id;
                $model_settings = new MasCompanySettings();
                $model_settings = $model_settings->find();
                if (!empty($model_settings)) {
                    $include_vat = $model_settings->include_vat;
                }
                $tot_of_net = $tot_tax = 0;
                $old_total_qty = $old_rate = array();
                $footer_value = 0;
                if (!empty($modelInvoiceAddition)) {
                    foreach ($modelInvoiceAddition as $eachModel) {
                        $eachModel->purchasing_invoice_id = $modelInvoice->id;
                        $eachModel->save();
                        $grand_total += $eachModel->calculated_value;
                        $footer_value += $eachModel->calculated_value;
                    }
                }
                if (!empty($modelInvoiceDeduction)) {
                    foreach ($modelInvoiceDeduction as $eachModel) {
                        $eachModel->purchasing_invoice_id = $modelInvoice->id;
                        $eachModel->save();
                        $grand_total -= $eachModel->calculated_value;
                        $footer_value -= $eachModel->calculated_value;
                    }
                }

                PurchasingInvoiceItem::model()->deleteAll('purchasing_invoice_id=:refer_id', array(':refer_id' => $modelInvoice->id));

                if (!empty($modelItem)) {



                    foreach ($modelItem as $eachItem) {
                        $eachItem->purchasing_invoice_id = $modelInvoice->id;
                        $eachItem->save(false);
                        $sales_item_id = $eachItem->id;
                        $eachItem->fill_up_previous();

                        $grand_total += $eachItem->amount;
                        $tot_of_net += $eachItem->amount;
                        $tot_tax += $eachItem->tax_amount;
                        $modelStore = Store::model()->findBypk($eachItem->product_id);

                        $rate = $modelStore->rate;
                        $old_qty = $modelStore->totalQuantity;

                        ($include_vat == 'Y') ? $actual_cost = ($eachItem->net_amount + $eachItem->tax_amount) : $actual_cost = $eachItem->net_amount;
                        $actual_cost_percentage = ($total_net_value > 0) ? $actual_cost / $total_net_value : 0;
                        $actual_cost_percentage = round($actual_cost_percentage, 6);
                        $item_footer_value = $actual_cost_percentage * $footer_value;
                        $total_item_net_value = $actual_cost + $item_footer_value;
                        $quantity_with_unit_factor = $eachItem->quantity * $eachItem->unitdetails->factor;
                        $variance_value = ($quantity_with_unit_factor > 0) ? $total_item_net_value / $quantity_with_unit_factor : 0;
                        $variance_value = round($variance_value, 6);
                        $cost_with_variance = $variance_value * $modelInvoice->exchange_rate;

                        $cur_total = $cost_with_variance * $quantity_with_unit_factor;
                        $old_net_amount = $rate * $old_qty;
                        $total_quantity = $old_qty + $quantity_with_unit_factor;
                        $total_amount = $old_net_amount + $cur_total;
                        $new_amount = ($total_quantity > 0) ? $total_amount / $total_quantity : 0;
                        $new_amount = round($new_amount, 6);
                        Store::model()->updateByPk($eachItem->product_id, array('rate' => $new_amount));
                        if ($sales_item_id > 0) {
                            StockLedger::model()->deleteAll(array('condition' => 'header_id=' . $modelInvoice->id . ' AND header_item_id=0 AND product_id=' . $eachItem->product_id));
                            StockLedger::model()->deleteAll(array('condition' => 'header_id=' . $modelInvoice->id . ' AND header_item_id=' . $sales_item_id . ' AND product_id=' . $eachItem->product_id));
                        }
                        $stockLedger = new StockLedger;
                        $stockLedger->header_id = $modelInvoice->id;
                        $stockLedger->header_item_id = $sales_item_id;
                        $stockLedger->transaction_date = date('Y-m-d');
                        $stockLedger->transaction_type = 'IN';
                        $stockLedger->transaction_from = 'LANDING_COST';
                        $stockLedger->product_id = $eachItem->product_id;
                        $stockLedger->quantity = $eachItem->quantity;
                        $stockLedger->unit_factor = 1;
                        // $stockLedger->product_location_id   = 0;
                        $stockLedger->unit_id = $modelStore->unit_id;
                        $stockLedger->warehouse_id = $modelStore->warehouse_id;
                        $stockLedger->rack_id = 0;
                        $stockLedger->bin_id = 0;
                        $stockLedger->created_by = Yii::app()->user->id;
                        $stockLedger->created_date = date('Y-m-d h:i:s');
                        $stockLedger->cost_price = $eachItem->rate;
                        $stockLedger->buying_price = $eachItem->rate;
                        $stockLedger->save(false);
                    }
                }

                $tot_of_net += $tot_tax;
                $total_net_value = $tot_of_net;
                //$net_total += $tot_tax;
                $grand_total += $tot_tax;
                $modelInvoice->updateByPk($modelInvoice->id, array('grand_total' => $grand_total, 'total_tax_amount' => $tot_tax));
                //code added by mereena on 06/04/2020
                if (isset($_POST['PurchasingInvoice']['po_id']) && $_POST['PurchasingInvoice']['po_id'] > 0) {
                    PurchasingOrder::model()->updateByPk($_POST['PurchasingInvoice']['po_id'], array('convert_status' => 'N'));
                }
                //end
                // Landing Cost Calculation
                if (!empty($modelInvoice->purchase_invoice_id)) {
                    LandingCost::model()->deleteAll(array('condition' => 'service_invoice_id=' . $modelInvoice->id));
                    $modelInvoice = PurchasingInvoice::model()->findByPk((int) $modelInvoice->id);
                    $grand_total = ((float) $modelInvoice->grand_total - (float) $modelInvoice->total_tax_amount) * (float) $modelInvoice->exchange_rate;
                    $SQL_GrandTotal = 'select (SUM(grand_total*exchange_rate)) AS tot from {{purchasinginvoice}} where id IN (' . $modelInvoice->purchase_invoice_id . ')';
                    $AllInvoiceGrandTotal = Yii::app()->db->createCommand($SQL_GrandTotal)->queryScalar();
                    $SQL_NetVatOrg = 'select (SUM(t.tax_amount*I.exchange_rate)) AS tot from {{purchasinginvoice_item}} t INNER JOIN {{purchasinginvoice}} I ON t.purchasing_invoice_id=I.id where t.purchasing_invoice_id IN (' . $modelInvoice->purchase_invoice_id . ')';
                    $NetVatOrg = Yii::app()->db->createCommand($SQL_NetVatOrg)->queryScalar();
                    //  foreach ($parent_invoice_ids as $eachInvoice) {
                    $eachInvoice = (int)$modelInvoice->purchase_invoice_id;

                    $invoice = PurchasingInvoice::model()->findByPk($eachInvoice);
                    foreach ($invoice->items as $eachItem) {
                        $landing_cost_item = 0;
                        $item_percentage = ($eachItem->amount * $invoice->exchange_rate) / ($AllInvoiceGrandTotal - $NetVatOrg);
                        $landing_cost_item = ($item_percentage * $grand_total) / $eachItem->quantity;
                        $modelLandingCost = new LandingCost;
                        $modelLandingCost->parent_invoice_id = $invoice->id;
                        $modelLandingCost->parent_invoice_item_id = $eachItem->id;
                        $modelLandingCost->product_id = $eachItem->product_id;
                        $modelLandingCost->service_invoice_id = $modelInvoice->id;
                        $modelLandingCost->quantity = $eachItem->quantity;
                        $modelLandingCost->rate = $eachItem->rate;
                        $modelLandingCost->amount = $eachItem->amount;
                        $modelLandingCost->currency = $invoice->currency;
                        $modelLandingCost->exchange_rate = $invoice->exchange_rate;
                        $modelLandingCost->service_amount_percentage = 100 * $item_percentage;
                        $modelLandingCost->service_invoice_value = $landing_cost_item;
                        $modelLandingCost->created_by = Yii::app()->user->id;
                        $time = date('Y-m-d H:i:s');
                        $timestamp = strtotime($time) + 4 * 60 * 60;
                        $time = date('Y-m-d H:i:s', $timestamp);
                        $modelLandingCost->created_date_time = $time;
                        $modelLandingCost->save(false);
                    }
                    // }
                }
                // End Landing Cost Calculation
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                if (is_array($_POST['materialreceiptfileId'])) {
                    foreach ($_POST['materialreceiptfileId'] as $i => $each) {
                        PurchasingMaterialreceipt::model()->updateByPk((int) $each, array('is_convertable' => 'N'));
                    }
                }
            } else {
                $error1 = $error2 = $error3 = $error4 = array();
                $error1 = json_decode(CActiveForm::validate($modelInvoice, '', false), true);
                if (!empty($modelItem[0]->product_id)) {
                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                } else {
                    $error2[] = "Please add atleast one line item";
                }

                if (!empty($modelInvoiceAddition)) {
                    $error3 = json_decode(CActiveForm::validateTabular($modelInvoiceAddition, '', false), true);
                }

                if (!empty($modelInvoiceDeduction)) {
                    $error4 = json_decode(CActiveForm::validateTabular($modelInvoiceDeduction, '', false), true);
                }

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4, $other));

                if ($error != '[]') {
                    echo $error;
                }
            }
            Yii::app()->end();
        } else {
            echo 'error';
        }
    }

    public function actionGetunitdrop()
    {
        $row = $_POST['row_field'];
        $product_id = (int) $_POST['product_id'];
        $drop = array();
        $modelOrder = new PurchasingInvoiceItem;
        $modelUOM = new UnitOfMeasurement();
        if ($product_id > 0) {

            //code added by mereena on 07/09/2022 to get default purchase unit_id
            $modelStore = new Store();
            $modelStore = $modelStore->findByPk($product_id);
            //   $default_purchase_unit_id = (int) $modelStore->default_purchase_unit_id;
            $default_purchase_unit_id = (int) $modelStore->unit_id;
            //end

            if ($default_purchase_unit_id > 0) {
                $modelOrder->unit = $default_purchase_unit_id;
            } else {
                $modelOrder->unit = $modelUOM->getSecondaryBaseunit($product_id);
            }

            $drop['drop'] = CHtml::activedropdownlist($modelOrder, "[" . $row . "]unit", $modelUOM->getUnits($product_id), array('class' => 'unit go'));
        }
        echo CJSON::encode($drop);
    }

    public function actionViewCalculateLCInvoice()
    {
        $model = new PurchasingInvoice();
        $id = (int) Yii::app()->request->getParam('id');
        $modelItems = array(new PurchasingInvoiceItem);
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelItems = PurchasingInvoiceItem::model()->findAll(array('condition' => 'purchasing_invoice_id="' . $id . '"'));
            if (empty($modelItems)) {
                $modelItems = array(new PurchasingInvoiceItem);
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('view_landingcost_calculation', array('model' => $model, 'modelItems' => $modelItems, 'id' => $id));
    }



    public function actionCalculateLcPurchaseInvoice()
    {
        $id = $_POST['PurchasingInvoice']['id'];


        if ($id > 0) {
            $modelInvoice = PurchasingInvoice::model()->with('items')->findByPk($id);
            if ($modelInvoice->posted == 'Y') {
                $jsonData['status'] = 'Error In Calculate LC,  This Invoice was Posted to the Finance! Please refresh the page.';
                echo CJSON::encode($jsonData);
            } else if ($modelInvoice->purchase_invoice !== 'LC') {
                $jsonData['status'] = "Error In Calculate LC: This invoice is not in LC status! Please refresh the page.";
                echo CJSON::encode($jsonData);
            } else if ((int) $modelInvoice->purchase_invoice_id <= 0) {
                $jsonData['status'] = "Error In Calculate LC: Purchase Invoice cannot be blank.";
                echo CJSON::encode($jsonData);
            } else if ($modelInvoice->lc_calulation == 'Y') {
                $jsonData['status'] = "Error in calculating LC: Purchase invoice has already been calculated. Please refresh the page.";
                echo CJSON::encode($jsonData);
            } else {

                //   ------------------------------------------------------------------------
                //calculate landing cost
                //   ------------------------------------------------------------------------

                $product_id = '';
                //  $ids = explode(',', $modelInvoice->purchase_invoice_id);
                //   foreach ($ids as $eachInvoice) {
                $eachInvoice = (int) $modelInvoice->purchase_invoice_id;




                $invoice = PurchasingInvoice::model()->findByPk($eachInvoice);



                foreach ($invoice->items as $i => $eachItem) {
                    $landing_cost = Yii::app()->db->createCommand('select SUM(service_invoice_value) AS cost from {{landing_cost}} where   parent_invoice_item_id =' . $eachItem->id . ' AND product_id=' . $eachItem->product_id)->queryScalar();//0.2

                    if ($landing_cost != 0) {
                        $cost_rate = ($landing_cost + $eachItem->rate) * $invoice->exchange_rate;
                    }
                    /*if ($invoice->purchase_invoice == 'DP') {
                        $head = $invoice->id;
                    } else {
                        $head = $invoice->materialreceived;
                    }*/

                    if ((int) $invoice->materialreceived > 0) {
                        $head = $invoice->materialreceived;
                    } else {
                        $head = $invoice->id;
                    }

                    
                    
                    StockLedger::model()->updateAll(array('cost_price' => $cost_rate, 'stock_updated' => "Y"), 'product_id=' . $eachItem->product_id . ' AND transaction_from ="QUALITY_CHECK" AND  transaction_type ="IN" AND header_id ="' . $head . '"');//stock_updated ="Y" AND
                    $store = Store::model()->findByPk($eachItem->product_id);
                    $SQL_AVG = 'select (SUM(cost_price*quantity)/SUM(quantity)) AS cost from {{stock_ledger}} where transaction_type ="IN" AND product_id=' . $eachItem->product_id;
                    $avg_stock_value = Yii::app()->db->createCommand($SQL_AVG)->queryScalar();
                    $store->rate = (float) $avg_stock_value;
                    $store->save(false);
                    if ($i > 0) {
                        $product .= ',' . $eachItem->product_id;
                    } else {
                        $product .= $eachItem->product_id;
                    }
                }
                PurchasingInvoice::model()->updateByPk($eachInvoice, array('lock_status' => 'Y'));

                /* $SQL = 'select invoice_id,invoice_date from {{invoice_item}} AS IT INNER JOIN {{invoice}} AS I ON IT.invoice_id=I.id where product_id IN (' . $product . ') group by invoice_id';
                  $data = Yii::app()->db->createCommand($SQL)->queryAll();
                  foreach ($data as $eachRow) {
                  $invoice_no    = $eachRow['invoice_id'];
                  $invoice_date  = $invoice->invoice_date;
                  $invoice_items = InvoiceItem::model()->findAll(array('condition' => 'invoice_id=' . $invoice_no));
                  $sales_cost_price = 0;
                  foreach ($invoice_items as $eachSalesItems) {
                  $qty   = $eachSalesItems->quantity;
                  $stock = Yii::app()->db->createCommand("select SUM(cost_price*quantity)/SUM(quantity) from erp_stock_ledger where product_id='" . $eachSalesItems->product_id . "' AND quantity>0 AND (transaction_date>='" . $invoice_date . "')")->queryScalar();
                  InvoiceItem::model()->updateAll(array('cost_rate' => $stock), 'id=' . $eachSalesItems->id);
                  $sales_cost_price += ($stock * $qty);
                  }
                  // Yii::app()->db->createCommand("update erp_finance_voucher_items I join erp_finance_voucher_head H on H.id=I.header_id set I.amount = '$sales_cost_price',I.currency_id=1,I.exchange_rate=1 WHERE H.voucher_type=7 AND H.voucher_no='$invoice_no' AND I.ledger_id=25")->execute();
                  // Yii::app()->db->createCommand("update erp_finance_voucher_items I join erp_finance_voucher_head H on H.id=I.header_id set I.amount = '-$sales_cost_price',I.currency_id=1,I.exchange_rate=1 WHERE H.voucher_type=7 AND H.voucher_no='$invoice_no' AND I.ledger_id=7")->execute();
                  } */
                // }

                $sql = "UPDATE `erp_purchasinginvoice` 
                        SET `lc_calulation` = 'Y' 
                        WHERE `purchase_invoice_id` = :purchase_invoice_id 
                        AND `purchase_invoice` = 'LC'";

                $command = Yii::app()->db->createCommand($sql);
                $command->bindValue(':purchase_invoice_id', (int) $modelInvoice->purchase_invoice_id, PDO::PARAM_INT);
                $command->execute();

                //$modelInvoice->lc_calulation = "Y";
                //$modelInvoice->save(false);

                // ------------------------------------
                if ($invoice->posted == 'N') {
                    Yii::import('application.modules.accounts.controllers.PostingController');
                    $from = 'purchase';
                    PostingController::DirectPost((int) $invoice->id, $from);
                }

                // ---------------------------------------------------------------
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }
        } else {
            $jsonData['status'] = "Error In Calculate LC: This invoice ID is Missing!";
            echo CJSON::encode($jsonData);
        }
    }

    public function actionViewLandingCost()
    {
        $id = Yii::app()->request->getParam('id');
        if ($id > 0) {
            $condition = 'parent_invoice_id=' . $id;
            $model = LandingCost::model()->findAll(array('condition' => $condition, 'order' => 'product_id'));
            $total = 0;
            $pre = 0;
            if (!empty($model)) {
                $table = '<table class="table table-fixed table-bordered table-primary dataTable">';
                $table .= '<thead><tr><th>Invoice</th><th>Vendor</th><th style="text-align:right">Grand Total</th><th>Currency</th><th>Ex.Rate</th><th style="text-align:right">Grand Total(' . MasCurrency::base_currency_code() . ')</th><th style="text-align:right">Value(' . MasCurrency::base_currency_code() . '/Item)</th><th style="text-align:right">Amount(' . MasCurrency::base_currency_code() . ')</th></tr></thead>';
                if (!empty($model)) {
                    foreach ($model as $i => $eachModel) {
                        if ($pre != $eachModel->product_id) {
                            if ($i != 0) {
                                $table .= '<tr><th style="text-align:right" colspan="6">Total (' . MasCurrency::base_currency_code() . ')</th><th style="text-align:right">' . number_format($tot_val, 3, ".", "") . '</th><th style="text-align:right">' . number_format($tot, 3, ".", "") . '</th></tr>';
                                $table .= '<tr><th style="text-align:right" colspan="6">Before Landed Cost (' . MasCurrency::base_currency_code() . ')</th><th style="text-align:right">' . number_format($product_rate, 3, ".", "") . '</th><th style="text-align:right">'  . number_format($product_amount, 3, ".", "") . '</th></tr>';
                                $table .= '<tr><th style="text-align:right" colspan="6">After Landed Cost (' . MasCurrency::base_currency_code() . ')</th><th style="text-align:right">' . number_format($product_rate + $tot_val, 3, ".", "") . '</th><th style="text-align:right">' . number_format($product_amount + $tot, 3, ".", "") . '</th></tr>';
                            }
                            $tot_val = 0;
                            $tot = 0;
                            $product_rate = $eachModel->rate * $eachModel->exchange_rate;
                            $product_amount = $eachModel->amount * $eachModel->exchange_rate;
                            $table .= '<thead><tr><th>Product : ' . $eachModel->product->part_number . '/' . $eachModel->product->description . '</th><th>Qty : ' . $eachModel->quantity . '</th><th style="text-align:right">Rate : ' . $eachModel->rate . '</th><th>' . $eachModel->currencyname->currency_code . '</th><th style="text-align:right">' . number_format(($eachModel->exchange_rate), 3, ".", "") . '</th><th style="text-align:right"> Item(%) : ' . number_format(($eachModel->service_amount_percentage), 3, ".", "") . '%</th><th style="text-align:right" colspan="2">Amount(' . MasCurrency::base_currency_code() . ') : ' . number_format(($eachModel->amount * $eachModel->exchange_rate), 3, ".", "") . ' Item(%) : ' . number_format($eachModel->service_amount_percentage, 3, ".", "") . '%</th></tr></thead>';
                        }
                        $table .= '<tr><th>' . $eachModel->service_invoice->id . '</th><th>' . $eachModel->service_invoice->vendor_details->vendor_name . '</th><th style="text-align:right">' . number_format($eachModel->service_invoice->grand_total, 3, ".", "") . '</th><th>' . $eachModel->service_invoice->currencyname->currency_code . '</th><th style="text-align:right">'  . number_format($eachModel->service_invoice->exchange_rate, 3, ".", "") . '</th><th style="text-align:right">' . number_format($eachModel->service_invoice->grand_total * $eachModel->service_invoice->exchange_rate, 3, ".", "") . '</th><th style="text-align:right">' . number_format($eachModel->service_invoice_value, 3, ".", "") . '</th><th style="text-align:right">' . number_format(($eachModel->quantity * $eachModel->service_invoice_value), 3, ".", "") . '</th></tr>';
                        $pre = $eachModel->product_id;
                        $tot_val += $eachModel->service_invoice_value;
                        $tot += $eachModel->quantity * $eachModel->service_invoice_value;
                    }
                    $table .= '<tr><th style="text-align:right" colspan="6">Total (' . MasCurrency::base_currency_code() . ')</th><th style="text-align:right">' . number_format($tot_val, 3, ".", "") . '</th><th style="text-align:right">' . number_format($tot, 3, ".", "") . '</th></tr>';
                    $table .= '<tr><th style="text-align:right" colspan="6">Before Landed Cost (' . MasCurrency::base_currency_code() . ')</th><th style="text-align:right">' . number_format($product_rate, 3, ".", "") . '</th><th style="text-align:right">'  . number_format($product_amount, 3, ".", "") . '</th></tr>';
                    $table .= '<tr><th style="text-align:right" colspan="6">After Landed Cost (' . MasCurrency::base_currency_code() . ')</th><th style="text-align:right">' . number_format($product_rate + $tot_val, 3, ".", "") . '</th><th style="text-align:right">' . number_format($product_amount + $tot, 3, ".", "") . '</th></tr>';
                    $table .= '</table>';
                }
            } else {
                $table .= '<tr><th style="text-align:right" colspan="6"></th><th style="text-align:right"></th><th style="text-align:center"><b>Empty</b></th></tr>';
            }
        }
        $this->render('landingcost_view', array('data' => $table));
    }


    public function actionLockInvoice()
    {
        $model = new PurchasingInvoice();
        $id = (int) Yii::app()->request->getParam('id');
        $modelItems = array(new PurchasingInvoiceItem);
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelItems = PurchasingInvoiceItem::model()->findAll(array('condition' => 'purchasing_invoice_id="' . $id . '"'));
            if (empty($modelItems)) {
                $modelItems = array(new PurchasingInvoiceItem);
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('lock_purchaseinvoice', array(
            'id' => $id,
            'model' => $model,
            'modelInvoiceItems' => $modelItems,
        ));
    }

    public function actionUnLockInvoice()
    {
        $model = new PurchasingInvoice();
        $id = (int) Yii::app()->request->getParam('id');
        $modelItems = array(new PurchasingInvoiceItem);
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelItems = PurchasingInvoiceItem::model()->findAll(array('condition' => 'purchasing_invoice_id="' . $id . '"'));
            if (empty($modelItems)) {
                $modelItems = array(new PurchasingInvoiceItem);
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('unlock_purchaseinvoice', array(
            'id' => $id,
            'model' => $model,
            'modelInvoiceItems' => $modelItems,
        ));
    }


    public function actionsaveLockPurchase()
    {
        $other = array();
        $valid = true;
        $purchase_id = $_POST['purchase_id'];

        // Step 1: Check if the purchase invoice is of type 'LC' and if the purchase ID is found in the invoice ID list
        $sql = "SELECT id, purchase_invoice_id 
              FROM `erp_purchasinginvoice` 
              WHERE `purchase_invoice` = 'LC' 
              AND FIND_IN_SET('$purchase_id', `purchase_invoice_id`)";
        $command_acc = Yii::app()->db->createCommand($sql);
        $inv_list = $command_acc->queryAll();
        $purchaseInvoiceIdsArray = [];

        // Step 2: If such invoices exist, mark as invalid and add an error message
        if (!empty($inv_list)) {
            $valid = false;
            $other[] = "Can't submit here; please calculate in showing LCs";
        } else {
            $product_error = [];
            $update_status = true;

            // Step 3: Retrieve the purchasing invoice model and its related items using the purchase ID
            $modelInvoice = PurchasingInvoice::model()->with('items')->findByPk($purchase_id);

            // Step 4: Check if the invoice is not locked, proceed with quantity validation      
            if ($modelInvoice->lock_status == 'N') {
                /*foreach ($modelInvoice->items as $i => $eachItem) {
                    // Step 5: Fetch available quantity for each product in the invoice
                    $available_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity * unit_factor), 0) as available_qty 
                                                                          FROM `erp_stock_ledger` 
                                                                          WHERE product_id = ' . $eachItem['product_id'])->queryScalar();
                    // Step 6: If available quantity is zero or less, set error flag and stop the process
                    if ((float) $available_qty <= 0) {
                        $available_qty = round($available_qty, 2);
                        $store = Store::model()->findByPk($eachItem->product_id);
                        $valid = false;
                        $other[] = "Error in Save: Available Quantity is less: $available_qty for product $store->part_number";
                        $product_error[] = $eachItem->product_id;
                        $update_status = false; // Stop further status update if there's a product with insufficient quantity
                        break;  // Step 7: Exit the loop once an invalid product is found
                    }
                }*/
            } else {
                // Step 8: If the invoice is already locked, add an error message
                $valid = false;
                $other[] = "Error in Save: This invoice is  In Lock Status: $modelInvoice->id";
            }
        }

        // Step 9: If validation is successful, proceed to update the lock status
        if ($valid) {
            // Step 10: If no product errors, update the invoice's lock status
            if ($update_status) {
                $modelInvoice = PurchasingInvoice::model()->findByPk($purchase_id);
                $modelInvoice->lock_status = "Y";
                $modelInvoice->save(false);

                // Step 11: Update stock ledger stock_updated = "Y" 
                $materialreceived = $modelInvoice->materialreceived;
                $file_id = $modelInvoice->file_id;

                $sql = 'UPDATE `erp_stock_ledger` 
                              SET stock_updated = "Y" 
                              WHERE `header_id` = "' . $materialreceived . '" 
                              AND file_id = "' . $file_id . '" 
                              AND transaction_from = "QUALITY_CHECK"';
                Yii::app()->db->createCommand($sql)->execute();
            }


            AuditLog::saveAuditLogs(
                'PURCHASE_INVOICE',
                Yii::app()->user->id,
                'UPDATED',
                " INV No: - {$purchase_id} "
            );

            // ------------------------------------
            if ($modelInvoice->posted == 'N') {
                Yii::import('application.modules.accounts.controllers.PostingController');
                $from = 'purchase';
                PostingController::DirectPost((int) $modelInvoice->id, $from);
            }

            // ---------------------------------------------------------------


            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        } else {
            // Step 14: If errors occurred, return the error messages in JSON format
            $error = CJSON::encode(array_merge_recursive($other));
            if ($error != '[]') {
                echo $error;
            }
        }
    }


    public function actionsaveUnlockPurchase()
    {
        $other = array();
        $valid = true;
        $purchase_id = $_POST['purchase_id'];

        // Step 1: Check if the purchase invoice is of type 'LC' and if the purchase ID is found in the invoice ID list
        $sql = "SELECT id, purchase_invoice_id 
              FROM `erp_purchasinginvoice` 
              WHERE `purchase_invoice` = 'LC' 
              AND FIND_IN_SET('$purchase_id', `purchase_invoice_id`)";
        $command_acc = Yii::app()->db->createCommand($sql);
        $inv_list = $command_acc->queryAll();
        $purchase_lc_InvoiceIdsArray = [];
        $purchaseInvoiceIdsArray = [];

        // Step 2: If such invoices exist, gather unique purchase invoice IDs and LC IDs
        if (!empty($inv_list)) {
            foreach ($inv_list as $row) {
                $ids = array_filter(array_unique(explode(',', $row['purchase_invoice_id'])));
                $purchaseInvoiceIdsArray = array_merge($purchaseInvoiceIdsArray, $ids);

                $lc_ids = array_filter(array_unique(explode(',', $row['id'])));
                $purchase_lc_InvoiceIdsArray = array_merge($purchase_lc_InvoiceIdsArray, $lc_ids);
            }
        }

        // Step 3: Ensure unique IDs in both arrays
        $purchaseInvoiceIdsArray = array_unique($purchaseInvoiceIdsArray);
        $purchase_lc_InvoiceIdsArray = array_unique($purchase_lc_InvoiceIdsArray);
        $product_error = [];
        $update_status = true;

        // Step 4: Validate each purchase invoice for lock status and available quantities
        if (!empty($purchaseInvoiceIdsArray)) {
            foreach ($purchaseInvoiceIdsArray as $j => $eachid) {
                $modelInvoice = PurchasingInvoice::model()->with('items')->findByPk($eachid);
                if ($modelInvoice->lock_status == 'Y') {
                    foreach ($modelInvoice->items as $i => $eachItem) {
                        // Step 5: Fetch available quantity for each product in the invoice
                        $available_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity * unit_factor), 0) as available_qty 
                                                                          FROM `erp_stock_ledger` 
                                                                          WHERE product_id = ' . $eachItem['product_id'])->queryScalar();
                        // Step 6: If available quantity is zero or less, set error flag and stop the process
                        if ((float) $available_qty <= 0) {
                            $available_qty = round($available_qty, 2);
                            $store = Store::model()->findByPk($eachItem->product_id);
                            $valid = false;
                            $other[] = "Error in Save: Available Quantity is less: $available_qty for product $store->part_number";
                            $product_error[] = $eachItem->product_id;
                            $update_status = false; // Set to false if any product has zero available quantity
                        }
                    }
                } else {
                    // Step 7: If the invoice is not locked, add an error message
                    $valid = false;
                    $other[] = "Error in Save: This invoice is Not In Lock Status: $modelInvoice->id";
                    $update_status = false; // Set to false if the invoice is not locked
                }

                // Step 8: Exit the loop if any error occurs
                if (!$update_status) {
                    break;
                }
            }
        } else {
            // Step 9: If no purchase invoices found, validate the individual purchase invoice
            $product_error = [];
            $update_status = true;
            $modelInvoice = PurchasingInvoice::model()->with('items')->findByPk($purchase_id);

            // Step 10: Check if the invoice is locked 
            if ($modelInvoice->lock_status == 'Y') {
                foreach ($modelInvoice->items as $i => $eachItem) {
                    $available_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity * unit_factor), 0) as available_qty 
                                                                      FROM `erp_stock_ledger` 
                                                                      WHERE product_id = ' . $eachItem['product_id'])->queryScalar();
                    // Step 11: If available quantity is zero or less, set error flag
                    if ((float) $available_qty <= 0) {
                        $available_qty = round($available_qty, 2);
                        $store = Store::model()->findByPk($eachItem->product_id);
                        $valid = false;
                        $other[] = "Error in Save: Available Quantity is less: $available_qty for product $store->part_number";
                        $product_error[] = $eachItem->product_id;
                        $update_status = false;
                        break; // Step 12: Exit the loop if an invalid product is found
                    }
                }
            } else {
                // Step 13: If the invoice is not locked, add an error message
                $valid = false;
                $other[] = "Error in Save: This invoice is Not In Lock Status: $modelInvoice->id";
            }
        }

        // Step 14: If validation is successful, proceed to update the lock status
        if ($valid) {
            // Step 15: Update the lock status for each invoice if no product errors were found
            if ($update_status) {
                if (!empty($purchaseInvoiceIdsArray)) {
                    foreach ($purchaseInvoiceIdsArray as $j => $eachid) {
                        $modelInvoice = PurchasingInvoice::model()->findByPk($eachid);
                        $modelInvoice->lock_status = "N"; // Unlock the invoice
                        $modelInvoice->save(false);

                        // Step 16: Update stock ledger stock_updated = "N" 
                        $materialreceived = $modelInvoice->materialreceived;
                        $file_id = $modelInvoice->file_id;

                        $sql = 'UPDATE `erp_stock_ledger` 
                                  SET stock_updated = "N" 
                                  WHERE `header_id` = "' . $materialreceived . '" 
                                  AND file_id = "' . $file_id . '" 
                                  AND transaction_from = "QUALITY_CHECK"';
                        Yii::app()->db->createCommand($sql)->execute();
                    }

                    // Step 17: If there are LC invoice IDs, update their status
                    if (!empty($purchase_lc_InvoiceIdsArray)) {
                        foreach ($purchase_lc_InvoiceIdsArray as $j => $eachlcid) {
                            $modelInvoicelc = PurchasingInvoice::model()->findByPk($eachlcid);
                            $modelInvoicelc->lc_calulation = "N"; // Reset LC calculation
                            $modelInvoicelc->save(false);
                        }
                    }
                } else {
                    // Step 18: Unlock the original purchase invoice if no LC purchase invoices found
                    $modelInvoice = PurchasingInvoice::model()->findByPk($purchase_id);
                    $modelInvoice->lock_status = "N";
                    $modelInvoice->save(false);

                    // Step 19: Update stock ledger for the received material and file
                    $materialreceived = $modelInvoice->materialreceived;
                    $file_id = $modelInvoice->file_id;

                    $sql = 'UPDATE `erp_stock_ledger` 
                              SET stock_updated = "N" 
                              WHERE `header_id` = "' . $materialreceived . '" 
                              AND file_id = "' . $file_id . '" 
                              AND transaction_from = "QUALITY_CHECK"';
                    Yii::app()->db->createCommand($sql)->execute();
                }
            }

            // Step 20: Log the update in the audit logs
            AuditLog::saveAuditLogs(
                'PURCHASE_INVOICE',
                Yii::app()->user->id,
                'UPDATED',
                " INV No: - {$purchase_id} "
            );

            // Step 21: Return success response in JSON format
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        } else {
            // Step 22: If errors occurred, return the error messages in JSON format
            $error = CJSON::encode(array_merge_recursive($other));
            if ($error != '[]') {
                echo $error;
            }
        }
    }

    // ------------------------end---------landing cost-----------------------------------------------------


}
