<?php

class ProfitsettingsController extends Controller
{
//	public function actionIndex()
//	{
//		$this->render('index');
//	}
    
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','SaveSettings','GetProfitList','deleteprofitsettings'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index');
         }
         
        public function actionGetProfitList()
         {
 
            $model=new ProfitSettings();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'t.id',
                   1 => 't.product_class_id',
                    2 => 't.landing_cost_percentage',
                     3 => 't.internal_cost_percentage',
                 
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" productbrand.product_class LIKE '%".$searchString."%' OR landing_cost_percentage LIKE '%".$searchString."%' OR internal_cost_percentage LIKE '%".$searchString."%'";
                }
                //$count = $model->count(array('condition'=>$condition));
               // $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $count = $model->with('productbrand')->count(array('condition'=>$condition));
                $model=$model->with('productbrand')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $button_string="";
                        if(isset(Yii::app()->user->havePermissionOn['profit_settings_edit']) ||  Yii::app()->user->authorised_user == 1)
                        {
                            $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'profitsettings/create&id='.$row['id'].'\',\'Edit Profit Settings \',\'lg\')"><i class="fa fa-edit"></i></button>';
                        }
                        if(isset(Yii::app()->user->havePermissionOn['profit_settings_delete']) ||  Yii::app()->user->authorised_user == 1)
                        {
                            $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteProfitSettings('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>';
                        }
                    $rowData[]=array($m,$row['productbrand']['product_class'],$row['landing_cost_percentage'],$row['internal_cost_percentage'],$button_string);
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new ProfitSettings(); 
        $id=(int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
                   
            
       Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('profit_settings_form', array('model' => $model), false, true);
    }
    public function actionSaveSettings()
        {
            $model = new ProfitSettings();
            if (isset($_POST['ProfitSettings']))
            {
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime =date('Y-m-d h:i:s');
    		
    		if ((int) @$_POST['ProfitSettings']['id'] > 0)
                {
                    $id= (int) @$_POST['ProfitSettings']['id'];
                    $model=$model->findByPk($id); 
                    $model->updated_by = Yii::app()->user->id;
                    $model->updated_datetime =date('Y-m-d h:i:s');
                }
                $model->attributes=$_POST['ProfitSettings'];
                $valid = $model->validate();
                if($valid)
                {       
                        $model->save();
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['profitsettings_form'];
                        $jsonData['id'] = $model->id;
	                   echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }

            }
        }
        public function actionDeleteprofitsettings()
    {
		$id = $_POST['id'];
                $model = new ProfitSettings();
            if($model->deleteByPk($id)){
                echo "success";
            }
            else{
                echo "fail";
            }
            
              
    }
    
        
        
  
}