<?php

class PaymenttermsController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetPaymentTermList', 'SavePaymentTerm', 'Disable','UploadEmployeecsv',
                 'DirectAdd','DownloadSampleCsv','readPaymenttermsCSV','DownloadErrorCsv','SavePaymenttermsUploadCsv','Uploadpaymentterms'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex()
        {
            if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['paymentterm_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['paymentterm_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
        }
    public function actionCreate() {
        $model = new MasPaymentTerm();
        $from = Yii::app()->request->getParam('from');
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model, 'from' => $from), false, true);
    }

    public function actionGetPaymentTermList() {

        $model = new MasPaymentTerm();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'payment_terms',
            2 => 'no_of_days',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        // $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $condition = "1=1 ";
            $searchString = $_POST['search']['value'];
            $condition.=" and (payment_code LIKE '%" . $searchString . "%' OR payment_terms LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
//                  foreach ($model as $row)
//                {
//                    $rowData[]=array($m,$row['payment_code'],$row['payment_terms'],$row['no_of_days'],$row['isBasePaymentTerm'],
//              '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'paymentterms/create&id='.$row['id'].'\',\'Edit Payment Term\')"><i class="fa fa-pencil"></i></button> '
//             .'<a href ="#" onclick="deletePaymentterm('.$row['id'].')"><button class="btn btn-danger btn-xs"><i class="fa fa-trash-o "></i></button></a>');
//               $m++;
//                }
        foreach ($model as $row) {

            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["paymentterm_edit"])) {
                $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'paymentterms/create&id=' . $row['id'] . '\',\'Edit Payment Term\')"><i class="fa fa-pencil"></i></button> ';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["paymentterm_delete"])) {
                //$div .=  ' <a href ="#" onclick="deletePaymentterm('.$row['id'].')"><button class="btn btn-danger btn-xs"><i class="fa fa-trash-o "></i></button></a>';
            }
            $rowData[] = array($m,
                $row['payment_terms'],
                $row['no_of_days'],
                $row['isBasePaymentTerm'],
                array('id' => $row['id'],'code'=>$row['payment_terms'], 'status' => $row->isActive),);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionSavePaymentTerm() {
        $model = new MasPaymentTerm();
        if (isset($_POST['MasPaymentTerm'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');

            if ((int) @$_POST['MasPaymentTerm']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $id = (int) @$_POST['MasPaymentTerm']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
            }
            

            $model->attributes = $_POST['MasPaymentTerm'];
            if ($_POST['MasPaymentTerm']['isBasePaymentTerm'] == "Y") {
                MasPaymentTerm::model()->updateAll(array('isBasePaymentTerm' => 'N'), 'isBasePaymentTerm = "Y"');
            }
            $model->isBasePaymentTerm = $_POST['MasPaymentTerm']['isBasePaymentTerm'];
            if ($model->validate()) {
                $model->save();
                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'PAYMENT_TERMS', Yii::app()->user->id, $audit_type, " with term: - {$model->payment_terms}  "
                );
                // end audit log 
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['paymentterm_form'];
                $jsonData['id'] = $model->id;
                $jsonData['from'] = $_POST['from'];
                ;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasPaymentTerm();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

    public function actionDirectAdd() {
        $from = $_POST['from'];
        $code = $_POST['code'];
        $term = $_POST['term'];
        $days = $_POST['days'];
        if ($term != '' && $days != '') {
            $modelPaymentterm = new MasPaymentTerm;
            $modelPaymentterm->created_by = Yii::app()->user->id;
            $modelPaymentterm->created_datetime = date('Y-m-d h:i:s');
            $modelPaymentterm->payment_code = $code;
            $modelPaymentterm->payment_terms = $term;
            $modelPaymentterm->no_of_days = $days;
            if ($modelPaymentterm->save()) {
                if ($modelPaymentterm->payment_code == '') {
                    if ($modelPaymentterm->id < 10) {
                        $code = '0' . $id;
                    } else {
                        $code = $modelPaymentterm->id;
                    }
                    MasPaymentTerm::model()->updateByPk($modelPaymentterm->id, array('payment_code' => 'AE' . $code));
                }
                $data = MasPaymentTerm::getPaymentTerms();
                if ($from == 'customer') {
                    $model = new Customer;
                    $field_name = 'customer_payment_term';
                }
                if ($from == 'quote') {
                    $model = new Quotes;
                    $field_name = 'payment_terms';
                }
                if ($from == 'order') {
                    $model = new Order;
                    $field_name = 'payment_terms';
                }
                if ($from == 'invoice') {
                    $model = new Invoice;
                    $field_name = 'payment_terms';
                }
                if ($from == 'vendor') {
                    $model = new Vendor;
                    $field_name = 'vendor_payment_term';
                }
                $model->$field_name = $modelPaymentterm->id;
                $drop = CHtml::activedropDownList($model, $field_name, $data, array('class' => 'tooltipster', 'data-label' => 'Payment Terms <span style="color:red;">*</span>'));
                $status = array("status" => "success", "drop" => $drop);
                echo CJSON::encode($status);
            } else {
                $error = CActiveForm::validate($modelPaymentterm, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionUploadpaymentterms(){
        //added by nisha on 28-02-2023
        $model=new MasPaymentTerm();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_paymentterms', array('model' => $model), false, true);
    }
public function actionSavePaymenttermsUploadCsv()
{
$file_name = Yii::app()->request->getParam('filename');
$url = Yii::app()->basePath . '/../uploads/paymentterms_csv/' . $file_name;
$error_url = Yii::app()->basePath . '/../uploads/paymentterms_csv/error/' . $file_name;
if (!file_exists($url)) {
    echo CJSON::encode([
        'status' => 'error',
        'message' => 'Uploaded CSV file not found: ' . $file_name
    ]);
    return;
}

$payment_list = $this->readPaymenttermsCSV("uploads/paymentterms_csv/" . $file_name);
if (empty($payment_list) || count($payment_list) < 2) {
    echo CJSON::encode([
        'status' => 'error',
        'message' => 'CSV file is empty or missing header.'
    ]);
    return;
}

$validate = true;
$error_list = [];
$error_names = [];
$models = [];

foreach (array_slice($payment_list, 1) as $i => $row) {
    if (!empty($row[0])) {
        $models[$i] = new MasPaymentTerm();
        $models[$i]->scenario = "excelupload";
        $models[$i]->payment_terms = trim(iconv('UTF-8', 'ASCII//TRANSLIT', $row[0]));
        $models[$i]->no_of_days = trim($row[1]);
        $models[$i]->isActive = 'Y';
        $models[$i]->isBasePaymentTerm = 'N';
        $models[$i]->created_by = Yii::app()->user->id;
        $models[$i]->created_datetime = date('Y-m-d h:i:s');
        $error_names[$i] = $models[$i]->payment_terms;

        $validate = $models[$i]->validate() && $validate;
    }
}

function array_not_unique($raw_array) {
    $dupes = array();
    natcasesort($raw_array);
    reset($raw_array);
    $old_key = null;
    $old_value = null;
    foreach ($raw_array as $key => $value) {
        if ($value === null) continue;
        if ($old_value !== null && strcasecmp($old_value, $value) === 0) {
            $dupes[$old_key] = $old_value;
            $dupes[$key] = $value;
        }
        $old_value = $value;
        $old_key = $key;
    }
    return $dupes;
}

$duplicates = array_not_unique($error_names);

if ($validate) {
    foreach ($models as $model) {
        $model->save();
    }
    $jsonData['error'] = '';
} else {
    foreach ($models as $i => $model) {
        $error_list[$i]['payment_terms'] = $model->payment_terms;
        $error_list[$i]['no_of_days'] = $model->no_of_days;
        $error_list[$i]['errors'] = [];

        if (!$model->validate()) {
            foreach ($model->getErrors() as $field => $messages) {
                foreach ($messages as $msg) {
                    $error_list[$i]['errors'][] = "$field: $msg";
                }
            }
        }
    }
}

if (!empty($error_list)) {
    $file_error = fopen($error_url, "w+");
    fputcsv($file_error, ['Payment Term*', 'No of Days*', 'Errors']);

    foreach ($error_list as $i => $error_detail) {
        $error_message = implode(" / ", $error_detail['errors']);
        if (in_array($error_detail['payment_terms'], $duplicates)) {
            $error_message .= " / Duplicate payment term in CSV";
        }
        fputcsv($file_error, [
            $error_detail['payment_terms'],
            $error_detail['no_of_days'],
            $error_message
        ]);
    }
    fclose($file_error);
}

$jsonData['status'] = 'success';
$jsonData['error_url'] = $error_url;
$jsonData['filename'] = $file_name;
$jsonData['link'] = CHtml::link('Download log', array('paymentterms/DownloadErrorCsv', 'id' => $file_name), array(
    'target' => '_blank',
    'style' => 'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
));

echo CJSON::encode($jsonData);
}
    public function actionDownloadSampleCsv()
    {
        $filename = 'paymenttermstemplate.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'Payment Term*,No of Days*';
        Yii::app()->end();
    }
    public function readPaymenttermsCSV($csvFile)
    {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            $line_of_text[] = $contents;
        }
        fclose($file_handle);
        return $line_of_text;
    }
    public function actionDownloadErrorCsv() {
        $file_name = $event_id = Yii::app()->request->getParam('id');
        $error_url = Yii::app()->basePath . '/../uploads/paymentterms_csv/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }
}

