<?php

class OrderController extends Controller {

    public $layout = 'layout';
    public $title = 'Order';

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails', 'Updatedefaulthrs', 'GetOrderDetails'), 
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'GetOrderList',
                    'Create',
                    'SaveOrder',
                    'Approve',
                    'ShortClosure',
                    'GetNotesList',
                    'DeleteNotes',
                    'CreateNote',
                    'SaveNote',
                    'Getunitdrop',
                    'getCustomerContactdetails',
                    'documentupload',
                    'GetDocumentList',
                    'DeleteDocument',
                    'PrintProformaReportPDF',
                    'PrintPOReportPDF',
                    'PrintOrderReportPDF',
                    'Deliverytracker',
                    'GetDeliveryList',
                    'ChangeDate',
                    'SaveDate',
                    'Proformainvoice',
                    'MissingList',
                    'PrintPickingListOrder',
                    'CreatePrint',
                    'DeliveryMonitor',
                    'MaterialAllocation', //MaterialAllocation- in controller
                    'PrintOrderAnnexureReportPDF',
                    'Advancepayment',
                    'Saveadvancepayment',
                    'GetFileid',
                    'Removeorderitem',
                    'getOrderCount',
                    'PaymentTracker',
                    'GetPaymentTrackerList',
                    'RemovelineItem',
                    'PrintOrderAvailableQtyPDF',
                    'GetItemHistory',
                    'GetunitRate',
                    'UploadDocumentOrder',
                    'ConvertProduction',
                    'GetOrderDetails',
                    'PrintOrderReportPDFNew',
                    'PrintOrderReportPDFs',
                    'GetServiceOrderList',
                    'SummaryView',
                    'ApproveLevel'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndex() {
        $frm = (int) Yii::app()->request->getParam('frm');
        $prefix_menu = ($frm == 3) ? 'service' : 'sales';
        $prefix = ($frm == 3) ? 'service_order' : 'order';
        if (
                Yii::app()->user->authorised_user == 1 ||
                (
                isset(Yii::app()->user->havePermissionOn["{$prefix_menu}_menu_view"]) &&
                isset(Yii::app()->user->havePermissionOn["{$prefix}_view"]) &&
                Yii::app()->user->havePermissionOn["{$prefix_menu}_menu_view"] &&
                Yii::app()->user->havePermissionOn["{$prefix}_view"]
                )
        ) {

            if ($frm == 3) {//service order
                $this->render('index_service', array('frm' => $frm));
            } else {//sales order
                $this->render('index', array('frm' => $frm));
            }
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }

    public function actionSummaryview() {
        $permission = (Yii::app()->user->authorised_user == 1) || isset(Yii::app()->user->havePermissionOn["service_order_view"]);
        if ($permission) {
            $this->render('service_summary', $_REQUEST);
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }

    public function actionGetOrderList() {
        $model = new Order();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $frm = $_POST['frm'];
        $prefix = ($frm == 3) ? 'service_order' : 'order';

        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.id',
            2 => 'customer.customer_name',
            3 => 'crmUser.first_name',
            4 => 't.order_date',
            5 => 't.delivery_date',
            6 => 'file.current_process_status',
            7 => 't.total_tax_amount',
            8 => 't.grand_total',
            9 => 'file.current_process_status',
            10 => 'file.current_process_status'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        //$condition = '(t.isActive="Y" AND (file.current_process_status="O" OR file.current_process_status="PD" OR file.current_process_status="PI"))  AND t.order_type="sale" AND completed!="C"';
        //edited by abin on 23-01-2024
        $condition = '(t.isActive="Y" AND (file.current_process_status="O" OR file.current_process_status="PD" OR file.current_process_status="PI"))';

        if ($frm == 3) {
            $condition .= ' AND t.order_type ="service"';
        } else {
            $condition .= ' AND t.order_type ="sales"';
        }

        if ($_POST['order_lead_owner'] != '') {
            $condition .= ' AND t.lead_owner_id="' . $_POST['order_lead_owner'] . '"';
        }

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $condition = 't.isActive="Y"';

            if ($frm == 3) {
                $condition .= ' AND t.order_type ="service"';
            } else {
                $condition .= ' AND t.order_type ="sales"';
            }
            $searchString = $_POST['search']['value'];

            $condition .= " AND ( t.total_tax_amount LIKE '%" . $searchString . "%' OR t.grand_total LIKE '%" . $searchString . "%'  OR customer.customer_name LIKE '%" . $searchString . "%' OR t.file_id LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%')";
        }
        if (!isset(Yii::app()->user->havePermissionOn["{$prefix}_view_all"]) && Yii::app()->user->authorised_user != 1) {
            $condition .= ' AND (t.lead_owner_id= "' . Yii::app()->user->id . '" OR file.lead_owner_id="' . Yii::app()->user->id . '")';
        }
        //echo $condition;
        $count = $model->with('customer', 'file', 'currencyname')->count(array('condition' => $condition));
        $model = $model->with('customer', 'file', 'currencyname')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($model as $s => $row) {
            $status = $row['file']['status'];

            $state = 0;
            if (strtotime($row->delivery_date) < strtotime(date('Y-m-d'))) {
                $state = 1;
            } elseif ($row->file->is_approved == 'N') {
                $state = 2;
            }
            $clr_state = 0;
            if ($row->netDiscount > 0) {
                $clr_state = 3;
            }
            $model_delivery_note = DeliveryNote::model()->find(array('condition' => 'order_id = "' . $row['id'] . '" and status="CL"'));
            $delivery_note = 0;
            if (!empty($model_delivery_note)) {
                $delivery_note = 1;
            }

            $permission = 1;
            //Delivery Note button access
            $show_delivery_btn = 'N';

            //code added by mereena on 05/02/2020
            //$model_ordered_qty = OrderItem::model()->findAll(array('condition'=>'order_id="'.$row['id'].'"'));



            $grand_total = $row['grand_total'];
            $order_item_net_amount = 0;
            $insufficent_qty = 0;
            foreach ($row->items as $orderItems) {
                //if($orderItems->checked==1){
                $order_item_net_amount += ($orderItems->net_amount + $orderItems->tax_vat_amount);
                //}

                $order_item_qty = $orderItems->quantity;
                //code added by mereena on 23/09/2022
                $total_free_qty = (float) $orderItems->product->totalQuantity;
                $total_allocated_qty = (float) $orderItems->product->total_allocated_quantity;
                $total_available_qty = $total_free_qty - $total_allocated_qty;
                //echo "order_item_qty=".$order_item_qty."<br>";
                //echo "total_available_qty=".$total_available_qty;
                if (($order_item_qty > $total_available_qty) && $orderItems->product->inventory_item_type != 2) {
                    $insufficent_qty = 1;
                }

                //end
            }
            $grand_total = $order_item_net_amount;
            $dataextra['current_process_status'] = $row['file']['current_process_status'];

            $dataextra['delivery_btn'] = $show_delivery_btn;
            $dataextra['production'] = $row['production_status'];
            Yii::import('application.modules.features.models.FeaturesApproveLevel');
            $model_approval = new FeaturesApproveLevel();
            $approvalType = 'SO';
            if ($frm == 3) {
                $approvalType = 'SRO';
            }
            $currentApproveLevel = $model_approval->getCurrentApproveLevel($approvalType, $row['file_id']);
            $accessApproveLevel = $model_approval->getAccessApproveLevel($currentApproveLevel, Yii::app()->user->id, $approvalType);
            $rowData[] = array(
                $row['file_id'],
                $row['id'],
                $row['customer']['customer_name'],
                $row['leadowner']['first_name'] . " " . $row['leadowner']['last_name'],
                date("d/m/Y", strtotime($row['order_date'])),
                date("d/m/Y", strtotime($row['delivery_date'])),
                $row['currencyname']['currency_code'],
                Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'], ""),
                Yii::app()->numberFormatter->formatCurrency($row['grand_total'], ""),
                Yii::app()->numberFormatter->formatCurrency(($row['grand_total'] * $row['exchange_rate']), ""),
                $status,
                $dataextra,
                $row['customer_id'],
                $clr_state,
                $insufficent_qty,
                (int) $row['level1_approved_by'],
                array(
                    'currentApproveLevel' => $currentApproveLevel,
                    'accessApproveLevel' => $accessApproveLevel,
                    'is_approved' => $row->file->is_approved
                )//16
            );
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetServiceOrderList() {
        $model = new Order();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $frm = $_POST['frm'];
        $prefix = ($frm == 3) ? 'service_order' : 'order';

        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.id',
            2 => 'customer.customer_name',
            3 => 'crmUser.first_name',
            4 => 't.order_date',
            5 => 't.delivery_date',
            6 => 'file.current_process_status',
            7 => 't.total_tax_amount',
            8 => 't.grand_total',
            9 => 'file.current_process_status',
            10 => 'file.current_process_status'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        //$condition = '(t.isActive="Y" AND (file.current_process_status="O" OR file.current_process_status="PD" OR file.current_process_status="PI"))  AND t.order_type="sale" AND completed!="C"';
        //edited by abin on 23-01-2024
        $condition = '(t.isActive="Y")';

        if ($frm == 3) {
            $condition .= ' AND t.order_type ="service"';
        } else {
            $condition .= ' AND t.order_type ="sales"';
        }

        if ($_POST['order_lead_owner'] != '') {
            $condition .= ' AND t.lead_owner_id="' . $_POST['order_lead_owner'] . '"';
        }

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $condition = 't.isActive="Y"';

            if ($frm == 3) {
                $condition .= ' AND t.order_type ="service"';
            } else {
                $condition .= ' AND t.order_type ="sales"';
            }
            $searchString = $_POST['search']['value'];

            $condition .= " AND ( t.total_tax_amount LIKE '%" . $searchString . "%' OR t.grand_total LIKE '%" . $searchString . "%'  OR customer.customer_name LIKE '%" . $searchString . "%' OR t.file_id LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%')";
        }
        if (!isset(Yii::app()->user->havePermissionOn["{$prefix}_view_all"]) && Yii::app()->user->authorised_user != 1) {
            $condition .= ' AND (t.lead_owner_id= "' . Yii::app()->user->id . '" OR file.lead_owner_id="' . Yii::app()->user->id . '")';
        }
        //echo $condition;
        $count = $model->with('customer', 'file', 'currencyname')->count(array('condition' => $condition));
        $model = $model->with('customer', 'file', 'currencyname')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($model as $s => $row) {
            $status = $row['file']['status'];

            $state = 0;
            if (strtotime($row->delivery_date) < strtotime(date('Y-m-d'))) {
                $state = 1;
            } elseif ($row->file->is_approved == 'N') {
                $state = 2;
            }
            $clr_state = 0;
            if ($row->netDiscount > 0) {
                $clr_state = 3;
            }
            $model_delivery_note = DeliveryNote::model()->find(array('condition' => 'order_id = "' . $row['id'] . '" and status="CL"'));
            $delivery_note = 0;
            if (!empty($model_delivery_note)) {
                $delivery_note = 1;
            }

            $permission = 1;
            //Delivery Note button access
            $show_delivery_btn = 'N';

            //code added by mereena on 05/02/2020
            //$model_ordered_qty = OrderItem::model()->findAll(array('condition'=>'order_id="'.$row['id'].'"'));



            $grand_total = $row['grand_total'];
            $order_item_net_amount = 0;
            $insufficent_qty = 0;
            foreach ($row->items as $orderItems) {
                //if($orderItems->checked==1){
                $order_item_net_amount += ($orderItems->net_amount + $orderItems->tax_vat_amount);
                //}

                $order_item_qty = $orderItems->quantity;
                //code added by mereena on 23/09/2022
                $total_free_qty = (float) $orderItems->product->totalQuantity;
                $total_allocated_qty = (float) $orderItems->product->total_allocated_quantity;
                $total_available_qty = $total_free_qty - $total_allocated_qty;
                //echo "order_item_qty=".$order_item_qty."<br>";
                //echo "total_available_qty=".$total_available_qty;
                if (($order_item_qty > $total_available_qty) && $orderItems->product->inventory_item_type != 2) {
                    $insufficent_qty = 1;
                }

                //end
            }
            $grand_total = $order_item_net_amount;
            $dataextra['current_process_status'] = $row['file']['current_process_status'];

            $dataextra['delivery_btn'] = $show_delivery_btn;
            $dataextra['production'] = $row['production_status'];
            Yii::import('application.modules.features.models.FeaturesApproveLevel');
            $model_approval = new FeaturesApproveLevel();
            $approvalType = 'SO';
            if ($frm == 3) {
                $approvalType = 'SRO';
            }
            $currentApproveLevel = $model_approval->getCurrentApproveLevel($approvalType, $row['file_id']);
            $accessApproveLevel = $model_approval->getAccessApproveLevel($currentApproveLevel, Yii::app()->user->id, $approvalType);
            $rowData[] = array(
                $row['file_id'], //0
                $row['id'], //1
                $row['customer']['customer_name'], //2
                $row['leadowner']['first_name'] . " " . $row['leadowner']['last_name'], //3
                date("d/m/Y", strtotime($row['order_date'])), //4
                date("d/m/Y", strtotime($row['contract_start_date'])), //5
                date("d/m/Y", strtotime($row['contract_end_date'])), //6
                $row['currencyname']['currency_code'], //7
                Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'], ""), //8
                Yii::app()->numberFormatter->formatCurrency($row['grand_total'], ""), //9
                Yii::app()->numberFormatter->formatCurrency(($row['grand_total'] * $row['exchange_rate']), ""), //10
                $status, //11
                $dataextra, //12
                $row['customer_id'], //13
                $clr_state, //14
                $insufficent_qty, //15
                (int) $row['level1_approved_by'], //16
                (int) $row['job_order_id'], //17
                array(
                    'currentApproveLevel' => $currentApproveLevel,
                    'accessApproveLevel' => $accessApproveLevel,
                    'is_approved' => $row->file->is_approved,
                    'oil_issue_job_order_id' => $row->oil_issue_job_order_id
                )//18
            );
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new Order();
        $id = (int) Yii::app()->request->getParam('id');
        $frm = (int) Yii::app()->request->getParam('frm');
        $quote_id = (int) Yii::app()->request->getParam('quote_id');

        $file_id = (int) Yii::app()->request->getParam('file_id');
        $type = Yii::app()->request->getParam('type');
        $duplicate = (int) Yii::app()->request->getParam('duplicate');
        $modelNotes = new Activity();
        $modelOrderItems = array(new OrderItem);
        $modelOrderContractItem = array(new OrderContractItem);
        $modelOrderAdditions = array(new OrderAddition);
        $modelOrderDeductions = array(new OrderDeduction);
        $modelMachinehours_invoiced = array();
        $modelManhours_invoiced = array();
        $modelMaterialUsage_invoiced = array();
        $blocked_min_date = '';
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelmasterfile = new MasterFile();
            $modelmasterfile = $modelmasterfile->findByPk($model->file_id);
            $condition = 'order_id="' . $id . '"'; //To fetch master
            $model_proforma = OrderProformaInvoice::model()->find(array('condition' => 'order_id="' . $id . '"'));
            if ($model_proforma->id == '') {
                $model_proforma = new OrderProformaInvoice();
            }
            $modelOrderItems = OrderItem::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));
            $modelOrderContractItem = OrderContractItem::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));
            $modelOrderAdditions = OrderAddition::model()->findAll(array('condition' => 'order_id="' . $id . '"', 'order' => 'id ASC'));
            $modelOrderDeductions = OrderDeduction::model()->findAll(array('condition' => 'order_id="' . $id . '"', 'order' => 'id ASC'));
            if ($duplicate == '1') {
                $model->id = '';
                $model->file_id = '';
                $model->job_order_id = '';
                $model->oil_issue_job_order_id = '';
                // $file_id = '';
                $k = 0;
                foreach ($modelOrderItems as $eachItem) {
                    $Items[$k] = new OrderItem;
                    $Items[$k]->attributes = $eachItem->attributes;
                    $Items[$k]->id = '';
                    $k++;
                }
                $l = 0;
                foreach ($modelOrderContractItem as $eachItem) {
                    $ItemsContact[$l] = new OrderContractItem;
                    $ItemsContact[$l]->attributes = $eachItem->attributes;
                    $ItemsContact[$l]->id = '';
                    $l++;
                }

                foreach ($modelOrderAdditions as $i => $eachItem) {
                    $Additions[$i] = new OrderAddition;
                    $Additions[$i]->attributes = $eachItem->attributes;
                }
                foreach ($modelOrderDeductions as $i => $eachItem) {
                    $Deductions[$i] = new OrderDeduction;
                    $Deductions[$i]->attributes = $eachItem->attributes;
                }
                $modelOrderItems = $Items;
                $modelOrderContractItem = $ItemsContact;
                $modelOrderAdditions = $Additions;
                $modelOrderDeductions = $Deductions;
            }
            if (empty($modelOrderItems)) {
                $modelOrderItems = array(new OrderItem);
            }
            if (empty($modelOrderContractItem)) {
                $modelOrderContractItem = array(new OrderContractItem);
            }
            if (empty($modelOrderAdditions)) {
                $modelOrderAdditions = array(new OrderAddition);
            }
            if (empty($modelOrderDeductions)) {
                $modelOrderDeductions = array(new OrderDeduction);
            }
        }
        if ($quote_id > 0) {//convert from quote to order
            $modelQuotes = Quotes::model()->findByPK($quote_id);
            $modelmasterfile = MasterFile::model()->findByPk($modelQuotes->file_id);
            $model->file_id = $modelQuotes->file_id;
            $model->quotes_id = $modelQuotes->id;
            $model->customer_id = $modelQuotes->customer_id;
            $model->inco_term_id = $modelQuotes->inco_term_id;
            $model->customer_name = $modelQuotes->customer->customer_name;
            if ($modelQuotes->lead_owner_id > 0) {
                $model->lead_owner_id = $modelQuotes->lead_owner_id;
            } else {
                $model->lead_owner_id = $modelQuotes->file->lead_owner_id;
            }
            $model->contact_id = $modelQuotes->contact_id;
            $model->ticket_id = $modelQuotes->ticket_id;
            $model->billing_address = $modelQuotes->billing_address;
            $model->sales_group_id = $modelQuotes->sales_group_id;
            $model->currency_id = $modelQuotes->currency_id;
            $model->exchange_rate = $modelQuotes->exchange_rate;
            $model->payment_terms_id = $modelQuotes->payment_terms_id;
            $model->notes = $modelQuotes->notes;
            $model->remarks = $modelQuotes->remarks;
            $model->terms_id = $modelQuotes->terms_id;
            $model->terms_and_conditions = $modelQuotes->terms_and_conditions;
            $model->file_title = $modelQuotes->file_title;
            $model->invoice_type_id = $modelQuotes->invoice_type_id;
            $model->project_id = $modelQuotes->project_id;
            $model->job_order_id = $modelQuotes->job_order_id;
            //code added by mereena on 12/01/2024 to get totaldiscount percentage
            $model->total_discount_percentage = $modelQuotes->total_discount_percentage;
            $model->total_discount_amount = $modelQuotes->total_discount_amount;
            $model->customer_outlet_id = $modelQuotes->customer_outlet_id;
            $k = 0;
            $l = 0;
            $conditionitems = 'quotes_id="' . $quote_id . '"';
            $modelQuotesItems = QuotesItem::model()->findAll(array('condition' => $conditionitems, 'order' => 't.id asc'));
            if (!empty($modelQuotesItems)) {
                foreach ($modelQuotesItems as $eachItem) {
                    if ($eachItem->checked == 1) {
                        $modelOrderItems[$k] = new OrderItem;
                        $modelOrderItems[$k]->attributes = $eachItem->attributes;
                        $modelOrderItems[$k]->unit_id = $eachItem->unit_id;
                        //code added by abin on 24-01-2024 to get the quotes id
                        $modelOrderItems[$k]->quotes_item_id = $eachItem->id;
                        $k++;
                    }
                }
            }


            $modelQuotesContactItems = QuotesContractItem::model()->findAll(array('condition' => $conditionitems, 'order' => 't.id asc'));
            if (!empty($modelQuotesContactItems)) {
                foreach ($modelQuotesContactItems as $eachItem) {
                    $modelOrderContractItem[$l] = new OrderContractItem;
                    $modelOrderContractItem[$l]->attributes = $eachItem->attributes;
                    $modelOrderContractItem[$l]->unit_id = $eachItem->unit_id;
                    $l++;
                }
            }

            foreach ($modelQuotes->adItems as $i => $eachItem) {
                $modelOrderAdditions[$i] = new OrderAddition;
                $modelOrderAdditions[$i]->attributes = $eachItem->attributes;
            }
            foreach ($modelQuotes->dedItems as $i => $eachItem) {
                $modelOrderDeductions[$i] = new OrderDeduction;
                $modelOrderDeductions[$i]->attributes = $eachItem->attributes;
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array(
            'model' => $model,
            'modelQuotesItems' => $modelQuotesItems,
            'modelQuotesContactItems' => $modelQuotesContactItems,
            'modelQuotesAdditions' => $modelQuotesAdditions,
            'modelQuotesDeductions' => $modelQuotesDeductions,
            'modelQuotes' => $modelQuotes,
            'modelmasterfile' => $modelmasterfile,
            'modelOrderItems' => $modelOrderItems,
            'modelOrderContractItem' => $modelOrderContractItem,
            'modelOrderAdditions' => $modelOrderAdditions,
            'modelOrderDeductions' => $modelOrderDeductions,
            'modelNotes' => $modelNotes,
            'quote_id' => $quote_id,
            'file_id' => $file_id,
            'id' => $id,
            'type' => $type,
            'frm' => $frm,
        ));
    }

    public function actionDeleteNotes() {
        $id = $_POST['id'];
        $model = new Activity();
        $model->deleteByPk($id);
        echo "success";
    }

    public function actionGetNotesList() {
        $id = $_POST['id'];
        $model = new Activity();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'notes',
            2 => 'created_date_time',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        if ($id == '') {
            $id = 0;
        }
        $condition = 't.file_id > 0 AND t.file_id="' . $id . '" and type_of_activity ="N"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (notes LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $model2 = User::model()->find(array('condition' => 't.id = "' . $row['created_by'] . '"'));
            $rowData[] = array($m, $row->notes, $model2->username, date('d/m/Y', STRTOTIME($row->created_date_time)));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreateNote() {
        $modelNotes = new Activity();
        $file_id = (int) Yii::app()->request->getParam('file_id');
        $id = (int) Yii::app()->request->getParam('id');
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $contact_id = (int) Yii::app()->request->getParam('contact_id');

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('order_note_form', array('modelNotes' => $modelNotes, 'file_id' => $file_id, 'id' => $id, 'customer_id' => $customer_id, 'contact_id' => $contact_id));
    }

    public function actionSaveNote() {
        $modelNotes = new Activity();
        if (!empty($_POST['Activity'])) {
            $modelNotes->created_by = Yii::app()->user->id;
            $modelNotes->created_date_time = date('Y-m-d h:i:s');
            $modelNotes->notes = $_POST['Activity']['notes'];
            $modelNotes->crm_user_id = Yii::app()->user->id;
            $modelNotes->customer_id = $_POST['customer_id'];
            $modelNotes->contact_id = $_POST['contact_id'];
            $modelNotes->file_id = $_POST['file_id'];
            $modelNotes->type_of_activity = 'N';
            $modelNotes->added_from = 'O';
            $modelNotes->save(false);
            $jsonData['status'] = 'success';
            $jsonData['customer_id'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }

    /* jo */

    public function actionGetunitdrop() {
        $row = $_POST['row_field'];
        $product_id = (int) $_POST['product_id'];
        $type = $_POST['type'];
        $selling_price = $_POST['selling_price'];
        $drop = array();
        $modelOrder = new OrderItem;

        if ($product_id > 0) {

            //code added by mereena on 07/09/2022 to get default sales unit_id
            $modelStore = new Store();
            $modelStore = $modelStore->findByPk($product_id);
            //end


            $arr_uom = UnitOfMeasurement::getSecondaryBaseUnitWithName($product_id);
            //$modelOrder->unit_id = UnitOfMeasurement::getBaseunit($product_id);
            $modelOrder->unit_id = UnitOfMeasurement::getSecondaryBaseunit($product_id);
            $drop['drop'] = CHtml::activedropdownlist($modelOrder, "[" . $row . "]unit_id", UnitOfMeasurement::getUnits($product_id), array('class' => 'unit go', 'onchange' => 'checkUnit(this.id);', 'onkeyup' => 'calculateorderValue($("#order_item_table"));'));
        }
        $drop['factor'] = $arr_uom->factor;
        //$drop['selling_price'] =  number_format(($selling_price * $arr_uom->factor),2);
        $drop['selling_price'] = number_format(((float) $selling_price), 2);
        echo CJSON::encode($drop);
    }

    public function actiongetCustomerContactdetails() {
        $id = Yii::app()->request->getparam("id");
        $models = CustomerContact::getCustomerContacts($id);
        $customer = Customer::model()->findBypk($id);
        if ($customer->customer_address != '')
            $ads = $customer->customer_address . PHP_EOL;
        else
            $ads = '';
        if ($customer->customer_postal_code != '')
            $post = "PO Box : " . $customer->customer_postal_code . PHP_EOL;
        else
            $post = '';
        if ($customer->customer_city != '')
            $city = $customer->customer_city . PHP_EOL;
        else
            $city = '';
        $adds = $ads . $post . $city . $customer->country->country_name;
        $drop = '<li class="col-sm-3">';
        $model = new Order;
        $drop .= CHtml::activedropDownList($model, 'contact_id', $models, array('class' => 'tooltipster', 'title' => 'Please Select Contact', 'data-label' => 'Contact <span style="color:red;">*</span>', 'data-search' => true));
        $drop .= '</li>';
        $status = array("dt" => $drop, 'adds' => $adds);
        echo CJSON::encode($status);
    }

    public function actionDocumentupload() {
        $file_id = Yii::app()->request->getparam("file_id");
        $modelDocument = Document::model()->find(array('condition' => 'file_id = "' . $file_id . '"'));
        if (empty($modelDocument)) {
            $modelDocument = new Document();
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->renderPartial('document_index', array('modelDocument' => $modelDocument, 'file_id' => $file_id), false, true);
    }

    public function actionGetDocumentList() {

        $model = new Document();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $frm = $_POST['frm'];
        $prefix = ($frm == 3) ? 'service_order' : 'order';

        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.document_name',
            2 => 't.created_by',
            3 => 't.created_datetime',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.file_id > 0 AND t.isActive="Y" and t.file_id = "' . $_POST['file_id'] . '"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (document_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $model2 = User::model()->find(array('condition' => 't.id = "' . $row['created_by'] . '"'));
            if (isset(Yii::app()->user->havePermissionOn["{$prefix}_document"]) || Yii::app()->user->authorised_user == 1) {
                $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a> &nbsp;';
            }
            $button_string .= ' <a href ="' . Yii::app()->createUrl('lead/downloaddocument&id=' . $row['id']) . '" class=" btn btn-primary btn-xs"><i class="fa fa-download"></i></a>';
            $rowData[] = array($m, $row['document_name'], $model2->username, date("d/m/Y h:m:s", strtotime($row['created_datetime'])), '<div class="btn-wrap text-center">' . $button_string . '</div>');
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionDeleteDocument() {
        $id = $_POST['id'];
        $modelDocument = new Document();
        $model_doc = Document::model()->findbyPK($id);
        $document_details = explode(',', $model_doc->document_name);
        foreach ($document_details as $value) {
            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $value;
            unlink($path);
        }
        $modelDocument->deleteByPk($id);
        echo "success";
    }

    public function actionSaveOrder() {
        $file_id = $_POST['hid_file_id'];
        $modelOrder = new Order;
        $other = array();
        $valid1 = true;
        $modelOrderItem = array(new OrderItem);

        $modelOrderAddition = array(new OrderAddition);

        $modelContractItems = array(new OrderContractItem);

        $modelOrderDeduction = array(new OrderDeduction);

        $order_id = (int) Yii::app()->request->getParam('id');

        $modelOrder->exchange_rate = 1;

        $modelNotes = new Activity();
        if ($order_id > 0) {

            $modelOrder = $modelOrder->findByPK($order_id);
            $modelOrder->attributes = $_POST['Order'];
            $modelOrderItem = $modelOrder->items;
            $modelOrderAddition = count($modelOrder->adItems) > 0 ? $modelOrder->adItems : $modelOrderAddition;
            $modelOrderDeduction = count($modelOrder->dedItems) > 0 ? $modelOrder->dedItems : $modelOrderDeduction;
        }
        if (isset($_POST['Order'])) {

            $tax_type = 1;

            //$tax_type = $_POST['Order']['tax_type'];
            $scenario = '';
            $flag = 0;
            $flag_dummy_item = 0;
            if ((int) $_POST['Order']['id'] > 0) {
                $modelOrder = $modelOrder->findByPK($_POST['Order']['id']);
                $scenario = 'update';
                $modelOrder->scenario = 'update';
                $audit_type = 'UPDATED';
                $flag = 1;
                $modelOrder->updated_by = Yii::app()->user->id;
                $modelOrder->updated_datetime = date('Y-m-d H:i:s');
            } else {
                $file = new MasterFile;
                $file->crm_user_id = Yii::app()->user->id;
                $file->start_from = 'O';
                $file->current_process_status = 'O';
                $file->customer_id = $_POST['Order']['customer_id'];
                $file->is_approved = 'Y';
                $file->date_of_approval = date('Y-m-d');
                $file->approved_by = Yii::app()->user->id;
                $scenario = 'add';
                $audit_type = 'CREATED';
                $modelOrder->created_by = Yii::app()->user->id;
                $modelOrder->created_datetime = date('Y-m-d H:i:s');
            }

            $modelOrder->attributes = $_POST['Order'];
            if ($_REQUEST['hid_frm'] == 3) {
                $modelOrder->order_type = 'service';
            }
            $modelOrder->terms_id = $_POST['Order']['terms_id'];
            //CODE ADDED BY ABIN ON 24/01/2024
            $modelOrder->quotes_id = $_POST['Order']['quotes_id'];
            $modelOrder->terms_and_conditions = $_POST['Order']['terms_and_conditions'];
            $modelOrder->file_title = $_POST['Order']['file_title'];
            //billing added sarika on 26-08-2022
            $modelOrder->billing_address = $_POST['Order']['billing_address'];

            $modelOrder->shipping_address = $_POST['Order']['shipping_address'];

            $modelOrder->shipping_city = $_POST['Order']['shipping_city'];
            //end
            $modelOrder->currency_id = $_POST['Order']['currency_id'];
            $modelOrder->exchange_rate = $_POST['Order']['exchange_rate'];
            $modelOrder->invoice_type_id = $_POST['Order']['invoice_type_id'];
            $modelOrder->project_id = $_POST['Order']['project_id'];

            $modelOrder->ticket_id = $_POST['Order']['ticket_id'];
            $modelOrder->job_order_id = $_POST['Order']['job_order_id'];
            $modelOrder->customer_outlet_id = $_POST['Order']['customer_outlet_id']; //Added by Lidiya On 09 12 2025

            if ((int) $_POST['hid_file_id'] > 0) {
                $mod_mas_file = MasterFile::model()->findByPk((int) $_POST['hid_file_id']);
            }
            /* if($mod_mas_file->current_process_status=='O'){
              $modelOrder->approved_level=0;
              }
              else{
              $modelOrder->approved_level=$_POST['Order']['approved_level'];
              } */

            if ($_POST['Order']['lpo_date'] != '0000-00-00' && $_POST['Order']['lpo_date'] != '') {
                $modelOrder->lpo_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['Order']['lpo_date'])));
            }
            /////////////////////////////////////////Added By Lidiya On 21/10/2025 for Service Module//////////////////////////////////////////
            if ($_POST['Order']['contract_start_date'] != '0000-00-00' && $_POST['Order']['contract_start_date'] != '') {
                $modelOrder->contract_start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['Order']['contract_start_date'])));
            } else {
                $modelOrder->contract_start_date = '0000-00-00';
            }
            if ($_POST['Order']['contract_end_date'] != '0000-00-00' && $_POST['Order']['contract_end_date'] != '') {
                $modelOrder->contract_end_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['Order']['contract_end_date'])));
            } else {
                $modelOrder->contract_end_date = '0000-00-00';
            }
            $modelOrder->contract_no = intVal($_POST['Order']['contract_no']);
            ////////////////////////////////////////////////////////////////////////////////////
            //code added by mereena on 12/01/2024
            $modelOrder->total_discount_percentage = $_POST['Order']['total_discount_percentage'];
            $modelOrder->total_discount_amount = $_POST['Order']['total_discount_amount'];

            //end
            //code added by mereena on 07/02/2020 for ckeditor content
            $modelOrder->terms_and_conditions = $_POST['Order']['terms_and_conditions'];
            $valid = $modelOrder->validate();
            $p = 0;
            $arr_pdts = array();
            if (is_array($_POST['OrderItem'])) {
                foreach ($_POST['OrderItem'] as $i => $item) {
                    if (($item['product_id'] > 0 && $item['product_name'] != 'memo') || $item['product_name'] == 'memo') {
                        /* if (in_array($item['product_id'], $arr_pdts)) {
                          $valid = false;
                          $other[] = 'Product ' . $item['product_name'] . ' is duplicated';
                          } else {
                          $arr_pdts[] = $item['product_id'];
                          } */
                        $modelOrderItem[$p] = new OrderItem;
                        $modelOrderItem[$p]->attributes = $_POST['OrderItem'][$i];
                        $modelOrderItem[$p]->brand_class_id = $item['brand_class_id'];
                        $modelOrderItem[$p]->description = $item['description'];
                        //CODE ADDED BY ABIN ON 24/01/2024 TO ADD PART NUMBER AND QUOTES ITEM ID
                        $modelOrderItem[$p]->part_number = $item['product_name'];
                        $modelOrderItem[$p]->quotes_item_id = $item['quotes_item_id'];
                        //end of code
                        $modelOrderItem[$p]->unit_id = $item['unit_id'];
                        //CODE ADDED BY MEREENA ON 18/02/2020 TO GET ITEM FROM HIRE INVENTORY
                        $modelOrderItem[$p]->inventory_type = $item['inventory_type'];
                        if ($item['inventory_type'] == 4) {
                            $flag_dummy_item = 1;
                        }
                        //END
                        $delivery_date = '';
                        if ($flag == 0) {
                            if ($_POST['Order']['delivery_date'] != '0000-00-00' && $_POST['Order']['delivery_date'] != '') {
                                $delivery_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['Order']['delivery_date'])));
                            }
                        } else {
                            if ($item['expected_delivery_date'] != '0000-00-00' && $item['expected_delivery_date'] != '') {
                                $delivery_date = date("Y-m-d", strtotime(str_replace('/', '-', $item['expected_delivery_date'])));
                            } else {
                                if ($_POST['Order']['delivery_date'] != '0000-00-00' && $_POST['Order']['delivery_date'] != '') {
                                    $delivery_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['Order']['delivery_date'])));
                                }
                            }
                        }
                        $modelOrderItem[$p]->expected_delivery_date = $delivery_date;
                        $modelOrderItem[$p]->tax_vat_percentage = $item['tax_vat_percentage'];
                        $modelOrderItem[$p]->tax_vat_amount = $item['tax_vat_amount'];
                        if ($item['product_name'] == 'memo') {
                            $modelOrderItem[$p]->product_id = '999999';
                            $modelOrderItem[$p]->quantity = 0;
                            $modelOrderItem[$p]->amount = 0;
                            $modelOrderItem[$p]->net_amount = 0;
                        }
                        $modelOrderItem[$p]->order_id = 0;

                        $arr_secondary_unit = UnitOfMeasurement::model()->findByPk((int) $item['unit_id']);

                        $item_actual_rate = number_format((float) $item['actual_rate'], 2);
                        if (isset($arr_secondary_unit->factor) && (int) $arr_secondary_unit->factor > 0) {
                            $item_actual_rate = number_format(((float) $item['actual_rate'] * $arr_secondary_unit->factor), 2);
                        }
                        if (!isset(Yii::app()->user->havePermissionOn['edit_selling_price'])) {

                            if ((float) $item['rate'] < (float) $item_actual_rate) {
                                $other[] = 'Rate should be greater than or equal to ' . (float) $item_actual_rate . ' [' . $item['product_name'] . ']';
                                $valid = false;
                            }
                        }
                        $valid = $modelOrderItem[$p]->validate() && $valid;
                        $p++;
                    }
                }
            }

            $valid = $valid && !empty($modelOrderItem[0]->product_id);
            $modelsToBeValidated = array($modelOrder, $modelOrderItem);
            $p = 0;

            if (is_array($_POST['OrderContractItem'])) {
                foreach ($_POST['OrderContractItem'] as $i => $itemc) {
                    if (($itemc['product_id'] > 0 && $itemc['product_name'] != 'memo') || $itemc['product_name'] == 'memo') {
                        $modelContractItems[$p] = new OrderContractItem;
                        $modelContractItems[$p]->attributes = $itemc;
                        $modelContractItems[$p]->unit_id = $itemc['unit_id'];
                        $modelContractItems[$p]->unit_id = $itemc['unit_id'];
                        $modelContractItems[$p]->unit_id = $itemc['unit_id'];
                        $modelContractItems[$p]->description = $itemc['description'];
                        $modelContractItems[$p]->quantity = $itemc['quantity'];
                        $modelContractItems[$p]->contract_month = isset($itemc['contract_month']) ? $itemc['contract_month'] : null;
                        if (strtolower($itemc['product_name']) == 'memo') {
                            $modelContractItems[$p]->product_id = 999999;
                        }

                        if (strtolower($itemc['product_name']) != 'memo') {
                            $valid = $modelContractItems[$p]->validate() && $valid;
                        }


                        $p++;
                    }
                }
            }

            /* if (is_array($_POST['OrderAddition'])) {

              foreach ($_POST['OrderAddition'] as $i => $item) {

              $modelOrderAddition[$i] = new OrderAddition;

              $modelOrderAddition[$i]->attributes = $_POST['OrderAddition'][$i];

              //                    $valid = $modelOrderAddition[$i]->validate() && $valid;
              if ($item['particular_value'] > 0 && $item['particular'] == '') {
              $other[] = 'Addition description Cannot Blank';
              $valid = false;
              }
              }
              $modelsToBeValidated[] = $modelOrderAddition;
              }



              if (is_array($_POST['OrderDeduction'])) {

              foreach ($_POST['OrderDeduction'] as $i => $item) {

              $modelOrderDeduction[$i] = new OrderDeduction;

              $modelOrderDeduction[$i]->attributes = $_POST['OrderDeduction'][$i];

              //                    $valid = $modelOrderDeduction[$i]->validate() && $valid;
              if ($item['particular_value'] > 0 && $item['particular'] == '') {
              $other[] = 'Deduction description Cannot Blank';
              $valid = false;
              }
              }



              $modelsToBeValidated[] = $modelOrderDeduction;
              } */


            if ($valid && $flag_dummy_item == 0 && $valid1) {

                $grand_total = 0;

                if ($_POST['hid_file_id'] > 0) {
                    $mod_mas_file = MasterFile::model()->findByPk($_POST['hid_file_id']);
                    if (!empty($mod_mas_file)) {
                        $mod_mas_file->file_title = $_POST['Order']['title'];
                        $mod_mas_file->save(false);
                    }
                }

                if ($_POST['Order']['order_date'] != '00/00/0000') {

                    $modelOrder->order_date = str_replace('/', '-', $_POST['Order']['order_date']);

                    $modelOrder->order_date = date("Y-m-d", strtotime($modelOrder->order_date));
                }

                if ($_POST['Order']['delivery_date'] != '00/00/0000') {

                    $modelOrder->delivery_date = str_replace('/', '-', $_POST['Order']['delivery_date']);

                    $modelOrder->delivery_date = date("Y-m-d", strtotime($modelOrder->delivery_date));
                }
                if ($_POST['hid_file_id'] > 0) {
                    $modelOrder->file_id = $_POST['hid_file_id'];

                    MasterFile::model()->updateByPk($_POST['hid_file_id'], array('current_process_status' => "O"));
                } else {
                    $file->save(false);
                    $modelOrder->file_id = $file->id;
                    //code added by mereena on 16/03/2020
                    //end
                }


                $modelOrder->level1_approved_by = 0;
                $modelOrder->level1_approved_time = '0000-00-00 00:00:00';

                $modelOrder->save(false);

                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'ORDERS',
                        Yii::app()->user->id,
                        $audit_type,
                        " with No: - {$modelOrder->id}  "
                );
                // end audit log

                $modelOrder->refresh();

                $order_id = $modelOrder->id;
                OrderItem::model()->deleteAll('order_id=:refer_id', array(':refer_id' => $modelOrder->id));
                OrderContractItem::model()->deleteAll('order_id=:refer_id', array(':refer_id' => $modelOrder->id));
                //OrderAddition::model()->deleteAll('order_id=:refer_id', array(':refer_id' => $modelOrder->id));
                //OrderDeduction::model()->deleteAll('order_id=:refer_id', array(':refer_id' => $modelOrder->id));
                $total_tax_amount = 0;

                foreach ($modelOrderItem as $eachModel) {
                    $eachModel->order_id = $order_id;
                    $total_tax_amount += $eachModel->tax_vat_amount;
                    $eachModel->save(false);
                    $grand_total += $eachModel->net_amount;
                }

                foreach ($modelContractItems as $eachModel) {
                    $eachModel->order_id = $order_id;
                    $eachModel->save(false);
                }
                /* foreach ($modelOrderAddition as $eachModel) {
                  $eachModel->order_id = $order_id;
                  $eachModel->save(false);
                  $grand_total += $eachModel->calculated_value;
                  }
                  foreach ($modelOrderDeduction as $eachModel) {
                  $eachModel->order_id = $order_id;
                  $eachModel->save(false);
                  $grand_total -= $eachModel->calculated_value;
                  } */
                //Allocate Item
                $modelAllocate = new AllocatedMaterial();
                $modelAllocate = $modelAllocate->findAll(array('condition' => 'file_id=' . $modelOrder->file_id));
                if (count($modelAllocate) > 0) {
                    foreach ($modelAllocate as $eachAllocatedItem) {
                        AllocatedMaterial::model()->updateByPk($eachAllocatedItem->id, array('allocated_from' => 'O', 'header_id' => $modelOrder->id, 'allocation_date' => $modelOrder->order_date, 'allocation_end_date' => $modelOrder->delivery_date));
                    }
                }


                $grand_total += $total_tax_amount;

                $modelOrder->updateByPk($modelOrder->id, array('grand_total' => $grand_total, 'total_tax_amount' => $total_tax_amount));
                if ($scenario == 'add') {
                    Yii::import('application.controllers.front.MasternotificationController');
                    $model_mail_setting = Notification::model()->find(array('condition' => 'event_id="5"'));
                    if ($model_mail_setting->mail_required == 'Y') {
                        // MasternotificationController::sendmail(5,$modelOrder->id);
                    }
                    if ($model_mail_setting->notification_required == 'Y') {
                        // MasternotificationController::sendnotification(5,$modelOrder->id);
                    }
                    if ($model_mail_setting->sms_required == 'Y') {
                        // MasternotificationController::sendsms(5,$modelOrder->id);
                    }
                }
                if (isset($_POST['Icon']['file']) && $_POST['Icon']['file'] != '') {
                    $doc_test = Document::model()->find(array('condition' => 'file_id=' . $modelOrder->file_id . ' AND document_name="' . $_POST['Icon']['file'] . '"'));
                    if (empty($doc_test)) {
                        $modelDocument = new Document;
                        $modelDocument->uploaded_from = "O";
                        $modelDocument->file_id = $modelOrder->file_id;
                        $modelDocument->created_by = Yii::app()->user->id;
                        $modelDocument->created_datetime = date('Y-m-d h:i:s');
                        $modelDocument->document_name = $_POST['Icon']['file'];
                        $modelDocument->save(false);
                    }
                }
                Yii::import('application.modules.features.models.FeaturesOperations');
                Yii::import('application.modules.features.models.FeaturesApproveLevel');
                $operationType = "SO";
                if ($_REQUEST['hid_frm'] == 3) {
                    $operationType = "SRO";
                }
                $model_level_approval = FeaturesApproveLevel::model()->find(array('condition' => ' operations_type="' . $operationType . '"'));
                $approveStatus = "N";
                if ($model_level_approval->max_level == 0) {
                    $approveStatus = "Y";
                    $modelOrder->updateByPk($modelOrder->id, array('level1_approved_by' => Yii::app()->user->id, 'level1_approved_time' => date('Y-m-d h:i:s')));
                }
                FeaturesOperations::model()->updateAll(
                        array(
                            'is_active' => 'N',
                            'updated_by' => Yii::app()->user->id,
                            'updated_date_time' => date('Y-m-d H:i:s'),
                        ),
                        'file_no = :fid',
                        array(':fid' => (int) $modelOrder->file_id)
                );
                MasterFile::model()->updateByPk($_POST['hid_file_id'], array('current_process_status' => "O", 'is_approved' => $approveStatus, 'updated_by' => Yii::app()->user->id, 'updated_datetime' => date('Y-m-d H:i:s')));
                $jsonData['file'] = $modelOrder->file;

                $jsonData['order'] = $modelOrder;

                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_REQUEST['hid_frm'];

                echo CJSON::encode($jsonData);
            } else {
                $error5 = array();
                $error1 = json_decode(CActiveForm::validate($modelOrder, '', false), true);
                //                if (!empty($modelOrderServiceItem)) {
//                    $error5 = json_decode(CActiveForm::validateTabular($modelOrderServiceItem, '', false), true);
//                }
                if (!empty($modelOrderItem[0]->product_id))
                    $error2 = json_decode(CActiveForm::validateTabular($modelOrderItem, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";

                $error3 = json_decode(CActiveForm::validateTabular($modelOrderAddition, '', false), true);

                $error4 = json_decode(CActiveForm::validateTabular($modelOrderDeduction, '', false), true);

                $error6 = array();
                if ($flag_dummy_item == 1) {
                    $error6[] = "Dummy item could not save";
                }

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4, $error5, $error6, $other));

                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionApprove() {

        $file_id = $_POST['hid_file_id'];
        $modelOrder = new Order;
        $other = array();
        $modelOrderItem = array(new OrderItem);
        $modelContractItems = array(new OrderContractItem);
        $modelOrderAddition = array(new OrderAddition);
        $modelOrderDeduction = array(new OrderDeduction);
        $order_id = (int) Yii::app()->request->getParam('id');
        $modelOrder->exchange_rate = 1;
        $modelNotes = new Activity();
        if ($order_id > 0) {
            $modelOrder = $modelOrder->findByPK($order_id);
            $modelOrder->attributes = $_POST['Order'];
            $modelOrderItem = $modelOrder->items;
            $modelContractItems = $modelOrder->contract;
            $modelOrderAddition = count($modelOrder->adItems) > 0 ? $modelOrder->adItems : $modelOrderAddition;
            $modelOrderDeduction = count($modelOrder->dedItems) > 0 ? $modelOrder->dedItems : $modelOrderDeduction;
        }
        if (isset($_POST['Order'])) {
            $tax_type = 1;
            //$tax_type = $_POST['Order']['tax_type'];
            $flag = 0;
            $flag_dummy_item = 0;
            if ((int) $_POST['Order']['id'] > 0) {
                $modelOrder = $modelOrder->findByPK($_POST['Order']['id']);
                $modelOrder->scenario = 'update';
                $flag = 1;
                $modelOrder->updated_by = Yii::app()->user->id;
                $modelOrder->updated_datetime = date('Y-m-d H:i:s');
            } else {
                /* $file = new MasterFile;
                  $file->crm_user_id = Yii::app()->user->id;
                  $file->start_from = 'O';
                  $file->current_process_status = 'O';
                  $file->customer_id = $_POST['Order']['customer_id'];
                  $file->is_approved = 'N'; */
                //$modelOrder->created_by = Yii::app()->user->id;
                //$modelOrder->created_datetime = date('Y-m-d H:i:s');
            }
            $modelOrder->attributes = $_POST['Order'];
            $modelOrder->terms_id = $_POST['Order']['terms_id'];
            //$modelOrder->terms_and_conditions = $_POST['Order']['terms_and_conditions'];
            $modelOrder->file_title = $_POST['Order']['file_title'];
            $modelOrder->currency_id = $_POST['Order']['currency_id'];
            $modelOrder->invoice_type_id = $_POST['Order']['invoice_type_id'];
            $modelOrder->customer_outlet_id = $_POST['Order']['customer_outlet_id'];
            //$modelOrder->crm_user_id = Yii::app()->user->id;
            if ($_POST['Order']['lpo_date'] != '0000-00-00' && $_POST['Order']['lpo_date'] != '') {
                $modelOrder->lpo_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['Order']['lpo_date'])));
            }
            if ($_POST['Order']['contract_end_date'] != '0000-00-00' && $_POST['Order']['contract_end_date'] != '') {
                $modelOrder->contract_end_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['Order']['contract_end_date'])));
            } else {
                $modelOrder->contract_end_date = '0000-00-00';
            }
            //$modelOrder->materials_allocated = (isset($_POST['allocate_materials']) && $_POST['allocate_materials'] == "Y") ? "Y" : "N";
            //code added by mereena on 07/02/2020 for ckeditor content
            $modelOrder->terms_and_conditions = $_POST['terms_conditions'];
            $valid = $modelOrder->validate();
            $p = 0;
            if (is_array($_POST['OrderItem'])) {
                foreach ($_POST['OrderItem'] as $i => $item) {
                    if (($item['product_id'] > 0 && $item['product_name'] != 'memo') || $item['product_name'] == 'memo') {
                        $modelOrderItem[$p] = new OrderItem;
                        $modelOrderItem[$p]->attributes = $_POST['OrderItem'][$i];
                        $modelOrderItem[$p]->brand_class_id = $item['brand_class_id'];
                        //$modelOrderItem[$p]->product_generic_name = $item['product_generic_name'];
                        $modelOrderItem[$p]->description = $item['description'];
                        $modelOrderItem[$p]->unit_id = $item['unit_id'];
                        //CODE ADDED BY MEREENA ON 18/02/2020 TO GET ITEM FROM HIRE INVENTORY

                        $modelOrderItem[$p]->inventory_type = $item['inventory_type'];
                        if ($item['inventory_type'] == 4) {
                            $flag_dummy_item = 1;
                        }
                        //END
                        $delivery_date = '';
                        if ($flag == 0) {
                            if ($_POST['Order']['delivery_date'] != '00/00/0000' && $_POST['Order']['delivery_date'] != '') {
                                $delivery_date = str_replace('/', '-', $_POST['Order']['delivery_date']);
                                $delivery_date = date("Y-m-d", strtotime($delivery_date));
                            }
                        } else {
                            if ($item['expected_delivery_date'] != '00/00/0000' && $item['expected_delivery_date'] != '') {
                                $delivery_date = str_replace('/', '-', $item['expected_delivery_date']);
                                $delivery_date = date("Y-m-d", strtotime($delivery_date));
                            }
                        }
                        $modelOrderItem[$p]->expected_delivery_date = $delivery_date;
                        $modelOrderItem[$p]->tax_vat_percentage = $item['tax_vat_percentage'];
                        $modelOrderItem[$p]->tax_vat_amount = $item['tax_vat_amount'];
                        if ($item['product_name'] == 'memo') {
                            $modelOrderItem[$p]->product_id = '999999';
                            $modelOrderItem[$p]->quantity = 0;
                            $modelOrderItem[$p]->amount = 0;
                            $modelOrderItem[$p]->net_amount = 0;
                        }
                        $valid = $modelOrderItem[$p]->validate() && $valid;
                        $p++;
                    }
                }
            }

            $valid = $valid && !empty($modelOrderItem[0]->product_id);

            $p = 0;

            if (is_array($_POST['OrderContractItem'])) {
                foreach ($_POST['OrderContractItem'] as $i => $itemc) {
                    if (($itemc['product_id'] > 0 && $itemc['product_name'] != 'memo') || $itemc['product_name'] == 'memo') {
                        $modelContractItems[$p] = new OrderContractItem;
                        $modelContractItems[$p]->attributes = $itemc;
                        $modelContractItems[$p]->unit_id = $itemc['unit_id'];
                        $modelContractItems[$p]->unit_id = $itemc['unit_id'];
                        $modelContractItems[$p]->unit_id = $itemc['unit_id'];
                        $modelContractItems[$p]->description = $itemc['description'];
                        $modelContractItems[$p]->quantity = $itemc['quantity'];
                        $modelContractItems[$p]->contract_month = isset($itemc['contract_month']) ? $itemc['contract_month'] : null;
                        if (strtolower($itemc['product_name']) == 'memo') {
                            $modelContractItems[$p]->product_id = 999999;
                        }

                        if (strtolower($itemc['product_name']) != 'memo') {
                            $valid = $modelContractItems[$p]->validate() && $valid;
                        }


                        $p++;
                    }
                }
            }
            $modelsToBeValidated = array($modelOrder, $modelOrderItem, $modelContractItems);
            if (is_array($_POST['OrderAddition'])) {
                foreach ($_POST['OrderAddition'] as $i => $item) {
                    $modelOrderAddition[$i] = new OrderAddition;
                    $modelOrderAddition[$i]->attributes = $_POST['OrderAddition'][$i];
                    //                    $valid = $modelOrderAddition[$i]->validate() && $valid;
                    if ($item['particular_value'] > 0 && $item['particular'] == '') {
                        $other[] = 'Addition description Cannot Blank';
                        $valid = false;
                    }
                }
                $modelsToBeValidated[] = $modelOrderAddition;
            }
            if (is_array($_POST['OrderDeduction'])) {
                foreach ($_POST['OrderDeduction'] as $i => $item) {
                    $modelOrderDeduction[$i] = new OrderDeduction;
                    $modelOrderDeduction[$i]->attributes = $_POST['OrderDeduction'][$i];
                    //                    $valid = $modelOrderDeduction[$i]->validate() && $valid;
                    if ($item['particular_value'] > 0 && $item['particular'] == '') {
                        $other[] = 'Deduction description Cannot Blank';
                        $valid = false;
                    }
                }
                $modelsToBeValidated[] = $modelOrderDeduction;
            }
            if ($valid && $flag_dummy_item == 0) {
                $grand_total = 0;
                if ($_POST['hid_file_id'] > 0) {
                    $mod_mas_file = MasterFile::model()->findByPk($_POST['hid_file_id']);
                    if (!empty($mod_mas_file)) {
                        $mod_mas_file->file_title = $_POST['Order']['title'];
                        $mod_mas_file->save(false);
                    }


                    $modelOrder->level1_approved_by = Yii::app()->user->id;
                    $modelOrder->level1_approved_time = date('Y-m-d h:i:s');

                    /* switch ($modelOrder->approved_level) {
                      case 0:
                      if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["order_approve_level1"]))) {
                      $modelOrder->approved_level++;
                      $modelOrder->level1_approved_by = Yii::app()->user->id;
                      $modelOrder->level1_approved_time = date('Y-m-d h:i:s');
                      }
                      break;
                      case 1:
                      if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["order_approve_level2"]))) {
                      $modelOrder->approved_level++;
                      $modelOrder->level2_approved_by = Yii::app()->user->id;
                      $modelOrder->level2_approved_time = date('Y-m-d h:i:s');
                      }
                      break;
                      case 2:
                      if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["order_approve_level3"]))) {
                      $modelOrder->approved_level++;
                      $modelOrder->level3_approved_by = Yii::app()->user->id;
                      $modelOrder->level3_approved_time = date('Y-m-d h:i:s');
                      }
                      break;
                      } */
                    //if($modelOrder->approved_level==3)
                    if ($modelOrder->level1_approved_by > 0) {
                        MasterFile::model()->updateByPk($_POST['hid_file_id'], array('is_approved' => "Y", 'date_of_approval' => date('Y-m-d'), 'approved_by' => Yii::app()->user->id));
                    }
                }

                if ($_POST['Order']['order_date'] != '00/00/0000') {

                    $modelOrder->order_date = str_replace('/', '-', $_POST['Order']['order_date']);

                    $modelOrder->order_date = date("Y-m-d", strtotime($modelOrder->order_date));
                }

                if ($_POST['Order']['delivery_date'] != '00/00/0000') {

                    $modelOrder->delivery_date = str_replace('/', '-', $_POST['Order']['delivery_date']);

                    $modelOrder->delivery_date = date("Y-m-d", strtotime($modelOrder->delivery_date));
                }
                if ($_POST['hid_file_id'] > 0) {
                    $modelOrder->file_id = $_POST['hid_file_id'];
                } else {
                    //$file->save(false);
                    //$modelOrder->file_id = $file->id;
                }

                $modelOrder->save(false);

                $modelOrder->refresh();

                //Allocate Item
                $modelAllocate = new AllocatedMaterial();
                $modelAllocate = $modelAllocate->findAll(array('condition' => 'file_id=' . $modelOrder->file_id));
                if (count($modelAllocate) > 0) {
                    foreach ($modelAllocate as $eachAllocatedItem) {
                        AllocatedMaterial::model()->updateByPk($eachAllocatedItem->id, array('allocation_date' => $modelOrder->order_date, 'allocation_end_date' => $modelOrder->delivery_date));
                    }
                }
                //End



                $order_id = $modelOrder->id;
                OrderItem::model()->deleteAll('order_id=:refer_id', array(':refer_id' => $modelOrder->id));
                OrderContractItem::model()->deleteAll('order_id=:refer_id', array(':refer_id' => $modelOrder->id));
                OrderAddition::model()->deleteAll('order_id=:refer_id', array(':refer_id' => $modelOrder->id));

                OrderDeduction::model()->deleteAll('order_id=:refer_id', array(':refer_id' => $modelOrder->id));
                $total_tax_amount = 0;

                foreach ($modelOrderItem as $eachModel) {

                    $eachModel->order_id = $order_id;

                    $total_tax_amount += $eachModel->tax_vat_amount;

                    $eachModel->save(false);

                    $grand_total += $eachModel->net_amount;
                }

                foreach ($modelContractItems as $eachModel) {
                    $eachModel->order_id = $order_id;
                    $eachModel->save(false);
                }



                foreach ($modelOrderAddition as $eachModel) {

                    $eachModel->order_id = $order_id;

                    $eachModel->save(false);

                    $grand_total += $eachModel->calculated_value;
                }



                foreach ($modelOrderDeduction as $eachModel) {

                    $eachModel->order_id = $order_id;

                    $eachModel->save(false);

                    $grand_total -= $eachModel->calculated_value;
                }

                if (!empty($_POST['Activity']['notes'])) {
                    $modelNotes->created_by = Yii::app()->user->id;
                    $modelNotes->created_date_time = date('Y-m-d h:i:s');
                    $modelNotes->notes = $_POST['Activity']['notes'];
                    $modelNotes->crm_user_id = Yii::app()->user->id;
                    $modelNotes->customer_id = $modelOrder->customer_id;
                    $modelNotes->contact_id = $modelOrder->contact_id;
                    $modelNotes->type_of_activity = 'N';
                    $modelNotes->added_from = 'O';
                    $modelNotes->file_id = $modelOrder->file_id;
                    $modelNotes->save(false);
                }

                if (isset($_POST['Icon']['file']) && $_POST['Icon']['file'] != '') {
                    $doc_test = Document::model()->find(array('condition' => 'file_id=' . $modelOrder->file_id . ' AND document_name="' . $_POST['Icon']['file'] . '"'));
                    if (empty($doc_test)) {
                        $modelDocument = new Document;
                        $modelDocument->uploaded_from = "O";
                        $modelDocument->file_id = $modelOrder->file_id;
                        $modelDocument->created_by = Yii::app()->user->id;
                        $modelDocument->created_datetime = date('Y-m-d h:i:s');
                        $modelDocument->document_name = $_POST['Icon']['file'];
                        $modelDocument->save(false);
                    }
                }

                $grand_total += $total_tax_amount;

                $modelOrder->updateByPk($modelOrder->id, array('grand_total' => $grand_total, 'total_tax_amount' => $total_tax_amount));
                /*                 * *************** START code added by mereena on 22-10-2019 for approval history******************* */
                date_default_timezone_set("Asia/Dubai");
                $approval_history = new ApprovalHistory;
                $approval_history->file_id = $modelOrder->file_id;
                $approval_history->status = "Y";
                $approval_history->action_by = Yii::app()->user->id;
                $approval_history->created_by = Yii::app()->user->id;
                $approval_history->created_datetime = date('Y-m-d h:i:s');
                $approval_history->date = date('Y-m-d h:i:s');
                $approval_history->state = 'O';
                $approval_history->save();

                /*                 * *************** End code added by mereena on 22-10-2019 for approval history******************* */

                Yii::import('application.controllers.front.MasternotificationController');
                $model_mail_setting = Notification::model()->find(array('condition' => 'event_id="6"'));
                if ($model_mail_setting->mail_required == 'Y') {
                    // MasternotificationController::sendmail(6,$modelOrder->id);
                }
                if ($model_mail_setting->notification_required == 'Y') {
                    // MasternotificationController::sendnotification(6,$modelOrder->id);
                }
                if ($model_mail_setting->sms_required == 'Y') {
                    // MasternotificationController::sendsms(6,$modelOrder->id);
                }


                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'ORDERS',
                        Yii::app()->user->id,
                        'UPDATED',
                        " with APPRVL LVL " . $modelOrder->level1_approved_by . " for No: - {$modelOrder->id} "
                );
                // end audit log

                $jsonData['file'] = $modelOrder->file;

                $jsonData['order'] = $modelOrder;

                $jsonData['status'] = 'success';

                echo CJSON::encode($jsonData);
            } else {

                $error1 = json_decode(CActiveForm::validate($modelOrder, '', false), true);

                if (!empty($modelOrderItem[0]->product_id))
                    $error2 = json_decode(CActiveForm::validateTabular($modelOrderItem, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";

                $error3 = json_decode(CActiveForm::validateTabular($modelOrderAddition, '', false), true);

                $error4 = json_decode(CActiveForm::validateTabular($modelOrderDeduction, '', false), true);

                $error5 = array();
                if ($flag_dummy_item == 1) {
                    $error5[] = "Dummy item could not save";
                }

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4, $error5, $other));

                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionShortClosure() {
        $id = $_POST['Order']['id'];
        if ($id > 0) {
            $model = Order::model()->findByPk($id);
            $model->completed = 'C';
            $model->convert_status = 'N';
            if ($model->save()) {
                AllocatedMaterial::model()->deleteAll('file_id=:refer_id', array(':refer_id' => $modelOrder->file_id));
                if (is_array($_POST['OrderItem'])) {
                    foreach ($_POST['OrderItem'] as $item) {
                        if ($item['id'] > 0) {
                            $modelItem = OrderItem::model()->findByPk($item['id']);
                            $modelItem->notes = $item['notes'];
                            $modelItem->received = $item['received'];
                            $modelItem->remaining_qty = $item['remaining_qty'];
                            $modelItem->save();
                        }
                    }
                }
            }
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

    public function actionPrintOrderReportPDF() {

        $model = new Order();
        $id = Yii::app()->request->getParam('id');
        $c_id = Yii::app()->request->getParam('c_id');
        $type = Yii::app()->request->getParam('type');

        if ($type == 'A5') {
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $page_name = "order_list_individual_A5";
        } else {
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $page_name = "order_list_individual";
        }
        if ($id > 0)
            $model = Order::model()->findByPk($id);
        $page_title = $id . '-O-' . $model->customer->customer_name . '.pdf';
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.' . $page_name, array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'type' => $type, 'mpdf' => $mPDF1), true));
        $mPDF1->Output($page_title, 'I');
    }

    public function actionPrintOrderReportPDFs() {

        $model = new Order();
        $id = (int) Yii::app()->request->getParam('id');
        $c_id = Yii::app()->request->getParam('c_id');
        $type = (int) Yii::app()->request->getParam('type');
        $print_type = Yii::app()->request->getParam('print_type');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        //$mPDF1->SetWatermarkImage('images/watermark.jpg', 0.05);
        //$mPDF1->showWatermarkImage = true;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        if ($type == 2) {
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.order_contract_individuals', array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title, 'mpdf' => $mPDF1), true));
        } else {
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.order_list_individuals', array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title, 'mpdf' => $mPDF1, 'print_type' => $print_type), true));
        }
        $mPDF1->Output("orderreport.pdf", 'I');
    }

    public function actionPrintPOReportPDF() {

        $model = new Order();
        $id = Yii::app()->request->getParam('id');
        $c_id = Yii::app()->request->getParam('c_id');
        $type = Yii::app()->request->getParam('type');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $page_name = "order_PO_list";
        if ($id > 0)
            $model = Order::model()->findByPk($id);
        $page_title = $id . '-O-' . $model->customer->customer_name . '.pdf';
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.' . $page_name, array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title, 'mpdf' => $mPDF1), true));
        $mPDF1->Output($page_title, 'I');
    }

    public function actionPrintOrderAnnexureReportPDF() {

        $model = new Order();
        $id = Yii::app()->request->getParam('id');
        $c_id = Yii::app()->request->getParam('c_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.order_annexure_individual', array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title), true));
        $mPDF1->Output("orderannexurereport.pdf", 'I');
    }

    public function actionPrintProformaReportPDF() {

        $model = new Order();
        $id = Yii::app()->request->getParam('id');
        $c_id = Yii::app()->request->getParam('c_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.proforma_list_individuals', array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionMissingList() {
        $model = new Order();
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.order_received_list', array('model' => $model, 'id' => $id, 'title' => $title), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintPickingListOrder() {
        /*  ini_set("memory_limit", "128G");
          ini_set('max_execution_time', 1000); */
        $modelName = new Order();
        $this->pageTitle = 'print- Order';
        //$view = Yii::app()->request->getParam('view');
        //$searchterm = trim(Yii::app()->request->getParam('searchterm'));
        $id = (int) Yii::app()->request->getParam('id');
        $product_items = "";
        $product_items .= '<table class="table">';
        $product_items .= '<thead><tr><th> No.</th><th>Product</th><th>Description</th><th>Remaining Order Qty</th><th>Warehouse</th><th>Rack</th><th>Bin</th></tr></thead>';
        $model = $modelName->with('items')->findByPK($id, array('order' => 'items.id ASC'));

        $k = 0;

        foreach ($model->items as $i => $eachItem) {
            $count = 0;
            if ($eachItem->quantity != 0) {

                $deliverynote = DeliveryNote::model()->findAll(array('condition' => 'order_id=' . $id));
                foreach ($deliverynote as $deliverynote1) {
                    $deliverynoteitem = DeliveryNoteItem::model()->find(array('condition' => 'delivery_note_id=' . $deliverynote1->id . ' and order_item_id=' . $eachItem->id));
                    $count = $count + $deliverynoteitem->picked_qty;
                }
                $remaining = preg_replace('/\s\d+\.00/', '', floatval($eachItem->quantity)) - $count;

                if ($remaining > 0) {
                    $class = $class == "odd" ? "even" : "odd";

                    $product_items .= '<tr class = "' . $class . '">
                    <td >' . (++$k) . '</td>
                    <td class = "cell-left">' . $eachItem->product->part_number . '</td>';

                    $product_items .= '<td class = "cell-left">' . nl2br($eachItem->description) . '</td>';

                    if ((int) $custom_changes['need_brand_in_sop_print_out'] && in_array($modelName, array("Quotes", "Order", "Invoice"))) {
                        $product_items .= '<td class = "cell-center">' . $eachItem->product->productclass->brand . '</td>';
                    }
                    //  $product_items .= '<td class = "cell-right">' . preg_replace('/\s\d+\.00/', '', floatval($eachItem->quantity)) . '</td>
                    // ';

                    $product_items .= '<td class = "cell-center"> ' . $remaining . '</td>';

                    if ($eachItem->product->totalQuantity > 0 && $remaining > 0) {
                        $rack = "-";
                        $bin = "-";
                        unset($rack_v);
                        unset($bin_v);
                        $locations = ProductLocationDetails::model()->findAll(array('condition' => 'product_id=' . $eachItem->product_id . ' and quantity >0'));
                        foreach ($locations as $eachlocations) {
                            if ($eachlocations->warehouse_id != 0)
                                $warehouse_s[] = $eachlocations->warehouse->warehouse_name;

                            if ($eachlocations->rack != 0)
                                $rack_v[] = $eachlocations->rack->name;

                            if ($eachlocations->bin != 0)
                                $bin_v[] = $eachlocations->bin->name;
                        }
                        if (!empty($rack_v))
                            $rack_v = array_unique($rack_v);
                        if (!empty($bin_v))
                            $bin_v = array_unique($bin_v);

                        if (!empty($warehouse_s))
                            $warehouse_s = array_unique($warehouse_s);

                        if (is_array($warehouse_s))
                            $warehouse = implode(', ', $warehouse_s);
                        if (is_array($rack_v))
                            $rack = implode(', ', $rack_v);
                        if (is_array($bin_v))
                            $bin = implode(', ', $bin_v);
                        $product_items .= '<td class = "cell-center"> ' . $warehouse . '</td>';
                        $product_items .= '<td class = "cell-center"> ' . $rack . '</td>';
                        $product_items .= '<td class = "cell-center"> ' . $bin . '</td></tr>';
                    } else {
                        $product_items .= '<td class = "cell-center">- </td>';
                        $product_items .= '<td class = "cell-center">-</td>';
                        $product_items .= '<td class = "cell-center">-</td></tr>';
                    }
                }
            }
        }


        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);

        $product_items .= '</table>';
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.sop-pickinglist-for-order', array('product_items' => $product_items, 'id' => $id, 'vendor' => $vendor, 'model' => $model), true));
        $mPDF1->Output('List-of-materials-that-needs-to-be-ordered', 'I');
    }

    public function actionCreatePrint() {
        $id = (int) Yii::app()->request->getParam('id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create_print', array('id' => $id));
    }

    public function actionDeliveryMonitor() {
        $model = new Order();
        $id = Yii::app()->request->getParam('id');
        $c_id = Yii::app()->request->getParam('c_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.order_delivery_monitor', array('model' => $model, 'id' => $id, 'title' => $title), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionDeliverytracker() {
        $frm = (int) Yii::app()->request->getParam('frm');
        $prefix_menu = ($frm == 3) ? 'service' : 'sales';
        $prefix = ($frm == 3) ? 'service_deliverytracker' : 'sales_deliverytracker';

        if (
                Yii::app()->user->authorised_user == 1 ||
                (
                isset(Yii::app()->user->havePermissionOn["{$prefix_menu}_menu_view"]) &&
                isset(Yii::app()->user->havePermissionOn["{$prefix}_view"]) &&
                Yii::app()->user->havePermissionOn["{$prefix_menu}_menu_view"] &&
                Yii::app()->user->havePermissionOn["{$prefix}_view"]
                )
        ) {
            // Authorized: render the main view
            $this->render('deliverytracker');
        } else {
            // Unauthorized: show custom unauthorized page
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }

    public function actionGetDeliveryList() {

        $model = new OrderItem();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.order_id',
            2 => 'order.customer_id',
            3 => 't.product_id',
            4 => 't.quantity',
            5 => 't.unit_id',
            6 => 't.expected_delivery_date',
            7 => 't.id',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        // $condition = " convert_to_delivery_note='Y' AND product.inventory_item_type!=2";
        $condition = "  product.inventory_item_type!=2";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];
            $condition .= " AND ( t.id LIKE '%" . $searchString . "%' OR t.order_id LIKE '%" . $searchString . "%' OR product.part_number LIKE '%" . $searchString . "%' OR delivery_date LIKE '%" . $searchString . "%' OR customer_name LIKE '%" . $searchString . "%' OR customer_location LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('order', 'product', 'order.customer')->count(array('condition' => $condition));
        $model = $model->with('order', 'product', 'order.customer')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $i => $row) {
            $modelDeliveryItem = DeliveryNoteItem::model()->find(array('select' => 'SUM(picked_qty) as picked_qty', 'condition' => 'order_item_id=' . $row->id));
            $balance_qty = $row['quantity'] - $modelDeliveryItem['picked_qty'];
            $order_date = '';
            if ($row->expected_delivery_date != '0000-00-00' && $row->expected_delivery_date != '') {
                $order_date = date("d/m/Y", strtotime($row->expected_delivery_date));
            }
            $available_qty = Yii::app()->db->createCommand('SELECT SUM(quantity) FROM  erp_stock_ledger WHERE product_id=' . $row->product_id)->queryScalar();

            if ($available_qty < $balance_qty) {
                $flag = 1;
            } else {
                $flag = 0;
            }


            //            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["sales_deliverytracker_view"])) {
//                $edit = ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'order/changedate&id=' . $row['id'] . '\',\'Change Delivery Date - ' . $row['order_id'] . '/' . $row['product']['part_number'] . '\',\'md\')" title="Change date"><i class="fa fa-calendar" aria-hidden="true"></i></i></button>';
//            }
            if ($balance_qty > 0) {
                $rowData[] = array($m, $row['order_id'], $row->order->customer->customer_name, $row->order->customercity->city, $row['product']['part_number'], $row['product']['description'], '<div class="text-right">' . Yii::app()->numberFormatter->formatCurrency($balance_qty, "") . '</div>', $row['orderunit']['name'], $order_date, '<div class="text-right">' . Yii::app()->numberFormatter->formatCurrency($available_qty, "") . '</div>', $row['id'], $flag);
                $m++;
            }
            $i++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionChangeDate() {
        $id = Yii::app()->request->getParam('id');
        $frm = Yii::app()->request->getParam('frm');
        if ($id > 0) {
            $dateModel = OrderItem::model()->findBypk($id);
            $dateModel->expected_delivery_date = date("d/m/Y", strtotime($dateModel->expected_delivery_date));
            $order_date = $dateModel->order->order_date;
            $order_date = date("d/m/Y", strtotime($order_date));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('change_date', array('model' => $dateModel, 'frm' => $frm, 'order_date' => $order_date));
    }

    public function actionSaveDate() {
        $id = $_POST['OrderItem']['id'];
        if ($id > 0) {
            OrderItem::model()->updateByPk($id, array('expected_delivery_date' => date("Y-m-d", strtotime(str_replace('/', '-', $_POST['OrderItem']['expected_delivery_date'])))));
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionGetFileid() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'file_id LIKE "%' . $searchTerm . '%" AND t.isActive="Y"';
        $model = new Order();
        $model = $model->findAll(array('select' => 't.id,t.file_id', 'condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {


            $data[$i]['file_id'] = $eachModel->file_id;
            $data[$i]['label'] = $eachModel->file_id;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionRemoveorderitem() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = new OrderItem();
            $model->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }

        echo CJSON::encode($status);
    }

    public function actionPaymentTracker() {
        $frm = (int) Yii::app()->request->getParam('frm');
        $prefix_menu = ($frm == 3) ? 'service' : 'sales';
        $prefix = ($frm == 3) ? 'service_receipttracker' : 'sales_receipttracker';
        if (
                Yii::app()->user->authorised_user == 1 ||
                (
                isset(Yii::app()->user->havePermissionOn["{$prefix_menu}_menu_view"]) &&
                isset(Yii::app()->user->havePermissionOn["{$prefix}_view"]) &&
                Yii::app()->user->havePermissionOn["{$prefix_menu}_menu_view"] &&
                Yii::app()->user->havePermissionOn["{$prefix}_view"]
                )
        ) {
            // Authorized: render the main view
            $this->render('paymenttracker');
        } else {
            // Unauthorized: show custom unauthorized page
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }

    public function actionGetPaymentTrackerList() {

        $model = new Invoice();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $frm = $_POST['frm'];
        $prefix = ($frm == 3) ? 'service_invoice' : 'invoice';

        $columns = array(
            // datatable column index  => database column name
            0 => '',
            1 => 't.id',
            2 => 'customer.customer_name',
            3 => 't.invoice_date',
            4 => 'currencyname.currency_code',
            5 => 'paymentTerm.payment_terms',
            6 => 't.invoice_date',
            7 => 't.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        //$orderBy = 't.id DESC';
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" ';
        if (!isset(Yii::app()->user->havePermissionOn["{$prefix}_view_all"]) && Yii::app()->user->authorised_user != 1) {
            $condition .= ' AND (t.lead_owner_id= "' . Yii::app()->user->id . '" OR file.lead_owner_id="' . Yii::app()->user->id . '")';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND ( t.id LIKE '%" . $searchString . "%' OR customer.customer_name LIKE '%" . $searchString . "%' OR paymentTerm.payment_terms LIKE '%" . $searchString . "%' OR t.invoice_date LIKE '%" . $searchString . "%' OR currencyname.currency_code LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('customer', 'paymentTerm', 'currencyname', 'file')->count(array('condition' => $condition));
        $model = $model->with('customer', 'currencyname', 'paymentTerm', 'file')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $status = '';
        $m = 0;
        foreach ($model as $row) {
            if ((int) $row['paymentTerm']['no_of_days'] > 0) {
                $receipt_date = date("d/m/Y", strtotime($row['invoice_date'] . "+" . $row['paymentTerm']['no_of_days'] . " days"));
            } else {
                $receipt_date = date("d/m/Y", strtotime($row['invoice_date']));
            }
            $d1 = strtotime(date("Y-m-d"));
            $date_to = date("Y-m-d", strtotime($row['invoice_date'] . "+" . $row['paymentTerm']['no_of_days'] . " days"));
            $d2 = strtotime($date_to);
            $datediff = $d1 - $d2;
            $diff = floor($datediff / (60 * 60 * 24));
            $m++;
            $rowData[] = array($m, $row['id'], $row['customer']['customer_name'], date("d/m/Y", strtotime($row['invoice_date'])), '<div class="text-right">' . $row['currencyname']['currency_code'] . ' ' . Yii::app()->numberFormatter->formatCurrency($row['grand_total'], "") . '</div>', $row['paymentTerm']['payment_terms'], $receipt_date, $diff);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionRemovelineItem() {
        $id = $_POST['id'];
        $frm = $_POST['frm'];
        if ($id > 0) {
            if ($frm == 'manhours') {
                $model = new OrderManhours();
            } else if ($frm == 'materialusage') {
                $model = new OrderMaterialUsage();
            } else if ($frm == 'machinehrs') {
                $model = new OrderMachinehours();
            }
            $model->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }

        echo CJSON::encode($status);
    }

    public function actionPrintOrderAvailableQtyPDF() {
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.order_availability', array('id' => $id), true));
        $mPDF1->Output("Quotation.pdf", 'I');
    }

    public function actionGetItemHistory() {
        $product_id = $_POST['product_id'];
        $customer_id = $_POST['customer_id'];
        $availble_qty = Yii::app()->db->createCommand('SELECT SUM(quantity) as availble_qty FROM `view_all_stock_items` WHERE id=' . $product_id . ' AND stock_updated="Y" GROUP BY id')->queryScalar();
        $model = new OrderItem();
        $arr_prev_rates = $model->with('order')->findAll(array('condition' => 'order.customer_id=' . $customer_id . ' AND t.product_id=' . $product_id, 'order' => 't.id DESC', 'limit' => 5));
        $table = '<table class="table table-sm table-theme table-bordered" id="prev_orders">
                              <thead>
                               <tr>
                               <th>Available Qty</th>
                               <th>' . $availble_qty . '</td>
                               </tr>
                               <tr><th colspan="2" style="background:#f5fca9;">Previous Rate</th></tr>
                                <tr>
                                    <th>Date</th>
                                    <th>Rate</th>
                                </tr>
                              </thead>
                              <tbody>';
        if (!empty($arr_prev_rates)) {
            foreach ($arr_prev_rates as $each) {
                $table .= '<tr>';
                $table .= '<td>' . date('d/m/Y', strtotime($each->order->order_date)) . '</td>';
                $table .= '<td class="text-right">' . $each->rate . '</td>';
                $table .= '</tr>';
            }
        } else {
            $table .= '<tr>';
            $table .= '<td colspan="2">No Data</td>';
            $table .= '</tr>';
        }

        $table .= '</tbody></table>';
        $jsonData['table'] = $table;
        echo CJSON::encode($jsonData);
    }

    public function actionGetunitRate() {
        //$row_id = $_POST['row_field'];
        $product_id = (int) $_POST['product_id'];
        $customer_id = (int) $_POST['customer_id'];
        $unit_id = (int) $_POST['unit'];
        $selling_price = $_POST['selling_price'];
        //echo  $unit_id;
        $drop = array();
        $modelOrder = new OrderItem;

        if ($product_id > 0) {

            $arr_uom = UnitOfMeasurement::model()->findByPK($unit_id);

            $modelCustomer = new Customer();
            $arr_customer_details = $modelCustomer->findByPk($customer_id);

            $customer_price_group_id = $arr_customer_details->default_pricing_group_id;

            $pricing_condition = 'product_id=' . $eachModel['id'];
            //code added by abin on 21/12/2023 for   new pricing concept base on customer price group name
            if ((int) $customer_price_group_id > 0) {
                $pricing_condition = ' pricing_group_id = ' . $customer_price_group_id . ' AND product_id=' . $product_id;
            }
            $arr_price_list = SalesPriceGroup::model()->find(array('condition' => $pricing_condition, 'order' => 'id DESC'));

            $sales_price = '';

            if (isset($arr_price_list->sales_price) && $arr_price_list->sales_price != '') {

                $sales_price = $arr_price_list->sales_price;
            }




            $drop['factor'] = $arr_uom->factor;
            //if ((int) $sales_price > 0) {
            $drop['selling_price'] = number_format(((float) $sales_price), 2, '.', '');
            /* } else {
              $drop['selling_price'] = number_format(((float) $selling_price * $arr_uom->factor), 2, '.', '');
              } */
        }


        echo CJSON::encode($drop);
    }

    public function actionGetOrderCount() {
        $filter = Yii::app()->request->getPost('filter');
        $frm = Yii::app()->request->getPost('frm');
        $prefix = ($frm == 3) ? 'service_order' : 'order';

        $model = new Order();

        $qty = 0;
        $total = 0;
        $extra_years = [];
        $current_year = date('Y');

        // Helper function to get date range for filter and year offset
        $getDateRange = function ($filter, $yearOffset = 0) {
            $targetDate = strtotime("-{$yearOffset} year");
            $year = date('Y', $targetDate);

            switch ($filter) {
                case 'today':
                    $date = date('Y-m-d', $targetDate);
                    return [$date, $date, $year];

                case 'yesterday':
                    $date = date('Y-m-d', strtotime('-1 day', $targetDate));
                    return [$date, $date, $year];

                case 'this_month':
                    $month = date('m');
                    $start = "{$year}-{$month}-01";
                    $end = date('Y-m-t', strtotime($start));
                    return [$start, $end, $year];

                case 'this_year':
                    return ["{$year}-01-01", "{$year}-12-31", $year];

                case 'this_week':
                    $monday = date('Y-m-d', strtotime("monday this week", $targetDate));
                    $sunday = date('Y-m-d', strtotime("sunday this week", $targetDate));
                    return [$monday, $sunday, $year];

                case 'last_week':
                    $monday = date('Y-m-d', strtotime("monday last week", $targetDate));
                    $sunday = date('Y-m-d', strtotime("sunday last week", $targetDate));
                    return [$monday, $sunday, $year];

                case 'quarterly':
                    $month = date('n', $targetDate); // 1-12
                    if ($month >= 1 && $month <= 3) {
                        $start = "$year-01-01";
                        $end = "$year-03-31";
                    } elseif ($month >= 4 && $month <= 6) {
                        $start = "$year-04-01";
                        $end = "$year-06-30";
                    } elseif ($month >= 7 && $month <= 9) {
                        $start = "$year-07-01";
                        $end = "$year-09-30";
                    } else {
                        $start = "$year-10-01";
                        $end = "$year-12-31";
                    }
                    return [$start, $end, $year];

                default:
                    return [null, null, null];
            }
        };

        // Step 1: Get current period range
        list($startDate, $endDate, $current_year) = $getDateRange($filter, 0);

        if (!$startDate || !$endDate) {
            echo CJSON::encode(['status' => 'error', 'message' => 'Invalid filter']);
            Yii::app()->end();
        }

        if ($frm == 3) {
            $condition = "order_type = 'service'";
        } else {
            $condition = "order_type != 'service'";
        }

        if (!(Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["{$prefix}_view_all"])) {
            $condition .= ' AND t.lead_owner_id = ' . Yii::app()->user->id;
        }

        $condition .= " AND order_date >= :startDate AND order_date <= :endDate";

        $params = [
            ':startDate' => $startDate,
            ':endDate' => $endDate
        ];

        $invoices = $model->findAll($condition, $params);
        $qty = count($invoices);
        foreach ($invoices as $row) {
            $total += $row->grand_total * $row->exchange_rate;
        }

        // Step 3: Fetch previous 2 years
        for ($i = 1; $i <= 2; $i++) {
            list($prevStart, $prevEnd, $yearLabel) = $getDateRange($filter, $i);

            $conditionPrev = 'order_date >= :startDate AND order_date <= :endDate';
            $paramsPrev = [':startDate' => $prevStart, ':endDate' => $prevEnd];

            $prevInvoices = $model->findAll($conditionPrev, $paramsPrev);
            $prevQty = count($prevInvoices);
            $prevTotal = 0;

            foreach ($prevInvoices as $row) {
                $prevTotal += $row->grand_total * $row->exchange_rate;
            }

            $extra_years[] = [
                'year' => $yearLabel,
                'qty' => $prevQty,
                'total' => $prevTotal,
                'date' => in_array($filter, ['today', 'yesterday']) ? date('d-m-Y', strtotime($prevStart)) : null,
            ];
        }

        // Final output
        echo CJSON::encode([
            'status' => 'success',
            'data' => [
                'qty' => $qty,
                'total' => $total,
                'current_period' => in_array($filter, ['today', 'yesterday']) ? date('d-m-Y', strtotime($startDate)) : $current_year,
                'previous_years' => $extra_years,
            ]
        ]);
        Yii::app()->end();
    }

    public function actionUploadDocumentOrder() {
        Yii::import("ext.EAjaxUpload.qqFileUploader");

        $folder = Yii::getPathOfAlias('webroot') . '/' . $_GET['folder'] . '/'; // target folder
        $allowedExtensions = array("jpg", "png", "doc", "docx", "xls", "xlsx", "pdf", "bmp", "jpeg");
        $sizeLimit = 1 * 1024 * 1024; // 1MB limit

        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);

        if ($result['success']) {
            $originalFile = $result['filename'];
            $extension = pathinfo($originalFile, PATHINFO_EXTENSION);
            $datePrefix = date('Y-m-d') . '-';

            $newFileName = $datePrefix . $originalFile;
            $oldPath = $folder . $originalFile;
            $newPath = $folder . $newFileName;

            if (file_exists($oldPath)) {
                rename($oldPath, $newPath);
            }

            $result['filename'] = $newFileName;
            $result['fileType'] = strtolower($extension);
        }

        echo htmlspecialchars(json_encode($result), ENT_NOQUOTES);
    }

    public function actionConvertProduction() {
        $id = (int) Yii::app()->request->getParam('order_id');
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $model = new Order();
        $condition = 'order_id="' . $id . '"'; //To fetch master
        $modelOrderItems = OrderItem::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));

        if (!empty($modelQuotesItems)) {
            foreach ($modelQuotesItems as $eachItem) {
                if ($eachItem->checked == 1) {
                    $modelOrderItems[$k] = new OrderItem;
                    $modelOrderItems[$k]->attributes = $eachItem->attributes;
                    $modelOrderItems[$k]->unit_id = $eachItem->unit_id;
                    //code added by abin on 24-01-2024 to get the quotes id
                    $modelOrderItems[$k]->quotes_item_id = $eachItem->id;
                    $k++;
                }
            }
        }
        // var_dump($modelOrderItems);
        // die();
        $this->render('convert_production', array('modelOrderItems' => $modelOrderItems, 'order_id' => $id, 'customer_id' => $customer_id, 'model' => $model));
    }

    public function actionGetOrderDetails() {
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $term = Yii::app()->request->getParam('term');

        $condition = 't.id LIKE "%' . $searchTerm . '%" AND t.isActive="Y"';

        if ($customer_id > 0) {
            $condition .= ' AND t.customer_id=' . $customer_id;
        }

        $modelOrder = new Order();
        $modelOrder = $modelOrder->with('customer')->findAll(array(
            'condition' => $condition,
            'limit' => 200
        ));
        $i = 0;
        $data = array();
        foreach ($modelOrder as $eachModel) {

            $data[$i]['label'] = $eachModel->id;
            $data[$i]['value'] = $eachModel->customer->customer_name;
            $data[$i]['customer_id'] = $eachModel->customer_id;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionPrintOrderReportPDFNew() {
        $model = new Order();

        $id = Yii::app()->request->getParam('id');
        $c_id = Yii::app()->request->getParam('c_id');
        $type = Yii::app()->request->getParam('type');
        $print_type = Yii::app()->request->getParam('print_type');

        $preview = Yii::app()->request->getParam('preview');

        if ($id > 0) {

            $model = new Order();
            $model = Order::model()->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $borderHeader = '
<htmlpageheader name="pageBorderHeader">
    <div style="
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        border: 5px solid red;
        box-sizing: border-box;
        z-index: -1000;
    ">
    </div>
</htmlpageheader>

<sethtmlpageheader name="pageBorderHeader" value="on" show-this-page="1" />
';
        $mPDF1->WriteHTML($borderHeader, \Mpdf\HTMLParserMode::HEADER_CSS);

        if ($preview == 'Y') {//preview
            $mPDF1->SetWatermarkText('PREVIEW');
            $mPDF1->showWatermarkText = true;
        }
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.order_list_individual_new', array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title, 'title' => $title, 'type' => $type, 'mpdf' => $mPDF1, 'print_type' => $print_type), true));

        $page_title = $id . '-O-' . $model->customer->customer_name . '.pdf';
        $mPDF1->Output($page_title, 'I');
    }

    public function actionApproveLevel() {
        $model = new Order();
        $level = (int) Yii::app()->request->getParam('level');
        $id = (int) Yii::app()->request->getParam('id');
        $frm = (int) Yii::app()->request->getParam('frm');
        $quote_id = (int) Yii::app()->request->getParam('quote_id');
        $file_id = (int) Yii::app()->request->getParam('file_id');
        $type = Yii::app()->request->getParam('type');
        $duplicate = (int) Yii::app()->request->getParam('duplicate');
        $modelNotes = new Activity();
        $modelOrderItems = array(new OrderItem);
        $modelOrderContractItem = array(new OrderContractItem);
        $modelOrderAdditions = array(new OrderAddition);
        $modelOrderDeductions = array(new OrderDeduction);
        $modelMachinehours_invoiced = array();
        $modelManhours_invoiced = array();
        $modelMaterialUsage_invoiced = array();
        $blocked_min_date = '';
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelmasterfile = new MasterFile();
            $modelmasterfile = $modelmasterfile->findByPk($model->file_id);
            $condition = 'order_id="' . $id . '"'; //To fetch master
            $model_proforma = OrderProformaInvoice::model()->find(array('condition' => 'order_id="' . $id . '"'));
            if ($model_proforma->id == '') {
                $model_proforma = new OrderProformaInvoice();
            }
            $modelOrderItems = OrderItem::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));
            $modelOrderContractItem = OrderContractItem::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));
            $modelOrderAdditions = OrderAddition::model()->findAll(array('condition' => 'order_id="' . $id . '"', 'order' => 'id ASC'));
            $modelOrderDeductions = OrderDeduction::model()->findAll(array('condition' => 'order_id="' . $id . '"', 'order' => 'id ASC'));
            if ($duplicate == '1') {
                $model->id = '';
                $model->file_id = '';
                // $file_id = '';
                $k = 0;
                foreach ($modelOrderItems as $eachItem) {
                    $Items[$k] = new OrderItem;
                    $Items[$k]->attributes = $eachItem->attributes;
                    $Items[$k]->id = '';
                    $k++;
                }
                $l = 0;
                foreach ($modelOrderContractItem as $eachItem) {
                    $ItemsContact[$l] = new OrderContractItem;
                    $ItemsContact[$l]->attributes = $eachItem->attributes;
                    $ItemsContact[$l]->id = '';
                    $l++;
                }

                foreach ($modelOrderAdditions as $i => $eachItem) {
                    $Additions[$i] = new OrderAddition;
                    $Additions[$i]->attributes = $eachItem->attributes;
                }
                foreach ($modelOrderDeductions as $i => $eachItem) {
                    $Deductions[$i] = new OrderDeduction;
                    $Deductions[$i]->attributes = $eachItem->attributes;
                }
                $modelOrderItems = $Items;
                $modelOrderContractItem = $ItemsContact;
                $modelOrderAdditions = $Additions;
                $modelOrderDeductions = $Deductions;
            }
            if (empty($modelOrderItems)) {
                $modelOrderItems = array(new OrderItem);
            }
            if (empty($modelOrderContractItem)) {
                $modelOrderContractItem = array(new OrderContractItem);
            }
            if (empty($modelOrderAdditions)) {
                $modelOrderAdditions = array(new OrderAddition);
            }
            if (empty($modelOrderDeductions)) {
                $modelOrderDeductions = array(new OrderDeduction);
            }
        }
        if ($quote_id > 0) {//convert from quote to order
            $modelQuotes = Quotes::model()->findByPK($quote_id);
            $modelmasterfile = MasterFile::model()->findByPk($modelQuotes->file_id);
            $model->file_id = $modelQuotes->file_id;
            $model->quotes_id = $modelQuotes->id;
            $model->customer_id = $modelQuotes->customer_id;
            $model->inco_term_id = $modelQuotes->inco_term_id;
            $model->customer_name = $modelQuotes->customer->customer_name;
            if ($modelQuotes->lead_owner_id > 0) {
                $model->lead_owner_id = $modelQuotes->lead_owner_id;
            } else {
                $model->lead_owner_id = $modelQuotes->file->lead_owner_id;
            }
            $model->contact_id = $modelQuotes->contact_id;
            $model->ticket_id = $modelQuotes->ticket_id;
            $model->billing_address = $modelQuotes->billing_address;
            $model->sales_group_id = $modelQuotes->sales_group_id;
            $model->currency_id = $modelQuotes->currency_id;
            $model->exchange_rate = $modelQuotes->exchange_rate;
            $model->payment_terms_id = $modelQuotes->payment_terms_id;
            $model->notes = $modelQuotes->notes;
            $model->remarks = $modelQuotes->remarks;
            $model->terms_id = $modelQuotes->terms_id;
            $model->terms_and_conditions = $modelQuotes->terms_and_conditions;
            $model->file_title = $modelQuotes->file_title;
            $model->invoice_type_id = $modelQuotes->invoice_type_id;
            $model->project_id = $modelQuotes->project_id;
            $model->job_order_id = $modelQuotes->job_order_id;
            //code added by mereena on 12/01/2024 to get totaldiscount percentage
            $model->total_discount_percentage = $modelQuotes->total_discount_percentage;
            $model->total_discount_amount = $modelQuotes->total_discount_amount;
            $model->customer_outlet_id = $modelQuotes->customer_outlet_id;
            $k = 0;
            $l = 0;
            $conditionitems = 'quotes_id="' . $quote_id . '"';
            $modelQuotesItems = QuotesItem::model()->findAll(array('condition' => $conditionitems, 'order' => 't.id asc'));
            if (!empty($modelQuotesItems)) {
                foreach ($modelQuotesItems as $eachItem) {
                    if ($eachItem->checked == 1) {
                        $modelOrderItems[$k] = new OrderItem;
                        $modelOrderItems[$k]->attributes = $eachItem->attributes;
                        $modelOrderItems[$k]->unit_id = $eachItem->unit_id;
                        //code added by abin on 24-01-2024 to get the quotes id
                        $modelOrderItems[$k]->quotes_item_id = $eachItem->id;
                        $k++;
                    }
                }
            }


            $modelQuotesContactItems = QuotesContractItem::model()->findAll(array('condition' => $conditionitems, 'order' => 't.id asc'));
            if (!empty($modelQuotesContactItems)) {
                foreach ($modelQuotesContactItems as $eachItem) {
                    $modelOrderContractItem[$l] = new OrderContractItem;
                    $modelOrderContractItem[$l]->attributes = $eachItem->attributes;
                    $modelOrderContractItem[$l]->unit_id = $eachItem->unit_id;
                    $l++;
                }
            }

            foreach ($modelQuotes->adItems as $i => $eachItem) {
                $modelOrderAdditions[$i] = new OrderAddition;
                $modelOrderAdditions[$i]->attributes = $eachItem->attributes;
            }
            foreach ($modelQuotes->dedItems as $i => $eachItem) {
                $modelOrderDeductions[$i] = new OrderDeduction;
                $modelOrderDeductions[$i]->attributes = $eachItem->attributes;
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('approvelevel', array(
            'model' => $model,
            'modelQuotesItems' => $modelQuotesItems,
            'modelQuotesContactItems' => $modelQuotesContactItems,
            'modelQuotesAdditions' => $modelQuotesAdditions,
            'modelQuotesDeductions' => $modelQuotesDeductions,
            'modelQuotes' => $modelQuotes,
            'modelmasterfile' => $modelmasterfile,
            'modelOrderItems' => $modelOrderItems,
            'modelOrderContractItem' => $modelOrderContractItem,
            'modelOrderAdditions' => $modelOrderAdditions,
            'modelOrderDeductions' => $modelOrderDeductions,
            'modelNotes' => $modelNotes,
            'quote_id' => $quote_id,
            'file_id' => $file_id,
            'id' => $id,
            'type' => $type,
            'frm' => $frm,
            'level' => $level
        ));
    }

}
