<?php

class NotificationController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetList','Create','SaveNotification','Deletenotification'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }
     public function actionGetList() {
        $model = new CalendarNotification();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'start_date',
            2 => 'end_date',
            3 => 'notification',
            4 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "1=1";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and (notification LIKE '%".$searchString."%')";      
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'start_date asc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
      
            $start_date = "";
            $end_date = "";
            if ($row['start_date'] != '' && $row['start_date'] != '0000-00-00') {
                $start_date = date("d/m/Y", strtotime($row->start_date));
            }
            if ($row['end_date'] != '' && $row['end_date'] != '0000-00-00') {
                $end_date = date("d/m/Y", strtotime($row->end_date));
            }            
            $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'notification/create&id='.$row['id'].'\',\'Edit Notification   \',\'lg\')"><i class="fa fa-edit"></i></button>';

            if(strtotime($row['start_date'])>  strtotime(date('Y-m-d'))){
                $button_string .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deletenotification('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';                      
                       
            }
            $rowData[] = array($m,$start_date, $end_date, $row->notification, $button_string);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate()
    {
        $model       = new CalendarNotification(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }                              
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }
    public function actionSaveNotification() {
        
         $model = new CalendarNotification;
        if (isset($_POST['CalendarNotification'])) {
            if ((int) @$_POST['CalendarNotification']['id'] > 0) {
                $model->id = (int) $_POST['CalendarNotification']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }
            $model->notification   = $_POST['CalendarNotification']['notification'];  
            if ($_POST['CalendarNotification']['start_date'] != '0000-00-00' && $_POST['CalendarNotification']['start_date'] != '') {
                $model->start_date = str_replace('/', '-', $_POST['CalendarNotification']['start_date']);
                $model->start_date = date("Y-m-d", strtotime($model->start_date));
            }
            if ($_POST['CalendarNotification']['end_date'] != '0000-00-00' && $_POST['CalendarNotification']['end_date'] != '') {
                $model->end_date = str_replace('/', '-', $_POST['CalendarNotification']['end_date']);
                $model->end_date = date("Y-m-d", strtotime($model->end_date));
            }
            if ($model->validate()) {
                $model->save();
                $model->refresh();
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);          
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
        Yii::app()->end();
          
    }
    public function actionDeletenotification() {
        $id = (int) Yii::app()->request->getParam('id');
        if ($id != 0) {
            CalendarNotification::model()->deletebyPK($id);
            echo CJSON::encode(array('status' => 'success'));
        }
    }
}
