<?php

class ModulesettingsController extends Controller
{
//	public function actionIndex()
//	{
//		$this->render('index');
//	}
    
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','DeleteModuleSettings','SaveModuleSettings','GetModuleSettingsList', 'Disable'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
        
        $this->render('index');
         }
         
        public function actionGetModuleSettingsList()
         {
 
            $model=new MasModuleSettings();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   
                     0 =>'id',
                     1 =>'erp_module_name',
                     2 =>'grant_access',
                 
                 
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                // $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (erp_module_name LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $div='';
                   // if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_ModuleSettings_edit"])){
                        $div.='<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'ModuleSettings/create&id='.$row['id'].'\',\'ModuleSettings - '.$row['erp_module_name'].' \',\'lg\')"><i class="fa fa-pencil"></i></button> ';
                    ///}
                    $rowData[]=array($m,
                        $row['erp_module_name'],
                        ($row['grant_access']=='1')?'Yes':'No',
                        '<div class="btn-wrap text-center">'.$div.'</div>',
                         array('id' => $row['id'],'code'=>$row['erp_module_name'] , 'status' => $row->isActive));       
                    
                    
                    
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new MasModuleSettings(); 
        $id=(int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
             Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('settings_form', array('model' => $model), false, true);
    }
    public function actionSaveModuleSettings()
        {
            $model = new MasModuleSettings();
            if (isset($_POST['MasModuleSettings']))
            {   $model->created_by = Yii::app()->user->id;
                $model->created_date_time =date('Y-m-d h:i:s');
    		
    		if ((int) @$_POST['MasModuleSettings']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_date_time =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['MasModuleSettings']['id'];
                    $model=$model->findByPk($id); 
                    $audit_type = 'UPDATED';
                    $edit_flag=1;
                }else{
                    $audit_type = 'CREATED';
                }
                 $model->attributes			=	$_POST['MasModuleSettings'];
                 $model->erp_module_name			=	trim($_POST['MasModuleSettings']['erp_module_name']);
                if($model->save())
                {
                                        
                        // inserting to audit log
                        // AuditLog::saveAuditLogs(
                        //     'ModuleSettings_MASTER',
                        //     Yii::app()->user->id,
                        //     $audit_type,
                        //     " with name: - {$model->ModuleSettings_name}  "
                        // );
                        // end audit log
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['settings_form'];
                        $jsonData['id'] = $model->id;
	                	echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }

            }
        }
        public function actionDeleteModuleSettings()
    {
		        $id = $_POST['id'];
                 
               if($id>0){
                    $model=new MasModuleSettings();
                    $ModuleSettings = $model->findByPk($id);
                    $model->deleteByPk($id);
                    // inserting to audit log
                    // AuditLog::saveAuditLogs(
                    //     'ModuleSettings_MASTER',
                    //     Yii::app()->user->id,
                    //     'DELETED',
                    //     " with name: - {$ModuleSettings->ModuleSettings_name}  "
                    // );
                    // end audit log
                    echo "success";
                }
                else
                    echo "error";
                
    }
    
    
            public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasModuleSettings();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
}