<?php

class MisController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','PrintSales','PrintPurchase', 'PrintCustomers','PrintVendors','PrintServiceDetails',
                    'PrintPurchaseDeliveryTracker','PrintSalesDeliveryTracker','Load_customer','Load_vendor'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $this->render('index');
    }
    public function actionPrintSales() {

        $customer_id = $_POST['customer_id'];
        $startDate = $_POST['start_date'];
        $closingDate = $_POST['end_date'];   

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_sales', array(                       
            'customer_id' => $customer_id,
            'startDate' => $startDate,
            'closingDate' => $closingDate
        ));
    }
    public function actionPrintCustomers(){
        $customer_id = $_POST['customer_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_customers', array(                       
            'customer_id' => $customer_id,
        ));
    }
    public function actionPrintVendors(){
        $customer_id = $_POST['customer_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_vendors', array(                       
            'customer_id' => $customer_id,
        ));
    }
    public function actionLoad_customer(){
        $type = $_POST['type'];
        $customer_id = $_POST['customer_id'];
        $startDate = $_POST['start_date'];
        $closingDate = $_POST['end_date'];
        if($type=='newcus'){
            $this->renderPartial('new_customers', 
                    array(  'startDate' => $startDate,
                            'customer_id' => $customer_id,
                            'closingDate' => $closingDate
            ));
        }
        if($type=='mostcontactcus'){
            $this->renderPartial('most_contact_customers', 
                    array(  'startDate' => $startDate,
                            'customer_id' => $customer_id,
                            'closingDate' => $closingDate
            ));
        }
        if($type=='noncontactcus'){
            $this->renderPartial('non_contact_customers', 
                    array(  'startDate' => $startDate,
                            'customer_id' => $customer_id,
                            'closingDate' => $closingDate
            ));
        }
        if($type=='missedcus'){
            $this->renderPartial('missed_customers', 
                    array(  'startDate' => $startDate,
                            'customer_id' => $customer_id,
                            'closingDate' => $closingDate
            ));
        }
        if($type=='bestordercus'){
            $this->renderPartial('bestorder_customers', 
                    array(  'startDate' => $startDate,
                            'customer_id' => $customer_id,
                            'closingDate' => $closingDate
            ));
        }
        if($type=='nonordercus'){
            $this->renderPartial('nonorder_customers', 
                    array(  'startDate' => $startDate,
                            'customer_id' => $customer_id,
                            'closingDate' => $closingDate
            ));
        }if($type=='qnordercus'){
            $this->renderPartial('qnorder_customers', 
                    array(  'startDate' => $startDate,
                            'customer_id' => $customer_id,
                            'closingDate' => $closingDate
            ));
        }
        if($type=='bestpaycus'){
            $this->renderPartial('bestpay_customers', 
                    array(  'startDate' => $startDate,
                            'customer_id' => $customer_id,
                            'closingDate' => $closingDate
            ));
        }
        if($type=='bstcusitem'){
            $this->renderPartial('best_customer_item', 
                    array(  'startDate' => $startDate,
                            'customer_id' => $customer_id,
                            'closingDate' => $closingDate
            ));
        }
    }
    public function actionLoad_vendor(){
        $type = $_POST['type'];
        $customer_id = $_POST['customer_id'];
        $startDate = $_POST['start_date'];
        $closingDate = $_POST['end_date'];
        if($type=='newven'){
            $this->renderPartial('new_vendors', 
                    array(  'startDate' => $startDate,
                            'customer_id' => $customer_id,
                            'closingDate' => $closingDate
            ));
        }
        if($type=='mostcontactcus'){
            $this->renderPartial('most_contact_customers', 
                    array(  'startDate' => $startDate,
                            'customer_id' => $customer_id,
                            'closingDate' => $closingDate
            ));
        }
        if($type=='noncontactcus'){
            $this->renderPartial('non_contact_customers', 
                    array(  'startDate' => $startDate,
                            'customer_id' => $customer_id,
                            'closingDate' => $closingDate
            ));
        }
        if($type=='missedcus'){
            $this->renderPartial('missed_customers', 
                    array(  'startDate' => $startDate,
                            'customer_id' => $customer_id,
                            'closingDate' => $closingDate
            ));
        }
        if($type=='bestordercus'){
            $this->renderPartial('bestorder_customers', 
                    array(  'startDate' => $startDate,
                            'customer_id' => $customer_id,
                            'closingDate' => $closingDate
            ));
        }
        if($type=='bestpaycus'){
            $this->renderPartial('bestpay_customers', 
                    array(  'startDate' => $startDate,
                            'customer_id' => $customer_id,
                            'closingDate' => $closingDate
            ));
        }
    }

    public function actionPrintCustomerDetails() {

        $customer_id = $_POST['customer_id'];

        $startDate = $_POST['start_date'];

        $closingDate = $_POST['end_date'];

        $condition = '1=1';
        $condition_CustomerId = '1=1';

        if ($customer_id != '') {
            $condition .= ' AND customer_id ="' . $customer_id . '"';
            $condition_CustomerId .= ' AND customer_id ="' . $customer_id . '"';
        }
        if ($startDate != '') {

            $startDate = str_replace('/', '-', $startDate);
            $startDate = date('Y-m-d', strtotime($startDate));
            $condition .= ' AND activity_created_date >="' . $startDate . '"';
        }
        if ($closingDate != '') {

            $closingDate = str_replace('/', '-', $closingDate);
            $closingDate = date('Y-m-d', strtotime($closingDate));
            $condition .= ' AND activity_created_date <="' . $closingDate . '"';
        }

        $status_Call_count = Yii::app()->db->createCommand("SELECT COUNT(*) FROM crm_activity WHERE " . $condition . " AND type_of_activity='C'")->queryScalar();
        $status_Task_count = Yii::app()->db->createCommand("SELECT COUNT(*) FROM crm_activity WHERE " . $condition . " AND type_of_activity='T'")->queryScalar();
        $status_Meeting_count = Yii::app()->db->createCommand("SELECT COUNT(*) FROM crm_activity WHERE " . $condition . " AND type_of_activity='M'")->queryScalar();
        $status_Visit_count = Yii::app()->db->createCommand("SELECT COUNT(*) FROM crm_activity WHERE " . $condition . " AND type_of_activity='V'")->queryScalar();


        $currentDate = date('Y-m-d');

        $call_current_date_count = Yii::app()->db->createCommand("SELECT COUNT(*) FROM crm_activity WHERE  " . $condition_CustomerId . " AND type_of_activity='C' AND activity_created_date = '" . $currentDate . "'")->queryScalar();
        $talk_current_date_count = Yii::app()->db->createCommand("SELECT COUNT(*) FROM crm_activity WHERE  " . $condition_CustomerId . " AND type_of_activity='T' AND activity_created_date = '" . $currentDate . "'")->queryScalar();
        $meeting_current_date_count = Yii::app()->db->createCommand("SELECT COUNT(*) FROM crm_activity WHERE  " . $condition_CustomerId . " AND type_of_activity='M' AND activity_created_date = '" . $currentDate . "'")->queryScalar();
        $visit_current_date_count = Yii::app()->db->createCommand("SELECT COUNT(*) FROM crm_activity WHERE  " . $condition_CustomerId . " AND type_of_activity='V' AND activity_created_date = '" . $currentDate . "'")->queryScalar();


        //to get current week
        $ts = strtotime($currentDate);
        $start = (date('w', $ts) == 0) ? $ts : strtotime('last sunday', $ts);
        $week_start_date = date('Y-m-d', $start);
        $week_end_date = date('Y-m-d', strtotime('next saturday', $start));

        //Current week count
        $call_current_week_count = Yii::app()->db->createCommand("SELECT COUNT(*) FROM crm_activity WHERE  " . $condition_CustomerId . " AND type_of_activity='C' AND activity_created_date BETWEEN '" . $week_start_date . "' AND '" . $week_end_date . "' ")->queryScalar();
        $talk_current_week_count = Yii::app()->db->createCommand("SELECT COUNT(*) FROM crm_activity WHERE  " . $condition_CustomerId . " AND type_of_activity='T' AND activity_created_date BETWEEN '" . $week_start_date . "' AND '" . $week_end_date . "' ")->queryScalar();
        $meeting_current_week_count = Yii::app()->db->createCommand("SELECT COUNT(*) FROM crm_activity WHERE  " . $condition_CustomerId . " AND type_of_activity='M' AND activity_created_date BETWEEN '" . $week_start_date . "' AND '" . $week_end_date . "' ")->queryScalar();
        $visit_current_week_count = Yii::app()->db->createCommand("SELECT COUNT(*) FROM crm_activity WHERE  " . $condition_CustomerId . " AND type_of_activity='V' AND activity_created_date BETWEEN '" . $week_start_date . "' AND '" . $week_end_date . "' ")->queryScalar();

        //to get current month
        $first_day_this_month = date('Y-m-01');
        $last_day_this_month = date('Y-m-t');

        $call_current_month_count = Yii::app()->db->createCommand("SELECT COUNT(*) FROM crm_activity WHERE  " . $condition_CustomerId . " AND type_of_activity='C' AND activity_created_date BETWEEN '" . $first_day_this_month . "' AND '" . $last_day_this_month . "' ")->queryScalar();
        $talk_current_month_count = Yii::app()->db->createCommand("SELECT COUNT(*) FROM crm_activity WHERE  " . $condition_CustomerId . " AND type_of_activity='T' AND activity_created_date BETWEEN '" . $first_day_this_month . "' AND '" . $last_day_this_month . "' ")->queryScalar();
        $meeting_current_month_count = Yii::app()->db->createCommand("SELECT COUNT(*) FROM crm_activity WHERE  " . $condition_CustomerId . " AND type_of_activity='M' AND activity_created_date BETWEEN '" . $first_day_this_month . "' AND '" . $last_day_this_month . "' ")->queryScalar();
        $visit_current_month_count = Yii::app()->db->createCommand("SELECT COUNT(*) FROM crm_activity WHERE  " . $condition_CustomerId . " AND type_of_activity='V' AND activity_created_date BETWEEN '" . $first_day_this_month . "' AND '" . $last_day_this_month . "' ")->queryScalar();


        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_customers_details', array(
            'status_call_count' => $status_Call_count,
            'status_task_count' => $status_Task_count,
            'status_meeting_count' => $status_Meeting_count,
            'status_visit_count' => $status_Visit_count,
            'call_current_date_count' => $call_current_date_count,
            'talk_current_date_count' => $talk_current_date_count,
            'meeting_current_date_count' => $meeting_current_date_count,
            'visit_current_date_count' => $visit_current_date_count,
            'call_current_week_count' => $call_current_week_count,
            'talk_current_week_count' => $talk_current_week_count,
            'meeting_current_week_count' => $meeting_current_week_count,
            'visit_current_week_count' => $visit_current_week_count,
            'call_current_month_count' => $call_current_month_count,
            'talk_current_month_count' => $talk_current_month_count,
            'meeting_current_month_count' => $meeting_current_month_count,
            'visit_current_month_count' => $visit_current_month_count,
            'startDate' => $startDate,
            'customer_id' => $customer_id,
            'closingDate' => $closingDate
        ));
    }
    public function actionPrintPurchaseDeliveryTracker() {

        $customer_id = $_POST['customer_id'];
        $startDate = $_POST['start_date'];
        $closingDate = $_POST['end_date'];
     
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_purchase_delivery_track', array(          
            'startDate' => $startDate,
            'customer_id' => $customer_id,
            'closingDate' => $closingDate
        ));
    }
    public function actionPrintSalesDeliveryTracker() {

        $customer_id = $_POST['customer_id'];
        $startDate = $_POST['start_date'];
        $closingDate = $_POST['end_date'];
     
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_sales_delivery_track', array(          
            'startDate' => $startDate,
            'customer_id' => $customer_id,
            'closingDate' => $closingDate
        ));
    }
     
    public function actionPrintServiceDetails() {
        $customer_id = $_POST['customer_id'];

        $startDate = $_POST['start_date'];

        $closingDate = $_POST['end_date'];

        $condition = '1=1';
        $condition_CustomerId = '1=1';

        if ($customer_id != '') {
            $condition .= ' AND customer_id ="' . $customer_id . '"';
            $condition_CustomerId .= ' AND customer_id ="' . $customer_id . '"';
        }
        if ($startDate != '') {

            $startDate = str_replace('/', '-', $startDate);
            $startDate = date('Y-m-d', strtotime($startDate));
            $condition .= ' AND date >="' . $startDate . '"';
        }
        if ($closingDate != '') {

            $closingDate = str_replace('/', '-', $closingDate);
            $closingDate = date('Y-m-d', strtotime($closingDate));
            $condition .= ' AND date <="' . $closingDate . '"';
        }
        $total_reg = Yii::app()->db->createCommand("SELECT count(*) FROM `crm_master_file` where " . $condition_CustomerId )->queryScalar();//. " AND EXISTS (sELECT * from crm_complaint_registration where file_id = crm_master_file.id)"
        $total_partial_registration = Yii::app()->db->createCommand("SELECT count(*) FROM `crm_master_file` where " . $condition_CustomerId . " AND current_process_status = 'JS'")->queryScalar();//AND EXISTS (select * from crm_complaint_registration where file_id = crm_master_file.id)
        $total_allocated = Yii::app()->db->createCommand("SELECT count(*) FROM `crm_master_file` where " . $condition_CustomerId . " AND current_process_status = 'JA' ")->queryScalar();//AND EXISTS (select * from crm_complaint_registration where file_id = crm_master_file.id)
        $total_materialrequest = Yii::app()->db->createCommand("SELECT count(*) FROM `crm_master_file` where " . $condition_CustomerId . " AND current_process_status = 'JMR' ")->queryScalar();//AND EXISTS (select * from crm_complaint_registration where file_id = crm_master_file.id)
        $total_materialused = Yii::app()->db->createCommand("SELECT count(*) FROM `crm_master_file` where " . $condition_CustomerId . " AND current_process_status = 'JU' ")->queryScalar();//AND EXISTS (select * from crm_complaint_registration where file_id = crm_master_file.id)
        $total_invoice = Yii::app()->db->createCommand("SELECT count(*) FROM `crm_master_file` where " . $condition_CustomerId . " AND current_process_status = 'JI' ")->queryScalar();//AND EXISTS (select * from crm_complaint_registration where file_id = crm_master_file.id)
        $total_paymentdone = Yii::app()->db->createCommand("SELECT count(*) FROM `crm_master_file` where " . $condition_CustomerId . " AND current_process_status = 'JR' ")->queryScalar();//AND EXISTS (select * from crm_complaint_registration where file_id = crm_master_file.id)

        $this->renderPartial('print_service_details',array(
            'total_reg'=>$total_reg,
            'total_partial_registration'=>$total_partial_registration,
            'total_allocated'=>$total_allocated,
            'total_materialrequest'=>$total_materialrequest,
            'total_materialused'=>$total_materialused,
            'total_invoice'=>$total_invoice,
            'total_paymentdone'=>$total_paymentdone
              )
             );
    }
     public function actionPrintPurchase() {

        $vendor_id = $_POST['customer_id'];
        $startDate = $_POST['start_date'];
        $closingDate = $_POST['end_date'];
     
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_purchase', array(          
            'startDate' => $startDate,
            'vendor_id' => $vendor_id,
            'closingDate' => $closingDate
        ));
    }   

}
