<?php

class MeetingactivityController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'create', 'save', 'DeleteItem'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $this->render('index');
    }

    public function actionCreate() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new MeetingActivity();
        $transation = MeetingTransaction::model()->findByPk($id);
        $model->transation_id = $id;
        $model->meeting_id = $transation->meeting_id;
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create', array('model' => $model));
    }

    public function actionSave() {
        $status = $_POST['MeetingTransaction']['complete_status'];
        date_default_timezone_set("Asia/Dubai");
        if ($status == 3) {
            $id = $_POST['MeetingActivity']['transation_id'];
            $model = MeetingTransaction::model()->findByPk($id);
            $closed_on = "";
            if (!empty($_POST['MeetingTransaction']["closed_on"])) {
                $input = str_replace("/", "-", $_POST['MeetingTransaction']["closed_on"]);
                $closed_on = date('Y-m-d H:i:s', strtotime($input));
            }
            $model->closed_on = $closed_on;
            $model->complete_status = 3;
            $model->updated_by = Yii::app()->user->id;
            $model->updated_date_time = date('Y-m-d H:i:s');
            $model->action_taken = $_POST['MeetingTransaction']["action_taken"];
            $model->scenario = "closing";
            if ($model->validate()) {
                echo json_encode(array('status' => 'success'));
                $model->save();
            } else {
                echo CActiveForm::validate($model, '', false);
            }
        } else if (isset($_POST["MeetingActivity"])) {

            $model = new MeetingActivity();
            $model->attributes = $_POST['MeetingActivity'];
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d H:i:s');
            $input = str_replace("/", "-", $_POST['MeetingActivity']["callback"]);
            $callback = strtotime($input);
            $model->callback = date('Y-m-d H:i:s', $callback);
            if ($model->validate()) {
                echo json_encode(array('status' => 'success'));
                $model->save();
            } else {
                echo CActiveForm::validate($model, '', false);
            }
        }
    }

    public function actionDeleteItem() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new MeetingActivity();
        $model = $model->findAll("t.transation_id = " . $id);
        if (empty($model)) {
            MeetingTransaction::model()->deleteByPk($id);
            echo json_encode(array('status' => 'success'));
        } else {
            echo json_encode(array('status' => 'error'));
        }
    }

}
