<?php

class MasternotificationController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetList','Create','SaveSetting','MailEvents','GetEvents','CreateEvents','SaveEvents','SaveEvents',
                                    'updatenotification'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }
     public function actionGetList() {
        $model = new Notification();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 't.id',
            1 => 'start_date',
            2 => 'end_date',
            3 => 'notification',
            4 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "1=1";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and (events.event_name LIKE '%".$searchString."%')";      
        }
        $count = $model->with('events')->count(array('condition' => $condition));
        $model = $model->with('events')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' =>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
      
            $mail_required = "";
            $sms_required="";
            $notification_required="";
            if ($row['mail_required'] == 'Y') {
                $mail_required = '<div class="btn-wrap text-center"><button class="btn btn-success btn-xs" ><i class="fa fa-check"></i></button></div>';
            }else{
                $mail_required = '<div class="btn-wrap text-center"><button class="btn btn-danger btn-xs text-center" ><i class="fa fa-times"></i></button></div>';
            }
            if ($row['sms_required'] == 'Y') {
                $sms_required = '<div class="btn-wrap text-center"><button class="btn btn-success btn-xs" ><i class="fa fa-check"></i></button></div>';
            }else{
                $sms_required = '<div class="btn-wrap text-center"><button class="btn btn-danger btn-xs" ><i class="fa fa-times"></i></button></div>';
            }
            if ($row['notification_required'] == 'Y') {
                $notification_required = '<div class="btn-wrap text-center"><button class="btn btn-success btn-xs" ><i class="fa fa-check"></i></button></div>';
            }else{
                $notification_required = '<div class="btn-wrap text-center"><button class="btn btn-danger btn-xs" ><i class="fa fa-times"></i></button></div>';
            }
            $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'masternotification/create&id='.$row['id'].'\',\'Edit Notification   \',\'lg\')"><i class="fa fa-edit"></i></button>';
            $rowData[] = array($m,$row['events']['event_name'] , $mail_required,$sms_required, $notification_required, $button_string);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate()
    {
        $model       = new Notification(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }                              
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }
    public function actionSaveSetting() {
        
         $model = new Notification;
        if (isset($_POST['Notification'])) {
            if ((int) @$_POST['Notification']['id'] > 0) {
                $model->id = (int) $_POST['Notification']['id'];
                $model = $model->findByPK($model->id);
            }
            $model->event_id   = $_POST['Notification']['event_id']; 
            $model->notification_required   = $_POST['Notification']['notification_required']; 
            $model->mail_required   = $_POST['Notification']['mail_required']; 
            $model->mail_cc   = $_POST['Notification']['mail_cc']; 
            $model->sms_required   = $_POST['Notification']['sms_required']; 
            $model->sms_mobile_number_cc   = $_POST['Notification']['sms_mobile_number_cc'];
            $model->mail_content   = $_POST['Notification']['mail_content'];
            if(isset($_POST['Notification']['notification_users']) && count($_POST['Notification']['notification_users']) > 0){
                $model->notification_users = implode(',',$_POST['Notification']['notification_users']);
            }else{
                $model->notification_users = "";
            } 
            if(isset($_POST['Notification']['mail_users']) && count($_POST['Notification']['mail_users']) > 0){
                $model->mail_users = implode(',',$_POST['Notification']['mail_users']);
            }else{
                $model->mail_users = "";
            } 
            if(isset($_POST['Notification']['sms_users']) && count($_POST['Notification']['sms_users']) > 0){
                $model->sms_users = implode(',',$_POST['Notification']['sms_users']);
            }else{
                $model->sms_users = "";
            } 
            if ($model->validate()) {
                $model->save();
                $model->refresh();
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);          
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
        Yii::app()->end();
          
    }
    public function actionMailEvents() {
        $this->render('mail_events');
    }
    public function actionGetEvents() {
        $model = new MailEvents();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 't.id',
            1 => 'event_name',
            2 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "1=1";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and (event_name LIKE '%".$searchString."%')";      
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' =>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'masternotification/createevents&id='.$row['id'].'\',\'Edit Event   \',\'sm\')"><i class="fa fa-edit"></i></button>';
            $rowData[] = array($m,$row['event_name'] , $button_string);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreateEvents()
    {
        $model       = new MailEvents(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }                              
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create_events', array('model' => $model), false, true);
    }
    public function actionSaveEvents() {
        $model = new MailEvents;
        if (isset($_POST['MailEvents'])) {
            if ((int) @$_POST['MailEvents']['id'] > 0) {
                $model->id = (int) $_POST['MailEvents']['id'];
                $model = $model->findByPK($model->id);
            }
            $model->attributes   = $_POST['MailEvents']; 
            if ($model->validate()) {
                $model->save();
                $model->refresh();
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);          
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
        Yii::app()->end();
          
    }
    public static function sendmail($apply_from,$id) {
        date_default_timezone_set("Asia/Dubai");
        $subject="";
        $view="";
        //Mail Setting
        $model_mail_setting=Notification::model()->find(array('condition' => 'event_id="'. $apply_from.'"'));       
        $notifying_employee=$model_mail_setting->mail_users;
        $from='';
        $to='';
        $content='';
        $applicant_name='';
        $salutation='';
        $sent_mail_id=array();
        $mailContent = array();  
        //Customer Add
        if($apply_from==1){
            $model_customer=Customer::model()->findByPK($id);
            $subject='New Customer -' . $model_customer->customer_name;            
            $applicant_name='Sales Team';           
            $content='CUSTOMER DETAILS:
                 <br><br>
                 Name: '.$model_customer->customer_name. '
                 <br><br>
                 Address: '.$model_customer->customer_address.'  
                 <br><br>
                 Country: '.$model_customer->country->country_name.' 
                 <br><br>
                 Email: '.$model_customer->customer_email_id.' 
                 <br> <br>
                 Phone:   '.$model_customer->customer_phone_no.'
                 <br><br>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
            ////Customer Add End
        }else if($apply_from==2){ //Lead Add-Start
            $model_lead=Lead::model()->findByPK($id);
            $enq_date='-';
            if($model_lead->enq_date!='0000-00-00' && $model_lead->enq_date!=''){                    
                $enq_date = date("d/m/Y",strtotime($model_lead->enq_date));
            }
            $subject='New Lead -' . $model_lead->customer->customer_name;            
            $applicant_name='Sales Team';           
            $content='LEAD DETAILS:
                 <br><br>
                 Name: '.$model_lead->customer->customer_name. '
                 <br><br>
                 Contact: '.$model_lead->contact->person_name.'  
                 <br><br>
                 Lead Owner: '.$model_lead->leadowner->Fullname.' 
                 <br><br>
                 Enquiry Date: '.$enq_date.' 
                 <br><br>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
            //Lead Add-End 
        }else if($apply_from==3 || $apply_from==4){ //Sales Quotation Add-Start
            $model_quotes=Quotes::model()->findByPK($id);
            $qtn_start_date='-';
            if($model_quotes->qtn_start_date!='0000-00-00' && $model_quotes->qtn_start_date!=''){                    
                $qtn_start_date = date("d/m/Y",strtotime($model_quotes->qtn_start_date));
            }
            $model_items = QuotesItem::model()->findAll(array('condition'=>'quotes_id ="'.$id.'"','order' => 'id ASC'));
            if($apply_from==3){
                $subject='New Quotation -' . $model_quotes->file_id.'/'.$model_quotes->id.'/'.$model_quotes->customer->customer_name;   
            }else if($apply_from==4){
                $subject='Quotation Approval-' . $model_quotes->file_id.'/'.$model_quotes->id.'/'.$model_quotes->customer->customer_name;  
            }
            $applicant_name='Sales Team';           
            $content='QUOTATION DETAILS:
                 <br><br>
                 CUSTOMER NAME: '.$model_quotes->customer->customer_name. '
                 <br><br>
                 File ID/QUOTATION NO: '.$model_quotes->file_id.'/'.$model_quotes->id.'  
                 <br><br>
                 QUOTATION DATE: '.$qtn_start_date.' 
                 <br><br>
                 PRODUCT DETAILS:
                 <br><br>';
            $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Part No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Description
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Qty
                        </th>
                    </tr>';
                            foreach ($model_items as $key => $value) {
                                $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px;">'.($key+1).'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->product->part_number.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->description.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->quantity.'</td>
                                    </tr>';
                            }
                $content.='</tbody>
            </table>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
        }
        //Quotation Add-End
        else if($apply_from==5 || $apply_from==6){ //Sales order add
            $model_order=Order::model()->findByPK($id);
            $order_date='-';
            if($model_order->order_date!='0000-00-00' && $model_order->order_date!=''){                    
                $order_date = date("d/m/Y",strtotime($model_order->order_date));
            }
            $model_items = OrderItem::model()->findAll(array('condition'=>'order_id ="'.$id.'"','order' => 'id ASC'));
            if($apply_from==5){
                $subject='New Order -' . $model_order->file_id.'/'.$model_order->id.'/'.$model_order->customer->customer_name;  
            }else if($apply_from==6){
                $subject='Order Approval-' . $model_order->file_id.'/'.$model_order->id.'/'.$model_order->customer->customer_name;  
            }
            $applicant_name='Sales Team';           
            $content='ORDER DETAILS:
                 <br><br>
                 CUSTOMER NAME: '.$model_order->customer->customer_name. '
                 <br><br>
                 File ID/ORDER NO: '.$model_order->file_id.'/'.$model_order->id.'  
                 <br><br>
                 ORDER DATE: '.$order_date.' 
                 <br><br>
                 PRODUCT DETAILS:
                 <br><br>';
            $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Part No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Description
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Qty
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Rate
                        </th>
                    </tr>';
                            foreach ($model_items as $key => $value) {
                                $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px;">'.($key+1).'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->product->part_number.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->description.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: center">'.$value->quantity.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: right">'.number_format($value->rate, 2, '.', '').'</td>
                                    </tr>';
                            }
                $content.='</tbody>
            </table>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
        }
        //sales order end
        else if($apply_from==7 || $apply_from==26){ //Delivery Note Add-Start
            $model_Delivery=DeliveryNote ::model()->findByPK($id);
            $delivery_date='-';
            if($model_Delivery->delivery_date!='0000-00-00' && $model_Delivery->delivery_date!=''){                    
                $delivery_date = date("d/m/Y",strtotime($model_Delivery->delivery_date));
            }
            $model_items = DeliveryNoteItem::model()->findAll(array('condition'=>'delivery_note_id ="'.$id.'" AND picked_qty>0','order' => 'id ASC'));
            if($apply_from==7){ 
                $subject='Delivery Note(Sales)-' . $model_Delivery->file_id.'/'.$model_Delivery->order_id.'/'.$model_Delivery->customer->customer_name;   
            }else if($apply_from==26){ 
                $subject='Delivery Note(Hiring)-' . $model_Delivery->file_id.'/'.$model_Delivery->order_id.'/'.$model_Delivery->customer->customer_name;   
            }
            
            $applicant_name='Sales Team';           
            $content='DELIVERY NOTE DETAILS:
                 <br><br>
                 CUSTOMER NAME: '.$model_Delivery->customer->customer_name. '
                 <br><br>
                 File ID/ORDER NO: '.$model_Delivery->file_id.'/'.$model_Delivery->id.'  
                 <br><br>
                 DELIVERY DATE: '.$delivery_date.' 
                 <br><br>
                 PRODUCT DETAILS:
                 <br><br>';
            $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Part No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Description
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Ord. Qty
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Del. Qty
                        </th>
                    </tr>';
                            foreach ($model_items as $key => $value) {
                                $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px;">'.($key+1).'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->product->part_number.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->description.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->quantity.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->picked_qty.'</td>
                                    </tr>';
                            }
                $content.='</tbody>
            </table>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
        }
        //Sales Delivery Add-End
         else if($apply_from==8){ //Sales Invoice Add-Start
            $model_invoice=Invoice::model()->findByPK($id);
            $invoice_date='-';
            if($model_invoice->invoice_date!='0000-00-00' && $model_invoice->invoice_date!=''){                    
                $invoice_date = date("d/m/Y",strtotime($model_invoice->invoice_date));
            }
            $model_items = InvoiceItem::model()->findAll(array('condition'=>'invoice_id ="'.$id.'"','order' => 'id ASC'));
            $subject='Invoice-' . $model_invoice->file_id.'/'.$model_invoice->id.'/'.$model_invoice->customer->customer_name;   
            
            $applicant_name='Sales Team';           
            $content='INVOICE DETAILS:
                 <br><br>
                 CUSTOMER NAME: '.$model_invoice->customer->customer_name. '
                 <br><br>
                 File ID/INVOICE NO: '.$model_invoice->file_id.'/'.$model_invoice->id.'  
                 <br><br>
                 DELIVERY DATE: '.$invoice_date.' 
                 <br><br>
                 PRODUCT DETAILS:
                 <br><br>';
            $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Part No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Description
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Qty
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Rate
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Net Amount
                        </th>
                    </tr>';
                    $total=0.00;
                    $total_vat=0.00;
                            foreach ($model_items as $key => $value) {
                                $rate=  round($value->net_amount / $value->quantity,2);
                                $total+=$value->net_amount;
                                $total_vat+=$value->tax_vat_amount;
                                $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px;">'.($key+1).'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->product->part_number.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->description.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->quantity.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: right">'.number_format($rate, 2, '.', '').'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: right">'.number_format($value->net_amount, 2, '.', '').'</td>
                                    </tr>';
                            }
                            $grand_total=$total+$total_vat;
                            $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: right" colspan="5">VAT</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: right">'.number_format($total_vat, 2, '.', '').'</td>
                                    </tr>';
                            $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: right" colspan="5">Grand Total</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: right">'.number_format($grand_total, 2, '.', '').'</td>
                                    </tr>';
                $content.='</tbody>
            </table>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
        }
        //Sales Invoice-End
        else if($apply_from==9){ //Sales Return Add-Start
            $model_creditnote=Creditnote::model()->findByPK($id);
            $credited_date='-';
            if($model_creditnote->credited_date!='0000-00-00' && $model_creditnote->credited_date!=''){                    
                $credited_date = date("d/m/Y",strtotime($model_creditnote->credited_date));
            }
            $model_items = CreditnoteItem::model()->findAll(array('condition'=>'creditnote_id ="'.$id.'" AND (returned_quantity>0 or returned_bonus_qty>0)'));
            $subject='SALES RETURN-' . $model_creditnote->file_id.'/'.$model_creditnote->invoice_id.'/'.$model_creditnote->customer->customer_name; 
            $applicant_name='Sales Team';           
            $content='SALES RETURN DETAILS:
                 <br><br>
                 CUSTOMER NAME: '.$model_creditnote->customer->customer_name. '
                 <br><br>
                 File ID/INVOICE NO: '.$model_creditnote->file_id.'/'.$model_creditnote->invoice_id.'  
                 <br><br>
                 CREDITED DATE: '.$credited_date.' 
                 <br><br>
                 PRODUCT DETAILS:
                 <br><br>';
            $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Part No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Description
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Qty(P)
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Qty(R)
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Net Amount
                        </th>
                    </tr>';
                    $total=0.00;
                    $total_vat=0.00;
                            foreach ($model_items as $key => $value) {
                                $total+=$value->net_amount;
                                $total_vat+=$value->tax_vat_amount;
                                $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px;">'.($key+1).'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->product->part_number.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->description.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->quantity.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->returned_quantity.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: right">'.number_format($value->net_amount, 2, '.', '').'</td>
                                    </tr>';
                            }
                            $grand_total=$total+$total_vat;
                            $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: right" colspan="5">VAT</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: right">'.number_format($total_vat, 2, '.', '').'</td>
                                    </tr>';
                            $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: right" colspan="5">Grand Total</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: right">'.number_format($grand_total, 2, '.', '').'</td>
                                    </tr>';
                $content.='</tbody>
            </table>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
        }
        //Sales Return-End
        else if($apply_from==10){   //Vendor Add
            $model_supplier=Vendor::model()->findByPK($id);
            $subject='New Supplier -' .$model_supplier->vendor_name;            
            $applicant_name='Sales Team';           
            $content='SUPPLIER DETAILS:
                 <br><br>
                 Name: '.$model_supplier->vendor_name. '
                 <br><br>
                 Email: '.$model_supplier->vendor_email_id.'  
                 <br><br>
                 Phone: '.$model_supplier->vendor_phone_no.' 
                 <br><br>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
            ////Customer Add End
        }
        else if($apply_from==11){ //Requisition Add-Start
            $model=PurchasingRequisition::model()->findByPK($id);
            $requisition_date='-';
            if($model->requisition_date!='0000-00-00' && $model->requisition_date!=''){                    
                $requisition_date = date("d/m/Y",strtotime($model->requisition_date));
            }
            //$model_stock_items = PurchasingRequisitionStockItem::model()->findAll(array('condition'=>'purchasing_requisition_id ="'.$id.'"'));
            //$model_nonstock_items = PurchasingRequisitionStockItem::model()->findAll(array('condition'=>'purchasing_requisition_id ="'.$id.'"'));
            $subject='PURCHASE REQUISITION'; 
            $applicant_name='Sales Team';           
            $content='PURCHASE REQUISITION DETAILS:
                 <br><br>
                 REFERENCE: '.$model->reference. '
                 <br><br>
                 REQUISITION DATE: '.$requisition_date.' 
                 <br><br>
                 DETAILS:
                 <br><br>';
            $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Item
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Description
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Qty
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Unit
                        </th>
                    </tr>';
                        foreach ($model->stockitems as $key => $value) {
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px;">'.($key+1).'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->stock_item_name.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->stock_item_description.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.number_format($value->stock_item_quantity, 2, '.', '').'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->stock_item_unit.'</td>
                                </tr>';
                        }
                        foreach ($model->nonstockitems as $key => $value) {
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px;">'.($key+1).'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->non_stock_item_name.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->non_stock_item_description.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.number_format($value->non_stock_item_quantity, 2, '.', '').'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->non_stock_item_unit.'</td>
                                </tr>';
                        }
                $content.='</tbody>
            </table>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
        }
        //Requisition-End
          else if($apply_from==12){ //Enquiry Add-Start
            $model=PurchasingEnquiry::model()->findByPK($id);
            $vendor_name =array();
            $vendorname="";
            $vendor_id=explode(',',$model->vendor_id);
            foreach ($vendor_id as $value) {                            
                $vendor_name[]=Vendor::model()->findbyPk($value)->vendor_name;
            }
            if(!empty($vendor_name)){
                $vendorname=  implode(',', $vendor_name);
            }
            $enquiry_date='-';
            if($model->enquiry_date!='0000-00-00' && $model->enquiry_date!=''){                    
                $enquiry_date = date("d/m/Y",strtotime($model->enquiry_date));
            }
            $model_stock_items = PurchasingEnquiryStockItem::model()->findAll(array('condition'=>'purchasing_enquiry_id ="'.$id.'"'));
            $model_nonstock_items = PurchasingEnquiryNonStockItem::model()->findAll(array('condition'=>'purchasing_enquiry_id ="'.$id.'"'));
            $subject='PURCHASE ENQUIRY'; 
            $applicant_name='Sales Team';           
            $content='PURCHASE ENQUIRY DETAILS:
                 <br><br>
                 SUPPLIER DETAILS: '.$vendorname. '
                 <br><br>
                 REFERENCE: '.$model->reference. '
                 <br><br>
                 REQUISITION DATE: '.$enquiry_date.' 
                 <br><br>
                 DETAILS:
                 <br><br>';
            $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Item
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Description
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Qty
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Unit
                        </th>
                    </tr>';
                        foreach ($model_stock_items as $key => $value) {
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px;">'.($key+1).'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->stock_item_name.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->stock_item_description.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.number_format($value->stock_item_quantity, 2, '.', '').'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->stock_item_unit.'</td>
                                </tr>';
                        }
                        foreach ($model_nonstock_items as $key => $value) {
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px;">'.($key+1).'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->non_stock_item_name.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->non_stock_item_description.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.number_format($value->non_stock_item_quantity, 2, '.', '').'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->non_stock_item_unit.'</td>
                                </tr>';
                        }
                $content.='</tbody>
            </table>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
        }
        //Enquiry-End
        else if($apply_from==13 || $apply_from==14){ //Purchase Order Add-Start
            $model=PurchasingOrder::model()->findByPK($id);
            $order_date='-';
            if($model->order_date!='0000-00-00' && $model->order_date!=''){                    
                $order_date = date("d/m/Y",strtotime($model->order_date));
            }
            $model_stock_items = PurchasingOrderStockItem::model()->findAll(array('condition'=>'purchasing_order_id ="'.$id.'"'));
            if($apply_from==13){
                $subject='PURCHASE ORDER:-'.$model->file_id.'/'.$model->id.'/'.$model->vendor_details->vendor_name;
            }else if($apply_from==14){
                $subject='PURCHASE ORDER APPROVAL:-'.$model->file_id.'/'.$model->id.'/'.$model->vendor_details->vendor_name;
            }
            $applicant_name='Sales Team';           
            $content='PURCHASE ORDER DETAILS:
                 <br><br>
                 SUPPLIER: '.$model->vendor_details->vendor_name. '
                 <br><br>
                 ORDER DATE: '.$order_date.' 
                 <br><br>
                 PRODUCT DETAILS:
                 <br><br>';
            $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Item
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Description
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Qty
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Unit
                        </th>
                    </tr>';
                        foreach ($model_stock_items as $key => $value) {
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px;">'.($key+1).'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->stock_item_name.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->stock_item_description.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.number_format($value->stock_item_quantity, 2, '.', '').'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->unitdetails->name.'</td>
                                </tr>';
                        }
                $content.='</tbody>
            </table>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
        }
        //Enquiry-End
        else if($apply_from==15){ //Material Add-Start
            $model=PurchasingMaterialreceipt::model()->findByPK($id);
            $order_date=$mrv_receipt_date=$dly_date='-';
            if($model->purchaseorder->order_date!='0000-00-00' && $model->purchaseorder->order_date!=''){                    
                $order_date = date("d/m/Y",strtotime($model->purchaseorder->order_date));
            }
            if($model->mrv_receipt_date!='0000-00-00' && $model->mrv_receipt_date!=''){                    
                $mrv_receipt_date = date("d/m/Y",strtotime($model->mrv_receipt_date));
            }
            if($model->dly_date!='0000-00-00' && $model->dly_date!=''){                    
                $dly_date = date("d/m/Y",strtotime($model->dly_date));
            }
            $model_stock_items = PurchasingMaterialreceiptItem::model()->findAll(array('condition'=>'purchasing_materialreceipt_id="'.$id.'" AND received_quantity>0'));
            $subject='MATERIAL RECEIPT:-'.$model->po_id.'/'.$model->vendor_details->vendor_name;
            $applicant_name='Sales Team';           
            $content='MATERIAL RECEIPT DETAILS:
                 <br><br>
                 SUPPLIER: '.$model->vendor_details->vendor_name. '
                 <br><br>
                 ORDER DATE: '.$order_date.' 
                 <br><br>
                 DELIVERY DATE: '.$dly_date.' 
                 <br><br>
                 DELIVERY NO: '.$model->dly_no.' 
                 <br><br>
                 MRV DATE: '.$mrv_receipt_date.' 
                 <br><br>
                 PRODUCT DETAILS:
                 <br><br>';
            $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Item
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Description
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Total
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Balance
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        MR Qty
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        QC Qty
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Unit
                        </th>
                    </tr>';
                        foreach ($model_stock_items as $key => $value) {
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px;">'.($key+1).'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->product_name.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->description.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.number_format($value->quantity, 2, '.', '').'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.number_format($value->remaining_quantity, 2, '.', '').'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.number_format($value->received_quantity, 2, '.', '').'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.number_format($value->qc_checked_quantity, 2, '.', '').'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->unit.'</td>
                                </tr>';
                        }
                $content.='</tbody>
            </table>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
        }
        //Material-End
          else if($apply_from==16){ //Material QC-Start
            $model=PurchasingMaterialreceipt::model()->findByPK($id);
            $order_date=$mrv_receipt_date=$dly_date='-';
            if($model->purchaseorder->order_date!='0000-00-00' && $model->purchaseorder->order_date!=''){                    
                $order_date = date("d/m/Y",strtotime($model->purchaseorder->order_date));
            }
            if($model->qc_check_date!='0000-00-00' && $model->qc_check_date!=''){                    
                $mrv_receipt_date = date("d/m/Y",strtotime($model->qc_check_date));
            }
            if($model->dly_date!='0000-00-00' && $model->dly_date!=''){                    
                $dly_date = date("d/m/Y",strtotime($model->dly_date));
            }
            $model_stock_items = PurchasingMaterialreceiptItem::model()->findAll(array('condition'=>'purchasing_materialreceipt_id="'.$id.'" AND qc_checked_quantity>0'));
            $subject='QUALITY CHECK:-'.$model->po_id.'/'.$model->vendor_details->vendor_name;
            $applicant_name='Sales Team';           
            $content='QUALITY CHECK DETAILS:
                 <br><br>
                 SUPPLIER: '.$model->vendor_details->vendor_name. '
                 <br><br>
                 ORDER DATE: '.$order_date.' 
                 <br><br>
                 DELIVERY DATE: '.$dly_date.' 
                 <br><br>
                 DELIVERY NO: '.$model->dly_no.' 
                 <br><br>
                 QUALITY CHECK DATE: '.$mrv_receipt_date.' 
                 <br><br>
                 PRODUCT DETAILS:
                 <br><br>';
            $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Item
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Description
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Total
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Balance
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        MR Qty
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        QC Qty
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Unit
                        </th>
                    </tr>';
                        foreach ($model_stock_items as $key => $value) {
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px;">'.($key+1).'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->product_name.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->description.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.number_format($value->quantity, 2, '.', '').'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.number_format($value->remaining_quantity, 2, '.', '').'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.number_format($value->received_quantity, 2, '.', '').'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.number_format($value->qc_checked_quantity, 2, '.', '').'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->unit.'</td>
                                </tr>';
                        }
                $content.='</tbody>
            </table>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
        }
        //MC QC end
        else if($apply_from==17){ //PURCHASE INVOICE-Start
            $model=PurchasingInvoice::model()->findByPK($id);
            $invoice_date='-';
            if($model->invoice_date!='0000-00-00' && $model->invoice_date!=''){                    
                $invoice_date = date("d/m/Y",strtotime($model->invoice_date));
            }
            $model_items = PurchasingInvoiceItem::model()->findAll(array('condition'=>'purchasing_invoice_id="'.$id.'"'));
            $subject='PURCHASE INVOICE:-'.$model->file_id.'/'.$model->invoice_no.'/'.$model->vendor_details->vendor_name;
            $applicant_name='Sales Team';           
            $content='PURCHASE INVOICE DETAILS:
                 <br><br>
                 SUPPLIER: '.$model->vendor_details->vendor_name. '
                 <br><br>
                 INVOICE NO: '.$model->invoice_no.' 
                 <br><br>
                 INVOICE DATE: '.$invoice_date.' 
                 <br><br>
                 PRODUCT DETAILS:
                 <br><br>';
            $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Part No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Description
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Qty
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Rate
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Net Amount
                        </th>
                    </tr>';
                    $total=0.00;
                    $tax_total=0.00;
                        foreach ($model_items as $key => $value) {
                            $total+=$value->net_amount;
                            $tax_total+=$value->tax_amount;
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px;">'.($key+1).'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->product->part_number.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->description.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.number_format($value->quantity, 2, '.', '').'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: right">'.number_format($value->rate, 2, '.', '').'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: right">'.number_format($value->net_amount, 2, '.', '').'</td>
                                </tr>';
                        }
                        $grand_total=$total+$tax_total;
                        $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: right" colspan="5">Total</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: right">'.number_format($total, 2, '.', '').'</td>
                                </tr>';
                        $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: right" colspan="5">VAT</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: right">'.number_format($tax_total, 2, '.', '').'</td>
                                </tr>';
                        $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: right" colspan="5">Grand Total</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: right">'.number_format($grand_total, 2, '.', '').'</td>
                                </tr>';
                        
                $content.='</tbody>
            </table>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
        }
        //PURCHASE INVOICE end
        else if($apply_from==18){ //PURCHASE Returns-Start
            $model=Purchasingdebitnote::model()->findByPK($id);
            $debited_date='-';
            if($model->debited_date!='0000-00-00' && $model->debited_date!=''){                    
                $debited_date = date("d/m/Y",strtotime($model->debited_date));
            }
            $model_items = PurchasingdebitnoteItem::model()->findAll(array('condition'=>'purchasing_debitnote_id="'.$id.'"'));
            $subject='PURCHASE RETURN:-'.$model->file_id.'/'.$model->invoice->id.'/'.$model->vendor_details->vendor_name;
            $applicant_name='Sales Team';           
            $content='PURCHASE RETURN DETAILS:
                 <br><br>
                 SUPPLIER: '.$model->vendor_details->vendor_name. '
                 <br><br>
                 INVOICE NO: '.$model->invoice->id.' 
                 <br><br>
                 PURCHASE RETURN DATE: '.$debited_date.' 
                 <br><br>
                 PRODUCT DETAILS:
                 <br><br>';
            $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Part No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Description
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Qty(P)
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Qty(R)
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Unit
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Rate
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Net Amount
                        </th>
                    </tr>';
                    $total=0.00;
                    $tax_total=0.00;
                        foreach ($model_items as $key => $value) {
                            $total+=$value->net_amount;
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px;">'.($key+1).'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->product->part_number.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->description.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.number_format($value->purchased_quantity, 2, '.', '').'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.number_format($value->returned_quantity, 2, '.', '').'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->product->unit->symbol.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: right">'.number_format($value->rate, 2, '.', '').'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: right">'.number_format($value->net_amount, 2, '.', '').'</td>
                                </tr>';
                        }
                        $grand_total=$total+$tax_total;
                        $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: right" colspan="7">Total</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: right">'.number_format($total, 2, '.', '').'</td>
                                </tr>';
                        
                $content.='</tbody>
            </table>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
        }
        //PURCHASE Returns end
        else if($apply_from==19){ //New Item-Start
            $model=Store::model()->findByPK($id);
            $subject='NEW ITEM:-'.$model->part_number.'/'.$model->description;
            $applicant_name='Sales Team';  
            $machine =array('M'=>'Machine','S'=>'Spare');
            $content='NEW ITEM DETAILS:
                 <br><br>
                 PART NO: '.$model->part_number. '
                 <br><br>
                 DESCRIPTION: '.$model->description.' 
                 <br><br>
                 BRAND/CLASS: '.$model->brand_detail->product_class.' 
                 <br><br>
                 MACHINE/SPARE:'.$machine[$model->machine_type].' 
                 <br><br>
                 UNIT:'.$model->unit->symbol.' 
                 <br><br>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
        }
        //New Item end
        else if($apply_from==20){ //Goods Issue-Start
            $model=InventoryGoodsIssue::model()->findByPK($id);
            $goods_issue_date='-';
            if($model->goods_issue_date!='0000-00-00' && $model->goods_issue_date!=''){                    
                $goods_issue_date = date("d/m/Y",strtotime($model->goods_issue_date));
            }
            $model_items = InventoryGoodsIssueItem::model()->findAll(array('condition'=>'inventory_goods_issue_id="'.$id.'"'));
            $subject='GOODS ISSUE:-'.$model->id.'/'.$model->customer->customer_name;
            $applicant_name='Sales Team';           
            $content='GOODS ISSUE DETAILS:
                 <br><br>
                 CUSTOMER: '.$model->customer->customer_name. '
                 <br><br>
                 GOODS ISSUE NO: '.$model->id.' 
                 <br><br>
                 GOODS ISSUE DATE: '.$goods_issue_date.' 
                 <br><br>
                 PRODUCT DETAILS:
                 <br><br>';
            $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Product Name
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Description
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Qty(Picked)
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Unit
                        </th>
                    </tr>';
                        foreach ($model_items as $key => $value) {
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px;">'.($key+1).'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->product_name.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->description.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: center">'.number_format($value->picked_qty, 2, '.', '').'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->unitdetails->name.'</td>
                            </tr>';
                        }
                $content.='</tbody>
            </table>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
        }
        //Goods ISSue end
        else if($apply_from==21){ //Goods Receipt-Start
            $model=InventoryGoodsReceipt::model()->findByPK($id);
            $goods_receipt_date='-';
            if($model->goods_receipt_date!='0000-00-00' && $model->goods_receipt_date!=''){                    
                $goods_receipt_date = date("d/m/Y",strtotime($model->goods_receipt_date));
            }
            $model_items = InventoryGoodsReceiptItem::model()->findAll(array('condition'=>'inventory_goods_receipt_id="'.$id.'"'));
            $subject='GOODS RECEIPT:-'.$model->id.'/'.$model->customer->customer_name;
            $applicant_name='Sales Team';           
            $content='GOODS RECEIPT DETAILS:
                 <br><br>
                 CUSTOMER: '.$model->customer->customer_name. '
                 <br><br>
                 GOODS RECEIPT NO: '.$model->id.' 
                 <br><br>
                 GOODS RECEIPT DATE: '.$goods_receipt_date.' 
                 <br><br>
                 PRODUCT DETAILS:
                 <br><br>';
            $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Product
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Description
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Qty(Picked)
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Unit
                        </th>
                    </tr>';
                        foreach ($model_items as $key => $value) {
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px;">'.($key+1).'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->product_name.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->description.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: center">'.number_format($value->picked_qty, 2, '.', '').'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->unitdetails->name.'</td>
                            </tr>';
                        }
                $content.='</tbody>
            </table>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
        }
        //Goods Receipt end
        else if($apply_from==22 || $apply_from==23){ //Hiring Quotation Add/Approve-Start
            $model_quotes=Quotes::model()->findByPK($id);
            $qtn_start_date='-';
            if($model_quotes->qtn_start_date!='0000-00-00' && $model_quotes->qtn_start_date!=''){                    
                $qtn_start_date = date("d/m/Y",strtotime($model_quotes->qtn_start_date));
            }
            $model_items = QuotesItem::model()->findAll(array('condition'=>'quotes_id ="'.$id.'"','order' => 'id ASC'));
            if($apply_from==22){
                $subject='New Hiring Quotation -' . $model_quotes->file_id.'/'.$model_quotes->id.'/'.$model_quotes->customer->customer_name;   
            }else if($apply_from==23){
                $subject='Hiring Quotation Approval-' . $model_quotes->file_id.'/'.$model_quotes->id.'/'.$model_quotes->customer->customer_name;  
            }
            $applicant_name='Sales Team';         
            $bill_type =array('1'=>'Daily','2'=>'Weekly','3'=>'Monthly');
            $content='QUOTATION DETAILS:
                 <br><br>
                 CUSTOMER NAME: '.$model_quotes->customer->customer_name. '
                 <br><br>
                 File ID/QUOTATION NO: '.$model_quotes->file_id.'/'.$model_quotes->id.'  
                 <br><br>
                 QUOTATION DATE: '.$qtn_start_date.' 
                 <br><br>
                 PRODUCT DETAILS:
                 <br><br>';
            $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Part No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Description
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Qty
                        </th>
                       <th style="border: 1px solid #666;padding: 4px 5px;">
                        Bill Type
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Rate
                        </th>
                    </tr>';
                            foreach ($model_items as $key => $value) {
                                $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px;">'.($key+1).'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->product->hiring_part_number.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->description.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.(int)$value->quantity.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$bill_type[$value->bill_type].'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.number_format($value->rate, 2, '.', '').'</td>
                                    </tr>';
                            }
                $content.='</tbody>
            </table>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
        }
        //ENd Hiring Quotation
        else if($apply_from==24 || $apply_from==25){ //Hiring order add
            $model_order=Order::model()->findByPK($id);            
            $order_date='-';
            if($model_order->order_date!='0000-00-00' && $model_order->order_date!=''){                    
                $order_date = date("d/m/Y",strtotime($model_order->order_date));
            }
            $model_items = OrderItem::model()->findAll(array('condition'=>'order_id ="'.$id.'" and checked="1"','order' => 'id ASC'));
            if($apply_from==24){
                $subject='New Hiring Order -' . $model_order->file_id.'/'.$model_order->id.'/'.$model_order->customer->customer_name; 
            }else if($apply_from==25){
                $subject='Hiring Order Approval-' . $model_order->file_id.'/'.$model_order->id.'/'.$model_order->customer->customer_name;  
            }
            $bill_type =array('1'=>'Daily','2'=>'Weekly','3'=>'Monthly');
            $applicant_name='Sales Team';           
            $content='ORDER DETAILS:
                 <br><br>
                 CUSTOMER NAME: '.$model_order->customer->customer_name. '
                 <br><br>
                 File ID/ORDER NO: '.$model_order->file_id.'/'.$model_order->id.'  
                 <br><br>
                 ORDER DATE: '.$order_date.' 
                 <br><br>
                 PRODUCT DETAILS:
                 <br><br>';
            $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Part No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Description
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Qty
                        </th>
                       <th style="border: 1px solid #666;padding: 4px 5px;">
                        Bill Type
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Rate
                        </th>
                    </tr>';
                            foreach ($model_items as $key => $value) {
                                $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px;">'.($key+1).'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->product->part_number.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->description.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: center">'.$value->quantity.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$bill_type[$value->bill_type].'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: right">'.number_format($value->rate, 2, '.', '').'</td>
                                    </tr>';
                            }
                $content.='</tbody>
            </table>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
        }
        //hiring order end
        else if($apply_from==27){ //Hiring Invoice
            $model_invoice=Invoice::model()->findByPK($id);            
            $invoice_date='-';
            if($model_invoice->invoice_date!='0000-00-00' && $model_invoice->invoice_date!=''){                    
                $invoice_date = date("d/m/Y",strtotime($model_invoice->invoice_date));
            }
            $model_items = InvoiceItem::model()->findAll(array('condition'=>'invoice_id ="'.$id.'"'));
            $subject='Hiring Invoice -' . $model_invoice->invoice_no.'/'.$model_invoice->id.'/'.$model_invoice->customer->customer_name; 
            $applicant_name='Sales Team';           
            $content='INVOICE DETAILS:
                 <br><br>
                 CUSTOMER NAME: '.$model_invoice->customer->customer_name. '
                 <br><br>
                 INVOICE NO: '.$model_invoice->invoice_no.'/'.$model_invoice->id.'  
                 <br><br>
                 INVOICE DATE: '.$invoice_date.' 
                 <br><br>
                 PRODUCT DETAILS:
                 <br><br>';
            $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        No
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Item Description
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Qty
                        </th>
                       <th style="border: 1px solid #666;padding: 4px 5px;">
                        U.Price
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        T.Price
                        </th>
                    </tr>';
                            foreach ($model_items as $key => $value) {
                                $rate=$value->amount/$value->quantity;
                                $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px;">'.($key+1).'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->description.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: center">'.$value->quantity.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.number_format($rate, 2, '.', '').'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: right">'.number_format($value->net_amount, 2, '.', '').'</td>
                                    </tr>';
                            }
                $content.='</tbody>
            </table>';
            $view='send_notification';
            $salutation='Dear Sir/Madam';
        }
        //start Mail Content
        $mailContent['body'] = '
            <table cellpadding="0" cellspacing="0" align="left" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit">
                <tbody>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">
                            <div>'.$salutation.',</div>                                              
                        </td>
                    </tr>                                      
                    <tr>
                        <td height="30"></td>
                    </tr>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">
                            <strong style="font-size: 15px">Sub: '.$subject.'</strong>
                        </td>
                    </tr>
                    <tr>
                        <td height="30"></td>
                    </tr>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">'                          
                            .$content.'<br>                       
                            <br>
                            <br>
                            This mail has been sent automatically from Bluesky ERP on '.date('d/m/Y H:i').'
                        </td>
                    </tr>
                    <tr style="vertical-align: top"><td></td><td></td></tr>
                </tbody>
            </table>';
        ////End Mail Content
        $message = new YiiMailMessage;        
        $message->view = $view;
        $message->setBody(array('mailContent' => $mailContent), 'text/html');
        $message->subject =$subject;      
        //Mail From Start       
        $from='dikson@mailbluesky.com';
        $message->from ='dikson@mailbluesky.com';
        //End Mail From
        $to='';
        if($notifying_employee!=''){
            $notifyingemployee=explode(',', $notifying_employee); 
            $m=0;
            foreach ($notifyingemployee as $emp_id) {
                $model_mail=Employee::model()->findByPK($emp_id);
                if (filter_var($model_mail->email, FILTER_VALIDATE_EMAIL)) { 
                    $sent_mail_id[]=$model_mail->email;
                    if($m==0){
                        $to=$model_mail->email;
                        $message->addTo($model_mail->email);
                    }else{
                        $message->addCC($model_mail->email);
                    }
                    $m++;
                }
            }
        }
        // Start Custom Mail
    //    if($model_mail_setting->mail_cc!=''){
    //     $custom_mail=explode(',', $model_mail_setting->mail_cc); 
    //         foreach ($custom_mail as $custom_mail_id) {
    //             if (filter_var($custom_mail_id, FILTER_VALIDATE_EMAIL)) {
    //                 $sent_mail_id[]=$custom_mail_id;
    //                 if($to==''){
    //                     $message->addTo($custom_mail_id);
    //                 }else{
    //                     $message->addCC($custom_mail_id);
    //                 }

    //             }
    //         }
    //     }
        // End Custom Mail
        // Yii::app()->mail->send($message);     
        //Saving Mail Status
        
        // if(count($sent_mail_id)>0){
        //     $sent_mails=  implode(',', $sent_mail_id);
        // }
        // $model_mail_status= new MailStatus();
        // $model_mail_status->type =$apply_from;
        // $model_mail_status->from_mail =$from;
        // $model_mail_status->sent_mail_id =$sent_mails;
        // $model_mail_status->content =$content;
        // $model_mail_status->created_date_time =date('Y-m-d H:i:s');
        // $model_mail_status->created_by =Yii::app()->user->id;
        // $model_mail_status->save();
        return 'mailsuccess';
    }
     public static function sendnotification($apply_from,$id) {
        //Notification Setting
        $model_mail_setting=Notification::model()->find(array('condition' => 'event_id="'. $apply_from.'"'));       
        $notifying_employee=$model_mail_setting->notification_users;
        if($apply_from==1){
            Customer::model()->updateByPK($id, array('customer_notification' =>$notifying_employee)); 
        }else if($apply_from==2){
            Lead::model()->updateByPK($id, array('lead_notification' =>$notifying_employee)); 
        }else if($apply_from==3){
            Quotes::model()->updateByPK($id, array('quotes_notification' =>$notifying_employee)); 
        }else if($apply_from==4){
            Quotes::model()->updateByPK($id, array('quotes_approve_notification' =>$notifying_employee)); 
        }else if($apply_from==5){
            Order::model()->updateByPK($id, array('order_notification' =>$notifying_employee)); 
        }else if($apply_from==6){
            Order::model()->updateByPK($id, array('order_approve_notification' =>$notifying_employee)); 
        }else if($apply_from==7){
            DeliveryNote::model()->updateByPK($id, array('delivery_notification' =>$notifying_employee)); 
        }else if($apply_from==8){
            Invoice::model()->updateByPK($id, array('invoice_notification' =>$notifying_employee)); 
        }else if($apply_from==9){
            Creditnote::model()->updateByPK($id, array('creditnote_notification' =>$notifying_employee)); 
        }else if($apply_from==10){
            Vendor::model()->updateByPK($id, array('vendor_notification' =>$notifying_employee)); 
        }else if($apply_from==11){
            PurchasingRequisition::model()->updateByPK($id, array('requisition_notification' =>$notifying_employee)); 
        }else if($apply_from==12){
            PurchasingEnquiry::model()->updateByPK($id, array('enquiry_notification' =>$notifying_employee)); 
        }else if($apply_from==13){
            PurchasingOrder::model()->updateByPK($id, array('order_notification' =>$notifying_employee)); 
        }else if($apply_from==14){
            PurchasingOrder::model()->updateByPK($id, array('order_approve_notification' =>$notifying_employee)); 
        }else if($apply_from==15){
            PurchasingMaterialreceipt::model()->updateByPK($id, array('mr_notification' =>$notifying_employee)); 
        }else if($apply_from==16){
            PurchasingMaterialreceipt::model()->updateByPK($id, array('qc_notification' =>$notifying_employee)); 
        }else if($apply_from==17){
            PurchasingInvoice::model()->updateByPK($id, array('invoice_notification' =>$notifying_employee)); 
        }else if($apply_from==18){
            Purchasingdebitnote::model()->updateByPK($id, array('debitnote_notification' =>$notifying_employee)); 
        }else if($apply_from==19){
            Store::model()->updateByPK($id, array('product_notification' =>$notifying_employee)); 
        }else if($apply_from==20){
            InventoryGoodsIssue::model()->updateByPK($id, array('issue_notification' =>$notifying_employee)); 
        }else if($apply_from==21){
            InventoryGoodsReceipt::model()->updateByPK($id, array('receipt_notification' =>$notifying_employee)); 
        }else if($apply_from==22){
            Quotes::model()->updateByPK($id, array('quotes_hiring_notification' =>$notifying_employee)); 
        }else if($apply_from==23){
            Quotes::model()->updateByPK($id, array('quotes_approve_hiring_notification' =>$notifying_employee)); 
        }else if($apply_from==24){
            Order::model()->updateByPK($id, array('order_hiring_notification' =>$notifying_employee)); 
        }else if($apply_from==25){
            Order::model()->updateByPK($id, array('order_hiring_approve_notification' =>$notifying_employee)); 
        }else if($apply_from==26){
            DeliveryNote::model()->updateByPK($id, array('delivery_hiring_notification' =>$notifying_employee)); 
        }else if($apply_from==27){
            Invoice::model()->updateByPK($id, array('invoice_hiring_notification' =>$notifying_employee)); 
        }
    }
     public static function sendsms($apply_from,$id) {
        
    }
     public function actionupdatenotification() {
        $from= Yii::app()->request->getParam('from');
        //Notification Update
        //Customer
        $model_mail_setting=Notification::model()->find(array('condition' => 'event_id="'.$from.'"')); 
        if($model_mail_setting->notification_required=='Y'){
            if($from==1){         
                $model_customer_notification = Customer::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",customer_notification)'));
                foreach ($model_customer_notification as $key => $value) {
                    $customer_notification_value=$value->customer_notification;              
                    $customer_notification_array=  explode(',', $customer_notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $customer_notification_array)) !== false) {
                        unset($customer_notification_array[$key]);
                    }
                    $customer_notification_new='';
                    if(count($customer_notification_array)){
                        $customer_notification_new=  implode(',', $customer_notification_array);
                    }
                    Customer::model()->updateByPK($value->id, array('customer_notification' =>$customer_notification_new)); 
                }
            }else if($from==2){          
                $model_lead_notification = Lead::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",lead_notification)'));
                foreach ($model_lead_notification as $key => $value) {
                    $lead_notification_value=$value->lead_notification;              
                    $lead_notification_array=  explode(',', $customer_notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $lead_notification_array)) !== false) {
                        unset($lead_notification_array[$key]);
                    }
                    $lead_notification_new='';
                    if(count($lead_notification_array)){
                        $lead_notification_new=  implode(',', $lead_notification_array);
                    }
                    Lead::model()->updateByPK($value->id, array('lead_notification' =>$lead_notification_new)); 
                }
            }else if($from==3){      //Quotes add    
                $model_notification = Quotes::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",quotes_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->quotes_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    Quotes::model()->updateByPK($value->id, array('quotes_notification' =>$notification_new)); 
                }
            }else if($from==4){       //Quotes Approve   
                $model_notification = Quotes::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",quotes_approve_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->quotes_approve_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    Quotes::model()->updateByPK($value->id, array('quotes_approve_notification' =>$notification_new)); 
                }
            }else if($from==5){          //Order Add
                $model_notification = Order::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",order_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->order_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    Order::model()->updateByPK($value->id, array('order_notification' =>$notification_new)); 
                }
            }else if($from==6){          //Order Approve
                $model_notification = Order::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",order_approve_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->order_approve_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    Order::model()->updateByPK($value->id, array('order_approve_notification' =>$notification_new)); 
                }
            }else if($from==7){          //Sales Delivry
                $model_notification = DeliveryNote::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",delivery_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->delivery_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    DeliveryNote::model()->updateByPK($value->id, array('delivery_notification' =>$notification_new)); 
                }
            }else if($from==8){          //Sales Invoice
                $model_notification = Invoice::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",invoice_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->invoice_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    Invoice::model()->updateByPK($value->id, array('invoice_notification' =>$notification_new)); 
                }
            }else if($from==9){          //Creditnote
                $model_notification = Creditnote::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",creditnote_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->creditnote_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    Creditnote::model()->updateByPK($value->id, array('creditnote_notification' =>$notification_new)); 
                }
            }else if($from==10){          //Vendor
                $model_notification = Vendor::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",vendor_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->vendor_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    Vendor::model()->updateByPK($value->id, array('vendor_notification' =>$notification_new)); 
                }
            }else if($from==11){          //Purchase Requisition
                $model_notification = PurchasingRequisition::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",requisition_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->requisition_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    PurchasingRequisition::model()->updateByPK($value->id, array('requisition_notification' =>$notification_new)); 
                }
            }else if($from==12){          //Purchase Requisition
                $model_notification = PurchasingEnquiry::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",enquiry_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->enquiry_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    PurchasingEnquiry::model()->updateByPK($value->id, array('enquiry_notification' =>$notification_new)); 
                }
            }else if($from==13){          //Purchase Order add
                $model_notification = PurchasingOrder::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",order_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->order_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    PurchasingOrder::model()->updateByPK($value->id, array('order_notification' =>$notification_new)); 
                }
            }else if($from==14){          //Purchase Order approve
                $model_notification = PurchasingOrder::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",order_approve_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->order_approve_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    PurchasingOrder::model()->updateByPK($value->id, array('order_approve_notification' =>$notification_new)); 
                }
            }else if($from==15){          //MR
                $model_notification = PurchasingMaterialreceipt::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",mr_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->mr_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    PurchasingMaterialreceipt::model()->updateByPK($value->id, array('mr_notification' =>$notification_new)); 
                }
            }else if($from==16){          //QC
                $model_notification = PurchasingMaterialreceipt::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",qc_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->qc_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    PurchasingMaterialreceipt::model()->updateByPK($value->id, array('qc_notification' =>$notification_new)); 
                }
            }else if($from==17){          //QC
                $model_notification = PurchasingInvoice::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",invoice_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->invoice_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    PurchasingInvoice::model()->updateByPK($value->id, array('invoice_notification' =>$notification_new)); 
                }
            }else if($from==18){          //QC
                $model_notification = Purchasingdebitnote::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",debitnote_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->debitnote_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    Purchasingdebitnote::model()->updateByPK($value->id, array('debitnote_notification' =>$notification_new)); 
                }
            }else if($from==19){          //New Item
                $model_notification = Store::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",product_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->product_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    Store::model()->updateByPK($value->id, array('product_notification' =>$notification_new)); 
                }
            }else if($from==20){          //Goods Issue
                $model_notification = InventoryGoodsIssue::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",issue_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->issue_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    InventoryGoodsIssue::model()->updateByPK($value->id, array('issue_notification' =>$notification_new)); 
                }
            }else if($from==21){          //Goods Receipt
                $model_notification = InventoryGoodsReceipt::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",receipt_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->receipt_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    InventoryGoodsReceipt::model()->updateByPK($value->id, array('receipt_notification' =>$notification_new)); 
                }
            }else if($from==22){          //Quotes Hiring add
                $model_notification = Quotes::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",quotes_hiring_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->quotes_hiring_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    Quotes::model()->updateByPK($value->id, array('quotes_hiring_notification' =>$notification_new)); 
                }
            }else if($from==23){       //Quotes Hiring Approve   
                $model_notification = Quotes::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",quotes_approve_hiring_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->quotes_approve_hiring_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    Quotes::model()->updateByPK($value->id, array('quotes_approve_hiring_notification' =>$notification_new)); 
                }
            }else if($from==24){          //Hiring Order Add
                $model_notification = Order::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",order_hiring_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->order_hiring_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    Order::model()->updateByPK($value->id, array('order_hiring_notification' =>$notification_new)); 
                }
            }else if($from==25){          //Hiring Order Approve
                $model_notification = Order::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",order_hiring_approve_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->order_hiring_approve_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    Order::model()->updateByPK($value->id, array('order_hiring_approve_notification' =>$notification_new)); 
                }
            }else if($from==26){          //Hiring Delivry
                $model_notification = DeliveryNote::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",delivery_hiring_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->delivery_hiring_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    DeliveryNote::model()->updateByPK($value->id, array('delivery_hiring_notification' =>$notification_new)); 
                }
            }else if($from==27){          //Hiring Delivry
                $model_notification = Invoice::model()->findAll(array('condition' => 'FIND_IN_SET("'.Yii::app()->user->id.'",invoice_hiring_notification)'));
                foreach ($model_notification as $key => $value) {
                    $notification_value=$value->invoice_hiring_notification;              
                    $notification_array=  explode(',', $notification_value);                
                    if (($key = array_search(Yii::app()->user->id, $notification_array)) !== false) {
                        unset($notification_array[$key]);
                    }
                    $notification_new='';
                    if(count($notification_array)){
                        $notification_new=  implode(',', $notification_array);
                    }
                    Invoice::model()->updateByPK($value->id, array('invoice_hiring_notification' =>$notification_new)); 
                }
            }
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData); 
    }
            
}
