<?php

class MastercompanyController extends Controller
{

    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'SaveCompany', 'UploadProfilePhoto', 'CreateBankDetails', 'BankDetailsSave', 'GetBankDetailsList', 'DeleteBankDetails', 'CreateOwnerBankDetails'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionCreate()
    {

        if (isset(Yii::app()->user->havePermissionOn['admin_company_settings_view']) || Yii::app()->user->authorised_user == 1) {
            $model = new MasCompany();
            $modelColorSettings = new ColorSettings();
            // $id = (int) Yii::app()->request->getParam('id');
            $id = 1;
            if ($id > 0) {
                $model = $model->findByPk($id);
                $modelColorSettings = $modelColorSettings->find(array('condition' => 'company_id=' . $id));
                if (empty($modelColorSettings))
                    $modelColorSettings = new ColorSettings();
            }


            $modelCountry = MasCountry::model()->findAll();
            $countryList = CHtml::listData($modelCountry, 'id', 'country_name');


            $modelCurrency = MasCurrency::model()->findAll();
            $currencyList = CHtml::listData($modelCurrency, 'id', 'currency');

            $modelMasCompanyLevel = MasCompanyLevel::model()->findAll();



            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
            $this->render('company-form', array('model' => $model, 'countryList' => $countryList, 'currencyList' => $currencyList, 'modelColorSettings' => $modelColorSettings, 'modelMasCompanyLevel' => $modelMasCompanyLevel), false, true);
        } else {
            throw new CHttpException(401, 'Unauthorized Access');
        }

    }

    public function actionSaveCompany()
    {
        $model = new MasCompany();
        /*         * ********** START Code for Save ************** */
        $modelColorSettings = new ColorSettings();
        if (isset($_POST['MasCompany'])) {
            if ((int) @$_POST['MasCompany']['id'] > 0) {
                $model->id = (int) $_POST['MasCompany']['id'];
                $model = $model->findByPK($model->id);
                $model->crm_user_id = Yii::app()->user->id;
            } else {

            }
            $model->attributes = $_POST['MasCompany'];
            $model->company_logo = $_POST['MasCompany']['company_logo'];
            $model->no_of_decimals = $_POST['MasCompany']['no_of_decimals'];
            $model->markup = $_POST['MasCompany']['markup'];
            $model->company_level_id = $_POST['MasCompany']['company_level_id'];
            $model->sales_and_service = $_POST['MasCompany']['sales_and_service'];
            $model->contract = $_POST['MasCompany']['contract'];
            if (!empty($_POST['MasCompany']['erp_setting'])) {
                $model->erp_setting = $_POST['MasCompany']['erp_setting'];

            }

            //////////////////////////////////////////////////////////////////////
            // $allPermissions = array();
            // foreach ($_POST['MasCompany']['print_permissions'] as $eachPermissionArray) {
            //     if (is_array($eachPermissionArray)) {
            //         foreach ($eachPermissionArray as $eachPermission) {
            //             $allPermissions[$eachPermission] = 1;
            //         }
            //     }
            // }
            // $model->print_permissions = json_encode($allPermissions);
            $model->print_permissions = json_encode($_POST['MasCompany']['print_permissions']);
            ////////////////////////////////////////////////////
            $valid = $model->validate();
            if (isset($_POST['ColorSettings'])) {
                if ((int) @$_POST['ColorSettings']['id'] > 0) {
                    $modelColorSettings->updated_by = Yii::app()->user->id;
                    $modelColorSettings->updated_date_time = date('Y-m-d h:i:s');
                    $id = (int) @$_POST['ColorSettings']['id'];
                    $modelColorSettings = $modelColorSettings->findByPk($id);
                    $audit_type = 'UPDATED';
                } else {
                    $audit_type = 'CREATED';
                    $modelColorSettings->created_by = Yii::app()->user->id;
                    $modelColorSettings->created_date_time = date('Y-m-d h:i:s');
                }



                $modelColorSettings->attributes = $_POST['ColorSettings'];

                $modelColorSettings->button_color_right = $_POST['ColorSettings']['button_color_right'];
                $modelColorSettings->report_html_header_color = $_POST['ColorSettings']['report_html_header_color'];

                $modelColorSettings->save(false);


                $theme_dark_color = $_POST['ColorSettings']['theme_color'];
                $theme_dark_color_right = $_POST['ColorSettings']['theme_color_right'];
                $theme_light_color = $_POST['ColorSettings']['light_color'];
                $theme_light_color_right = $_POST['ColorSettings']['light_color_right'];
                $theme_logo_color = $_POST['ColorSettings']['logo_bg_color'];
                $theme_print_tbl_border_color = $_POST['ColorSettings']['print_tbl_border_color'];
                $theme_print_tbl_header_color = $_POST['ColorSettings']['print_tbl_header_color'];
                $theme_print_top_left_bg = $_POST['ColorSettings']['print_top_left_bg'];
                $theme_print_top_left_text_color = $_POST['ColorSettings']['print_top_left_box_text_color'];
                $theme_print_footer_bg = $_POST['ColorSettings']['print_footer_bg'];
                $theme_print_alternative_row_bg = $_POST['ColorSettings']['print_table_alternative_row_bg'];
                $theme_report_html_header_color = $_POST['ColorSettings']['report_html_header_color'];

                $theme_grid_header_font_color = $_POST['ColorSettings']['grid_header_font_color'];
                $theme_grid_table_bg = $_POST['ColorSettings']['grid_table_bg'];

                $theme_grid_table_row_color = $_POST['ColorSettings']['grid_table_row_color'];
                $theme_button_color = $_POST['ColorSettings']['button_color'];
                $theme_button_color_right = $_POST['ColorSettings']['button_color_right'];

                $theme_menu_color = $_POST['ColorSettings']['menu_color'];
                $theme_menu_hover_color = $_POST['ColorSettings']['menu_hover_color'];

                $theme_dashboard_count_color = $_POST['ColorSettings']['dashboard_count_color'];

                $theme_login_page_bg = $_POST['ColorSettings']['login_page_bg'];
                $theme_tab_bg_color = $_POST['ColorSettings']['tab_bg_color'];


                $originalCSSPath = 'css/admin-style-format.css';
                $pdfcssPath = 'css/pdf-style-format.css';
                $loginpage = 'css/particles/particle-format.css';

                // Step 2: Read the content of the original CSS file
                $pdfcssContent = file_get_contents($pdfcssPath);

                $cssContent = file_get_contents($originalCSSPath);

                $loginCss = file_get_contents($loginpage);

                $cssContent = str_replace('themedarkcolor', $theme_dark_color, $cssContent);
                $cssContent = str_replace('themedarkright', $theme_dark_color_right, $cssContent);

                $cssContent = str_replace('themelightcolor', $theme_light_color, $cssContent);
                $cssContent = str_replace('themelightright', $theme_light_color_right, $cssContent);

                $cssContent = str_replace('themelogocolor', $theme_logo_color, $cssContent);

                $cssContent = str_replace('themebuttoncolor', $theme_button_color, $cssContent);

                $cssContent = str_replace('themebuttonsecondcolor', $theme_button_color_right, $cssContent);

                $cssContent = str_replace('thememenucolor', $theme_menu_color, $cssContent);

                $cssContent = str_replace('thememenuhovercolor', $theme_menu_hover_color, $cssContent);

                $cssContent = str_replace('themegridheadercolor', $theme_grid_header_font_color, $cssContent);

                $cssContent = str_replace('themegridtablebgcolor', $theme_grid_table_bg, $cssContent);

                $cssContent = str_replace('themegridtablerowoddcolor', $theme_grid_table_row_color, $cssContent);

                $cssContent = str_replace('dashboardcountcolor', $theme_dashboard_count_color, $cssContent);
                $cssContent = str_replace('tabbgcolor', $theme_tab_bg_color, $cssContent);

                 $cssContent = str_replace('htmlheadercolor', $theme_report_html_header_color, $cssContent);

                $pdfcssContent = str_replace('themeprinttablebrdrcolor', $theme_print_tbl_border_color, $pdfcssContent);

                $pdfcssContent = str_replace('themeprinttableheadercolor', $theme_print_tbl_header_color, $pdfcssContent);
                $pdfcssContent = str_replace('themeprintfootercolor', $theme_print_footer_bg, $pdfcssContent);


                $pdfcssContent = str_replace('themeprinttopleftcolor', $theme_print_top_left_bg, $pdfcssContent);

                $pdfcssContent = str_replace('themeprinttoplefttextcolor', $theme_print_top_left_text_color, $pdfcssContent);

                $pdfcssContent = str_replace('themeprintaletrnativerowbg', $theme_print_alternative_row_bg, $pdfcssContent);

                $loginPage = str_replace('themeloginpage', $theme_login_page_bg, $loginCss);

                file_put_contents('css/admin-style.css', $cssContent);

                file_put_contents('css/pdf_style.css', $pdfcssContent);

                file_put_contents('css/particles/particle.css', $loginPage);






            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            if (isset($_POST['MasCompanySettings'])) {

                $modelCompanySettings = new MasCompanySettings();
                $modelCompanySettings = $modelCompanySettings->find(array('condition' => 'crm_company_id=' . (int) $model->id));
                if ($modelCompanySettings !== null) {
                    $modelCompanySettings->mis_menu = $_POST['MasCompanySettings']['mis_menu'];
                    $modelCompanySettings->sales_menu = $_POST['MasCompanySettings']['sales_menu'];
                    $modelCompanySettings->purchase_menu = $_POST['MasCompanySettings']['purchase_menu'];
                    $modelCompanySettings->inventory_menu = $_POST['MasCompanySettings']['inventory_menu'];
                    $modelCompanySettings->assembly_menu = $_POST['MasCompanySettings']['assembly_menu'];
                    $modelCompanySettings->accounts_menu = $_POST['MasCompanySettings']['accounts_menu'];
                    $modelCompanySettings->projects_menu = $_POST['MasCompanySettings']['projects_menu'];
                    $modelCompanySettings->reports_menu = $_POST['MasCompanySettings']['reports_menu'];
                    $modelCompanySettings->masters_menu = $_POST['MasCompanySettings']['masters_menu'];
                    $modelCompanySettings->admin_menu = $_POST['MasCompanySettings']['admin_menu'];
                    $modelCompanySettings->print_template_id = $_POST['print_template_id'];
                } else {
                    $modelCompanySettings = new MasCompanySettings();
                    $modelCompanySettings->crm_company_id = $model->id;
                    $modelCompanySettings->mis_menu = $_POST['MasCompanySettings']['mis_menu'];
                    $modelCompanySettings->sales_menu = $_POST['MasCompanySettings']['sales_menu'];
                    $modelCompanySettings->purchase_menu = $_POST['MasCompanySettings']['purchase_menu'];
                    $modelCompanySettings->inventory_menu = $_POST['MasCompanySettings']['inventory_menu'];
                    $modelCompanySettings->assembly_menu = $_POST['MasCompanySettings']['assembly_menu'];
                    $modelCompanySettings->accounts_menu = $_POST['MasCompanySettings']['accounts_menu'];
                    $modelCompanySettings->projects_menu = $_POST['MasCompanySettings']['projects_menu'];
                    $modelCompanySettings->reports_menu = $_POST['MasCompanySettings']['reports_menu'];
                    $modelCompanySettings->masters_menu = $_POST['MasCompanySettings']['masters_menu'];
                    $modelCompanySettings->admin_menu = $_POST['MasCompanySettings']['admin_menu'];
                    $modelCompanySettings->print_template_id = $_POST['print_template_id'];

                }
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            // $model->print_permissions = json_encode($_POST['MasCompany']['print_permissions']);
            if ($valid) {
                if ($model->save()) {
                    // update companysettings

                    // $companySetting = MasCompanySettings::model()->findByAttributes(array('crm_company_id' => $model->id));
                    // if ($companySetting !== null) {
                    //     $companySetting->print_template_id = $_POST['print_template_id'];
                    //     $companySetting->save(false);
                    // }else{
                    //      $companySetting = new MasCompanySettings();
                    //         $companySetting->crm_company_id = $model->id;
                    //         $companySetting->print_template_id = $_POST['print_template_id'];
                    //         $companySetting->save(false);
                    // }
                    $modelCompanySettings->save(false);
                    $jsonData['status'] = 'success';
                    $jsonData['frm'] = $_POST['company-form'];
                    $jsonData['id'] = $model->id;
                    echo CJSON::encode($jsonData);
                } else {
                    $error = CActiveForm::validate($model, '', false);
                    if ($error != '[]')
                        echo $error;
                }

            }
        }
    }

    public function actionCreateBankDetails()
    {

        $model = new OwnerBankDetails();
        //for country dropdown
        $modelCountry = MasCurrency::model()->findAll();
        $countryList = CHtml::listData($modelCountry, 'id', 'currency');

        //for bank dropdown
        $modelBank = MasBank::model()->findAll();
        $bankList = CHtml::listData($modelBank, 'id', 'bank_name');

        $id = (int) Yii::app()->request->getParam('id');

        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('company_bank_details_form', array('model' => $model, 'currencyList' => $countryList, 'bankLIst' => $bankList), false, true);
    }

    public function actionBankDetailsSave()
    {

        $model = new OwnerBankDetails();

        /************ START Code for Save ***************/
        if (isset($_POST['OwnerBankDetails'])) {

            if ((int) @$_POST['OwnerBankDetails']['id'] > 0) {
                $model->id = (int) $_POST['OwnerBankDetails']['id'];
                $model = $model->findByPK($model->id);
            } else {
            }

            $model->attributes = $_POST['OwnerBankDetails'];
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['company_bank_details_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }

        }

    }

    public function actionGetBankDetailsList()
    {


        $model = new OwnerBankDetails();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'bank_account_name',
            1 => 'bank_id',
            2 => 'currency_id',
            3 => 'bank_branch',
            4 => 'bank_ac_no',
            5 => 'bank_tax_id',
            6 => 'bank_iban',
            7 => 'bank_swift',
            8 => 'bank_ifsc',
            9 => 'bank_others',

        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (bank_account_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('bank')->count(array('condition' => $condition));
        $model = $model->with('bank')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $rowData[] = array(
                $m,
                $row['bank']['bank_name'],
                $row['bank_branch'],
                $row['bank_account_name'],
                $row['bank_ac_no'],
                $row['bank_swift'],
                $row['bank_iban'],
                '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'Mastercompany/CreateBankDetails&id=' . $row['id'] . '\',\'Edit Bank\',\'lg\');return false;"><i class="fa fa-pencil"></i></button> '
                . '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteBankDetails(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a></div>'
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);

    }


    public function actionDeleteBankDetails()
    {

        $id = $_POST['id'];
        $model = new OwnerBankDetails();
        $model->deleteByPk($id);
        echo "success";

    }
    public function actionindex()
    {
        if (isset(Yii::app()->user->havePermissionOn['admin_company_settings_view']) || Yii::app()->user->authorised_user == 1) {
            $model = new MasCompany();
            //$id = (int) Yii::app()->request->getParam('id');
            $modelColorSettings = new ColorSettings();
            $id = Yii::app()->user->master_user_company_id;

            if ($id > 0) {
                $model = $model->findByPk($id);
                $modelColorSettings = $modelColorSettings->find(array('condition' => 'company_id=' . $id));
                if (empty($modelColorSettings))
                    $modelColorSettings = new ColorSettings();
            }

            $modelCountry = MasCountry::model()->findAll();
            $countryList = CHtml::listData($modelCountry, 'id', 'country_name');


            $modelCurrency = MasCurrency::model()->findAll();
            $currencyList = CHtml::listData($modelCurrency, 'id', 'currency');



            //Yii::app()->clientScript->scriptMap = array('*jquery.js' => true, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false,'jquery-2.1.4.min.js' => false, '*.css' => false);
            $this->render('index', array('model' => $model, 'countryList' => $countryList, 'currencyList' => $currencyList, 'modelColorSettings' => $modelColorSettings), false, true);

        } else {
            throw new CHttpException(401, 'Unauthorized Access');
        }
    }
    public function actionCreateOwnerBankDetails()
    {

        $model = new MasCompanyBankDetails();
        //for country dropdown
        $modelCountry = MasCurrency::model()->findAll();
        $countryList = CHtml::listData($modelCountry, 'id', 'currency');

        //for bank dropdown
        $modelBank = MasBank::model()->findAll();
        $bankList = CHtml::listData($modelBank, 'id', 'bank_name');

        $id = (int) Yii::app()->request->getParam('id');

        if ($id > 0) {
            $model = $model->findByPk($id);
        }

        $this->render('company_bank_details_form', array('model' => $model, 'currencyList' => $countryList, 'bankLIst' => $bankList), false, true);
    }



    public function actionUploadProfilePhotoold($folder = null)
    {

        Yii::import("ext.EAjaxUpload.qqFileUploader");

        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';

        // make the directory to store the pic:

        if (!is_dir($folder)) {

            mkdir($folder, 0777, TRUE);

            //chmod($folder, 0755);

        }

        $allowedExtensions = array();

        $sizeLimit = 1 * 1024 * 1024; // maximum file size in bytes

        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);

        $result = $uploader->handleUpload($folder);

        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);

        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);

        $fileName = $result['filename']; //GETTING FILE NAME

        // $this->CropIfImage($folder, $fileName, 100, 100);

        echo $return; // it's array

    }


    public function actionUploadProfilePhoto($folder = null)
    {
        Yii::import("ext.EAjaxUpload.qqFileUploader");

        // Set the folder path for upload
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';

        // Create the directory if it doesn't exist
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }

        $allowedExtensions = array();
        $sizeLimit = 1 * 1024 * 1024; // Maximum file size in bytes (1MB)

        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $newFileName = 'blueskylogo.png';
        $fileExtension = pathinfo($result['filename'], PATHINFO_EXTENSION);

        $result['uploadfilename'] = $result['filename'];
        // Rename the uploaded file to "blueskylogo.png"
        rename($folder . $result['filename'], $folder . $newFileName);
        // Update the result with the new file name
        $result['filename'] = $newFileName;
        $result['fileType'] = $fileExtension;

        // Return the result as a JSON response
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        echo $return; // Send response back to the front-end
    }




}
