<?php

class MashiringapplicationController extends Controller
{
    
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','DeleteApplication','SaveMasHiringApplication','GetApplicationList','Disable'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
        $this->render('index');
         }
         
        public function actionGetApplicationList()
         {
 
                $model=new MasHiringApplication();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'application_name',
                   1 =>'application_name'
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition =" (application_name LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                
                foreach ($model as $row)
                {
                    $div = '';
                    
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_application_edit"])){
                        $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'mashiringapplication/create&id='.$row['id'].'\',\'Edit Application\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    }
                        $rowData[]=array($m,$row['application_name'],'<div class="btn-wrap text-center">'.$div.'</div>',array('id' => $row['id'], 'status' => $row->isActive ,'code'=>$row['application_name']));
   
                
                    $m++;
                    
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new MasHiringApplication(); 
        $id=(int) Yii::app()->request->getParam('id');
         $from=(int) Yii::app()->request->getParam('from');
            if($id>0){
                $model=$model->findByPk($id);
            }
             Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('create', array('model' => $model,'from' => $from), false, true);
    }
    public function actionSaveMasHiringApplication()
        {
            $model = new MasHiringApplication();
            if (isset($_POST['MasHiringApplication']))
            {   $model->created_by = Yii::app()->user->id;
                $model->created_datetime =date('Y-m-d h:i:s');
    		
    		if ((int) @$_POST['MasHiringApplication']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_datetime =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['MasHiringApplication']['id'];
                    $model=$model->findByPk($id); 
                    $audit_type = 'UPDATED';
                    $edit_flag=1;
                }else{
                    $audit_type = 'CREATED';
                }
                $model->attributes=$_POST['MasHiringApplication'];
                if($model->save())
                {
                       if($edit_flag==1)
                {
                    $this->ChanageDB(MasCompany::DB_ARK);
                    $arkProduct = MasHiringApplication::model()->findByPk($model->id);
                    $arkProduct->attributes = $model->attributes;
                    $arkProduct->save(false);
                    $this->ChanageDB();    
                }
                else {
                    $this->ChanageDB(MasCompany::DB_ARK);
                    $arkProduct = new MasHiringApplication;
                    $arkProduct->id=$model->id;
                    $arkProduct->attributes = $model->attributes;
                    $arkProduct->save(false);
                    $this->ChanageDB();  
                }
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'HIRING',
                            Yii::app()->user->id,
                            $audit_type,
                            " with application: - {$model->application_name}  ",
                            "",
                            ""
                        );
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['application_form'];
                        $jsonData['from'] = $_POST['from'];
                        $jsonData['id'] = $model->id;
	                    echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }

            }
        }
        public function actionDeleteMasHiringApplication()
    {
		$id = $_POST['id'];
                $model_s = Store::model()->findAll(array('condition'=>'application_id='.$id.' '));
                if(empty($model_s)){
                    $model=new MasHiringApplication();
                    $model->deleteByPk($id);
                    echo "success";  
                }else{
                    echo "fail";  
                }
               
    }
    
         public function actionDirectAdd(){
           $from = $_POST['from'];
           $name = $_POST['name'];
           $symbol = $_POST['symbol'];
           $type = $_POST['type'];
           if($name != '' && $symbol != '' && $type !=''){
               $modelApplication = new Application;
               $modelApplication->application_name = $name;
               $modelApplication->symbol = $symbol;
               $modelApplication->application_type = $type;
               if($modelApplication->save()){
                    $data  = Application::getApplications();
                    if($from == 'inventory'){
                        $model = new Store;
                        $field_name = 'application_id';
                    }
                    $model->$field_name = $modelApplication->id;
                    $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Application <span style="color:red;">*<span>'));  
                    $status=array("status" =>"success","drop" => $drop);    
                    echo CJSON::encode($status);
               }else{
                   $error = CActiveForm::validate($modelApplication, '', false);
                        if ($error != '[]')
		               echo $error;
               }
           }
           
            
         }
         
          public function actionDirectAddTax(){
           $from = $_POST['from'];
           $name = $_POST['name'];
           $percent = $_POST['percent'];
           if($name != '' && $percent !=''){
                    $modelTax = new MasInvTax;
                    $modelTax->tax_code = $name;
                    $modelTax->percentage = $percent;
                    if($modelTax->save()){
                         $data  = MasInvTax::getTax();
                    if($from == 'inventory'){
                        $model = new Store;
                        $field_name = 'tax_code';
                    }
                    if($from == 'inventory_1'){
                        $model = new Store;
                        $field_name = 'tax_code_1';
                    }
                    if($from == 'inventory_2'){
                        $model = new Store;
                        $field_name = 'tax_code_2';
                    }
                    if($from == 'inventory_3'){
                        $model = new Store;
                        $field_name = 'tax_code_3';
                    }
                    $model->$field_name = $modelTax->id;
                    $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Tax Code <span style="color:red;">*<span>'));  
                    $status=array("status" =>"success","drop" => $drop);    
                    echo CJSON::encode($status);
               }else{
                   $error = CActiveForm::validate($modelTax, '', false);
                        if ($error != '[]')
		               echo $error;
               }
           }
         
            
         }
        
                public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasHiringApplication();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
    public function ChanageDB($database = MasCompany::DB_ACE){
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $database;
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
    }
}