<?php

class MasclothtypeController extends Controller
{
        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetList','Save','Delete', 'Disable'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	public function actionIndex()
	{
		$this->render('index');
	}

	
	
	public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
        public function actionGetList()
        {
                $model=new MasterClothType();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   /*0 =>'id',
                   1 =>'tax_code',*/
                   
                   0 =>'id',
                   1 =>'type_name',
                   2 => 'rate'
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                 $condition ="  (type_name LIKE '%".$searchString."%' OR rate  LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                
                foreach ($model as $row)
                {
                    $div = '';
                    //if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_rack_edit"])){
                  $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'clothtype/create&id='.$row['id'].'\',\'Edit Tax Code\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                  //  }
                   // if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_rack_delete"])){
                   //     $div .=  '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteTax('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                 //   }
                       $rowData[]=array($m,
                           $row['type_name'],
                           $row['rate'],
                           '<div class="btn-wrap text-center">'.$div.'</div>',
                           array('id' => $row['id'],'code'=>$row['type_name'], 'status' => $row->isActive));
                
                    $m++;
                    
                }
                
                
                
//                foreach ($model as $row)
//                {
//                    $rowData[]=array($m,$row['name'],'<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'rack/create&id='.$row['id'].'\',\'Edit Rack\',\'lg\')"><i class="fa fa-pencil"></i></button> '
//             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteRack('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
//                    $m++;
//                }
                $data['data'] = $rowData;
                echo json_encode($data);
        }
         public function actionCreate()
        {
            $model=new MasterClothType();
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('type_form', array('model' => $model), false, false);
        }
  
  
        public function actionSave()
        {
            $model = new MasterClothType();
            if (isset($_POST['MasterClothType']))
            {
    		$model->created_by = Yii::app()->user->id;
                $model->created_date_time =date('Y-m-d h:i:s');
    		if ((int) @$_POST['MasterClothType']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_date_time =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['MasterClothType']['id'];
                    $model=$model->findByPk($id); 
                    $audit_type = 'UPDATED'; 
                    $edit_flag=1;
                }else{
                  $audit_type = 'CREATED';
                }
                $model->attributes=$_POST['MasterClothType'];
                if ($model->save())
                {
                    
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                          'TAX_MASTER',
                          Yii::app()->user->id,
                          $audit_type,
                      );
                      // end audit log
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['rack_form'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            }
        }
        public function actionDelete(){
		$id = $_POST['id'];
                $model=new MasterClothType();
                $del = $model->findByPk($id); // audit log changes
                $model->deleteByPk($id);
                // inserting to audit log
                AuditLog::saveAuditLogs(
                  'TAX_MASTER',
                  Yii::app()->user->id,
                  'DELETED',
              );
                echo "success";
    }
             public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasterClothType();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

}