<?php

class MasQuotesStatusController  extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'Getlist', 'Save', 'deleteQuotesStatus'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionIndex()
    {
        $this->render('index');
    }
    public function actionGetlist()
    {
        $model = new MasQuotesStatus();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'status',
            2 => 'status_code',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        $condition = '';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            if ($_POST['search']['value'] == 'y' or $_POST['search']['value'] == 'ye' or $_POST['search']['value'] == 'yes') {
                $tax_string  = 'Y';
            } else if ($_POST['search']['value'] == 'n' or $_POST['search']['value'] == 'no') {
                $tax_string  = 'N';
            }
            $condition .= " ( t.status LIKE '%" . $searchString . "%' OR t.status_code LIKE '%" . $searchString . "%')";
        }

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {




            $div = '';
            if (Yii::app()->user->authorised_user == 1 || isset(Yii::app()->user->havePermissionOn['mas_quotes_status_edit'])) {
                $div .= ' <button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'MasQuotesStatus/create&id=' . $row['id'] . '\',\'Update Quotes Status\',\'lg\');return false;"><i class="fa fa-pencil"></i></button>';
            }
            if (Yii::app()->user->authorised_user == 1 || isset(Yii::app()->user->havePermissionOn['mas_quotes_status_delete'])) {
                $div .= ' <a href ="#" class="btn btn-danger btn-xs" title="Delete" onclick="deleteQuotesStatus(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>';
            }
            $rowData[] = array($m, $row['status'], $row['status_code'], '<div class="btn-wrap text-center">' . $div . '</div>');
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate()
    {


        $model = new MasQuotesStatus();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('status_form', array('model' => $model));
    }

    public function actionSave()
    {
        $model = new MasQuotesStatus();

        if (isset($_POST['MasQuotesStatus'])) {
            $model->created_by        = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d h:i:s');

            if ((int) @$_POST['MasQuotesStatus']['id'] > 0) {
                $id = (int) @$_POST['MasQuotesStatus']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            }




            $model->attributes = $_POST['MasQuotesStatus'];

            $valid = $model->validate();

            if ($valid) {
                $model->save();
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {

                $error1 = array();


                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1));

                if ($error != '[]')
                    echo $error;
            }
        }
    }


    public function actiondeleteQuotesStatus()
    {
        $id    = $_POST['id'];
        $model = new MasQuotesStatus();
        $model->deleteByPk($id);
        echo "success";
    }
}
