<?php

class MasProject3Controller extends Controller
{
        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetLists','SaveMasterProject3','DeleteBin','DirectAdd', 'Getbins', 'UnBlockbin','Blockbin','Disable,','GetMaster2ById'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	public function actionIndex()
        {
            if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['projects_masster3_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['projects_masster3_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
                $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
        }

	
	
	public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
        
        public function actionGetLists()
        {
                $model=new MasProject3();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $master1_id = isset($_POST['master1_id']) ? $_POST['master1_id'] : '';
                $master2_id = isset($_POST['master2_id']) ? $_POST['master2_id'] : '';
                $master3_id = isset($_POST['master3_id']) ? $_POST['master3_id'] : '';
                $columns = array(
                // datatable column index  => database column bin_name
                0 =>'t.id',
                1 => 'master_det.master_name',
                2 =>'master2.master2_name',
                2 =>'master3_name',
                );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                //$orderBy   = $filterColumn." ".$filterOrder;
               //echo $orderBy;
                $orderBy=" master_det.master_name , master2.master2_name asc, master3_name asc";
               
                $condition = '1=1';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  ( master3_name LIKE '%".$searchString."%' OR master2.master2_name LIKE '%".$searchString."%')";
                }
                if (!empty( $master1_id)) {
                    $condition .= " AND t.master1_id = $master1_id";
                 
                }
        
                if (!empty($master2_id)) {
                    $condition .= " AND t.master2_id  = $master2_id";
                 
                }
                
                //  if (!empty($master3_id)) {
                //     $condition .= " AND t.id  = $master3_id";
                 
                // }
                if (!empty($master3_id)) {
                    if (!empty($master2_id)) {
                        $condition .= " AND t.id = $master3_id AND t.master2_id = $master2_id";
                    } else {
                        $condition .= " AND t.id = $master3_id";
                    }
                }
                
               
         // echo  $condition;
                $count = $model->with('master2','master_det')->count(array('condition'=>$condition));
                $model=$model->with('master2','master_det')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=> $orderBy )); //$orderBy order by master3_name asc
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                 
                foreach ($model as $row)
                {
                    $div = '';
                    $rowData[]=array($m,
                        //$row['master2']['mas_projcet1_det']['master_name'],
                        $row['master_det']['master_name'],
                        $row['master2']['master2_name'],
                        $row['master3_name'],
                        $row['is_base_master'],
                        array('id' => $row['id'],'code'=>$row['master3_name'], 'status' => $row->isActive),);
   
                
                    $m++;
                    
                }
                
                $data['data'] = $rowData;
                echo json_encode($data);
        }

        public function actionCreate()
        {
            $model=new MasProject3();
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('master_project3_form', array('model' => $model), false, false);
        }
  
  
        public function actionSaveMasterProject3()
        {
            $model = new MasProject3();
            if (isset($_POST['MasProject3']))
            {
    		$model->created_by = Yii::app()->user->id;
                $model->created_datetime =date('Y-m-d h:i:s');
    		if ((int) @$_POST['MasProject3']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_datetime =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['MasProject3']['id'];
                    $model=$model->findByPk($id);  
                    $audit_type = 'UPDATED';
                    $edit_flag=1;
                }else{
                    $audit_type = 'CREATED';
                }
                if($_POST['MasProject3']['is_base_master'] == "Y"){
                	MasProject3::model()->updateAll(array( 'is_base_master' => 'N' ), 'is_base_master = "Y"' );
            	}
                $model->is_base_master = $_POST['MasProject3']['is_base_master'];
                $model->attributes=$_POST['MasProject3'];
                $model->master1_id = $_POST['MasProject3']['master1_id'];
                if ($model->save())
                {    
                    // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'PROJECT3_MASTER',
                            Yii::app()->user->id,
                            $audit_type,
                            " with master3_name: - {$model->master3_name}  "
                        );
                        // end audit log
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['mas-project3-form'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            }
        }
        public function actionDeleteBin(){
		$id = $_POST['id'];
                $model=new MasProject3();
                $del = $model->findByPk($id); // audit log changes
                $model->deleteByPk($id);
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'BIN_MASTER',
                    Yii::app()->user->id,
                    'DELETED',
                    " with bin_name: - {$del->bin_name}  "
                );
                // end audit log
                echo "success";
    }
    
     public function actionDirectAdd(){
           $from = $_POST['from'];
           $bin_name = $_POST['bin_name'];
           $rack = $_POST['rack'];
           if($bin_name != ''){
               $modelBin = new MasProject3;
               $modelBin->bin_name = $bin_name;
               $modelBin->rack_id = $rack;
               if($modelBin->save()){
                    $data  = MasProject3::getBins();
                    if($from == 'inventory'){
                        $model = new ProductLocation;
                        $field_bin_name = 'bin';
                    }
                    $model->$field_bin_name = $modelBin->id;
                    $drop=CHtml::activedropDownList($model,$field_bin_name, $data,  array('class' => 'tooltipster','data-label'=>'Bin'));  
                    $status=array("status" =>"success","drop" => $drop);    
                    echo CJSON::encode($status);
               }else{
                    $error = CActiveForm::validate($modelBin, '', false);
                        if ($error != '[]')
		               echo $error;
               }
           }
           
            
         }
    public function actionGetbins(){
        $model = $_POST['model'];
        $field_id = $_POST['field_id'];
        $id = (int) $_POST['id'];
        echo CHtml::activedropDownList(new $model, $field_id,MasProject3::getBins_rackwise($id), array('data-label'=>'Bin'));
    }


    public function actionBlockbin() {
        $id = $_POST['id'];
        if ($id > 0) {
            MasProject3::model()->updateByPK($id, array('isActive' => "N"));
              // inserting to audit log
              $model=new MasProject3();
              $upt = $model->findByPk($id); // audit log changes
              AuditLog::saveAuditLogs(
                  'BIN_MASTER',
                  Yii::app()->user->id,
                  'BLOCKED',
                  " with bin_name: - {$upt->bin_name}  "
              );
             // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionUnBlockbin() {
        $id = $_POST['id'];
        if ($id > 0) {
            MasProject3::model()->updateByPK($id, array('isActive' => "Y"));
             // inserting to audit log
             $model=new MasProject3();
             $upt = $model->findByPk($id); // audit log changes
             AuditLog::saveAuditLogs(
                 'BIN_MASTER',
                 Yii::app()->user->id,
                 'UNBLOCKED',
                 " with bin_name: - {$upt->bin_name}  "
             );
            // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasProject3();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
    
    
    public function actionGetMaster2ById()
    {
          if (isset($_POST['master1_id'])) {
             $master1_id = (int) $_POST['master1_id'];
            $rackList =MasProject2::getMaster2Wise($master1_id);
           //print_r($rackList);
            $formattedRacks = [];
            foreach ($rackList as $id => $name) {
                $formattedRacks[] = ['id' => $id, 'name' => $name];
            }
    
            echo CJSON::encode($formattedRacks);
         }
   }
}

