<?php

class MasProject2Controller extends Controller
{
        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetList','SaveMasterProjct2','DeleteRack','DirectAdd', 'Disable','GetMaster2list'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	public function actionIndex()
        {
            if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['projects_master2_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['projects_master2_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
                $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
        }

	
	
	public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
        public function actionGetList()
        {
                $model=new MasProject2();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                 $warehouse_type = isset($_POST['warehouse_type']) ? $_POST['warehouse_type'] : '';
                $columns = array(
                // datatable column index  => database column name
                  
                    0 =>'t.id',
                    1 => 't.master1_id',
                    2 => 'master2_name',
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '1=1';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (master2_name LIKE '%".$searchString."%')";
                }
                 if (!empty( $warehouse_type)) {
                    $condition .= " AND t.master1_id = $warehouse_type";
                 
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'master2_name ASC'));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                
                foreach ($model as $row)
                {
                    $div = '';
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_rack_edit"])){
                       // $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'rack/create&id='.$row['id'].'\',\'Edit Rack\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    }
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_rack_delete"])){
                        //$div .=  '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteRack('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                    }
                       $rowData[]=array($m,
                         $row['mas_projcet1_det']['master_name'],
                           $row['master2_name'],
                           '<div class="btn-wrap text-center">'.$div.'</div>',
                           $row['is_base_master'],
                array('id' => $row['id'],'code'=>$row['master2_name'], 'status' => $row->isActive));
                    $m++;
                    
                }
                $data['data'] = $rowData;
                echo json_encode($data);
        }
         public function actionCreate()
        {
            $model=new MasProject2();
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('master_project2_form', array('model' => $model), false, false);
        }
  
  
        public function actionSaveMasterProjct2()
        {
            $model = new MasProject2();
            if (isset($_POST['MasProject2']))
            {
    		$model->created_by = Yii::app()->user->id;
                $model->created_datetime =date('Y-m-d h:i:s');
    		if ((int) @$_POST['MasProject2']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_datetime =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['MasProject2']['id'];
                    $model=$model->findByPk($id); 
                    $audit_type = 'UPDATED';
                    $edit_flag=1;
                }else{
                    $audit_type = 'CREATED';
                }
                if($_POST['MasProject2']['is_base_master'] == "Y"){
                	MasProject2::model()->updateAll(array( 'is_base_master' => 'N' ), 'is_base_master = "Y"' );
                }
                $model->attributes=$_POST['MasProject2'];
                if ($model->save())
                {
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'PROJECT2_MASTER',
                            Yii::app()->user->id,
                            $audit_type,
                            " with master2_name: - {$model->master2_name}  "
                        );
                        // end audit log
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['master-project2-form'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            }
        }
        public function actionDeleteRack(){
		$id = $_POST['id'];
                $model=new MasProject2();
                $rack = $model->findByPk($id); // audit log changes
                $model->deleteByPk($id);
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'RACK_MASTER',
                    Yii::app()->user->id,
                    'DELETED',
                    " with rack_name: - {$rack->name}  "
                );
                // end audit log
                echo "success";
    }
    
     public function actionDirectAdd(){
           $from = $_POST['from'];
           $name = $_POST['rack_name'];
           if($name != ''){
               $modelRack = new MasProject2;
               $modelRack->rack_name = $rack_name;
               if($modelRack->save()){
                    $data  = MasProject2::getRacks();
                    if($from == 'inventory'){
                        $model = new ProductLocation;
                        $field_name = 'rack';
                    }
                    $model->$field_name = $modelRack->id;
                    $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Rack'));  
                    $status=array("status" =>"success","drop" => $drop);    
                    echo CJSON::encode($status);
            
               }else{
                   $error = CActiveForm::validate($modelRack, '', false);
                        if ($error != '[]')
		               echo $error;
               }
           }
           
         }
        public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasProject2();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
    
     public function actionGetMaster2list() {
        $master1_id= Yii::app()->request->getParam('id');
        $list = MasProject2::getMaster2listDropdwn($master1_id);
        $model = new MasProject3();
        $masproject2 = CHtml::activeDropDownList($model, 'master2_id', $list, array('data-label' => 'Master 2 <span style="color:red">*</span>', 'empty' => '--Select--'));
        echo json_encode(["masproject2" => $masproject2, "status" => "success"]);
    }

}