<?php

class MasErpNotificationController extends Controller
{
	public function accessRules()
	{
		return array(
			array(
				'allow', // allow all users to perform 'index' and 'view' actions
				'actions' => array('login', 'error', 'logout'),
				'users' => array('*'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('Index', 'GetList', 'Create', 'SaveNotification', 'Deletenotification','UpdateViewStatus'),
				'expression' => '$user->isMember()',
			),
			array(
				'deny', // deny all users
				'users' => array('*'),
			),
		);
	}
	public function actionIndex()
	{
		$this->render('index');
	}

	public function actionCreate()
	{
		$model = new MasErpNotification();
		$id = (int) Yii::app()->request->getParam('id');
		if ($id > 0) {
			$model = $model->findByPk($id);
		}
		Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
		$this->renderPartial('create', array('model' => $model), false, true);
	}
	public function actionGetList()
	{
		$model = new MasErpNotification();

		$draw = $_POST['draw'];
		$offset = $_POST['start'];
		$limit = $_POST['length'];

		$columns = array(
			0 => 'id',
			1 => 'reference_no',
			2 => 'user_ids',
			3 => 'notification_type',
			4 => 'notes',
			5 => 'notification_date_time',
			6 => 'notification_date_time',
			7 => 'status',
		);

		$filterColumn = $columns[$_POST['order'][0]['column']];
		$filterOrder = $_POST['order'][0]['dir'];
		$orderBy = $filterColumn . " " . $filterOrder;

		$condition = "1=1";
		if (!empty($_POST['search']['value'])) {
			$searchString = $_POST['search']['value'];
			$condition .= " AND (
            reference_no LIKE '%" . $searchString . "%' OR
            user_ids LIKE '%" . $searchString . "%' OR
            notes LIKE '%" . $searchString . "%' OR
            status LIKE '%" . $searchString . "%'
        )";
		}

		$count = $model->count(array('condition' => $condition));

		$list = $model->findAll(array(
			'condition' => $condition,
			'limit' => $limit,
			'offset' => $offset,
			'order' => $orderBy,
		));

		$data = array();
		$data['draw'] = intval($draw);
		$data['recordsTotal'] = $count;
		$data['recordsFiltered'] = $count;

		$rowData = array();
		$m = $offset + 1;

		foreach ($list as $row) {
			// Convert user_ids CSV to names
			$userNames = '';
			if (!empty($row->user_ids)) {
				$userIds = explode(',', $row->user_ids);
				$criteria = new CDbCriteria();
				$criteria->addInCondition('id', $userIds);
				$employees = User::model()->findAll($criteria);

				$nameList = array();
				foreach ($employees as $emp) {
					$nameList[] = trim($emp->fullname);
				}

				$userNames = implode(', ', $nameList);
			}
            
			// Status mapping
			$statusLabels = array(
				'O' => 'Open',
				'S' => 'Sent',
				'C' => 'Closed',
			);
// 			$created_user = "";
// 			$modelUser = User::model()->findByPk($row->created_by);
// 			if(!empty($modelUser))
// 			$created_user = $modelUser->username;

			$rowData[] = array(
				$m,
				CHtml::encode($row->reference_no),
				CHtml::encode($userNames),
				CHtml::encode($row->notif->type_name),
				CHtml::encode($row->notes),
				CHtml::encode(date('d/m/Y H:i:s', strtotime($row->notification_date_time))),

				// CHtml::encode($row->notification_date_time),
				CHtml::encode(isset($statusLabels[$row->status]) ? $statusLabels[$row->status] : $row->status),
				CHtml::encode($row->id),
				CHtml::encode($row->userdet),
				CHtml::encode($row->created_date_time),
			);
			$m++;
		}

		$data['data'] = $rowData;

		echo json_encode($data);
		Yii::app()->end();
	}

	public function actionSaveNotification()
	{
		$model = new MasErpNotification;
		$valid = true;

		if (isset($_POST['MasErpNotification'])) {
			$postData = $_POST['MasErpNotification'];


			if (!empty($postData['id']) && (int) $postData['id'] > 0) {
				$model = MasErpNotification::model()->findByPk((int) $postData['id']);
				if ($model === null) {
					throw new CHttpException(404, 'Notification not found.');
				}
			} else {

				$model->created_by = Yii::app()->user->id;
				$model->created_date_time = date('Y-m-d H:i:s');
			}


			$model->attributes = $postData;
// 			if (is_array($postData['user_ids'])) {
// 				$model->user_ids = implode(',', $postData['user_ids']);
// 			}
            if (is_array($postData['user_ids'])) {
                $model->user_ids = implode(',',  $postData['user_ids']);
            } else {
                $model->user_ids = trim( $postData['user_ids']);
            }

			if (!empty($model->notification_date_time)) {
				$dateTimeStr = str_replace('/', '-', $model->notification_date_time);
				$model->notification_date_time = date('Y-m-d H:i:s', strtotime($dateTimeStr));
			}
			/////////////////////////////////////////////////////////////////////////////////////
			$p=0;
			 if (is_array($postData['user_ids'])) {
			     if((int)$postData['id']>0)
			     UserNotificationHistory::model()->deleteAll('notification_id=:notification_id', array(':notification_id' => (int)$postData['id']));
                foreach ($postData['user_ids'] as $i => $eachUser) {
                    $modelUserStatus[$p] = new UserNotificationHistory;
                    //$modelUserStatus[$p]->notif_status = "N";
                    if((int)$postData['id']>0 && (int)$eachUser>0)
                    {
                    $modelUserStatus[$p] =UserNotificationHistory::model()->find(array('condition'=>'user_id='.$eachUser.' AND notification_id='.$postData['id']));
                    if(empty($modelUserStatus[$p]))
                    $modelUserStatus[$p] = new UserNotificationHistory;
                    }
                    $modelUserStatus[$p]->notification_id = 0;
                    $modelUserStatus[$p]->user_id = $eachUser;
                    $modelUserStatus[$p]->created_by = Yii::app()->user->id;
				    $modelUserStatus[$p]->created_date_time = date('Y-m-d H:i:s');  
                    $p++;
                }
			 }
			/////////////////////////////////////////////////////////////////////////////////////
			$valid = $model->validate();

			if ($valid) {
				$model->save(false);
				$model->refresh();
				if (!empty($modelUserStatus)) {

                    foreach ($modelUserStatus as $eachModel) {
                        $eachModel->notification_id = $model->id;
						$eachModel->notes = $model->notes;
                        $eachModel->save(false); 
                    }
                }

				echo CJSON::encode(array(
					'status' => 'success',
					'message' => 'Notification saved successfully.',
					'id' => $model->id,
				));
			} else {
				// Return validation errors
				$error = CActiveForm::validate($model);
				if (!empty($error)) {
					echo $error;
				}
			}
		}

		Yii::app()->end();
	}


	public function actionDeleteNotification()
	{

		$id = (int) $_POST['id'];
		$model = MasErpNotification::model()->findByPk($id);

		if ($model !== null) {
			if ($model->delete()) {
				echo CJSON::encode(['status' => 'success']);
			} else {
				echo CJSON::encode(['status' => 'error', 'message' => 'Delete failed.']);
			}
		} else {
			echo CJSON::encode(['status' => 'error', 'message' => 'Record not found.']);
		}

		Yii::app()->end();

	}
	public function actionUpdateViewStatus() {
	    
        	$user_id = (int) $_POST['user_id'];
        	$not_id = (int) $_POST['not_id'];
         if ($user_id > 0 && $not_id >0) {
            $model = new UserNotificationHistory();
            $model = $model->find(array('condition'=>'user_id='.$user_id.' AND notification_id='.$not_id));
            if(!empty($model))
            {
               $model->notif_status= "Y";
               $model->save(false);
               
               $modelHistoryCount =(int) UserNotificationHistory::model()->count(array('condition'=>'notif_status="N" AND notification_id='.$not_id));
               if($modelHistoryCount==0)
               {
                   MasErpNotification::model()->updateByPk($not_id, array('status' => "C"));
               }
               
            }
          
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }



}