<?php

class MachinedocumentController extends Controller
{
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
                ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','Create','deleteDocument','SaveDocument','GetList','DirectAdd', 'Disable'),
                'expression' => '$user->isMember()',
                ),
            array('deny', // deny all users
                'users' => array('*'),
                ),
        );
    }
    
    public function filters(){
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
        
    public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }
         
    public function actionGetList(){
        $model=new MachineDocument();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
            0 =>'document_name',
            1 =>'document_type',
            2 =>''
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = 't.isActive="Y"';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
          $searchString = $_POST['search']['value'];
          $condition ="  (document_name LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {
            $button_string="";
            if($row['id']!= '1'){
                if (isset(Yii::app()->user->havePermissionOn['hiring_master_document_edit'])  || Yii::app()->user->authorised_user == 1) {
                    $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'machinedocument/create&id='.$row['id'].'\',\'Edit Document  \',\'md\')"><i class="fa fa-edit"></i></button>';                   
                }
//                if (isset(Yii::app()->user->haveHrPermissionOn['hiring_master_document_delete'])  || Yii::app()->user->authorised_user == 1) {
//                    $button_string .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deleteDocument('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
//                }    
            }
            $type=array('1'=>"With Date",'2'=>"Without Date");                       
            $rowData[]=array($m,$row['document_name'],$type[$row['document_type']],array('id' => $row->id, 'status' => $row->isActive));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new MachineDocument(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        } 
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('document_form', array('model' => $model), false, true);
    }
    public function actionSaveDocument(){
        if (isset($_POST['MachineDocument'])){
            $model = new MachineDocument();
            if ((int) @$_POST['MachineDocument']['id'] > 0)
            {
                $id= (int) @$_POST['MachineDocument']['id'];
                $model=$model->findByPk($id); 
                $audit_type = 'UPDATED';
            }else{
                $audit_type = 'CREATED';
            }
            $model->attributes=$_POST['MachineDocument'];
            if($model->save()){       
                    // inserting to audit log
                    AuditLog::saveAuditLogs(
                        'MACHINE_DOCUMENT',
                        Yii::app()->user->id,
                        $audit_type,
                        " with name: - {$model->document_name}  "
                    );
                    // end audit log 

                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
            }else{
                    $error = CActiveForm::validate($model, '', false);
                    if ($error != '[]')
                           echo $error;
            }
        }
    }
    public function actiondeleteDocument(){
        $id = $_POST['id'];
        if($id>0){
            $model = new MachineDocument();    
            $del = $model->findByPk($id);                
            $model->deleteByPk($id);
            // inserting to audit log
            AuditLog::saveAuditLogs(
                'DOCUMENT',
                Yii::app()->user->id,
                'DELETED',
                " with name: - {$del->document_name}  "
            );
            // end audit log 
            echo "success";
        }
        else{
            echo "fail";
        }
    }
                    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MachineDocument();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
}