<?php

class LogisticsController extends Controller
{
    public $layout = 'layout';
    public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                        'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover'),
                        'users' => array('*'),
                ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                        'actions' => array('Index','GetSalesLeadList','Create','SaveLead',
                            'getCustomerContactDetails','FetchContactDetails',
                            'GetDocumentList','UploadDocuments','DocumentUpload','DeleteDocument','DownloadDocument',
                            'GetNotesList','CreateNote','SaveNote','DeleteNote','PrintLeadReportPDF',
                            'GetExchangeRate',
                            'PrintLeadList','SalesButton','orderdetails','savehistory','GetTrackingList','Details','savedetails','GetPoNo'
                                ),
                        'expression' => '$user->isMember()',

                ),

                array('deny', // deny all users

                                'users' => array('*'),
                ),
            );
    }
    public function filters() {
            return array('accessControl'); // perform access control for CRUD operations
    }



public function actionGetTrackingList()
    {



            $model=new TrackingFile();
            $draw   = $_POST['draw'];
            $offset = $_POST['start'];
            $limit  = $_POST['length'];
            $columns = array(
                            // datatable column index  => database column name
                            //0=>'t.id',
                            
                            0=>'t.id',
                            1 => 'type',
                            2 => 'order_no',
                            3 => 'start_date',
                            4 => 't.id',
                            5 => 't.id',
                            6 => 't.id',
                           
            );

            $filterColumn = $columns[$_POST['order'][0]['column']];
            $filterOrder  = $_POST['order'][0]['dir'];
            $orderBy      = $filterColumn." ".$filterOrder;
            $condition = 't.closed="0"';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
          $searchString = $_POST['search']['value'];
          $condition="id LIKE '%".$searchString."%'" OR "order_no LIKE '%".$searchString."%'";
        }
            //$condition  = '1=1';
           
            $count = $model->count(array('condition'=>$condition));
            $model = $model->findAll(array('condition'=>$condition,'order' => $orderBy,'limit'=>$limit,'offset'=>$offset));

            $recordsTotal = $count;
            $recordsFiltered = $count;
            $data['draw'] = $draw;
            $data['recordsTotal'] = $recordsTotal;
            $data['recordsFiltered'] = $recordsFiltered;
            $rowData=array();
            foreach ($model as $row)
            {
                $userr=User::model()->findbypk($row['created_by']);
                $userrclosed=User::model()->findbypk($row['closed_by']);
                $name=$userr->first_name." ".$userr->last_name;
                if($row['type'] == "PO")
                {
                    $orderr='Purchase';
                }elseif($row['type'] == "SO")
                {
                    $orderr='Sales';
                }else
                {
                    $orderr='Others';
                }
                $name1=$userrclosed->first_name." ".$userrclosed->last_name;
                if($row['closed'] != 1)
                {
                    $closedby= '-';
                    $closedate= ' - ';
                }else
                {
                    $closedby= $name1;
                    $closedate= date("d/m/Y h:i a", strtotime($row['close_date']));
                }
                // $div = '';
                  if(isset(Yii::app()->user->havePermissionOn['bank_edit']) ||  Yii::app()->user->authorised_user == 1)
                {
                    //$div = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'logistics/create&id='.$row['id'].',&orderid='.$row['order_no'].'\',\'Tracking Details \',\'lg\')"><i class="fa fa-edit"></i></button>';
                }
                         
                $rowData[]=array($row['id'],$orderr,$row['order_no'],date("d/m/Y h:i a", strtotime($row['start_date'])),$closedate,$name,$closedby,array('id' => $row['id'],'order_no' => $row['order_no']));



            }
            $data['data'] = $rowData;

            echo json_encode($data);

    }
    public function actionIndex()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }
    /*
     * function to getlist for lead datatable
     * modified by jisha on 17-9-18. 
     */
     
     
     public function actionorderdetails() {
       
         $model = new PurchasingOrder();
         $po_no = Yii::app()->request->getParam('po_no');
          $order_typee = Yii::app()->request->getParam('type');
          $ref_no = Yii::app()->request->getParam('ref_no');
          
          $modelHistory = new TrackingFile();
              $modeldetails = new TrackingDetails();
          
          if($order_typee == "PO"){
         if($po_no>0){
             $model=PurchasingOrder::model()->findbypk($po_no);
             $modelHistory = new TrackingFile();
              $modeldetails = new TrackingDetails();
             $history= TrackingFile::model()->findAll(array('condition'=>"order_no='$po_no'"));
             $vendor=$model['vendor_id'];
             $vendordetails=Vendor::model()->findbypk($vendor);
             $v_name=$vendordetails['vendor_name'];
             $address=$model['shipping_address'];
            // echo 'ok'. $v_name;
         }
          }else if($order_typee == "SO"){
              
               $model=Order::model()->findbypk($po_no);
             $modelHistory = new TrackingFile();
              $modeldetails = new TrackingDetails();
             $history= TrackingFile::model()->findAll(array('condition'=>"order_no='$po_no'"));
               $vendor=$model['customer_id'];
                $vendordetails=Customer::model()->findbypk($vendor);
             $v_name=$vendordetails['customer_name'];
                $address=$model['billing_address'];
            // echo 'ok'. $v_name;
          }
          else if($order_typee == "OT"){
              $po_no  = $ref_no;
          }
          
		 
	
	
	 Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
	
		$this->render('logistic_view',array('address'=>$address,'v_name'=>$v_name,'model'=>$model,'modelHistory' => $modelHistory,'po_no'=>$po_no,'history' => $history,'order_typee' =>$order_typee,'modeldetails' =>$modeldetails));
        
       
    }
    
     public function actionsavehistory() {
        $model = new TrackingFile();

        $model->type  = $_POST['order_typee'];
       $model->order_no  = $_POST['new_po_no'];
       $model->created_by  = Yii::app()->user->id;
       $model->closed  = $_POST['close'];
    $end = $_POST['close'];
      
     /*  if($_POST['TrackingFile']['start_date']!='00/00/0000 00:00:00' && $_POST['TrackingFile']['start_date']!='' && $_POST['TrackingFile']['start_date']!='01/01/1970 00:00:00'){   
                $start_date = str_replace('/', '-', $_POST['TrackingFile']['start_date']);
                $start_date= date("Y-m-d H:i:s", strtotime($start_date));
            }*/
            $model->start_date  = date("Y-m-d H:i:s");
            if($end == 1){
                 $model->close_date  = date("Y-m-d H:i:s");
                 $model->closed_by = Yii::app()->user->id;
            }
           $exist = TrackingFile::model()->findAll();
if(empty($exist)){
    Yii::app()->db->createCommand("ALTER TABLE erp_tracking_file AUTO_INCREMENT=10001 ")->query();   
}
 $valid = $model->validate();
        if ($valid) {
 if($model->save(false)){
     $idlast=Yii::app()->db->getLastInsertId();
    // echo $idlast;exit;

$modeldetails=new TrackingDetails;
       $modeldetails->tracking_no  = $idlast;
        $modeldetails->entry_no  = 1;
          $cmnts=$_POST['TrackingDetails']['comments'];
           
            $modeldetails->entry_date  =date("Y/m/d H:i:s");
             if($end == 1 && $cmnts == ""){
      $modeldetails->comments  = Completed;
            }else{
      $modeldetails->comments  = $cmnts;
            }
       $modeldetails->user  = Yii::app()->user->id;
     $validd = $modeldetails->validate();
        if ($validd) {
        if($modeldetails->save(false)){
      $jsonData['status'] = 'success';
               echo CJSON::encode($jsonData);
        }
      }
       else {
            $error2 = array();
            $error1 = json_decode(CActiveForm::validate($modeldetails, '', false), true);
            $error = CJSON::encode(array_merge_recursive($error1, $error2));
            if ($error != '[]')
                echo $error;
        }
 }
    }
     else {
            $error2 = array();
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            $error = CJSON::encode(array_merge_recursive($error1, $error2));
            if ($error != '[]')
                echo $error;
        }
     }
   
    public function actionCreate()
    {
         

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false,'jquery-2.1.4.min.js' => false);
        $this->render('create');
    }
    public function actionDetails()
    {
          $id = (int) Yii::app()->request->getParam('id');
       
        $modelHistory=new TrackingFile();
        $modeldetails=new TrackingDetails();
         $modeldetailsHistory= TrackingDetails::model()->findAll(array('condition'=>'tracking_no='.$id,'order'=>'id DESC'));
          $model=PurchasingOrder::model()->findbypk($orderid);
        $history= TrackingFile::model()->findAll(array('condition'=>'id='.$id));
       

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false,'jquery-2.1.4.min.js' => false);
        $this->render('tracking_details', array('model' => $model,'modelHistory'=>$modelHistory,'modeldetails'=>$modeldetails,'id' => $id,'history'=>$history,'modeldetailsHistory'=>$modeldetailsHistory));
    }
    
    
     public function actionsavedetails() {
     
       $modeldetails=new TrackingDetails;
        $modeldetails->tracking_no  =  $_POST['trackingg_no'];
         $modeldetails->entry_no  = 1;
        
      /*
       if($_POST['TrackingDetails']['entry_date']!='00/00/0000 00:00:00' && $_POST['TrackingDetails']['entry_date']!='' && $_POST['TrackingDetails']['entry_date']!='01/01/1970 00:00:00'){   
                $entry_date = str_replace('/', '-', $_POST['TrackingDetails']['entry_date']);
                $entry_date= date("Y-m-d H:i:s", strtotime($entry_date));
            }*/
            $modeldetails->entry_date  = date("Y-m-d H:i:s");
          
    $end = $_POST['close'];
    $id=$_POST['trackingg_no'];
     
if($end == 1){
    $model=new TrackingFile;
                  $model = $model->findByPK($id);
                 
                $model->closed  = $_POST['close'];
                 $model->close_date  = date("Y-m-d H:i:s");
                 $model->closed_by = Yii::app()->user->id;
                  $model->save();
            
}
      
      $cmnts=$_POST['TrackingDetails']['comments'];
  if($end == 1 && $cmnts == ""){
      $modeldetails->comments  = Completed;
            }else{
      $modeldetails->comments  = $cmnts;
            }
     
     
       $modeldetails->user  = Yii::app()->user->id;
     
        if($modeldetails->save(false)){
           
      $jsonData['status'] = 'success';
               echo CJSON::encode($jsonData);
        
      }
        
    }
    
    public function actionGetPoNo() {
        
        
        $searchTerm = $_GET['term'];
         $searchType = $_GET['search_type'];
         $condition  = 'id  LIKE "%' . $searchTerm . '%"'; 
         if($searchType == 'PO'){
             
             $model = new PurchasingOrder();
                $model = $model->findAll(array('select' => 'id', 'condition' => $condition));
                $i = 0;
                foreach ($model as $eachModel) {
                    $data[$i]['value'] = $eachModel->id;
                    $i++;
                }
             }
             else{
                 $model = new Order();
                $model = $model->findAll(array('select' => 'id', 'condition' => $condition));
                $i = 0;
                foreach ($model as $eachModel) {
                    $data[$i]['value'] = $eachModel->id;
                    $i++;
                }
             }
        
        
        echo CJSON::encode($data);
        Yii::app()->end();
    }
   
}