<?php

class LogController extends Controller
{

    public function accessRules()
    {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails','downloadlog'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetAuditLogs', 'GetUserInLog','downloadlog'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters()
    {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndex()
        {
            if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['admin_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['auditlog_view']) &&
            Yii::app()->user->havePermissionOn['admin_menu_view'] && 
            Yii::app()->user->havePermissionOn['auditlog_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
                $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
        }

    public function actionGetAuditLogs()
    {
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $function = isset($_POST['fun']) ? $_POST['fun'] : '';
        $columns = array(
            // datatable column index  => database column name
            0 => 'esal.id',
            1 => 'ealfl.symbolic_name',
            2 => 'full_name',
            3 => 'esal.changes',
            4 => 'esal.performed_datetime',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "eu.username!='nimda123'";//this user only for nimda123
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (eu.username LIKE '%" . $searchString . "%' OR eu.first_name LIKE '%" . $searchString . "%' OR eu.last_name LIKE '%" . $searchString . "%' OR esal.changes LIKE '%" . $searchString . "%' OR ealfl.symbolic_name LIKE '%" . $searchString . "%') ";
        }

        if (!empty($function)) {
            $performed_by = isset($_POST['performed_by']) ? $_POST['performed_by'] : '';
            $from = new DateTime();
            $to = new DateTime();
            $from->modify("first day of previous month");
            $to->modify("+1 day");
            $from = !empty($_POST['from']) ? DateTime::createFromFormat('d/m/Y', $_POST['from'])->format('Y-m-d') : $from->format("Y-m-d"); 
            $to = !empty($_POST['to']) ? DateTime::createFromFormat('d/m/Y', $_POST['to'])->format('Y-m-d') : $to->format('Y-m-d'); 

            $condition .= " AND (esal.performed_datetime >= '$from' AND esal.performed_datetime <= '$to' ) ";

            if (!empty($performed_by)) {
                $condition .= " AND esal.performed_by = $performed_by ";
            }

        }
        $model = AuditLog::getAuditLogs($condition, $orderBy, $limit, $offset);
        $count = count(AuditLog::getAuditLogsCount($condition));

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();

        foreach ($model as $row) {
            $colour = 0;
            $rowData[] = array(
                $row['id'],
                $row['symbolic_name'],
                $row['full_name'],
                $row['changes'],
                //date('M d Y H:i:s', strtotime('+4 hours', strtotime($row['performed_datetime']))),
                date('M d Y H:i:s', strtotime($row['performed_datetime'])), 
            );
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetUserInLog()
    {
        echo json_encode(AuditLog::getUserInLog($_GET['term']));
    }
    public function actiondownloadlog()
    {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', "-1");
        $current_date=date('Y-m-d');
        $month_start_date=date('Y-m-01'); 
        if(strtotime($current_date)== strtotime($month_start_date)){
            $previous_month=date('Y-m-d', strtotime('-2 months', strtotime(date('Y-m-d'))));
            //Acecentro
            Yii::app()->db->setActive(false);
            Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=cumuluse_ace_centro'; 
            Yii::app()->db->tablePrefix = 'erp_';
            Yii::app()->db->setActive(true);
            $model_log_details=AuditLog::model()->findAll(array('condition'=>'DATE(performed_datetime)<="'.$previous_month.'"')); 
            Yii::import('ext.PHPExcel.PHPExcel');
            $objPHPExcel = new PHPExcel();
            // Add some data
            $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(40);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(30);
            $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A1', 'LOG ID')
                ->setCellValue('B1', 'FUNCTIONALITY')
                ->setCellValue('C1', 'DESCRIPTION')
                ->setCellValue('D1', 'PERFORMED BY')
                ->setCellValue('E1', 'PERFORMED AT');
            $objPHPExcel->getActiveSheet()->getStyle('A1:E1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle("A1:E1")->getFont()->setSize(12)->setBold( true );
            $rowCount = 2;
            $start=$rowCount; $end=0;
            foreach ($model_log_details as $j => $details) {
                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $details->id);
                $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $details->functionality_name->symbolic_name);
                $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $details->changes);
                $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $details->login_user->fullname);
                $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, date("d/m/Y H:i:s", strtotime($details->performed_datetime)));
                $objPHPExcel->getActiveSheet()->getRowDimension($rowCount)->setRowHeight(20);
                $end=$rowCount;
                $rowCount++;
            }
            $objPHPExcel->getActiveSheet()->getStyle('A'.$start.':A'.$end.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle('E'.$start.':E'.$end.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle('B'.$start.':D'.$end.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
            $objPHPExcel->getActiveSheet()->getStyle('A'.$start.':E'.$end.'')->getFont()->setSize(12);
            // Rename worksheet
            $objPHPExcel->getActiveSheet()->setTitle('Audit Log File');
            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
            $objPHPExcel->setActiveSheetIndex(0);
            // Redirect output to a client�s web browser (Excel5)
            header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
            header('Content-Disposition: attachment;filename="Acecentro Audit Log.xls"');
            header('Cache-Control: max-age=0');
            // If you're serving to IE 9, then the following may be needed
            header('Cache-Control: max-age=1');
            // If you're serving to IE over SSL, then the following may be needed
            header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header ('Pragma: public'); // HTTP/1.0
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('uploads/auditlog/acecentro_auditlog'.$previous_month.'.xls');
            //AuditLog::model()->deleteAll(array('condition'=>'DATE(performed_datetime)<="'.$previous_month.'"')); 
            //End Acecentro
            //Arkcentro
            Yii::app()->db->setActive(false);
            Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=cumuluse_ace_ark_centro'; 
            Yii::app()->db->tablePrefix = 'erp_';
            Yii::app()->db->setActive(true);
            $model_log_details=AuditLog::model()->findAll(array('condition'=>'DATE(performed_datetime)<="'.$previous_month.'"')); 
            Yii::import('ext.PHPExcel.PHPExcel');
            $objPHPExcel = new PHPExcel();
            // Add some data
            $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(40);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(30);
            $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A1', 'LOG ID')
                ->setCellValue('B1', 'FUNCTIONALITY')
                ->setCellValue('C1', 'DESCRIPTION')
                ->setCellValue('D1', 'PERFORMED BY')
                ->setCellValue('E1', 'PERFORMED AT');
            $objPHPExcel->getActiveSheet()->getStyle('A1:E1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle("A1:E1")->getFont()->setSize(12)->setBold( true );
            $rowCount = 2;
            $start=$rowCount; $end=0;
            foreach ($model_log_details as $j => $details) {
                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $details->id);
                $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $details->functionality_name->symbolic_name);
                $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $details->changes);
                $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $details->login_user->fullname);
                $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, date("d/m/Y H:i:s", strtotime($details->performed_datetime)));
                $objPHPExcel->getActiveSheet()->getRowDimension($rowCount)->setRowHeight(20);
                $end=$rowCount;
                $rowCount++;
            }
            $objPHPExcel->getActiveSheet()->getStyle('A'.$start.':A'.$end.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle('E'.$start.':E'.$end.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle('B'.$start.':D'.$end.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
            $objPHPExcel->getActiveSheet()->getStyle('A'.$start.':E'.$end.'')->getFont()->setSize(12);
            // Rename worksheet
            $objPHPExcel->getActiveSheet()->setTitle('Audit Log File');
            // Set active sheet index to the first sheet, so Excel opens this as the first sheet
            $objPHPExcel->setActiveSheetIndex(0);
            // Redirect output to a client�s web browser (Excel5)
            header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
            header('Content-Disposition: attachment;filename="Arkcentro Audit Log.xls"');
            header('Cache-Control: max-age=0');
            // If you're serving to IE 9, then the following may be needed
            header('Cache-Control: max-age=1');
            // If you're serving to IE over SSL, then the following may be needed
            header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header ('Pragma: public'); // HTTP/1.0
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('uploads/auditlog/arkcentro_auditlog'.$previous_month.'.xls');
            //AuditLog::model()->deleteAll(array('condition'=>'DATE(performed_datetime)<="'.$previous_month.'"')); 
            //End Acecentro
            //Mail Function
            $mailContent['body'] = 'Audit Log '.date("d/m/Y", strtotime($previous_month));
             $mailContent['body'] = '
            <table cellpadding="0" cellspacing="0" align="left" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit">
                <tbody>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">
                            <div>Dear Admin,</div>                                              
                        </td>
                    </tr>                                      
                    <tr>
                        <td height="30"></td>
                    </tr>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">
                            <strong style="font-size: 15px">Sub:Audit Log</strong>
                        </td>
                    </tr>
                    <tr>
                        <td height="30"></td>
                    </tr>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">                        
                            Please find attached the exported audit log. <br>
                            Kindly keep this file for future reference as this data has already been deleted from the Server.<br>
                            <br>
                            <br>
                        </td>
                    </tr>
                    <tr>
                        <td style="color: #565656;text-align: left;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;font-size: 13px;padding: 5px;">
                        <br>
                        Thanks,
                        <br><br>
                        <strong>Team Bluesky</strong>
                        </td>
                    </tr>
                </tbody>
            </table>';
            $message = new YiiMailMessage;
            $message->view = 'send_leave';
            $message->setBody(array('mailContent' => $mailContent), 'text/html');
            $message->subject ='Audit Log'; 
            $message->from ='info@mailbluesky.com';
            $message->addTo('it@acecentro.com');
            $message->addBcc('support@mailbluesky.com');
            $message->addBcc('dksnrajan@gmail.com');
            $message->addBcc('john@mailbluesky.com');
            $swiftAttachment = Swift_Attachment::fromPath('uploads/auditlog/acecentro_auditlog'.$previous_month.'.xls')->setFilename('acecentro_auditlog_'.$previous_month.'.xls'); // create a Swift Attachment          
            $message->attach($swiftAttachment);
            $swiftAttachment_1 = Swift_Attachment::fromPath('uploads/auditlog/arkcentro_auditlog'.$previous_month.'.xls')->setFilename('arkcentro_auditlog_'.$previous_month.'.xls'); // create a Swift Attachment          
            $message->attach($swiftAttachment_1);
            Yii::app()->mail->send($message); 
        }
    }
}
